# RedNet 系列
---
## 目录

* [1. 概述](#1)
* [2. 精度、FLOPS 和参数量](#2)
* [3. 基于 V100 GPU 的预测速度](#3)

<a name='1'></a>
## 1. 概述

在 ResNet 的 Backbone 和 Backbone 的所有 Bottleneck 位置上使用 Involution 替换掉了卷积，但保留了所有的卷积用于通道映射和融合。这些精心重新设计的实体联合起来，形成了一种新的高效 Backbone 网络，称为 RedNet。[论文地址](https://arxiv.org/abs/2103.06255)。

<a name='2'></a>
## 2. 精度、FLOPS 和参数量

|         Model         | Params (M) | FLOPs (G) | Top-1 (%) | Top-5 (%) |
|:---------------------:|:----------:|:---------:|:---------:|:---------:|
| RedNet26             |  9.2       | 1.7       | 75.95     | 93.19     |
| RedNet38            | 12.4       | 2.2       | 77.47     | 93.56     |
| RedNet50             | 15.5       | 2.7       | 78.33     | 94.17     |
| RedNet101           | 25.7       | 4.7       | 78.94     | 94.36     |
| RedNet152           | 34.0       | 6.8       | 79.17     | 94.40     |

<a name='3'></a>

## 3. 基于 V100 GPU 的预测速度

| 模型      | Crop Size | Resize Short Size | time(ms)<br>bs=1 | time(ms)<br>bs=4 | time(ms)<br/>bs=8 |
| --------- | --------- | ----------------- | ---------------- | ---------------- | ----------------- |
| RedNet26  | 224       | 256               | 4.45             | 15.16            | 29.03             |
| RedNet38  | 224       | 256               | 6.24             | 21.39            | 41.26             |
| RedNet50  | 224       | 256               | 8.04             | 27.71            | 53.73             |
| RedNet101 | 224       | 256               | 13.07            | 44.12            | 83.28             |
| RedNet152 | 224       | 256               | 18.66            | 63.27            | 119.48            |
