# 图像识别任务数据集说明

本文档将介绍 PaddleClas 所使用的图像识别任务数据集格式，以及图像识别领域的常见数据集介绍。

---


## 目录

- [数据集格式说明](#数据集格式说明)
- [图像识别任务常见数据集介绍](#图像识别任务常见数据集介绍)
    - [2.1 通用图像识别数据集](#通用图像识别数据集)
    - [2.2 垂类图像识别数据集](#垂类图像识别数据集)
        - [2.2.1 动漫人物识别](#动漫人物识别)
        - [2.2.2 商品识别](#商品识别)
        - [2.2.3 Logo识别](#Logo识别)
        - [2.2.4 车辆识别](#车辆识别)


<a name="数据集格式说明"></a>
## 一、数据集格式说明

与分类任务数据集不同，图像检索任务的数据集分为以下三部分：

* 训练集合（train dataset）：用来训练模型，使模型能够学习该集合的图像特征。
* 底库数据集合（gallery dataset）：用来提供图像检索任务中的底库数据，该集合可与训练集或测试集相同，也可以不同，当与训练集相同时，测试集的类别体系应与训练集的类别体系相同。
* 测试数据集合（query dataset）：用来测试模型的好坏，通常要对测试集的每一张测试图片进行特征提取，之后和底库数据的特征进行距离匹配，得到识别结果，后根据识别结果计算整个测试集的指标。

训练集、底库数据集和测试数据集均使用 `txt` 文件指定，以 `CUB_200_2011` 数据集为例，训练数据集 `train_list.txt` 文件内容格式如下所示：

```shell
# 采用"空格"作为分隔符号
...
train/99/Ovenbird_0136_92859.jpg 99 2
...
train/99/Ovenbird_0128_93366.jpg 99 6
...
```

验证数据集(`CUB_200_2011`中既是gallery dataset，也是query dataset) `test_list.txt` 文件内容格式如下所示：

```shell
# 采用"空格"作为分隔符号
...
test/200/Common_Yellowthroat_0126_190407.jpg 200 1
...
test/200/Common_Yellowthroat_0114_190501.jpg 200 6
...
```

每行数据使用“空格”分割，三列数据的含义分别是训练数据的路径、训练数据的label信息、训练数据的unique id。

**注意**：

1.当gallery dataset和query dataset相同时，为了去掉检索得到的第一个数据（检索图片本身无须评估），每个数据需要对应一个unique id（每张图片的id不同即可，可以用行号来表示unique id），用于后续评测mAP、recall@1等指标。yaml配置文件的数据集选用`VeriWild`。

2.当gallery dataset和query dataset不同时，无需增加unique id，`query_list.txt` 和`gallery_list.txt` 均为两列，分别是训练数据的路径、训练数据的label信息。yaml配置文件的数据集选用`ImageNetDataset`。

<a name="图像识别任务常见数据集介绍"></a>
## 二、图像识别任务常见数据集介绍

这里整理了常用的图像识别任务数据集，持续更新中，欢迎各位小伙伴补充完善～

<a name="通用图像识别数据集"></a>
### 2.1 通用图像识别数据集
- SOP: SOP数据集是通用识别研究领域、MetricLearning技术研究方向常用的一个商品数据集, 其包含从eBay.com下载的22,634个产品的120,053张图片。其中, 训练集包含图片59551张, 类别数11318; 验证集包含图片60502张，类别数11316个。

    地址: https://cvgl.stanford.edu/projects/lifted_struct/

- Cars196:
Cars数据集包含了196类汽车的16185张图像。数据被分成8144张训练图像和8041张测试图像，每个类大致以50-50的比例分割。级别通常是在制造，模型，年，例如2012特斯拉模型S或2012宝马M3双门跑车。

    地址: https://ai.stanford.edu/~jkrause/cars/car_dataset.html
- CUB_200_2011: CUB_200_2011数据集是由加州理工学院在2010年提出的细粒度数据集，也是目前细粒度分类识别研究的基准图像数据集。该数据集共有11788张鸟类图像，包含200类鸟类子类，其中训练数据集有5994张图像，测试集有5794张图像，每张图像均提供了图像类标记信息，图像中鸟的bounding box，鸟的关键part信息，以及鸟类的属性信息，数据集如下图所示。

    地址: http://www.vision.caltech.edu/visipedia/CUB-200-2011.html

- In-shop Clothes： In-shop Clothes 是DeepFashion数据集的4个子集之一, 它是一个卖家秀图片集，每个商品id，有多张不同角度的卖家秀，放在同一个文件夹内。该数据集共包含7982件商品，共52712张图像，每张图片都有463中属性，Bbox，landmarks，以及店铺描述。

    地址： http://mmlab.ie.cuhk.edu.hk/projects/DeepFashion.html

<a name="垂类图像识别数据集"></a>
### 2.2 垂类图像识别数据集

<a name="动漫人物识别"></a>
#### 2.2.1 动漫人物识别
+ iCartoonFace: iCartoonFace是由爱奇艺开放的目前全球最大的手工标注卡通人物检测数据集与识别数据集，它包含超过5013个卡通人物、389678张高质量实景图片。相比于其他数据集，它具有大规模、高质量、多样性丰富、挑战难度大等特点，是目前研究动漫人物识别最常用的数据集之一。

    地址： http://challenge.ai.iqiyi.com/detail?raceId=5def69ace9fcf68aef76a75d

+ Manga109： Manga109是2020.5月发布的一个用于研究卡通人物检测和识别的数据集，其包含21142张图片，官方不允许用于商用。该数据集旗下的子集Manga109-s，可以供工业使用， 主要用于文本检测、基于线稿的任务检索、角色图像生成等任务。

    地址：http://www.manga109.org/en/

+ IIT-CFW：IIF-CFW数据集共包含8928个带有标注的明星人物卡通头像，覆盖100个人物形象，每个人卡通头像数不等。 另外，其还提供了1000张真实人脸照（100个公众人物，每个人10张真实头像）。该数据集既可以用于研究动漫人物识别，也经常被用于研究跨模态的检索任务。

    地址： http://cvit.iiit.ac.in/research/projects/cvit-projects/cartoonfaces

<a name="商品识别"></a>
#### 2.2.2 商品识别
+ AliProduct: AliProduct数据集是目前开源最大的商品数据集，它是一个SKU级别的图像分类数据集， 包含5万类别、300万张商品图像，商品图像的类别和总量均为业界之最。此数据集中涵盖了大量的生活用品、食物等，数据集中没有人工标注，数据较脏，数据分布较不均衡，且有很多相似的商品图片。

    地址:  https://retailvisionworkshop.github.io/recognition_challenge_2020/

+ Product-10k: Products-10k数据集中的所有图片均来自京东商城。数据集中共包含1万个经常购买的SKU。所有SKU组织成一个层次结构。总共有近19万张图片。在实际应用场景中，图像量的分布是不均衡的。所有图像都由生产专家团队手工检查/标记。

    地址：https://www.kaggle.com/c/products-10k/data?select=train.csv

+ DeepFashion-Inshop:  同通用图像识别数据集中的In-shop Clothes

<a name="Logo识别"></a>
### 2.2.3 Logo识别
+ Logo-2K+： Logo-2K+是一个仅用于logo图像识别的数据集，其包含10个大类，2341个小类和167140张图片。

    地址： https://github.com/msn199959/Logo-2k-plus-Dataset

+ Tsinghua-Tencent 100K： 该数据集是从10万张腾讯街景全景图中创建的一个大型交通标志基准数据集。它提供包含30000个交通标志实例的100000张图像。这些图像涵盖了照度和天气条件的巨大变化。基准测试中的每个交通标志都标注了类别标签、边界框和像素掩码。 它总共包含222个类别 (0 background + 221 traffic signs)

    地址： https://cg.cs.tsinghua.edu.cn/traffic-sign/
<a name="车辆识别"></a>
### 2.2.4 车辆识别
+ CompCars： 图像主要来自网络和监控数据，其中网络数据包含163个汽车制造商、1716个汽车型号的汽车。共136,726张全车图像，27,618张部分车图像。其中网络汽车数据包含bounding box、视角、5个属性（最大速度、排量、车门数、车座数、汽车类型）。监控数据包含50,000张前视角图像。

    地址： http://mmlab.ie.cuhk.edu.hk/datasets/comp_cars/

+ BoxCars： 此数据集共包含21250辆车、63750张图像、27个汽车制造商、148个细类别，此数据集全部来自监控数据。

    地址： https://github.com/JakubSochor/BoxCars

+ PKU-VD Dataset：该数据集包含了两个大型车辆数据集（VD1和VD2），它们分别从两个城市的真实世界不受限制的场景拍摄图像。其中VD1是从高分辨率交通摄像头获得的，VD2中的图像则是从监视视频中获取的。作者对原始数据执行车辆检测，以确保每个图像仅包含一辆车辆。由于隐私保护的限制，所有车牌号码都已被黑色覆盖遮挡。所有车辆图像均从前视图进行拍摄。 数据集中为每个图像提供了多样化的属性注释，包括身份编号，精确的车辆模型和车辆颜色。VD1原先包含1097649张图像，1232种车俩模型，11种车辆颜色，但删除图像里面有多辆车辆以及从车辆后方拍摄的图片，该数据集仅剩846358张图像，141756辆车辆。 VD2包含807260张图像，79763辆车辆，1112种车辆模型，11种车辆颜色。

    地址： https://pkuml.org/resources/pku-vds.html
