# PP-ShiTu Whl 使用说明

PaddleClas 支持 Python Whl 包方式进行预测。

---

## 目录


<a name="1"></a>

## 1. 安装 paddleclas

* **[推荐]** 直接 pip 安装：

```bash
pip3 install paddleclas
```

* 如需使用 PaddleClas develop 分支体验最新功能，或是需要基于 PaddleClas 进行二次开发，请本地构建安装：

```bash
python3 setup.py install
```

<a name="2"></a>

## 2. 快速开始

<a name="2.1"></a>

### 2.1 构建索引库

下载demo数据集，命令如下：
```shell
# 下载 demo 数据并解压
wget https://paddle-imagenet-models-name.bj.bcebos.com/dygraph/rec/data/drink_dataset_v2.0.tar && tar -xf drink_dataset_v2.0.tar
```

解压完毕后，`drink_dataset_v2.0/` 文件夹下应有如下文件结构：

```log
├── drink_dataset_v2.0/
│   ├── gallery/
│   ├── index/
│   ├── index_all/
│   └── test_images/
├── ...
```

其中 `gallery` 文件夹中存放的是用于构建索引库的原始图像，`index` 表示基于原始图像构建得到的索引库信息，`test_images` 文件夹中存放的是用于测试识别效果的图像列表。




**在Python代码中构建索引库**
```python
from paddleclas import PaddleClas
build = PaddleClas(
    build_gallery=True,
    gallery_image_root='./drink_dataset_v2.0/gallery/',
    gallery_data_file='./drink_dataset_v2.0/gallery/drink_label.txt',
    index_dir='./drink_dataset_v2.0/index')
```
参数说明：
- build_gallery：是否使用索引库构建模式，默认为`False`。
- gallery_image_root：构建索引库使用的`gallery`图像地址。
- gallery_data_file：构建索引库图像的真值文件。
- index_dir：索引库存放地址。


**在命令行中构建索引库**
```shell
paddleclas --build_gallery=True --model_name="PP-ShiTuV2" \
-o IndexProcess.image_root=./drink_dataset_v2.0/gallery/ \
-o IndexProcess.index_dir=./drink_dataset_v2.0/index \
-o IndexProcess.data_file=./drink_dataset_v2.0/gallery/drink_label.txt
```
其中参数`build_gallery(bool)`控制是否使用索引库构建模式，默认为`False`。

同时可以通过`-o`指令更改构建索引库使用的配置，字段说明如下：

- IndexProcess.image_root(str): 构建索引库使用的`gallery`图像地址。
- IndexProcess.index_dir(str): 索引库存放地址。
- IndexProcess.data_file(str): 构建索引库图像的真值文件。


<a name="2.2"></a>

### 2.2 瓶装饮料识别

体验瓶装饮料识别，对图像`./drink_dataset_v2.0/test_images/100.jpeg`进行识别与检索。

待检索图像如下：
![](../../../images/recognition/drink_data_demo/test_images/100.jpeg)

**在Python代码中进行识别和检索**
```python
from paddleclas import PaddleClas
clas = PaddleClas(model_name='PP-ShiTuV2',
                  index_dir='./drink_dataset_v2.0/index')
infer_imgs='./drink_dataset_v2.0/test_images/100.jpeg'
result=clas.predict(infer_imgs, predict_type='shitu')
print(next(result))
```
参数说明：
- model_name(str):用于检索和识别的模型。
- index_dir(str):用于检索的索引库地址。

最终输出结果如下：
```
[{'bbox': [437, 71, 660, 728], 'rec_docs': '元气森林', 'rec_scores': 0.7740249}, {'bbox': [221, 72, 449, 701], 'rec_docs': '元气森林', 'rec_scores': 0.6950992}, {'bbox': [794, 104, 979, 652], 'rec_docs': '元气森林', 'rec_scores': 0.6305153}]
```

**在命令行中进行识别和检索**
```shell
paddleclas --model_name=PP-ShiTuV2 --predict_type=shitu \
-o Global.infer_imgs='./drink_dataset_v2.0/test_images/100.jpeg' \
-o IndexProcess.index_dir='./drink_dataset_v2.0/index'
```
其中参数`model_name`为用于检索和识别的模型、`predict_type`设置为'shitu'模式。

同时可以通过`-o`指令更改检索图像以及索引库，字段说明如下：
- Global.infer_imgs(str)：待检索图像地址。
- IndexProcess.index_dir(str): 索引库存放地址。

最终输出结果如下：
```
[{'bbox': [437, 71, 660, 728], 'rec_docs': '元气森林', 'rec_scores': 0.7740249}, {'bbox': [221, 72, 449, 701], 'rec_docs': '元气森林', 'rec_scores': 0.6950992}, {'bbox': [794, 104, 979, 652], 'rec_docs': '元气森林', 'rec_scores': 0.6305153}], filename: ./drink_dataset_v2.0/test_images/100.jpeg
```
