# 图像分类
---

图像分类是根据图像的语义信息将不同类别图像区分开来，是计算机视觉中重要的基本问题，也是图像检测、图像分割、物体跟踪、行为分析等其他高层视觉任务的基础。图像分类在很多领域有广泛应用，包括安防领域的人脸识别和智能视频分析等，交通领域的交通场景识别，互联网领域基于内容的图像检索和相册自动归类，医学领域的图像识别等。

一般来说，图像分类通过手工特征或特征学习方法对整个图像进行全部描述，然后使用分类器判别物体类别，因此如何提取图像的特征至关重要。在深度学习算法之前使用较多的是基于词袋(Bag of Words)模型的物体分类方法。而基于深度学习的图像分类方法，可以通过有监督或无监督的方式学习层次化的特征描述，从而取代了手工设计或选择图像特征的工作。深度学习模型中的卷积神经网络(Convolution Neural Network, CNN)近年来在图像领域取得了惊人的成绩，CNN直接利用图像像素信息作为输入，最大程度上保留了输入图像的所有信息，通过卷积操作进行特征的提取和高层抽象，模型输出直接是图像识别的结果。这种基于"输入-输出"直接端到端的学习方法取得了非常好的效果，得到了广泛的应用。

图像分类是计算机视觉里很基础但又重要的一个领域，其研究成果一直影响着计算机视觉甚至深度学习的发展，图像分类有很多子领域，如多标签分类、细粒度分类等，此处只对单标签图像分类做一个简述。


## 一、数据集介绍

### 1.1 ImageNet-1k

ImageNet项目是一个大型视觉数据库，用于视觉目标识别软件研究。该项目已手动注释了1400多万张图像，以指出图片中的对象，并在至少100万张图像中提供了边框。ImageNet-1k是ImageNet数据集的子集，其包含1000个类别。训练集包含1281167个图像数据，验证集包含50000个图像数据。2010年以来，ImageNet项目每年举办一次图像分类竞赛，即ImageNet大规模视觉识别挑战赛（ILSVRC）。挑战赛使用的数据集即为ImageNet-1k。到目前为止，ImageNet-1k已经成为计算机视觉领域发展的最重要的数据集之一，其促进了整个计算机视觉的发展，很多计算机视觉下游任务的初始化模型都是基于该数据集训练得到的权重。

### 1.2 CIFAR-10/CIFAR-100

CIFAR-10数据集由10个类的60000个彩色图像组成，图像分辨率为32x32，每个类有6000个图像，其中训练集5000张，验证集1000张，10个不同的类代表飞机、汽车、鸟类、猫、鹿、狗、青蛙、马、轮船和卡车。CIFAR-100数据集是CIFAR-10的扩展，由100个类的60000个彩色图像组成，图像分辨率为32x32，每个类有600个图像，其中训练集500张，验证集100张。由于这两个数据集规模较小，因此可以让研究人员快速尝试不同的算法。这两个数据集也是图像分类领域测试模型好坏的常用数据集。

## 二、图像分类的流程

将准备好的训练数据做相应的数据预处理后经过图像分类模型，模型的输出与真实标签做交叉熵损失函数，该损失函数描述了模型的收敛方向，遍历所有的图片数据输入模型，对最终损失函数通过某些优化器做相应的梯度下降，将梯度信息回传到模型中，更新模型的权重，如此循环往复遍历多次数据，即可得到一个图像分类的模型。

### 2.1 数据及其预处理

数据的质量及数量往往可以决定一个模型的好坏。在图像分类领域，数据包括图像及标签。在大部分情形下，带有标签的数据比较匮乏，所以数量很难达到使模型饱和的程度，为了可以使模型学习更多的图像特征，图像数据在进入模型之前要经过很多图像变换或者数据增强，来保证输入图像数据的多样性，从而保证模型有更好的泛化能力。PaddleClas提供了训练ImageNet-1k的标准图像变换，也提供了8中数据增强的方法，相关代码可以[数据处理](../../../ppcls/data/preprocess)，配置文件可以参考[数据增强配置文件](../../../ppcls/configs/ImageNet/DataAugment)。

### 2.2 模型准备

在数据确定后，模型往往决定了最终算法精度的上限，在图像分类领域，经典的模型层出不穷，PaddleClas提供了36个系列共175个ImageNet预训练模型。具体的精度、速度等指标请参考[骨干网络和预训练模型库](./ImageNet_models.md)。

### 2.3 模型训练

在准备好数据、模型后，便可以开始迭代模型并更新模型的参数。经过多次迭代最终可以得到训练好的模型来做图像分类任务。图像分类的训练过程需要很多经验，涉及很多超参数的设置，PaddleClas提供了一些列的[训练调优方法](../models/Tricks.md)，可以快速助你获得高精度的模型。

### 2.4 模型评估

当训练得到一个模型之后，如何确定模型的好坏，需要将模型在验证集上进行评估。评估指标一般是Top1-Acc或者Top5-Acc，该指标越高往往代表模型性能越好。


## 三、主要算法简介

- LeNet：Yan LeCun等人于上个世纪九十年代第一次将卷积神经网络应用到图像分类任务上，创造性的提出了LeNet，在手写数字识别任务上取得了巨大的成功。

- AlexNet：Alex Krizhevsky等人在2012年提出了AlexNet，并应用于ImageNet上，获得了2012年ImageNet分类比赛的冠军，从此，掀起了深度学习的热潮。

- VGG：Simonyan和Zisserman于2014年提出了VGG网络结构，该网络结构使用了更小的卷积核堆叠整个网络，在ImageNet分类上取得了更好的性能，也为之后的网络结构设计提供了新的思路。

- GoogLeNet：Christian Szegedy等人在2014年提出了GoogLeNet，该网络使用了多分支结构和全局平均池化层（GAP），在保持模型精度的同时，模型存储和计算量大大缩减。该网络取得了2014年ImageNet分类比赛的冠军。

- ResNet：Kaiming He等人在2015年提出了ResNet，通过引入残差模块加深了网络的深度，最终该网络将ImageNet分类的识别错误率降低到了3.6\%，首次超出正常人眼的识别精度。

- DenseNet：Huang Gao等人在2017年提出了DenseNet，该网络设计了一种更稠密连接的block，在更小的参数量上获得了更高的性能。

- EfficientNet：Mingxing Tan等人在2019年提出了EfficientNet，该网络平衡了网络的宽度、网络的深度、以及输入图片的分辨率，在同样FLOPS与参数量的情况下，精度达到了state-of-the-art的效果。

关于更多的算法介绍，请参考[算法介绍](../models)。
