# Twins
---
## 目录

* [1. 概述](#1)
* [2. 精度、FLOPS 和参数量](#2)
* [3. 基于V100 GPU 的预测速度](#3)

<a name='1'></a>

## 1. 概述
Twins 网络包括 Twins-PCPVT 和 Twins-SVT，其重点对空间注意力机制进行了精心设计，得到了简单却更为有效的方案。由于该体系结构仅涉及矩阵乘法，而目前的深度学习框架中对矩阵乘法有较高的优化程度，因此该体系结构十分高效且易于实现。并且，该体系结构在图像分类、目标检测和语义分割等多种下游视觉任务中都能够取得优异的性能。[论文地址](https://arxiv.org/abs/2104.13840)。

<a name='2'></a>

## 2. 精度、FLOPs 和参数量

| Models        | Top1 | Top5 | Reference<br>top1 | Reference<br>top5 | FLOPs<br>(G) | Params<br>(M) |
|:--:|:--:|:--:|:--:|:--:|:--:|:--:|
| pcpvt_small   | 0.8082 | 0.9552 | 0.812 | - | 3.7 | 24.1   |
| pcpvt_base    | 0.8242 | 0.9619 | 0.827 | - | 6.4 | 43.8   |
| pcpvt_large   | 0.8273 | 0.9650 | 0.831 | - | 9.5 | 60.9   |
| alt_gvt_small | 0.8140 | 0.9546 | 0.817 | - | 2.8  | 24   |
| alt_gvt_base  | 0.8294 | 0.9621 | 0.832 | - | 8.3  | 56   |
| alt_gvt_large | 0.8331 | 0.9642 | 0.837 | - | 14.8 | 99.2   |

**注**：与 Reference 的精度差异源于数据预处理不同。

<a name='3'></a>

## 3. 基于 V100 GPU 的预测速度

| Models        | Crop Size | Resize Short Size | FP32<br/>Batch Size=1<br/>(ms) | FP32<br/>Batch Size=4<br/>(ms) | FP32<br/>Batch Size=8<br/>(ms) |
| ------------- | --------- | ----------------- | ------------------------------ | ------------------------------ | ------------------------------ |
| pcpvt_small   | 224       | 256               | 7.32                           | 10.51                          | 15.27                          |
| pcpvt_base    | 224       | 256               | 12.20                          | 16.22                          | 23.16                          |
| pcpvt_large   | 224       | 256               | 16.47                          | 22.90                          | 32.73                          |
| alt_gvt_small | 224       | 256               | 6.94                           | 9.01                           | 12.27                          |
| alt_gvt_base  | 224       | 256               | 9.37                           | 15.02                          | 24.54                          |
| alt_gvt_large | 224       | 256               | 11.76                          | 22.08                          | 35.12                          |
