# ResNeSt 与 RegNet 系列
----
## 目录

* [1. 概述](#1)
* [2. 精度、FLOPS 和参数量](#2)
* [3. 基于 V100 GPU 的预测速度](#3)
* [4. 基于 T4 GPU 的预测速度](#4)

<a name='1'></a>

## 1. 概述

ResNeSt 系列模型是在 2020 年提出的，在原有的 resnet 网络结构上做了改进，通过引入 K 个 Group 和在不同 Group 中加入类似于 SEBlock 的 attention 模块，使得精度相比于基础模型 ResNet 有了大幅度的提高，且参数量和 flops 与基础的 ResNet 基本保持一致。

RegNet 是由 facebook 于 2020 年提出，旨在深化设计空间理念的概念，在 AnyNetX 的基础上逐步改进，通过加入共享瓶颈 ratio、共享组宽度、调整网络深度与宽度等策略，最终实现简化设计空间结构、提高设计空间的可解释性、改善设计空间的质量，并保持设计空间的模型多样性的目的。最终设计出的模型在类似的条件下，性能还要优于 EfficientNet，并且在 GPU 上的速度提高了 5 倍。

<a name='2'></a>

## 2. 精度、FLOPS 和参数量

| Models           | Top1 | Top5 | Reference<br>top1 | Reference<br>top5 | FLOPS<br>(G) | Parameters<br>(M) |
|:--:|:--:|:--:|:--:|:--:|:--:|:--:|
| ResNeSt50_fast_1s1x64d        | 0.8035 | 0.9528|  0.8035 |            -| 8.68     | 26.3   |
| ResNeSt50        | 0.8083 | 0.9542|  0.8113 |            -| 10.78     | 27.5   |
| RegNetX_4GF        | 0.7850 | 0.9416|  0.7860 |            -| 8.0     | 22.1   |

<a name='3'></a>

## 3. 基于 V100 GPU 的预测速度

| Models                 | Crop Size | Resize Short Size | FP32<br/>Batch Size=1<br/>(ms) | FP32<br/>Batch Size=4<br/>(ms) | FP32<br/>Batch Size=8<br/>(ms) |
| ---------------------- | --------- | ----------------- | ------------------------------ | ------------------------------ | ------------------------------ |
| ResNeSt50_fast_1s1x64d | 224       | 256               | 2.73                           | 5.33                           | 8.24                           |
| ResNeSt50              | 224       | 256               | 7.36                           | 10.23                          | 13.84                          |
| RegNetX_4GF            | 224       | 256               | 6.46                           | 8.48                           | 11.45                          |

<a name='4'></a>

## 4. 基于 T4 GPU 的预测速度

| Models             | Crop Size | Resize Short Size | FP16<br>Batch Size=1<br>(ms) | FP16<br>Batch Size=4<br>(ms) | FP16<br>Batch Size=8<br>(ms) | FP32<br>Batch Size=1<br>(ms) | FP32<br>Batch Size=4<br>(ms) | FP32<br>Batch Size=8<br>(ms) |
|--------------------|-----------|-------------------|------------------------------|------------------------------|------------------------------|------------------------------|------------------------------|------------------------------|
| ResNeSt50_fast_1s1x64d          | 224       | 256   | 3.46466           | 5.56647           | 9.11848          | 3.45405      |   8.72680    |    15.48710     |
| ResNeSt50         | 224       | 256               | 7.05851           | 8.97676            | 13.34704          | 6.16248      |   12.0633    |    21.49936     |
| RegNetX_4GF | 224       | 256       | 6.69042    | 8.01664            | 11.60608       | 6.46478     |   11.19862    |    16.89089    |
