# 图像识别任务数据集说明

本文档将介绍 PaddleClas 所使用的图像识别任务数据集格式，以及图像识别领域的常见数据集介绍。

---


## 目录

- [1. 数据集格式说明](#1)
- [2. 图像识别任务常见数据集介绍](#2)
    - [2.1 通用图像识别数据集](#2.1)
    - [2.2 垂类图像识别数据集](#2.2)
        - [2.2.1 动漫人物识别](#2.2.1)
        - [2.2.2 商品识别](#2.2.2)
        - [2.2.3 Logo 识别](#2.2.3)
        - [2.2.4 车辆识别](#2.2.4)


<a name="1"></a>
## 1. 数据集格式说明

与分类任务数据集不同，图像检索任务的数据集分为以下三部分：

* 训练集合（train dataset）：用来训练模型，使模型能够学习该集合的图像特征。
* 底库数据集合（gallery dataset）：用来提供图像检索任务中的底库数据，该集合可与训练集或测试集相同，也可以不同，当与训练集相同时，测试集的类别体系应与训练集的类别体系相同。
* 测试数据集合（query dataset）：用来测试模型的好坏，通常要对测试集的每一张测试图片进行特征提取，之后和底库数据的特征进行距离匹配，得到识别结果，后根据识别结果计算整个测试集的指标。

训练集、底库数据集和测试数据集均使用 `txt` 文件指定，以 `CUB_200_2011` 数据集为例，训练数据集 `train_list.txt` 文件内容格式如下所示：

```shell
# 采用"空格"作为分隔符号
...
train/99/Ovenbird_0136_92859.jpg 99 2
...
train/99/Ovenbird_0128_93366.jpg 99 6
...
```

验证数据集(`CUB_200_2011` 中既是 gallery dataset，也是 query dataset)`test_list.txt` 文件内容格式如下所示：

```shell
# 采用"空格"作为分隔符号
...
test/200/Common_Yellowthroat_0126_190407.jpg 200 1
...
test/200/Common_Yellowthroat_0114_190501.jpg 200 6
...
```

每行数据使用“空格”分割，三列数据的含义分别是训练数据的路径、训练数据的 label 信息、训练数据的 unique id。

**注意**：

1.当 gallery dataset 和 query dataset 相同时，为了去掉检索得到的第一个数据（检索图片本身无须评估），每个数据需要对应一个 unique id（每张图片的 id 不同即可，可以用行号来表示 unique id），用于后续评测 mAP、recall@1 等指标。yaml 配置文件的数据集选用 `VeriWild`。

2.当 gallery dataset 和 query dataset 不同时，无需增加 unique id，`query_list.txt` 和 `gallery_list.txt` 均为两列，分别是训练数据的路径、训练数据的 label 信息。yaml 配置文件的数据集选用 `ImageNetDataset`。

<a name="2"></a>
## 2. 图像识别任务常见数据集介绍

这里整理了常用的图像识别任务数据集，持续更新中，欢迎各位小伙伴补充完善～

<a name="2.1"></a>
### 2.1 通用图像识别数据集
- SOP: SOP 数据集是通用识别研究领域、MetricLearning 技术研究方向常用的一个商品数据集, 其包含从 eBay.com 下载的 22,634 个产品的 120,053 张图片。其中, 训练集包含图片 59551 张, 类别数 11318; 验证集包含图片 60502 张，类别数 11316 个。

    地址: https://cvgl.stanford.edu/projects/lifted_struct/

- Cars196:
Cars 数据集包含了 196 类汽车的 16185 张图像。数据被分成 8144 张训练图像和 8041 张测试图像，每个类大致以 50-50 的比例分割。级别通常是在制造，模型，年，例如 2012 特斯拉模型 S 或 2012 宝马 M3 双门跑车。

    地址: https://ai.stanford.edu/~jkrause/cars/car_dataset.html
- CUB_200_2011: CUB_200_2011 数据集是由加州理工学院在 2010 年提出的细粒度数据集，也是目前细粒度分类识别研究的基准图像数据集。该数据集共有 11788 张鸟类图像，包含 200 类鸟类子类，其中训练数据集有 5994 张图像，测试集有 5794 张图像，每张图像均提供了图像类标记信息，图像中鸟的 bounding box，鸟的关键 part 信息，以及鸟类的属性信息，数据集如下图所示。

    地址: http://www.vision.caltech.edu/visipedia/CUB-200-2011.html

- In-shop Clothes： In-shop Clothes 是 DeepFashion 数据集的 4 个子集之一, 它是一个卖家秀图片集，每个商品 id，有多张不同角度的卖家秀，放在同一个文件夹内。该数据集共包含 7982 件商品，共 52712 张图像，每张图片都有 463 中属性，Bbox，landmarks，以及店铺描述。

    地址： http://mmlab.ie.cuhk.edu.hk/projects/DeepFashion.html

<a name="2.2"></a>
### 2.2 垂类图像识别数据集

<a name="2.2.1"></a>
#### 2.2.1 动漫人物识别
+ iCartoonFace: iCartoonFace 是由爱奇艺开放的目前全球最大的手工标注卡通人物检测数据集与识别数据集，它包含超过 5013 个卡通人物、389678 张高质量实景图片。相比于其他数据集，它具有大规模、高质量、多样性丰富、挑战难度大等特点，是目前研究动漫人物识别最常用的数据集之一。

    地址： http://challenge.ai.iqiyi.com/detail?raceId=5def69ace9fcf68aef76a75d

+ Manga109： Manga109 是 2020.5 月发布的一个用于研究卡通人物检测和识别的数据集，其包含 21142 张图片，官方不允许用于商用。该数据集旗下的子集 Manga109-s，可以供工业使用，主要用于文本检测、基于线稿的任务检索、角色图像生成等任务。

    地址：http://www.manga109.org/en/

+ IIT-CFW：IIF-CFW 数据集共包含 8928 个带有标注的明星人物卡通头像，覆盖 100 个人物形象，每个人卡通头像数不等。 另外，其还提供了 1000 张真实人脸照（100 个公众人物，每个人 10 张真实头像）。该数据集既可以用于研究动漫人物识别，也经常被用于研究跨模态的检索任务。

    地址： http://cvit.iiit.ac.in/research/projects/cvit-projects/cartoonfaces

<a name="2.2.2"></a>
#### 2.2.2 商品识别
+ AliProduct: AliProduct 数据集是目前开源最大的商品数据集，它是一个 SKU 级别的图像分类数据集，包含 5 万类别、300 万张商品图像，商品图像的类别和总量均为业界之最。此数据集中涵盖了大量的生活用品、食物等，数据集中没有人工标注，数据较脏，数据分布较不均衡，且有很多相似的商品图片。

    地址:  https://retailvisionworkshop.github.io/recognition_challenge_2020/

+ Product-10k: Products-10k 数据集中的所有图片均来自京东商城。数据集中共包含 1 万个经常购买的 SKU。所有 SKU 组织成一个层次结构。总共有近 19 万张图片。在实际应用场景中，图像量的分布是不均衡的。所有图像都由生产专家团队手工检查/标记。

    地址：https://www.kaggle.com/c/products-10k/data?select=train.csv

+ DeepFashion-Inshop: 同通用图像识别数据集中的 In-shop Clothes

<a name="2.2.3"></a>
### 2.2.3 Logo 识别
+ Logo-2K+： Logo-2K+是一个仅用于 logo 图像识别的数据集，其包含 10 个大类，2341 个小类和 167140 张图片。

    地址： https://github.com/msn199959/Logo-2k-plus-Dataset

+ Tsinghua-Tencent 100K： 该数据集是从 10 万张腾讯街景全景图中创建的一个大型交通标志基准数据集。它提供包含 30000 个交通标志实例的 100000 张图像。这些图像涵盖了照度和天气条件的巨大变化。基准测试中的每个交通标志都标注了类别标签、边界框和像素掩码。 它总共包含 222 个类别(0 background + 221 traffic signs)

    地址： https://cg.cs.tsinghua.edu.cn/traffic-sign/
<a name="2.2.4"></a>
### 2.2.4 车辆识别
+ CompCars： 图像主要来自网络和监控数据，其中网络数据包含 163 个汽车制造商、1716 个汽车型号的汽车。共 136,726 张全车图像，27,618 张部分车图像。其中网络汽车数据包含 bounding box、视角、5 个属性（最大速度、排量、车门数、车座数、汽车类型）。监控数据包含 50,000 张前视角图像。

    地址： http://mmlab.ie.cuhk.edu.hk/datasets/comp_cars/

+ BoxCars： 此数据集共包含 21250 辆车、63750 张图像、27 个汽车制造商、148 个细类别，此数据集全部来自监控数据。

    地址： https://github.com/JakubSochor/BoxCars

+ PKU-VD Dataset：该数据集包含了两个大型车辆数据集（VD1 和 VD2），它们分别从两个城市的真实世界不受限制的场景拍摄图像。其中 VD1 是从高分辨率交通摄像头获得的，VD2 中的图像则是从监视视频中获取的。作者对原始数据执行车辆检测，以确保每个图像仅包含一辆车辆。由于隐私保护的限制，所有车牌号码都已被黑色覆盖遮挡。所有车辆图像均从前视图进行拍摄。 数据集中为每个图像提供了多样化的属性注释，包括身份编号，精确的车辆模型和车辆颜色。VD1 原先包含 1097649 张图像，1232 种车俩模型，11 种车辆颜色，但删除图像里面有多辆车辆以及从车辆后方拍摄的图片，该数据集仅剩 846358 张图像，141756 辆车辆。 VD2 包含 807260 张图像，79763 辆车辆，1112 种车辆模型，11 种车辆颜色。

    地址： https://pkuml.org/resources/pku-vds.html
