# DLA 系列
----
## 目录
* [1. 概述](#1)
* [2. 精度、FLOPS 和参数量](#2)
* [3. 基于 V100 GPU 的预测速度](#3)

<a name='1'></a>

## 1. 概述

DLA(Deep Layer Aggregation)。 视觉识别需要丰富的表示形式，其范围从低到高，范围从小到大，分辨率从精细到粗糙。即使卷积网络中的要素深度很深，仅靠隔离层还是不够的：将这些表示法进行复合和聚合可改善对内容和位置的推断。尽管已合并了残差连接以组合各层，但是这些连接本身是“浅”的，并且只能通过简单的一步操作来融合。作者通过更深层的聚合来增强标准体系结构，以更好地融合各层的信息。Deep Layer Aggregation 结构迭代地和分层地合并了特征层次结构，以使网络具有更高的准确性和更少的参数。跨体系结构和任务的实验表明，与现有的分支和合并方案相比，Deep Layer Aggregation 可提高识别和分辨率。[论文地址](https://arxiv.org/abs/1707.06484)。

<a name='2'></a>

## 2. 精度、FLOPS 和参数量

|         Model         | Params (M) | FLOPs (G) | Top-1 (%) | Top-5 (%) |
|:-----------------:|:----------:|:---------:|:---------:|:---------:|
| DLA34                 | 15.8       | 3.1       | 76.03     |   92.98   |
| DLA46_c              | 1.3        | 0.5       | 63.21     |   85.30   |
| DLA46x_c            | 1.1        | 0.5       | 64.36     |   86.01   |
| DLA60               | 22.0       | 4.2       | 76.10    |   92.92   |
| DLA60x             | 17.4       | 3.5       | 77.53    |   93.78   |
| DLA60x_c              | 1.3        | 0.6       | 66.45     |   87.54   | 
| DLA102                | 33.3       | 7.2       | 78.93     |   94.52   |
| DLA102x             | 26.4       | 5.9       | 78.10     |   94.00   |
| DLA102x2              | 41.4       | 9.3       | 78.85     |   94.45   |
| DLA169                | 53.5       | 11.6      | 78.09    |   94.09   |

<a name='3'></a>

## 3. 基于 V100 GPU 的预测速度

| 模型     | Crop Size | Resize Short Size | FP32<br/>Batch Size=1<br/>(ms) | FP32<br/>Batch Size=4<br/>(ms) | FP32<br/>Batch Size=8<br/>(ms) |
| -------- | --------- | ----------------- | ------------------------------ | ------------------------------ | ------------------------------ |
| DLA102   | 224       | 256               | 4.95                           | 8.08                           | 12.40                          |
| DLA102x2 | 224       | 256               | 19.58                          | 23.97                          | 31.37                          |
| DLA102x  | 224       | 256               | 11.12                          | 15.60                          | 20.37                          |
| DLA169   | 224       | 256               | 7.70                           | 12.25                          | 18.90                          |
| DLA34    | 224       | 256               | 1.83                           | 3.37                           | 5.98                           |
| DLA46_c  | 224       | 256               | 1.06                           | 2.08                           | 3.23                           |
| DLA60    | 224       | 256               | 2.78                           | 5.36                           | 8.29                           |
| DLA60x_c | 224       | 256               | 1.79                           | 3.68                           | 5.19                           |
| DLA60x   | 224       | 256               | 5.98                           | 9.24                           | 12.52                          |