// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "paddle/fluid/framework/block_desc.h"
#include "paddle/fluid/framework/convert_utils.h"
#include "paddle/fluid/framework/op_desc.h"
#include "paddle/fluid/framework/operator.h"
#include "paddle/fluid/framework/program_desc.h"
#include "paddle/fluid/prim/api/manual_prim/utils/utils.h"
#include "paddle/fluid/prim/utils/static/desc_tensor.h"
#include "paddle/fluid/prim/utils/static/static_global_utils.h"
#include "paddle/phi/api/include/tensor.h"
#include "paddle/phi/core/macros.h"
#include "paddle/phi/core/utils/data_type.h"
namespace paddle {
namespace prim {
using Tensor = paddle::experimental::Tensor;
template <>
Tensor empty<DescTensor>(const paddle::experimental::IntArray& shape,
                         paddle::experimental::DataType dtype,
                         const paddle::Place& place) {
  framework::VarDesc* new_var =
      StaticCompositeContext::Instance().GetBlock()->Var(
          std::move(StaticCompositeContext::Instance().GenerateUniqueName()));
  new_var->SetShape(shape.GetData());
  new_var->SetDataType(framework::TransToProtoVarType(dtype));
  // Place is not supported in static mode
  return Tensor(std::make_shared<prim::DescTensor>(new_var));
}

template <>
Tensor empty_like<DescTensor>(const Tensor& x,
                              paddle::experimental::DataType dtype,
                              const paddle::Place& place) {
  return empty<prim::DescTensor>(
      paddle::experimental::IntArray(x.shape()), x.dtype(), paddle::Place());
}

template <>
void set_output<DescTensor>(const paddle::experimental::Tensor& x_tmp,
                            paddle::experimental::Tensor* x) {
  x->set_impl(x_tmp.impl());
}

template <>
void by_pass<DescTensor>(const paddle::experimental::Tensor& x,
                         paddle::experimental::Tensor* out) {
  Tensor new_out =
      empty<DescTensor>({}, phi::DataType::FLOAT32, paddle::Place());
  framework::BlockDesc* block = StaticCompositeContext::Instance().GetBlock();
  framework::OpDesc* op = block->AppendOp();
  op->SetType("assign");
  op->SetInput("X",
               {std::static_pointer_cast<prim::DescTensor>(x.impl())->Name()});
  op->SetOutput(
      "Out", {std::static_pointer_cast<prim::DescTensor>(out->impl())->Name()});
  op->CheckAttrs();
  op->InferVarType(block);
  op->InferShape(*block);
  set_output<DescTensor>(new_out, out);
}

}  // namespace prim
}  // namespace paddle
