// Copyright (c) 2023 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include "paddle/phi/core/dense_tensor.h"
#include "paddle/phi/core/device_context.h"

namespace phi {

template <typename T, typename Context>
void FlashAttnRawKernel(const Context& ctx,
                        const DenseTensor& q,
                        const DenseTensor& k,
                        const DenseTensor& v,
                        const DenseTensor& cu_seqlens_q,
                        const DenseTensor& cu_seqlens_k,
                        int64_t max_seqlen_q,
                        int64_t max_seqlen_k,
                        float scale,
                        float dropout,
                        bool causal,
                        bool return_softmax,
                        DenseTensor* out,
                        DenseTensor* softmax_lse,
                        DenseTensor* softmax,
                        DenseTensor* seed_offset);

template <typename T, typename Context>
void FlashAttnKernel(const Context& ctx,
                     const DenseTensor& q,
                     const DenseTensor& k,
                     const DenseTensor& v,
                     float dropout,
                     bool causal,
                     bool return_softmax,
                     DenseTensor* out,
                     DenseTensor* softmax_lse,
                     DenseTensor* softmax,
                     DenseTensor* seed_offset);

}  // namespace phi
