// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "paddle/phi/backends/gpu/gpu_context.h"
#include "paddle/phi/core/kernel_registry.h"
#include "paddle/phi/kernels/impl/tril_triu_grad_kernel_impl.h"

PD_REGISTER_KERNEL(tril_grad,
                   GPU,
                   ALL_LAYOUT,
                   phi::TrilGradKernel,
                   bool,
                   float,
                   double,
                   int,
                   int64_t,
                   phi::dtype::float16) {}

PD_REGISTER_KERNEL(triu_grad,
                   GPU,
                   ALL_LAYOUT,
                   phi::TriuGradKernel,
                   bool,
                   float,
                   double,
                   int,
                   int64_t,
                   phi::dtype::float16) {}

PD_REGISTER_KERNEL(tril_triu_grad,
                   GPU,
                   ALL_LAYOUT,
                   phi::TrilTriuGradKernel,
                   bool,
                   float,
                   double,
                   int,
                   int64_t,
                   phi::dtype::float16) {}
