// Copyright (c) 2023 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "paddle/fluid/ir/dialect/pd_kernel_dialect.h"
#include "paddle/fluid/ir/dialect/pd_attribute.h"
#include "paddle/fluid/ir/dialect/pd_kernel_op.h"
// NOTE(zhangbo9674): File pd_op.h is generated by op_gen.py, see details in
// paddle/fluid/ir/dialect/CMakeLists.txt.
#include "paddle/fluid/framework/convert_utils.h"
#include "paddle/fluid/framework/data_type.h"
#include "paddle/fluid/ir/dialect/pd_kernel_type.h"
#include "paddle/fluid/ir/dialect/pd_kernel_type_storage.h"
#include "paddle/fluid/ir/dialect/pd_op.h"
#include "paddle/fluid/ir/dialect/utils.h"
#include "paddle/ir/core/dialect_interface.h"
#include "paddle/phi/core/dense_tensor.h"

namespace paddle {
namespace dialect {

PaddleKernelDialect::PaddleKernelDialect(ir::IrContext *context)
    : ir::Dialect(name(), context, ir::TypeId::get<PaddleKernelDialect>()) {
  initialize();
}

void PaddleKernelDialect::initialize() {
  RegisterTypes<paddle::dialect::AllocatedDenseTensorType>();
  RegisterOps<dialect::PhiKernelOp>();

  // RegisterAttributes<paddle::dialect::IntArrayAttribute,
  //                    paddle::dialect::DataTypeAttribute,
  //                    paddle::dialect::PlaceAttribute,
  //                    paddle::dialect::DataLayoutAttribute>();
}

void PaddleKernelDialect::PrintType(ir::Type type, std::ostream &os) {
  AllocatedDenseTensorType tensor_type =
      type.dyn_cast<AllocatedDenseTensorType>();

  os << phi::AllocationTypeStr(tensor_type.place().GetType()) << "_";
  os << "tensor<";
  for (auto d : phi::vectorize(tensor_type.dims())) {
    os << d;
    os << "x";
  }
  tensor_type.dtype().Print(os);
  os << ">";
}

}  // namespace dialect
}  // namespace paddle
