## PDSA-2023-004: FPE in paddle.linalg.matrix_power

### CVE Number

CVE-2023-38672

### Impact

When dim contains 0, `paddle.linalg.matrix_power` will trigger a float point exception. The PoC is as follows:

```python
import paddle
import numpy as np
from paddle.linalg import matrix_power

x = paddle.to_tensor(np.random.uniform(-10, 10, [1, 1, 0, 0]).astype(np.float32))

matrix_power(x, -1)
```

### Patches

We have patched the issue in commit [09926af166b060c9a9845c309110d3baa82921fd](https://github.com/PaddlePaddle/Paddle/commit/09926af166b060c9a9845c309110d3baa82921fd).
The fix will be included in PaddlePaddle 2.5.0.

### For more information

Please consult [our security guide](../../SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution

This vulnerability has been reported by Tong Liu of ShanghaiTech University.
