/* Copyright (c) 2016 Baidu, Inc. All Rights Reserve.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. */


#pragma once

#include "ConvBaseLayer.h"
#include "paddle/math/Matrix.h"
#include "Projection.h"
#include <vector>

namespace paddle {

/**
 * @brief A 2-dimension conv layer implemented by cuDNN. It only
 *        supports GPU mode. We automatic select CudnnConvLayer for GPU
 *        mode and ExpandConvLayer for CPU mode if you set type of "conv".
 *        User also can specfiy type of "exconv" or "cudnn_conv" for
 *        particular type.
 *
 * The config file api is img_conv_layer.
 */
class CudnnConvLayer : public ConvBaseLayer {
protected:
  std::vector<std::unique_ptr<ProjectionConfig>> projConf_;
  std::vector<std::unique_ptr<Projection>> projections_;

  hl_tensor_descriptor biasDesc_;
  hl_tensor_descriptor outputDesc_;
  int biasOffset_;
  int outputOffset_;

public:
  explicit CudnnConvLayer(const LayerConfig& config) : ConvBaseLayer(config) {}

  ~CudnnConvLayer();

  bool init(const LayerMap& layerMap, const ParameterMap& parameterMap);
  void forward(PassType passType);
  void backward(const UpdateCallback& callback);
  void addBiases();
  void bpropBiases();
};

}  // namespace paddle
