// Copyright (c) 2022 CINN Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include "paddle/cinn/auto_schedule/cost_model/feature.h"
#include "paddle/cinn/common/target.h"
#include "paddle/cinn/ir/ir.h"
#include "paddle/cinn/ir/ir_base.h"
#include "paddle/cinn/ir/ir_schedule.h"
#include "paddle/cinn/ir/ir_visitor.h"

namespace cinn {
namespace auto_schedule {

class FeatureExtractor : public ir::IRVisitorRequireReImpl<void> {
 public:
  FeatureExtractor();
  Feature Extract(const ir::ModuleExpr& mod_expr, const common::Target& target);

  void Visit(const Expr* x) override;

#define __(op__) void Visit(const ir::op__* x) override;
  NODETY_FORALL(__)
#undef __

#define __(op__) virtual void Visit(const ir::intrinsics::op__* x);
  INTRINSIC_KIND_FOR_EACH(__)
#undef __

 private:
  Feature feature_;
};

}  // namespace auto_schedule
}  // namespace cinn
