// Copyright (c) 2019 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once
#include <algorithm>
#include "lite/core/kernel.h"
#include "lite/core/op_registry.h"
#include "lite/fpga/KD/float16.hpp"
#include "lite/fpga/KD/pes/elementwise_add_pe.hpp"

namespace paddle {
namespace lite {
namespace kernels {
namespace fpga {

using float16 = zynqmp::float16;

class ElementwiseAddCompute
    : public KernelLite<TARGET(kFPGA), PRECISION(kFP16), DATALAYOUT(kNHWC)> {
 public:
  void Run() override;
  void PrepareForRun() override;

  virtual ~ElementwiseAddCompute() = default;

 private:
  zynqmp::ElementwiseAddPE pe_;
  zynqmp::Tensor input_x_;
  zynqmp::Tensor input_y_;
  zynqmp::Tensor output_;
};

class ElementwiseAddActivationCompute
    : public KernelLite<TARGET(kFPGA), PRECISION(kFP16), DATALAYOUT(kNHWC)> {
 public:
  void Run() override;
  void PrepareForRun() override;

  virtual ~ElementwiseAddActivationCompute() = default;

 private:
  zynqmp::ElementwiseAddPE pe_;
  zynqmp::Tensor input_x_;
  zynqmp::Tensor input_y_;
  zynqmp::Tensor output_;
};

}  // namespace fpga
}  // namespace kernels
}  // namespace lite
}  // namespace paddle
