// Copyright (c) 2019 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "lite/kernels/arm/is_empty_compute.h"
#include <vector>
#include "lite/api/paddle_place.h"
#include "lite/arm/math/funcs.h"
#include "lite/core/op_registry.h"
#include "lite/core/type_system.h"

namespace paddle {
namespace lite {
namespace kernels {
namespace arm {

void IsEmptyCompute::PrepareForRun() {}

void IsEmptyCompute::Run() {
  auto& param = this->Param<operators::IsEmptyParam>();
  const size_t count = param.X->numel();
  param.Out->mutable_data<bool>()[0] = (count == 0);
}

}  // namespace arm
}  // namespace kernels
}  // namespace lite
}  // namespace paddle
REGISTER_LITE_KERNEL(is_empty,
                     kARM,
                     kFloat,
                     kNCHW,
                     paddle::lite::kernels::arm::IsEmptyCompute,
                     def)
    .BindInput("X", {LiteType::GetTensorTy(TARGET(kARM))})
    .BindOutput("Out", {LiteType::GetTensorTy(TARGET(kARM))})
    .Finalize();
