// Copyright (c) 2019 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "lite/core/target_wrapper.h"
#include "lite/backends/fpga/KD/llapi/zynqmp_api.h"
#include "lite/utils/all.h"
#ifdef LITE_WITH_FPGA
namespace paddle {
namespace lite {

void* TargetWrapper<TARGET(kFPGA)>::Malloc(size_t size) {
  return zynqmp::fpga_malloc(size);
}

void TargetWrapper<TARGET(kFPGA)>::Free(void* ptr) { zynqmp::fpga_free(ptr); }

void TargetWrapper<TARGET(kFPGA)>::MemcpySync(void* dst,
                                              const void* src,
                                              size_t size,
                                              IoDirection dir) {
  memcpy(dst, src, size);
}

}  // namespace lite
}  // namespace paddle
#endif
