// Copyright (c) 2019 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "lite/operators/prior_box_op.h"
#include "lite/core/op_registry.h"

namespace paddle {
namespace lite {
namespace operators {

bool PriorBoxOpLite::CheckShape() const {
  CHECK_OR_FALSE(param_.input);
  CHECK_OR_FALSE(param_.image);
  CHECK_OR_FALSE(param_.boxes);
  CHECK_OR_FALSE(param_.variances);
  return true;
}

bool PriorBoxOpLite::InferShape() const { return true; }

bool PriorBoxOpLite::AttachImpl(const cpp::OpDesc& opdesc, lite::Scope* scope) {
  auto input = opdesc.Input("Input").front();
  auto image = opdesc.Input("Image").front();
  auto boxes = opdesc.Output("Boxes").front();
  auto variances = opdesc.Output("Variances").front();

  param_.input = scope->FindVar(input)->GetMutable<lite::Tensor>();
  param_.image = scope->FindVar(image)->GetMutable<lite::Tensor>();
  param_.boxes = scope->FindVar(boxes)->GetMutable<lite::Tensor>();
  param_.variances = scope->FindVar(variances)->GetMutable<lite::Tensor>();

  param_.clip = opdesc.GetAttr<bool>("clip");
  param_.min_sizes = opdesc.GetAttr<std::vector<float>>("min_sizes");
  param_.max_sizes = opdesc.GetAttr<std::vector<float>>("max_sizes");
  param_.aspect_ratios = opdesc.GetAttr<std::vector<float>>("aspect_ratios");
  param_.variances_ = opdesc.GetAttr<std::vector<float>>("variances");
  if (opdesc.HasAttr("flip")) {
    param_.flip = opdesc.GetAttr<bool>("flip");
  }
  if (opdesc.HasAttr("img_w")) {
    param_.img_w = opdesc.GetAttr<int>("img_w");
  }
  if (opdesc.HasAttr("img_h")) {
    param_.img_h = opdesc.GetAttr<int>("img_h");
  }
  if (opdesc.HasAttr("step_w")) {
    param_.step_w = opdesc.GetAttr<float>("step_w");
  }
  if (opdesc.HasAttr("step_h")) {
    param_.step_h = opdesc.GetAttr<float>("step_h");
  }
  param_.offset = opdesc.GetAttr<float>("offset");
  if (opdesc.HasAttr("prior_num")) {
    param_.prior_num = opdesc.GetAttr<int>("prior_num");
  }
  if (opdesc.HasAttr("order")) {
    param_.order = opdesc.GetAttr<std::vector<std::string>>("order");
  }
  if (opdesc.HasAttr("min_max_aspect_ratios_order")) {
    param_.min_max_aspect_ratios_order =
        opdesc.GetAttr<bool>("min_max_aspect_ratios_order");
  }
  return true;
}

}  // namespace operators
}  // namespace lite
}  // namespace paddle

REGISTER_LITE_OP(prior_box, paddle::lite::operators::PriorBoxOpLite);
