---
layout: post
title: Paddle-Lite文档
---

> 版本：develop

Paddle-Lite 框架是 PaddleMobile 新一代架构，重点支持移动端推理预测，特点**高性能、多硬件、轻量级** 。支持PaddleFluid/TensorFlow/Caffe/ONNX模型的推理部署，目前已经支持 ARM CPU, Mali GPU, Adreno GPU, Huawei NPU 等多种硬件，正在逐步增加 X86 CPU, Nvidia GPU 等多款硬件，相关硬件性能业内领先。

## 简介

- [技术特点]({{site.baseurl}}/develop/tech_highlights)
- [架构设计]({{site.baseurl}}/develop/architecture)
- [支持的硬件]({{site.baseurl}}/develop/support_hardware)
- [Road Map]({{site.baseurl}}/develop/roadmap)

## Benchmark

- [最新性能]({{site.baseurl}}/develop/benchmark)
- [测试方法]({{site.baseurl}}/develop/benchmark_tools)

## 安装

- [源码编译]({{site.baseurl}}/develop/source_compile)

## 使用

- [使用流程]({{site.baseurl}}/develop/tutorial)
- [C++实例]({{site.baseurl}}/develop/cpp_demo)
- [Java实例]({{site.baseurl}}/develop/java_demo)
- [Android/IOS APP demo](https://github.com/PaddlePaddle/Paddle-Lite-Demo)
- [模型转化方法]({{site.baseurl}}/develop/model_optimize_tool)
- [根据模型裁剪预测库方法]({{site.baseurl}}/develop/library_tailoring)

## 进阶

- [通过 X2Paddle 支持 Caffe, TensorFlow , ONNX 模型]({{site.baseurl}}/develop/x2paddle)
- [X2Paddle 支持模型列表]({{site.baseurl}}/develop/x2paddle_models_doc)
- [模型量化]({{site.baseurl}}/develop/model_quantization)
- [支持Op列表]({{site.baseurl}}/develop/support_operation_list)
- [新增Op方法]({{site.baseurl}}/develop/add_new_operation)
- [测试工具]({{site.baseurl}}/develop/debug_tools)
- [调试方法]({{site.baseurl}}/develop/debug_tools)
- [使用华为NPU]({{site.baseurl}}/develop/npu)
- [使用Android GPU]({{site.baseurl}}/develop/opencl)
- [使用FPGA]({{site.baseurl}}/develop/fpga)
- [使用CUDA]({{site.baseurl}}/develop/cuda)
- [使用X86预测库]({{site.baseurl}}/develop/x86)

## 开发者文档

- [开发基础须知]({{site.baseurl}}/develop/for-developer)
- [架构详解]({{site.baseurl}}/develop/architecture-intro)

## API文档

- [C++ API文档]({{site.baseurl}}/develop/cxx_api_doc)
- [Java API文档]({{site.baseurl}}/develop/java_api_doc)
- [Python API文档]({{site.baseurl}}/develop/python_api_doc)

## FAQ

- 问题或建议可以[发Issue](https://github.com/PaddlePaddle/Paddle-Lite/issues)，为加快问题解决效率，可先检索是否有类似问题，我们也会及时解答！
- 欢迎加入Paddle-Lite百度官方QQ群：696965088

## paddle-mobile

- [paddle-mobile 编译]({{site.baseurl}}/develop/mobile)
