// Copyright (c) 2019 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "lite/backends/cuda/blas.h"

namespace paddle {
namespace lite {
namespace cuda {

template <>
class Blas<float> : public BlasBase {
  using T = float;

  void sgemm(cublasOperation_t transa,
             cublasOperation_t transb,  //
             int m,
             int n,
             int k,           //
             const T* alpha,  //
             const T* A,
             int lda,  //
             const T* B,
             int ldb,        //
             const T* beta,  //
             T* C,
             int ldc) const {
    CUBLAS_CALL(cublasSgemm(handle(),
                            transa,
                            transb,
                            m,
                            n,
                            k,
                            alpha,
                            A,
                            lda,
                            B,
                            ldb,
                            beta,
                            C,
                            ldc));
  }
};

}  // namespace cuda
}  // namespace lite
}  // namespace paddle
