# 技术特点

不同于普通的移动端预测基于类 Caffe 的架构，Lite 架构最早的设计目标来源于 Paddle Server 和 Mobile 两种场景的要求，其中 Server 端需要有完善的图分析和优化能力，而 Mobile 端要求有轻量级部署的能力，两种场景共同的要求是高性能，多硬件支持等。

基于上述要求，Lite 架构完整实现了相应的能力，重点描述如下。

## 多硬件支持

Lite 架构已经验证和完整支持从 Mobile 到 Server 多种硬件的支持需求，包括 ARM CPU, ARM GPU, Huawei NPU, Intel X86 CPU, NV GPU 等。 得益于对不同硬件适度的抽象，在Lite 框架本身清晰的同时支持不同硬件的特殊调度需求，使得Lite架构在框架的清晰程度和硬件的特定调度优化上达到很好的平衡，比如 Nvidia GPU 上复杂的 stream, event 分配，在 Lite 中可以清晰表示。

多种硬件的 Kernel 在代码层和执行层均互不干扰，用户可以自由插拔任何硬件的支持。

## 高性能

高性能来源于两方面，一是 Kernel 优化；二是框架执行。

Kernel 方面，我们对相应硬件上的 Kernel 通过指令集、操作熔合、算法改写等方式进行了深入优化。

框架执行方面，通过简化 Op 和 Kernel 的功能，使得执行期的框架开销极低；此外，框架极大的灵活性可以支持各种硬件的特定调度优化以提升整体效率。

## 量化支持

Lite 支持Paddle Slim 强大的量化训练完毕的模型，因此完整保留了量化计算的高性能以及量化训练的高精度。

## 强大的图分析和优化能力

在图分析优化上，不同于常规的移动端预测引擎基于 Python 脚本工具转化模型， Lite 架构上有完整基于 C++ 开发的 IR 及相应 Pass 集合，以支持操作熔合 (Operator fusion)，计算剪枝 (Computation pruning)，存储优化 (Memory optimization)，量化计算 (Quantitative computation)  等多类计算图优化。

更多的优化策略可以简单通过添加 Pass 的方式模块化支持。 

## 轻量级部署

尽管图优化上有复杂的策略，但并不影响移动端的轻量级部署，图分析模块和最终的执行引擎可以拆开使用，最终部署只有一层薄薄的 Kernel 。

## 可支持任意硬件的混合调度

Lite 支持系统可见任意硬件的混合调度，目前已经支持 ARM CPU  和  ARM GPU 的 Kernel 自动混合调度，并验证了 X86 CPU 和 Nvidia GPU 间的混合调度。

支持混合调度的考量有两点：

1. 当系统内同时存在多种硬件可用时，混合调度可以充分利用各类硬件资源
2. 随着支持模型的增多，各硬件对kernel的支持丰富度不一，难免需要混合调度才能跑通

Lite架构通过从底层支持 `Type system`  的方式通用建模各类混合执行的行为，从而能够相对完备地支持混调。
