# Versioning (Work In Progress)


PaddlePaddle framework follows Semantic Versioning 2.0 (semver).
Each release has version of the following format: MAJOR.MINOR.PATCH
(e.g. 1.2.0). Some key points:


 * Major version number change can result in backward-incompatible changes. Codes working in old version don’t necessarily work in the new version. In addition, data, such as program model and checkpointed parameters, generated by the previous major version might not work in the new version. Tools will be attempted to be built to help the release migration.

 * Minor version number change always maintain backward compatibility. It normally contains compatible improvements and bug fixes.

 * Patch number change is for bug fixes.

 * Violation of the policy are considered as bugs and should be fixed.

### What is Covered

* All public documented Python APIs, excluding those live in the contrib namespace.

### What is Not Covered

* If an API’s implementation has bugs, we reserve the rights to fix the bugs and change the behavior.

* The Python APIs in contrib namespace.

* The Python function and classes that start with ‘_’.

* The offline tools.

* The data generated by the framework, such as serialized Program model file and checkpointed variables, are subject to different versioning scheme described below.

* C++ Inference APIs. (To be covered)


## Data


Data refers to the artifacts generated by the framework. Here, we specifically mean model Program file and the checkpointed variables.



* Backward Compatibility: User sometimes generates Data at PaddlePaddle version 1.1 and expects it to be consumed by PaddlePaddle version 1.2.
  This can happen when an new online system wants to serve an old model trained previously.



* Forward Compatibility: User sometimes generates Data at PaddlePaddle version 1.2 and expects it to be consumed by PaddlePaddle version 1.1.
  The can happen when an new successful research model want to be served by an old online system that is not frequently upgraded.



### Versioning

Data version. Data is assigned an integer version number. Version is increased when incompatible change is introduced.

PaddlePaddle framework has an interval of Data version that it supports. PadlePaddle framework within the same major version (semver) cannot drop support of lower version of Data. Hence, a minor version change cannot drop support of Data version.


For example, For PaddlePaddle version 1.1, it supports Program version 3 to 5. Later, Program version is increased from 5 to 6 due to addition of an attribute. As a result PaddlePaddle version 1.1 won’t be able to consume it. PaddlePaddle 1.2 should support Program version 3 to 6. PaddlePaddle can only drop support for Program version 3 until PaddlePaddle version 2.0.



### Known Issues

Currently, forward compatibility for new Data version is best-effort.
