
"""Tests for the zhon.zhuyin module."""

import random
import re
import unittest

from zhon import zhuyin

VALID_SYLS = (
    'ㄓ', 'ㄔ', 'ㄕ', 'ㄖ', 'ㄗ', 'ㄘ', 'ㄙ', 'ㄚ', 'ㄅㄚ', 'ㄆㄚ', 'ㄇㄚ',
    'ㄈㄚ', 'ㄉㄚ', 'ㄊㄚ', 'ㄋㄚ', 'ㄌㄚ', 'ㄍㄚ', 'ㄎㄚ', 'ㄏㄚ', 'ㄓㄚ',
    'ㄔㄚ', 'ㄕㄚ', 'ㄗㄚ', 'ㄘㄚ', 'ㄙㄚ', 'ㄛ', 'ㄅㄛ', 'ㄆㄛ', 'ㄇㄛ',
    'ㄈㄛ', 'ㄌㄛ', 'ㄜ', 'ㄇㄜ', 'ㄉㄜ', 'ㄊㄜ', 'ㄋㄜ', 'ㄌㄜ', 'ㄍㄜ',
    'ㄎㄜ', 'ㄏㄜ', 'ㄓㄜ', 'ㄔㄜ', 'ㄕㄜ', 'ㄖㄜ', 'ㄗㄜ', 'ㄘㄜ', 'ㄙㄜ',
    'ㄝ', 'ㄞ', 'ㄅㄞ', 'ㄆㄞ', 'ㄇㄞ', 'ㄉㄞ', 'ㄊㄞ', 'ㄋㄞ', 'ㄌㄞ', 'ㄍㄞ',
    'ㄎㄞ', 'ㄏㄞ', 'ㄓㄞ', 'ㄔㄞ', 'ㄕㄞ', 'ㄗㄞ', 'ㄘㄞ', 'ㄙㄞ', 'ㄟ',
    'ㄅㄟ', 'ㄆㄟ', 'ㄇㄟ', 'ㄈㄟ', 'ㄉㄟ', 'ㄋㄟ', 'ㄌㄟ', 'ㄍㄟ', 'ㄏㄟ',
    'ㄓㄟ', 'ㄕㄟ', 'ㄗㄟ', 'ㄠ', 'ㄅㄠ', 'ㄆㄠ', 'ㄇㄠ', 'ㄉㄠ', 'ㄊㄠ',
    'ㄋㄠ', 'ㄌㄠ', 'ㄍㄠ', 'ㄎㄠ', 'ㄏㄠ', 'ㄓㄠ', 'ㄔㄠ', 'ㄕㄠ', 'ㄖㄠ',
    'ㄗㄠ', 'ㄘㄠ', 'ㄙㄠ', 'ㄡ', 'ㄆㄡ', 'ㄇㄡ', 'ㄈㄡ', 'ㄉㄡ', 'ㄊㄡ',
    'ㄋㄡ', 'ㄌㄡ', 'ㄍㄡ', 'ㄎㄡ', 'ㄏㄡ', 'ㄓㄡ', 'ㄔㄡ', 'ㄕㄡ', 'ㄖㄡ',
    'ㄗㄡ', 'ㄘㄡ', 'ㄙㄡ', 'ㄢ', 'ㄅㄢ', 'ㄆㄢ', 'ㄇㄢ', 'ㄈㄢ', 'ㄉㄢ',
    'ㄊㄢ', 'ㄋㄢ', 'ㄌㄢ', 'ㄍㄢ', 'ㄎㄢ', 'ㄏㄢ', 'ㄓㄢ', 'ㄔㄢ', 'ㄕㄢ',
    'ㄖㄢ', 'ㄗㄢ', 'ㄘㄢ', 'ㄙㄢ', 'ㄣ', 'ㄅㄣ', 'ㄆㄣ', 'ㄇㄣ', 'ㄈㄣ',
    'ㄋㄣ', 'ㄍㄣ', 'ㄎㄣ', 'ㄏㄣ', 'ㄓㄣ', 'ㄔㄣ', 'ㄕㄣ', 'ㄖㄣ', 'ㄗㄣ',
    'ㄘㄣ', 'ㄙㄣ', 'ㄤ', 'ㄅㄤ', 'ㄆㄤ', 'ㄇㄤ', 'ㄈㄤ', 'ㄉㄤ', 'ㄊㄤ',
    'ㄋㄤ', 'ㄌㄤ', 'ㄍㄤ', 'ㄎㄤ', 'ㄏㄤ', 'ㄓㄤ', 'ㄔㄤ', 'ㄕㄤ', 'ㄖㄤ',
    'ㄗㄤ', 'ㄘㄤ', 'ㄙㄤ', 'ㄥ', 'ㄅㄥ', 'ㄆㄥ', 'ㄇㄥ', 'ㄈㄥ', 'ㄉㄥ',
    'ㄊㄥ', 'ㄋㄥ', 'ㄌㄥ', 'ㄍㄥ', 'ㄎㄥ', 'ㄏㄥ', 'ㄓㄥ', 'ㄔㄥ', 'ㄕㄥ',
    'ㄖㄥ', 'ㄗㄥ', 'ㄘㄥ', 'ㄙㄥ', 'ㄦ', 'ㄧ', 'ㄅㄧ', 'ㄆㄧ', 'ㄇㄧ', 'ㄉㄧ',
    'ㄊㄧ', 'ㄋㄧ', 'ㄌㄧ', 'ㄐㄧ', 'ㄑㄧ', 'ㄒㄧ', 'ㄧㄚ', 'ㄉㄧㄚ', 'ㄌㄧㄚ',
    'ㄐㄧㄚ', 'ㄑㄧㄚ', 'ㄒㄧㄚ', 'ㄧㄛ', 'ㄧㄝ', 'ㄅㄧㄝ', 'ㄆㄧㄝ', 'ㄇㄧㄝ',
    'ㄉㄧㄝ', 'ㄊㄧㄝ', 'ㄋㄧㄝ', 'ㄌㄧㄝ', 'ㄐㄧㄝ', 'ㄑㄧㄝ', 'ㄒㄧㄝ',
    'ㄧㄞ', 'ㄧㄠ', 'ㄅㄧㄠ', 'ㄆㄧㄠ', 'ㄇㄧㄠ', 'ㄉㄧㄠ', 'ㄊㄧㄠ', 'ㄋㄧㄠ',
    'ㄌㄧㄠ', 'ㄐㄧㄠ', 'ㄑㄧㄠ', 'ㄒㄧㄠ', 'ㄧㄡ', 'ㄇㄧㄡ', 'ㄉㄧㄡ',
    'ㄋㄧㄡ', 'ㄌㄧㄡ', 'ㄐㄧㄡ', 'ㄑㄧㄡ', 'ㄒㄧㄡ', 'ㄧㄢ', 'ㄅㄧㄢ',
    'ㄆㄧㄢ', 'ㄇㄧㄢ', 'ㄉㄧㄢ', 'ㄊㄧㄢ', 'ㄋㄧㄢ', 'ㄌㄧㄢ', 'ㄐㄧㄢ',
    'ㄑㄧㄢ', 'ㄒㄧㄢ', 'ㄧㄣ', 'ㄅㄧㄣ', 'ㄆㄧㄣ', 'ㄇㄧㄣ', 'ㄋㄧㄣ',
    'ㄌㄧㄣ', 'ㄐㄧㄣ', 'ㄑㄧㄣ', 'ㄒㄧㄣ', 'ㄧㄤ', 'ㄋㄧㄤ', 'ㄌㄧㄤ',
    'ㄐㄧㄤ', 'ㄑㄧㄤ', 'ㄒㄧㄤ', 'ㄧㄥ', 'ㄅㄧㄥ', 'ㄆㄧㄥ', 'ㄇㄧㄥ',
    'ㄉㄧㄥ', 'ㄊㄧㄥ', 'ㄋㄧㄥ', 'ㄌㄧㄥ', 'ㄐㄧㄥ', 'ㄑㄧㄥ', 'ㄒㄧㄥ', 'ㄨ',
    'ㄅㄨ', 'ㄆㄨ', 'ㄇㄨ', 'ㄈㄨ', 'ㄉㄨ', 'ㄊㄨ', 'ㄋㄨ', 'ㄌㄨ', 'ㄍㄨ',
    'ㄎㄨ', 'ㄏㄨ', 'ㄓㄨ', 'ㄔㄨ', 'ㄕㄨ', 'ㄖㄨ', 'ㄗㄨ', 'ㄘㄨ', 'ㄙㄨ',
    'ㄨㄚ', 'ㄍㄨㄚ', 'ㄎㄨㄚ', 'ㄏㄨㄚ', 'ㄓㄨㄚ', 'ㄔㄨㄚ', 'ㄕㄨㄚ', 'ㄨㄛ',
    'ㄉㄨㄛ', 'ㄊㄨㄛ', 'ㄋㄨㄛ', 'ㄌㄨㄛ', 'ㄍㄨㄛ', 'ㄎㄨㄛ', 'ㄏㄨㄛ',
    'ㄓㄨㄛ', 'ㄔㄨㄛ', 'ㄕㄨㄛ', 'ㄖㄨㄛ', 'ㄗㄨㄛ', 'ㄘㄨㄛ', 'ㄙㄨㄛ',
    'ㄨㄞ', 'ㄍㄨㄞ', 'ㄎㄨㄞ', 'ㄏㄨㄞ', 'ㄓㄨㄞ', 'ㄔㄨㄞ', 'ㄕㄨㄞ', 'ㄨㄟ',
    'ㄉㄨㄟ', 'ㄊㄨㄟ', 'ㄍㄨㄟ', 'ㄎㄨㄟ', 'ㄏㄨㄟ', 'ㄓㄨㄟ', 'ㄔㄨㄟ',
    'ㄕㄨㄟ', 'ㄖㄨㄟ', 'ㄗㄨㄟ', 'ㄘㄨㄟ', 'ㄙㄨㄟ', 'ㄨㄢ', 'ㄉㄨㄢ',
    'ㄊㄨㄢ', 'ㄋㄨㄢ', 'ㄌㄨㄢ', 'ㄍㄨㄢ', 'ㄎㄨㄢ', 'ㄏㄨㄢ', 'ㄓㄨㄢ',
    'ㄔㄨㄢ', 'ㄕㄨㄢ', 'ㄖㄨㄢ', 'ㄗㄨㄢ', 'ㄘㄨㄢ', 'ㄙㄨㄢ', 'ㄨㄣ',
    'ㄉㄨㄣ', 'ㄊㄨㄣ', 'ㄌㄨㄣ', 'ㄍㄨㄣ', 'ㄎㄨㄣ', 'ㄏㄨㄣ', 'ㄓㄨㄣ',
    'ㄔㄨㄣ', 'ㄕㄨㄣ', 'ㄖㄨㄣ', 'ㄗㄨㄣ', 'ㄘㄨㄣ', 'ㄙㄨㄣ', 'ㄨㄤ',
    'ㄍㄨㄤ', 'ㄎㄨㄤ', 'ㄏㄨㄤ', 'ㄓㄨㄤ', 'ㄔㄨㄤ', 'ㄕㄨㄤ', 'ㄨㄥ',
    'ㄉㄨㄥ', 'ㄊㄨㄥ', 'ㄋㄨㄥ', 'ㄌㄨㄥ', 'ㄍㄨㄥ', 'ㄎㄨㄥ', 'ㄏㄨㄥ',
    'ㄓㄨㄥ', 'ㄔㄨㄥ', 'ㄖㄨㄥ', 'ㄗㄨㄥ', 'ㄘㄨㄥ', 'ㄙㄨㄥ', 'ㄩ', 'ㄋㄩ',
    'ㄌㄩ', 'ㄐㄩ', 'ㄑㄩ', 'ㄒㄩ', 'ㄩㄝ', 'ㄋㄩㄝ', 'ㄌㄩㄝ', 'ㄐㄩㄝ',
    'ㄑㄩㄝ', 'ㄒㄩㄝ', 'ㄩㄢ', 'ㄐㄩㄢ', 'ㄑㄩㄢ', 'ㄒㄩㄢ', 'ㄩㄣ', 'ㄌㄩㄣ',
    'ㄐㄩㄣ', 'ㄑㄩㄣ', 'ㄒㄩㄣ', 'ㄩㄥ', 'ㄐㄩㄥ', 'ㄑㄩㄥ', 'ㄒㄩㄥ'
)

SYL = re.compile(zhuyin.syllable)


def create_syllable():
    syl = random.choice(VALID_SYLS)
    return syl + random.choice(list(zhuyin.marks) + [' '])


class TestZhuyinSyllables(unittest.TestCase):

    def test_zhuyin_syllable(self):
        vs = []
        for n in range(0, len(VALID_SYLS)):
            vs.append(VALID_SYLS[n] + random.choice(list(zhuyin.marks) + ['']))
        s = ''.join(vs)
        self.assertEqual(''.join(SYL.findall(s)), s)
