# PaddlePaddle Speech toolkit

![License](https://img.shields.io/badge/license-Apache%202-red.svg)
![python version](https://img.shields.io/badge/python-3.7+-orange.svg)
![support os](https://img.shields.io/badge/os-linux-yellow.svg)

*DeepSpeech* is an open-source implementation of end-to-end Automatic Speech Recognition engine, with [PaddlePaddle](https://github.com/PaddlePaddle/Paddle) platform. Our vision is to empower both industrial application and academic research on speech recognition, via an easy-to-use, efficient, samller and scalable implementation, including training, inference & testing module, and deployment.


## Features

 See [feature list](docs/source/feature_list.md) for more information.

## Setup

All tested under:  
* Ubuntu 16.04
* python>=3.7
* paddlepaddle==2.1.2

Please see [install](docs/source/install.md).

## Getting Started

Please see [Getting Started](docs/source/getting_started.md) and [tiny egs](examples/tiny/s0/README.md).


## More Information  

* [Data Prepration](docs/source/data_preparation.md)  
* [Data Augmentation](docs/source/augmentation.md)  
* [Ngram LM](docs/source/ngram_lm.md)  
* [Benchmark](docs/source/benchmark.md)  
* [Relased Model](docs/source/released_model.md)  


## Questions and Help

You are welcome to submit questions in [Github Discussions](https://github.com/PaddlePaddle/DeepSpeech/discussions) and bug reports in [Github Issues](https://github.com/PaddlePaddle/DeepSpeech/issues). You are also welcome to contribute to this project.


## License

DeepSpeech is provided under the [Apache-2.0 License](./LICENSE).

## Acknowledgement

We depends on many open source repos. See [References](docs/source/reference.md) for more information.
