/*
 * Copyright (c) 2013-2019 Huawei Technologies Co., Ltd. All rights reserved.
 * Copyright (c) 2020-2021 Huawei Device Co., Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list
 * of conditions and the following disclaimer in the documentation and/or other materials
 * provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "it_test_process.h"

static void *Thread(void *arg)
{
    sleep(1);
    return NULL;
}

static int GroupProcess(void)
{
    int testPid;
    int ret;
    int status = 0;
    pid_t pid, pid1;
    int count = 500;
    int waitProcess = 0;
    pthread_attr_t a = { 0 };
    pthread_t pthread[1000] = { 0 };
    struct sched_param param = { 0 };
    bool thread = false;

    int processCount = 0;

    pthread_attr_init(&a);
    param.sched_priority = 31; // 31, set pthread priority.
    pthread_attr_setschedparam(&a, &param);
    for (int i = 0; i < 40; i++) { // 40, number of cycles
        ret = pthread_create(&pthread[i], &a, Thread, NULL);
        if (ret != 0) {
            exit(10); // 10, exit args
            break;
        }
    }

    for (int i = 0; i < count; i++) {
        pid = fork();
        if (pid == 0) {
            pthread_create(&pthread[100], &a, Thread, NULL); // 100, pthread array subscript
            pthread_create(&pthread[100], &a, Thread, NULL); // 100, pthread array subscript
            pthread_create(&pthread[100], &a, Thread, NULL); // 100, pthread array subscript
            usleep(1000 * 10 * 50); // 1000, 10, 50, Used to calculate the delay time.
            exit(0);
        } else if (pid < 0) {
            if (errno != EAGAIN) {
                sleep(1);
            }
            ret = wait(&status);
            if (ret > 0) {
                processCount--;
            }
            continue;
        } else {
            processCount++;
            testPid = pid;
            continue;
        }
    }

    ret = 0;
    while (processCount > 0) {
        ret = wait(&status);
        if (ret > 0) {
            processCount--;
        } else {
            sleep(1);
        }
    }

    exit(255); // 255, exit args
EXIT:
    return 0;
}

static int TestCase(void)
{
    int ret;
    int status = 0;
    pid_t pid, pid1;
    pid = fork();
    ICUNIT_GOTO_WITHIN_EQUAL(pid, 0, 100000, pid, EXIT); // 100000, assert pid equal to this.

    if (pid == 0) {
        prctl(PR_SET_NAME, "mainFork", 0UL, 0UL, 0UL);
        GroupProcess();
        printf("[Failed] - [Errline : %d RetCode : 0x%x\n", g_iCunitErrLineNo, g_iCunitErrCode);
        exit(g_iCunitErrLineNo);
    }

    ret = waitpid(pid, &status, 0);
    ICUNIT_ASSERT_EQUAL(ret, pid, ret);
    status = WEXITSTATUS(status);
    ICUNIT_GOTO_EQUAL(status, 255, status, EXIT); // 255, assert status equal to this.

    return 0;
EXIT:
    return 1;
}

void ItTestProcess041(void)
{
    TEST_ADD_CASE("IT_POSIX_PROCESS_041", TestCase, TEST_POSIX, TEST_MEM, TEST_LEVEL0, TEST_FUNCTION);
}
