/*
 * Copyright (c) 2013-2019 Huawei Technologies Co., Ltd. All rights reserved.
 * Copyright (c) 2020-2021 Huawei Device Co., Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 *    conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list
 *    of conditions and the following disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

 * PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "It_vfs_fat.h"

static VOID *PthreadF01(void *arg)
{
    INT32 ret;
    CHAR fileName[FAT_STANDARD_NAME_LENGTH] = "";
    time_t tTime;
    struct tm stTime;

    g_testCount++;

    time(&tTime);
    localtime_r(&tTime, &stTime);
    (void)memset_s(g_fatPathname1, FAT_STANDARD_NAME_LENGTH, 0, FAT_STANDARD_NAME_LENGTH);
    strftime(g_fatPathname1, FAT_STANDARD_NAME_LENGTH - 1, "%Y-%m-%d_%H.%M.%S", &stTime);
    (void)snprintf_s(fileName, FAT_STANDARD_NAME_LENGTH - 1, FAT_STANDARD_NAME_LENGTH - 1, "/vs/sd/%s_#%d",
        g_fatPathname1, (INT32)arg);

    (void)snprintf_s(g_fatPathname1, FAT_STANDARD_NAME_LENGTH, FAT_STANDARD_NAME_LENGTH - 1, "testfile#%d", (INT32)arg);
    prctl(PR_SET_NAME, (unsigned long)g_fatPathname1, 0, 0, 0);

    ret = RandWrite(fileName, FILE_SIZE, 0);
    ICUNIT_GOTO_EQUAL(ret, FAT_NO_ERROR, ret, EXIT);

    ret = RandRead(fileName, FILE_SIZE, 0);
    ICUNIT_GOTO_EQUAL(ret, FAT_NO_ERROR, ret, EXIT);

    g_testCount++;

    return FAT_NO_ERROR;

EXIT:
    return FAT_NO_ERROR;
    g_testCount = 0;
}
static UINT32 TestCase(VOID)
{
    INT32 ret;
    pthread_t threadId = 0;
    pthread_attr_t attr;

    g_testCount = 0;

    ret = chdir("/");
    ICUNIT_GOTO_EQUAL(ret, FAT_NO_ERROR, ret, EXIT0);

    ret = umount(FAT_MOUNT_DIR);
    ICUNIT_GOTO_EQUAL(ret, FAT_NO_ERROR, ret, EXIT);

    ret = mount(FAT_DEV_PATH, FAT_MOUNT_DIR, FAT_FILESYS_TYPE, 0, NULL);
    ICUNIT_GOTO_EQUAL(ret, FAT_NO_ERROR, ret, EXIT);

    ret = PosixPthreadInit(&attr, 4); // level 4
    ICUNIT_ASSERT_EQUAL(ret, FAT_NO_ERROR, ret);

    ret = pthread_create(&threadId, &attr, PthreadF01, NULL);
    ICUNIT_ASSERT_EQUAL(ret, FAT_NO_ERROR, ret);

    while (g_testCount < 2) { // each thread add 2 at g_testCount
        sleep(1);
    }

    ret = pthread_join(threadId, NULL);
    ICUNIT_GOTO_EQUAL(ret, FAT_NO_ERROR, ret, EXIT);

    ret = pthread_attr_destroy(&attr);
    ICUNIT_GOTO_EQUAL(ret, FAT_NO_ERROR, ret, EXIT);

    return FAT_NO_ERROR;
EXIT:
    pthread_join(threadId, NULL);
    pthread_attr_destroy(&attr);
EXIT0:
    return FAT_NO_ERROR;
}

VOID ItFsFatPerformance001(VOID)
{
    TEST_ADD_CASE("IT_FS_FAT_PERFORMANCE_001", TestCase, TEST_VFS, TEST_VFAT, TEST_LEVEL3, TEST_PERFORMANCE);
}
