/*
 * Copyright (c) 2013-2019 Huawei Technologies Co., Ltd. All rights reserved.
 * Copyright (c) 2020-2023 Huawei Device Co., Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list
 * of conditions and the following disclaimer in the documentation and/or other materials
 * provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "It_posix_queue.h"

#define QUEUE_NAME_MAX_LEN (MQUEUE_NAME_MAX_TEST * 2)

static UINT32 Testcase(VOID)
{
    CHAR mqname[QUEUE_NAME_MAX_LEN];
    mqd_t mqueue;
    UINT32 ret;
    INT32 i;

    ret = snprintf_s(mqname, QUEUE_NAME_MAX_LEN, QUEUE_NAME_MAX_LEN - 1, \
                     "/mq025_%d", LosCurTaskIDGet()); // 2, mqname length.
    ICUNIT_GOTO_NOT_EQUAL(ret, MQUEUE_IS_ERROR, ret, EXIT1);

    for (i = 0; i < MQUEUE_NAME_MAX_TEST; i++) {
        ret = strcat_s(mqname, QUEUE_NAME_MAX_LEN, "0");
        ICUNIT_ASSERT_EQUAL(ret, EOK, ret);
    }

    mqueue = mq_open(mqname, O_CREAT | O_RDWR, S_IRUSR | S_IWUSR, NULL);
    ICUNIT_GOTO_EQUAL(mqueue, (mqd_t)-1, mqueue, EXIT);
    ICUNIT_ASSERT_EQUAL(errno, ENAMETOOLONG, errno);

    return MQUEUE_NO_ERROR;
EXIT:
    mq_close(mqueue);
    mq_unlink(mqname);
EXIT1:
    return MQUEUE_IS_ERROR;
}

VOID ItPosixQueue025(VOID)
{
    TEST_ADD_CASE("IT_POSIX_QUEUE_025", Testcase, TEST_POSIX, TEST_QUE, TEST_LEVEL2, TEST_FUNCTION);
}
