/*

  Broadcom B43 wireless driver
  IEEE 802.11n 2056 radio device data tables

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
  Boston, MA 02110-1301, USA.

*/

#include "b43.h"
#include "radio_2056.h"
#include "phy_common.h"

#define RADIOREGS3(r00, r01, r02, r03, r04, r05, r06, r07, r08, r09, \
		   r10, r11, r12, r13, r14, r15, r16, r17, r18, r19, \
		   r20, r21, r22, r23, r24, r25, r26, r27, r28, r29, \
		   r30, r31, r32, r33, r34, r35, r36) \
	.radio_syn_pll_vcocal1		= r00,	\
	.radio_syn_pll_vcocal2		= r01,	\
	.radio_syn_pll_refdiv		= r02,	\
	.radio_syn_pll_mmd2		= r03,	\
	.radio_syn_pll_mmd1		= r04,	\
	.radio_syn_pll_loopfilter1	= r05,	\
	.radio_syn_pll_loopfilter2	= r06,	\
	.radio_syn_pll_loopfilter3	= r07,	\
	.radio_syn_pll_loopfilter4	= r08,	\
	.radio_syn_pll_loopfilter5	= r09,	\
	.radio_syn_reserved_addr27	= r10,	\
	.radio_syn_reserved_addr28	= r11,	\
	.radio_syn_reserved_addr29	= r12,	\
	.radio_syn_logen_vcobuf1	= r13,	\
	.radio_syn_logen_mixer2		= r14,	\
	.radio_syn_logen_buf3		= r15,	\
	.radio_syn_logen_buf4		= r16,	\
	.radio_rx0_lnaa_tune		= r17,	\
	.radio_rx0_lnag_tune		= r18,	\
	.radio_tx0_intpaa_boost_tune	= r19,	\
	.radio_tx0_intpag_boost_tune	= r20,	\
	.radio_tx0_pada_boost_tune	= r21,	\
	.radio_tx0_padg_boost_tune	= r22,	\
	.radio_tx0_pgaa_boost_tune	= r23,	\
	.radio_tx0_pgag_boost_tune	= r24,	\
	.radio_tx0_mixa_boost_tune	= r25,	\
	.radio_tx0_mixg_boost_tune	= r26,	\
	.radio_rx1_lnaa_tune		= r27,	\
	.radio_rx1_lnag_tune		= r28,	\
	.radio_tx1_intpaa_boost_tune	= r29,	\
	.radio_tx1_intpag_boost_tune	= r30,	\
	.radio_tx1_pada_boost_tune	= r31,	\
	.radio_tx1_padg_boost_tune	= r32,	\
	.radio_tx1_pgaa_boost_tune	= r33,	\
	.radio_tx1_pgag_boost_tune	= r34,	\
	.radio_tx1_mixa_boost_tune	= r35,	\
	.radio_tx1_mixg_boost_tune	= r36

#define PHYREGS(r0, r1, r2, r3, r4, r5)	\
	.phy_regs.phy_bw1a	= r0,	\
	.phy_regs.phy_bw2	= r1,	\
	.phy_regs.phy_bw3	= r2,	\
	.phy_regs.phy_bw4	= r3,	\
	.phy_regs.phy_bw5	= r4,	\
	.phy_regs.phy_bw6	= r5

/* http://bcm-v4.sipsolutions.net/802.11/Radio/2056/ChannelTable */
static const struct b43_nphy_channeltab_entry_rev3 b43_nphy_channeltab_rev3[] = {
  {	.freq			= 4920,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xec, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07b4, 0x07b0, 0x07ac, 0x0214, 0x0215, 0x0216),
  },
  {	.freq			= 4930,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xed, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07b8, 0x07b4, 0x07b0, 0x0213, 0x0214, 0x0215),
  },
  {	.freq			= 4940,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xee, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07bc, 0x07b8, 0x07b4, 0x0212, 0x0213, 0x0214),
  },
  {	.freq			= 4950,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xef, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07c0, 0x07bc, 0x07b8, 0x0211, 0x0212, 0x0213),
  },
  {	.freq			= 4960,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf0, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07c4, 0x07c0, 0x07bc, 0x020f, 0x0211, 0x0212),
  },
  {	.freq			= 4970,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf1, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07c8, 0x07c4, 0x07c0, 0x020e, 0x020f, 0x0211),
  },
  {	.freq			= 4980,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf2, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07cc, 0x07c8, 0x07c4, 0x020d, 0x020e, 0x020f),
  },
  {	.freq			= 4990,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf3, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07d0, 0x07cc, 0x07c8, 0x020c, 0x020d, 0x020e),
  },
  {	.freq			= 5000,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf4, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07d4, 0x07d0, 0x07cc, 0x020b, 0x020c, 0x020d),
  },
  {	.freq			= 5010,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf5, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07d8, 0x07d4, 0x07d0, 0x020a, 0x020b, 0x020c),
  },
  {	.freq			= 5020,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf6, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07dc, 0x07d8, 0x07d4, 0x0209, 0x020a, 0x020b),
  },
  {	.freq			= 5030,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf7, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07e0, 0x07dc, 0x07d8, 0x0208, 0x0209, 0x020a),
  },
  {	.freq			= 5040,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf8, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07e4, 0x07e0, 0x07dc, 0x0207, 0x0208, 0x0209),
  },
  {	.freq			= 5050,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf9, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07e8, 0x07e4, 0x07e0, 0x0206, 0x0207, 0x0208),
  },
  {	.freq			= 5060,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfa, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07ec, 0x07e8, 0x07e4, 0x0205, 0x0206, 0x0207),
  },
  {	.freq			= 5070,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfb, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07f0, 0x07ec, 0x07e8, 0x0204, 0x0205, 0x0206),
  },
  {	.freq			= 5080,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfc, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07f4, 0x07f0, 0x07ec, 0x0203, 0x0204, 0x0205),
  },
  {	.freq			= 5090,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfd, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07f8, 0x07f4, 0x07f0, 0x0202, 0x0203, 0x0204),
  },
  {	.freq			= 5100,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xfe, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xff, 0x00),
	PHYREGS(0x07fc, 0x07f8, 0x07f4, 0x0201, 0x0202, 0x0203),
  },
  {	.freq			= 5110,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xff, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xfc, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xfc, 0x00),
	PHYREGS(0x0800, 0x07fc, 0x07f8, 0x0200, 0x0201, 0x0202),
  },
  {	.freq			= 5120,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x00, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xfc, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xfc, 0x00),
	PHYREGS(0x0804, 0x0800, 0x07fc, 0x01ff, 0x0200, 0x0201),
  },
  {	.freq			= 5130,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x01, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xfc, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xfc, 0x00),
	PHYREGS(0x0808, 0x0804, 0x0800, 0x01fe, 0x01ff, 0x0200),
  },
  {	.freq			= 5140,
	RADIOREGS3(0xc6, 0x01, 0x01, 0x02, 0x02, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xfc, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xfc, 0x00),
	PHYREGS(0x080c, 0x0808, 0x0804, 0x01fd, 0x01fe, 0x01ff),
  },
  {	.freq			= 5160,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x04, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xfc, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xfc, 0x00),
	PHYREGS(0x0814, 0x0810, 0x080c, 0x01fb, 0x01fc, 0x01fd),
  },
  {	.freq			= 5170,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x05, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xfc, 0x00, 0xff, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xfc, 0x00),
	PHYREGS(0x0818, 0x0814, 0x0810, 0x01fa, 0x01fb, 0x01fc),
  },
  {	.freq			= 5180,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x06, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xef, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xfc, 0x00, 0xef, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xfc, 0x00),
	PHYREGS(0x081c, 0x0818, 0x0814, 0x01f9, 0x01fa, 0x01fb),
  },
  {	.freq			= 5190,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x07, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xef, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xfc, 0x00, 0xef, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xfc, 0x00),
	PHYREGS(0x0820, 0x081c, 0x0818, 0x01f8, 0x01f9, 0x01fa),
  },
  {	.freq			= 5200,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x08, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xef, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xef, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x0824, 0x0820, 0x081c, 0x01f7, 0x01f8, 0x01f9),
  },
  {	.freq			= 5210,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x09, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xdf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xdf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x0828, 0x0824, 0x0820, 0x01f6, 0x01f7, 0x01f8),
  },
  {	.freq			= 5220,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xdf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xdf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x082c, 0x0828, 0x0824, 0x01f5, 0x01f6, 0x01f7),
  },
  {	.freq			= 5230,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xdf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xdf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x0830, 0x082c, 0x0828, 0x01f4, 0x01f5, 0x01f6),
  },
  {	.freq			= 5240,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xcf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xcf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x0834, 0x0830, 0x082c, 0x01f3, 0x01f4, 0x01f5),
  },
  {	.freq			= 5250,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xcf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xcf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x0838, 0x0834, 0x0830, 0x01f2, 0x01f3, 0x01f4),
  },
  {	.freq			= 5260,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xcf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xcf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x083c, 0x0838, 0x0834, 0x01f1, 0x01f2, 0x01f3),
  },
  {	.freq			= 5270,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xcf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xcf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x0840, 0x083c, 0x0838, 0x01f0, 0x01f1, 0x01f2),
  },
  {	.freq			= 5280,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x10, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xbf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xbf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x0844, 0x0840, 0x083c, 0x01f0, 0x01f0, 0x01f1),
  },
  {	.freq			= 5290,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x11, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xbf, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xfc, 0x00, 0xbf, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xfc, 0x00),
	PHYREGS(0x0848, 0x0844, 0x0840, 0x01ef, 0x01f0, 0x01f0),
  },
  {	.freq			= 5300,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x12, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xbf, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfc, 0x00, 0xbf, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfc, 0x00),
	PHYREGS(0x084c, 0x0848, 0x0844, 0x01ee, 0x01ef, 0x01f0),
  },
  {	.freq			= 5310,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x13, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xbf, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0xbf, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x0850, 0x084c, 0x0848, 0x01ed, 0x01ee, 0x01ef),
  },
  {	.freq			= 5320,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x14, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xbf, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0xbf, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x0854, 0x0850, 0x084c, 0x01ec, 0x01ed, 0x01ee),
  },
  {	.freq			= 5330,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x15, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xaf, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0xaf, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x0858, 0x0854, 0x0850, 0x01eb, 0x01ec, 0x01ed),
  },
  {	.freq			= 5340,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x16, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xaf, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0xaf, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x085c, 0x0858, 0x0854, 0x01ea, 0x01eb, 0x01ec),
  },
  {	.freq			= 5350,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x17, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x9f, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0x9f, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x0860, 0x085c, 0x0858, 0x01e9, 0x01ea, 0x01eb),
  },
  {	.freq			= 5360,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x18, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x9f, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0x9f, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x0864, 0x0860, 0x085c, 0x01e8, 0x01e9, 0x01ea),
  },
  {	.freq			= 5370,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x19, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x9f, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0x9f, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x0868, 0x0864, 0x0860, 0x01e7, 0x01e8, 0x01e9),
  },
  {	.freq			= 5380,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x9f, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0x9f, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x086c, 0x0868, 0x0864, 0x01e6, 0x01e7, 0x01e8),
  },
  {	.freq			= 5390,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x8f, 0x00, 0x05, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xfa, 0x00, 0x8f, 0x00, 0x05, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xfa, 0x00),
	PHYREGS(0x0870, 0x086c, 0x0868, 0x01e5, 0x01e6, 0x01e7),
  },
  {	.freq			= 5400,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x8f, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xfa, 0x00, 0x8f, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xfa, 0x00),
	PHYREGS(0x0874, 0x0870, 0x086c, 0x01e5, 0x01e5, 0x01e6),
  },
  {	.freq			= 5410,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x8f, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xfa, 0x00, 0x8f, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xfa, 0x00),
	PHYREGS(0x0878, 0x0874, 0x0870, 0x01e4, 0x01e5, 0x01e5),
  },
  {	.freq			= 5420,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x8e, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xfa, 0x00, 0x8e, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xfa, 0x00),
	PHYREGS(0x087c, 0x0878, 0x0874, 0x01e3, 0x01e4, 0x01e5),
  },
  {	.freq			= 5430,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x8e, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xfa, 0x00, 0x8e, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xfa, 0x00),
	PHYREGS(0x0880, 0x087c, 0x0878, 0x01e2, 0x01e3, 0x01e4),
  },
  {	.freq			= 5440,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x20, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x7e, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xfa, 0x00, 0x7e, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xfa, 0x00),
	PHYREGS(0x0884, 0x0880, 0x087c, 0x01e1, 0x01e2, 0x01e3),
  },
  {	.freq			= 5450,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x21, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x7d, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xfa, 0x00, 0x7d, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xfa, 0x00),
	PHYREGS(0x0888, 0x0884, 0x0880, 0x01e0, 0x01e1, 0x01e2),
  },
  {	.freq			= 5460,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x22, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x6d, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xf8, 0x00, 0x6d, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xf8, 0x00),
	PHYREGS(0x088c, 0x0888, 0x0884, 0x01df, 0x01e0, 0x01e1),
  },
  {	.freq			= 5470,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x23, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x6d, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xf8, 0x00, 0x6d, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xf8, 0x00),
	PHYREGS(0x0890, 0x088c, 0x0888, 0x01de, 0x01df, 0x01e0),
  },
  {	.freq			= 5480,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x24, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x5d, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xf8, 0x00, 0x5d, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xf8, 0x00),
	PHYREGS(0x0894, 0x0890, 0x088c, 0x01dd, 0x01de, 0x01df),
  },
  {	.freq			= 5490,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x25, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x5c, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x08,
		   0x00, 0xf8, 0x00, 0x5c, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x08, 0x00, 0xf8, 0x00),
	PHYREGS(0x0898, 0x0894, 0x0890, 0x01dd, 0x01dd, 0x01de),
  },
  {	.freq			= 5500,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x26, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x5c, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x5c, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x089c, 0x0898, 0x0894, 0x01dc, 0x01dd, 0x01dd),
  },
  {	.freq			= 5510,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x27, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x4c, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x4c, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08a0, 0x089c, 0x0898, 0x01db, 0x01dc, 0x01dd),
  },
  {	.freq			= 5520,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x28, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x4c, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x4c, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08a4, 0x08a0, 0x089c, 0x01da, 0x01db, 0x01dc),
  },
  {	.freq			= 5530,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x29, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x3b, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x3b, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08a8, 0x08a4, 0x08a0, 0x01d9, 0x01da, 0x01db),
  },
  {	.freq			= 5540,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x3b, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x3b, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08ac, 0x08a8, 0x08a4, 0x01d8, 0x01d9, 0x01da),
  },
  {	.freq			= 5550,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x3b, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x3b, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08b0, 0x08ac, 0x08a8, 0x01d7, 0x01d8, 0x01d9),
  },
  {	.freq			= 5560,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x2b, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x2b, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08b4, 0x08b0, 0x08ac, 0x01d7, 0x01d7, 0x01d8),
  },
  {	.freq			= 5570,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x2a, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x2a, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08b8, 0x08b4, 0x08b0, 0x01d6, 0x01d7, 0x01d7),
  },
  {	.freq			= 5580,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x1a, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x1a, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08bc, 0x08b8, 0x08b4, 0x01d5, 0x01d6, 0x01d7),
  },
  {	.freq			= 5590,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x1a, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x1a, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08c0, 0x08bc, 0x08b8, 0x01d4, 0x01d5, 0x01d6),
  },
  {	.freq			= 5600,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x30, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x1a, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x1a, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08c4, 0x08c0, 0x08bc, 0x01d3, 0x01d4, 0x01d5),
  },
  {	.freq			= 5610,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x31, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x19, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x19, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08c8, 0x08c4, 0x08c0, 0x01d2, 0x01d3, 0x01d4),
  },
  {	.freq			= 5620,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x32, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x19, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x19, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08cc, 0x08c8, 0x08c4, 0x01d2, 0x01d2, 0x01d3),
  },
  {	.freq			= 5630,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x33, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x09, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x09, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08d0, 0x08cc, 0x08c8, 0x01d1, 0x01d2, 0x01d2),
  },
  {	.freq			= 5640,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x34, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x09, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x09, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08d4, 0x08d0, 0x08cc, 0x01d0, 0x01d1, 0x01d2),
  },
  {	.freq			= 5650,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x35, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x08, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf8, 0x00, 0x08, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf8, 0x00),
	PHYREGS(0x08d8, 0x08d4, 0x08d0, 0x01cf, 0x01d0, 0x01d1),
  },
  {	.freq			= 5660,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x36, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x08, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf6, 0x00, 0x08, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf6, 0x00),
	PHYREGS(0x08dc, 0x08d8, 0x08d4, 0x01ce, 0x01cf, 0x01d0),
  },
  {	.freq			= 5670,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x37, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x08, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf6, 0x00, 0x08, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf6, 0x00),
	PHYREGS(0x08e0, 0x08dc, 0x08d8, 0x01ce, 0x01ce, 0x01cf),
  },
  {	.freq			= 5680,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x38, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x08, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf6, 0x00, 0x08, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf6, 0x00),
	PHYREGS(0x08e4, 0x08e0, 0x08dc, 0x01cd, 0x01ce, 0x01ce),
  },
  {	.freq			= 5690,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x39, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x07, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf6, 0x00, 0x07, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf6, 0x00),
	PHYREGS(0x08e8, 0x08e4, 0x08e0, 0x01cc, 0x01cd, 0x01ce),
  },
  {	.freq			= 5700,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x07, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf6, 0x00, 0x07, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf6, 0x00),
	PHYREGS(0x08ec, 0x08e8, 0x08e4, 0x01cb, 0x01cc, 0x01cd),
  },
  {	.freq			= 5710,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x07, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x07, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x08f0, 0x08ec, 0x08e8, 0x01ca, 0x01cb, 0x01cc),
  },
  {	.freq			= 5720,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x07, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x07, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x08f4, 0x08f0, 0x08ec, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5725,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x79, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x06, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x08f6, 0x08f2, 0x08ee, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5730,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x06, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x08f8, 0x08f4, 0x08f0, 0x01c9, 0x01c9, 0x01ca),
  },
  {	.freq			= 5735,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x7b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x06, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x08fa, 0x08f6, 0x08f2, 0x01c8, 0x01c9, 0x01ca),
  },
  {	.freq			= 5740,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x06, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x08fc, 0x08f8, 0x08f4, 0x01c8, 0x01c9, 0x01c9),
  },
  {	.freq			= 5745,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x06, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x08fe, 0x08fa, 0x08f6, 0x01c8, 0x01c8, 0x01c9),
  },
  {	.freq			= 5750,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x06, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0900, 0x08fc, 0x08f8, 0x01c7, 0x01c8, 0x01c9),
  },
  {	.freq			= 5755,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7f, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x05, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0902, 0x08fe, 0x08fa, 0x01c7, 0x01c8, 0x01c8),
  },
  {	.freq			= 5760,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x40, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x05, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0904, 0x0900, 0x08fc, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5765,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x81, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x05, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0906, 0x0902, 0x08fe, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5770,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x41, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x05, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0908, 0x0904, 0x0900, 0x01c6, 0x01c6, 0x01c7),
  },
  {	.freq			= 5775,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x83, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x05, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x090a, 0x0906, 0x0902, 0x01c5, 0x01c6, 0x01c7),
  },
  {	.freq			= 5780,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x42, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x05, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x090c, 0x0908, 0x0904, 0x01c5, 0x01c6, 0x01c6),
  },
  {	.freq			= 5785,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x85, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x04, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x04, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x090e, 0x090a, 0x0906, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5790,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x43, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x04, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x04, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0910, 0x090c, 0x0908, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5795,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x87, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x04, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x04, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0912, 0x090e, 0x090a, 0x01c4, 0x01c4, 0x01c5),
  },
  {	.freq			= 5800,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x44, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x04, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x04, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0914, 0x0910, 0x090c, 0x01c3, 0x01c4, 0x01c5),
  },
  {	.freq			= 5805,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x89, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x04, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x04, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0916, 0x0912, 0x090e, 0x01c3, 0x01c4, 0x01c4),
  },
  {	.freq			= 5810,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x45, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x04, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x04, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0918, 0x0914, 0x0910, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5815,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x04, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x04, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x091a, 0x0916, 0x0912, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5820,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x46, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x03, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x091c, 0x0918, 0x0914, 0x01c2, 0x01c2, 0x01c3),
  },
  {	.freq			= 5825,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x03, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x091e, 0x091a, 0x0916, 0x01c1, 0x01c2, 0x01c3),
  },
  {	.freq			= 5830,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x47, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x03, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0920, 0x091c, 0x0918, 0x01c1, 0x01c2, 0x01c2),
  },
  {	.freq			= 5840,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x48, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x03, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0924, 0x0920, 0x091c, 0x01c0, 0x01c1, 0x01c2),
  },
  {	.freq			= 5850,
	RADIOREGS3(0xe0, 0x00, 0x01, 0x02, 0x49, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf4, 0x00, 0x03, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf4, 0x00),
	PHYREGS(0x0928, 0x0924, 0x0920, 0x01bf, 0x01c0, 0x01c1),
  },
  {	.freq			= 5860,
	RADIOREGS3(0xde, 0x00, 0x01, 0x02, 0x4a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf2, 0x00, 0x03, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf2, 0x00),
	PHYREGS(0x092c, 0x0928, 0x0924, 0x01bf, 0x01bf, 0x01c0),
  },
  {	.freq			= 5870,
	RADIOREGS3(0xdb, 0x00, 0x01, 0x02, 0x4b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x02, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf2, 0x00, 0x02, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf2, 0x00),
	PHYREGS(0x0930, 0x092c, 0x0928, 0x01be, 0x01bf, 0x01bf),
  },
  {	.freq			= 5880,
	RADIOREGS3(0xd8, 0x00, 0x01, 0x02, 0x4c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x02, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf2, 0x00, 0x02, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf2, 0x00),
	PHYREGS(0x0934, 0x0930, 0x092c, 0x01bd, 0x01be, 0x01bf),
  },
  {	.freq			= 5890,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x02, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x06,
		   0x00, 0xf2, 0x00, 0x02, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x06, 0x00, 0xf2, 0x00),
	PHYREGS(0x0938, 0x0934, 0x0930, 0x01bc, 0x01bd, 0x01be),
  },
  {	.freq			= 5900,
	RADIOREGS3(0xd3, 0x00, 0x01, 0x02, 0x4e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x87, 0x03, 0x00,
		   0x00, 0x02, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x05,
		   0x00, 0xf2, 0x00, 0x02, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x05, 0x00, 0xf2, 0x00),
	PHYREGS(0x093c, 0x0938, 0x0934, 0x01bc, 0x01bc, 0x01bd),
  },
  {	.freq			= 5910,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x87, 0x03, 0x00,
		   0x00, 0x01, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x05,
		   0x00, 0xf2, 0x00, 0x01, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x05, 0x00, 0xf2, 0x00),
	PHYREGS(0x0940, 0x093c, 0x0938, 0x01bb, 0x01bc, 0x01bc),
  },
  {	.freq			= 2412,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x6c, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x04, 0x04, 0x04, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xff, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xff, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03c9, 0x03c5, 0x03c1, 0x043a, 0x043f, 0x0443),
  },
  {	.freq			= 2417,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x71, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xff, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xff, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03cb, 0x03c7, 0x03c3, 0x0438, 0x043d, 0x0441),
  },
  {	.freq			= 2422,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x76, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xff, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xff, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03cd, 0x03c9, 0x03c5, 0x0436, 0x043a, 0x043f),
  },
  {	.freq			= 2427,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x7b, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xfd, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xfd, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03cf, 0x03cb, 0x03c7, 0x0434, 0x0438, 0x043d),
  },
  {	.freq			= 2432,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x80, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xfb, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xfb, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03d1, 0x03cd, 0x03c9, 0x0431, 0x0436, 0x043a),
  },
  {	.freq			= 2437,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x85, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xfa, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xfa, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03d3, 0x03cf, 0x03cb, 0x042f, 0x0434, 0x0438),
  },
  {	.freq			= 2442,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8a, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf8, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xf8, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03d5, 0x03d1, 0x03cd, 0x042d, 0x0431, 0x0436),
  },
  {	.freq			= 2447,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8f, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf7, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xf7, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03d7, 0x03d3, 0x03cf, 0x042b, 0x042f, 0x0434),
  },
  {	.freq			= 2452,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x94, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf6, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0f, 0x00, 0xf6, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0f),
	PHYREGS(0x03d9, 0x03d5, 0x03d1, 0x0429, 0x042d, 0x0431),
  },
  {	.freq			= 2457,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x99, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf5, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0d, 0x00, 0xf5, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0d),
	PHYREGS(0x03db, 0x03d7, 0x03d3, 0x0427, 0x042b, 0x042f),
  },
  {	.freq			= 2462,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x9e, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf4, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0d, 0x00, 0xf4, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0d),
	PHYREGS(0x03dd, 0x03d9, 0x03d5, 0x0424, 0x0429, 0x042d),
  },
  {	.freq			= 2467,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa3, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf3, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0d, 0x00, 0xf3, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0d),
	PHYREGS(0x03df, 0x03db, 0x03d7, 0x0422, 0x0427, 0x042b),
  },
  {	.freq			= 2472,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa8, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf2, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0d, 0x00, 0xf2, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0d),
	PHYREGS(0x03e1, 0x03dd, 0x03d9, 0x0420, 0x0424, 0x0429),
  },
  {	.freq			= 2484,
	RADIOREGS3(0xff, 0x01, 0x03, 0x09, 0xb4, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf0, 0x00, 0x05, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0d, 0x00, 0xf0, 0x00, 0x05, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0d),
	PHYREGS(0x03e6, 0x03e2, 0x03de, 0x041b, 0x041f, 0x0424),
  },
};

static const struct b43_nphy_channeltab_entry_rev3 b43_nphy_channeltab_rev4[] = {
  {	.freq			= 4920,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xec, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0e, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07b4, 0x07b0, 0x07ac, 0x0214, 0x0215, 0x0216),
  },
  {	.freq			= 4930,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xed, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0e, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07b8, 0x07b4, 0x07b0, 0x0213, 0x0214, 0x0215),
  },
  {	.freq			= 4940,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xee, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0e, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07bc, 0x07b8, 0x07b4, 0x0212, 0x0213, 0x0214),
  },
  {	.freq			= 4950,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xef, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0e, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07c0, 0x07bc, 0x07b8, 0x0211, 0x0212, 0x0213),
  },
  {	.freq			= 4960,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf0, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0e, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07c4, 0x07c0, 0x07bc, 0x020f, 0x0211, 0x0212),
  },
  {	.freq			= 4970,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf1, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0e, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07c8, 0x07c4, 0x07c0, 0x020e, 0x020f, 0x0211),
  },
  {	.freq			= 4980,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf2, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0e, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07cc, 0x07c8, 0x07c4, 0x020d, 0x020e, 0x020f),
  },
  {	.freq			= 4990,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf3, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0e, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0e, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07d0, 0x07cc, 0x07c8, 0x020c, 0x020d, 0x020e),
  },
  {	.freq			= 5000,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf4, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07d4, 0x07d0, 0x07cc, 0x020b, 0x020c, 0x020d),
  },
  {	.freq			= 5010,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf5, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07d8, 0x07d4, 0x07d0, 0x020a, 0x020b, 0x020c),
  },
  {	.freq			= 5020,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf6, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07dc, 0x07d8, 0x07d4, 0x0209, 0x020a, 0x020b),
  },
  {	.freq			= 5030,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf7, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07e0, 0x07dc, 0x07d8, 0x0208, 0x0209, 0x020a),
  },
  {	.freq			= 5040,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf8, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07e4, 0x07e0, 0x07dc, 0x0207, 0x0208, 0x0209),
  },
  {	.freq			= 5050,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf9, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07e8, 0x07e4, 0x07e0, 0x0206, 0x0207, 0x0208),
  },
  {	.freq			= 5060,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfa, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07ec, 0x07e8, 0x07e4, 0x0205, 0x0206, 0x0207),
  },
  {	.freq			= 5070,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfb, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07f0, 0x07ec, 0x07e8, 0x0204, 0x0205, 0x0206),
  },
  {	.freq			= 5080,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfc, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07f4, 0x07f0, 0x07ec, 0x0203, 0x0204, 0x0205),
  },
  {	.freq			= 5090,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfd, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0d, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xff, 0x00, 0xff, 0x00, 0x0d, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xff, 0x00),
	PHYREGS(0x07f8, 0x07f4, 0x07f0, 0x0202, 0x0203, 0x0204),
  },
  {	.freq			= 5100,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xfe, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xff, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x07fc, 0x07f8, 0x07f4, 0x0201, 0x0202, 0x0203),
  },
  {	.freq			= 5110,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xff, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xff, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x0800, 0x07fc, 0x07f8, 0x0200, 0x0201, 0x0202),
  },
  {	.freq			= 5120,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x00, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xff, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x0804, 0x0800, 0x07fc, 0x01ff, 0x0200, 0x0201),
  },
  {	.freq			= 5130,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x01, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xff, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x0808, 0x0804, 0x0800, 0x01fe, 0x01ff, 0x0200),
  },
  {	.freq			= 5140,
	RADIOREGS3(0xc6, 0x01, 0x01, 0x02, 0x02, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xff, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x080c, 0x0808, 0x0804, 0x01fd, 0x01fe, 0x01ff),
  },
  {	.freq			= 5160,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x04, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xff, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x0814, 0x0810, 0x080c, 0x01fb, 0x01fc, 0x01fd),
  },
  {	.freq			= 5170,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x05, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xff, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x0818, 0x0814, 0x0810, 0x01fa, 0x01fb, 0x01fc),
  },
  {	.freq			= 5180,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x06, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xef, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xef, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x081c, 0x0818, 0x0814, 0x01f9, 0x01fa, 0x01fb),
  },
  {	.freq			= 5190,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x07, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xef, 0x00, 0x0c, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfe, 0x00, 0xef, 0x00, 0x0c, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfe, 0x00),
	PHYREGS(0x0820, 0x081c, 0x0818, 0x01f8, 0x01f9, 0x01fa),
  },
  {	.freq			= 5200,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x08, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xef, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xef, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x0824, 0x0820, 0x081c, 0x01f7, 0x01f8, 0x01f9),
  },
  {	.freq			= 5210,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x09, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xdf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xdf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x0828, 0x0824, 0x0820, 0x01f6, 0x01f7, 0x01f8),
  },
  {	.freq			= 5220,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xdf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xdf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x082c, 0x0828, 0x0824, 0x01f5, 0x01f6, 0x01f7),
  },
  {	.freq			= 5230,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xdf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xdf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x0830, 0x082c, 0x0828, 0x01f4, 0x01f5, 0x01f6),
  },
  {	.freq			= 5240,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xcf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xcf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x0834, 0x0830, 0x082c, 0x01f3, 0x01f4, 0x01f5),
  },
  {	.freq			= 5250,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xcf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xcf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x0838, 0x0834, 0x0830, 0x01f2, 0x01f3, 0x01f4),
  },
  {	.freq			= 5260,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xcf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xcf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x083c, 0x0838, 0x0834, 0x01f1, 0x01f2, 0x01f3),
  },
  {	.freq			= 5270,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xcf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xcf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x0840, 0x083c, 0x0838, 0x01f0, 0x01f1, 0x01f2),
  },
  {	.freq			= 5280,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x10, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xbf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xbf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x0844, 0x0840, 0x083c, 0x01f0, 0x01f0, 0x01f1),
  },
  {	.freq			= 5290,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x11, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xbf, 0x00, 0x0a, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfc, 0x00, 0xbf, 0x00, 0x0a, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfc, 0x00),
	PHYREGS(0x0848, 0x0844, 0x0840, 0x01ef, 0x01f0, 0x01f0),
  },
  {	.freq			= 5300,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x12, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xbf, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0xbf, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x084c, 0x0848, 0x0844, 0x01ee, 0x01ef, 0x01f0),
  },
  {	.freq			= 5310,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x13, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xbf, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0xbf, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x0850, 0x084c, 0x0848, 0x01ed, 0x01ee, 0x01ef),
  },
  {	.freq			= 5320,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x14, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xbf, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0xbf, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x0854, 0x0850, 0x084c, 0x01ec, 0x01ed, 0x01ee),
  },
  {	.freq			= 5330,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x15, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xaf, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0xaf, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x0858, 0x0854, 0x0850, 0x01eb, 0x01ec, 0x01ed),
  },
  {	.freq			= 5340,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x16, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xaf, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0xaf, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x085c, 0x0858, 0x0854, 0x01ea, 0x01eb, 0x01ec),
  },
  {	.freq			= 5350,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x17, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x9f, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0x9f, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x0860, 0x085c, 0x0858, 0x01e9, 0x01ea, 0x01eb),
  },
  {	.freq			= 5360,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x18, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x9f, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0x9f, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x0864, 0x0860, 0x085c, 0x01e8, 0x01e9, 0x01ea),
  },
  {	.freq			= 5370,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x19, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x9f, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0x9f, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x0868, 0x0864, 0x0860, 0x01e7, 0x01e8, 0x01e9),
  },
  {	.freq			= 5380,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x9f, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0x9f, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x086c, 0x0868, 0x0864, 0x01e6, 0x01e7, 0x01e8),
  },
  {	.freq			= 5390,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x8f, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xfa, 0x00, 0x8f, 0x00, 0x08, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xfa, 0x00),
	PHYREGS(0x0870, 0x086c, 0x0868, 0x01e5, 0x01e6, 0x01e7),
  },
  {	.freq			= 5400,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x8f, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x8f, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x0874, 0x0870, 0x086c, 0x01e5, 0x01e5, 0x01e6),
  },
  {	.freq			= 5410,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x8f, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x8f, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x0878, 0x0874, 0x0870, 0x01e4, 0x01e5, 0x01e5),
  },
  {	.freq			= 5420,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x8e, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x8e, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x087c, 0x0878, 0x0874, 0x01e3, 0x01e4, 0x01e5),
  },
  {	.freq			= 5430,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x8e, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x8e, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x0880, 0x087c, 0x0878, 0x01e2, 0x01e3, 0x01e4),
  },
  {	.freq			= 5440,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x20, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x7e, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x7e, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x0884, 0x0880, 0x087c, 0x01e1, 0x01e2, 0x01e3),
  },
  {	.freq			= 5450,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x21, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x7d, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x7d, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x0888, 0x0884, 0x0880, 0x01e0, 0x01e1, 0x01e2),
  },
  {	.freq			= 5460,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x22, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x6d, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x6d, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x088c, 0x0888, 0x0884, 0x01df, 0x01e0, 0x01e1),
  },
  {	.freq			= 5470,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x23, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x6d, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x6d, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x0890, 0x088c, 0x0888, 0x01de, 0x01df, 0x01e0),
  },
  {	.freq			= 5480,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x24, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x5d, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x5d, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x0894, 0x0890, 0x088c, 0x01dd, 0x01de, 0x01df),
  },
  {	.freq			= 5490,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x25, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x5c, 0x00, 0x07, 0x00, 0x7f, 0x00, 0x0f,
		   0x00, 0xf8, 0x00, 0x5c, 0x00, 0x07, 0x00, 0x7f,
		   0x00, 0x0f, 0x00, 0xf8, 0x00),
	PHYREGS(0x0898, 0x0894, 0x0890, 0x01dd, 0x01dd, 0x01de),
  },
  {	.freq			= 5500,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x26, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x5c, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x5c, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x089c, 0x0898, 0x0894, 0x01dc, 0x01dd, 0x01dd),
  },
  {	.freq			= 5510,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x27, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x4c, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x4c, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08a0, 0x089c, 0x0898, 0x01db, 0x01dc, 0x01dd),
  },
  {	.freq			= 5520,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x28, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x4c, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x4c, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08a4, 0x08a0, 0x089c, 0x01da, 0x01db, 0x01dc),
  },
  {	.freq			= 5530,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x29, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x3b, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x3b, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08a8, 0x08a4, 0x08a0, 0x01d9, 0x01da, 0x01db),
  },
  {	.freq			= 5540,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x3b, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x3b, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08ac, 0x08a8, 0x08a4, 0x01d8, 0x01d9, 0x01da),
  },
  {	.freq			= 5550,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x3b, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x3b, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08b0, 0x08ac, 0x08a8, 0x01d7, 0x01d8, 0x01d9),
  },
  {	.freq			= 5560,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x2b, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x2b, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08b4, 0x08b0, 0x08ac, 0x01d7, 0x01d7, 0x01d8),
  },
  {	.freq			= 5570,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x2a, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x2a, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08b8, 0x08b4, 0x08b0, 0x01d6, 0x01d7, 0x01d7),
  },
  {	.freq			= 5580,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x1a, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x1a, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08bc, 0x08b8, 0x08b4, 0x01d5, 0x01d6, 0x01d7),
  },
  {	.freq			= 5590,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x1a, 0x00, 0x06, 0x00, 0x7f, 0x00, 0x0d,
		   0x00, 0xf6, 0x00, 0x1a, 0x00, 0x06, 0x00, 0x7f,
		   0x00, 0x0d, 0x00, 0xf6, 0x00),
	PHYREGS(0x08c0, 0x08bc, 0x08b8, 0x01d4, 0x01d5, 0x01d6),
  },
  {	.freq			= 5600,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x30, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x1a, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x1a, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08c4, 0x08c0, 0x08bc, 0x01d3, 0x01d4, 0x01d5),
  },
  {	.freq			= 5610,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x31, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x19, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x19, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08c8, 0x08c4, 0x08c0, 0x01d2, 0x01d3, 0x01d4),
  },
  {	.freq			= 5620,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x32, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x19, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x19, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08cc, 0x08c8, 0x08c4, 0x01d2, 0x01d2, 0x01d3),
  },
  {	.freq			= 5630,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x33, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x09, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x09, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08d0, 0x08cc, 0x08c8, 0x01d1, 0x01d2, 0x01d2),
  },
  {	.freq			= 5640,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x34, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x09, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x09, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08d4, 0x08d0, 0x08cc, 0x01d0, 0x01d1, 0x01d2),
  },
  {	.freq			= 5650,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x35, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x08, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x08, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08d8, 0x08d4, 0x08d0, 0x01cf, 0x01d0, 0x01d1),
  },
  {	.freq			= 5660,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x36, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x08, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x08, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08dc, 0x08d8, 0x08d4, 0x01ce, 0x01cf, 0x01d0),
  },
  {	.freq			= 5670,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x37, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x08, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x08, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08e0, 0x08dc, 0x08d8, 0x01ce, 0x01ce, 0x01cf),
  },
  {	.freq			= 5680,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x38, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x08, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x08, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08e4, 0x08e0, 0x08dc, 0x01cd, 0x01ce, 0x01ce),
  },
  {	.freq			= 5690,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x39, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x07, 0x00, 0x04, 0x00, 0x7f, 0x00, 0x0b,
		   0x00, 0xf4, 0x00, 0x07, 0x00, 0x04, 0x00, 0x7f,
		   0x00, 0x0b, 0x00, 0xf4, 0x00),
	PHYREGS(0x08e8, 0x08e4, 0x08e0, 0x01cc, 0x01cd, 0x01ce),
  },
  {	.freq			= 5700,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x07, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x07, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x08ec, 0x08e8, 0x08e4, 0x01cb, 0x01cc, 0x01cd),
  },
  {	.freq			= 5710,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x07, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x07, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x08f0, 0x08ec, 0x08e8, 0x01ca, 0x01cb, 0x01cc),
  },
  {	.freq			= 5720,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x07, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x07, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x08f4, 0x08f0, 0x08ec, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5725,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x79, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x06, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x08f6, 0x08f2, 0x08ee, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5730,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x06, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x08f8, 0x08f4, 0x08f0, 0x01c9, 0x01c9, 0x01ca),
  },
  {	.freq			= 5735,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x7b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x06, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x08fa, 0x08f6, 0x08f2, 0x01c8, 0x01c9, 0x01ca),
  },
  {	.freq			= 5740,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x06, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x08fc, 0x08f8, 0x08f4, 0x01c8, 0x01c9, 0x01c9),
  },
  {	.freq			= 5745,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x06, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x08fe, 0x08fa, 0x08f6, 0x01c8, 0x01c8, 0x01c9),
  },
  {	.freq			= 5750,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x06, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x06, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x0900, 0x08fc, 0x08f8, 0x01c7, 0x01c8, 0x01c9),
  },
  {	.freq			= 5755,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7f, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x05, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x0902, 0x08fe, 0x08fa, 0x01c7, 0x01c8, 0x01c8),
  },
  {	.freq			= 5760,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x40, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x05, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x0904, 0x0900, 0x08fc, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5765,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x81, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x05, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x0906, 0x0902, 0x08fe, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5770,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x41, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x05, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x0908, 0x0904, 0x0900, 0x01c6, 0x01c6, 0x01c7),
  },
  {	.freq			= 5775,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x83, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x05, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x090a, 0x0906, 0x0902, 0x01c5, 0x01c6, 0x01c7),
  },
  {	.freq			= 5780,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x42, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x05, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x05, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x090c, 0x0908, 0x0904, 0x01c5, 0x01c6, 0x01c6),
  },
  {	.freq			= 5785,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x85, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x04, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x04, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x090e, 0x090a, 0x0906, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5790,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x43, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x04, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x04, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x0910, 0x090c, 0x0908, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5795,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x87, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x04, 0x00, 0x03, 0x00, 0x7f, 0x00, 0x0a,
		   0x00, 0xf2, 0x00, 0x04, 0x00, 0x03, 0x00, 0x7f,
		   0x00, 0x0a, 0x00, 0xf2, 0x00),
	PHYREGS(0x0912, 0x090e, 0x090a, 0x01c4, 0x01c4, 0x01c5),
  },
  {	.freq			= 5800,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x44, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x04, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x04, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0914, 0x0910, 0x090c, 0x01c3, 0x01c4, 0x01c5),
  },
  {	.freq			= 5805,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x89, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x04, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x04, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0916, 0x0912, 0x090e, 0x01c3, 0x01c4, 0x01c4),
  },
  {	.freq			= 5810,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x45, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x04, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x04, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0918, 0x0914, 0x0910, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5815,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x04, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x04, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x091a, 0x0916, 0x0912, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5820,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x46, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x03, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x091c, 0x0918, 0x0914, 0x01c2, 0x01c2, 0x01c3),
  },
  {	.freq			= 5825,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x03, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x091e, 0x091a, 0x0916, 0x01c1, 0x01c2, 0x01c3),
  },
  {	.freq			= 5830,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x47, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x03, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0920, 0x091c, 0x0918, 0x01c1, 0x01c2, 0x01c2),
  },
  {	.freq			= 5840,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x48, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x03, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0924, 0x0920, 0x091c, 0x01c0, 0x01c1, 0x01c2),
  },
  {	.freq			= 5850,
	RADIOREGS3(0xe0, 0x00, 0x01, 0x02, 0x49, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x03, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0928, 0x0924, 0x0920, 0x01bf, 0x01c0, 0x01c1),
  },
  {	.freq			= 5860,
	RADIOREGS3(0xde, 0x00, 0x01, 0x02, 0x4a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x03, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x03, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x092c, 0x0928, 0x0924, 0x01bf, 0x01bf, 0x01c0),
  },
  {	.freq			= 5870,
	RADIOREGS3(0xdb, 0x00, 0x01, 0x02, 0x4b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x02, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x02, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0930, 0x092c, 0x0928, 0x01be, 0x01bf, 0x01bf),
  },
  {	.freq			= 5880,
	RADIOREGS3(0xd8, 0x00, 0x01, 0x02, 0x4c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x02, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x02, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0934, 0x0930, 0x092c, 0x01bd, 0x01be, 0x01bf),
  },
  {	.freq			= 5890,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x02, 0x00, 0x02, 0x00, 0x7f, 0x00, 0x09,
		   0x00, 0xf0, 0x00, 0x02, 0x00, 0x02, 0x00, 0x7f,
		   0x00, 0x09, 0x00, 0xf0, 0x00),
	PHYREGS(0x0938, 0x0934, 0x0930, 0x01bc, 0x01bd, 0x01be),
  },
  {	.freq			= 5900,
	RADIOREGS3(0xd3, 0x00, 0x01, 0x02, 0x4e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x87, 0x03, 0x00,
		   0x00, 0x02, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf0, 0x00, 0x02, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf0, 0x00),
	PHYREGS(0x093c, 0x0938, 0x0934, 0x01bc, 0x01bc, 0x01bd),
  },
  {	.freq			= 5910,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x87, 0x03, 0x00,
		   0x00, 0x01, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x07,
		   0x00, 0xf0, 0x00, 0x01, 0x00, 0x00, 0x00, 0x7f,
		   0x00, 0x07, 0x00, 0xf0, 0x00),
	PHYREGS(0x0940, 0x093c, 0x0938, 0x01bb, 0x01bc, 0x01bc),
  },
  {	.freq			= 2412,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x6c, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x04, 0x04, 0x04, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xff, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xff, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03c9, 0x03c5, 0x03c1, 0x043a, 0x043f, 0x0443),
  },
  {	.freq			= 2417,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x71, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xff, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xff, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03cb, 0x03c7, 0x03c3, 0x0438, 0x043d, 0x0441),
  },
  {	.freq			= 2422,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x76, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xff, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xff, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03cd, 0x03c9, 0x03c5, 0x0436, 0x043a, 0x043f),
  },
  {	.freq			= 2427,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x7b, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xfd, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xfd, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03cf, 0x03cb, 0x03c7, 0x0434, 0x0438, 0x043d),
  },
  {	.freq			= 2432,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x80, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xfb, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xfb, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03d1, 0x03cd, 0x03c9, 0x0431, 0x0436, 0x043a),
  },
  {	.freq			= 2437,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x85, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xfa, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xfa, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03d3, 0x03cf, 0x03cb, 0x042f, 0x0434, 0x0438),
  },
  {	.freq			= 2442,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8a, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf8, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xf8, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03d5, 0x03d1, 0x03cd, 0x042d, 0x0431, 0x0436),
  },
  {	.freq			= 2447,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8f, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf7, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xf7, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03d7, 0x03d3, 0x03cf, 0x042b, 0x042f, 0x0434),
  },
  {	.freq			= 2452,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x94, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf6, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xf6, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03d9, 0x03d5, 0x03d1, 0x0429, 0x042d, 0x0431),
  },
  {	.freq			= 2457,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x99, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf5, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xf5, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03db, 0x03d7, 0x03d3, 0x0427, 0x042b, 0x042f),
  },
  {	.freq			= 2462,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x9e, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf4, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xf4, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03dd, 0x03d9, 0x03d5, 0x0424, 0x0429, 0x042d),
  },
  {	.freq			= 2467,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa3, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf3, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xf3, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03df, 0x03db, 0x03d7, 0x0422, 0x0427, 0x042b),
  },
  {	.freq			= 2472,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa8, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf2, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xf2, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03e1, 0x03dd, 0x03d9, 0x0420, 0x0424, 0x0429),
  },
  {	.freq			= 2484,
	RADIOREGS3(0xff, 0x01, 0x03, 0x09, 0xb4, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0xf0, 0x00, 0x04, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0e, 0x00, 0xf0, 0x00, 0x04, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0e),
	PHYREGS(0x03e6, 0x03e2, 0x03de, 0x041b, 0x041f, 0x0424),
  },
};

static const struct b43_nphy_channeltab_entry_rev3 b43_nphy_channeltab_rev5[] = {
  {	.freq			= 4920,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xec, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0b, 0x00, 0x70, 0x00, 0x0f,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0b, 0x00, 0x70,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07b4, 0x07b0, 0x07ac, 0x0214, 0x0215, 0x0216),
  },
  {	.freq			= 4930,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xed, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0b, 0x00, 0x70, 0x00, 0x0e,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0b, 0x00, 0x70,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x07b8, 0x07b4, 0x07b0, 0x0213, 0x0214, 0x0215),
  },
  {	.freq			= 4940,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xee, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0b, 0x00, 0x70, 0x00, 0x0e,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0b, 0x00, 0x70,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x07bc, 0x07b8, 0x07b4, 0x0212, 0x0213, 0x0214),
  },
  {	.freq			= 4950,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xef, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0b, 0x00, 0x70, 0x00, 0x0e,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0b, 0x00, 0x70,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c0, 0x07bc, 0x07b8, 0x0211, 0x0212, 0x0213),
  },
  {	.freq			= 4960,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf0, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0e,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c4, 0x07c0, 0x07bc, 0x020f, 0x0211, 0x0212),
  },
  {	.freq			= 4970,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf1, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c8, 0x07c4, 0x07c0, 0x020e, 0x020f, 0x0211),
  },
  {	.freq			= 4980,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf2, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07cc, 0x07c8, 0x07c4, 0x020d, 0x020e, 0x020f),
  },
  {	.freq			= 4990,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf3, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d0, 0x07cc, 0x07c8, 0x020c, 0x020d, 0x020e),
  },
  {	.freq			= 5000,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf4, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d4, 0x07d0, 0x07cc, 0x020b, 0x020c, 0x020d),
  },
  {	.freq			= 5010,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf5, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d8, 0x07d4, 0x07d0, 0x020a, 0x020b, 0x020c),
  },
  {	.freq			= 5020,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf6, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07dc, 0x07d8, 0x07d4, 0x0209, 0x020a, 0x020b),
  },
  {	.freq			= 5030,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf7, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0c,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e0, 0x07dc, 0x07d8, 0x0208, 0x0209, 0x020a),
  },
  {	.freq			= 5040,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf8, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0c,
		   0x00, 0x9f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e4, 0x07e0, 0x07dc, 0x0207, 0x0208, 0x0209),
  },
  {	.freq			= 5050,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf9, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0c,
		   0x00, 0x9f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e8, 0x07e4, 0x07e0, 0x0206, 0x0207, 0x0208),
  },
  {	.freq			= 5060,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfa, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0c,
		   0x00, 0x9f, 0x00, 0xfd, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x07ec, 0x07e8, 0x07e4, 0x0205, 0x0206, 0x0207),
  },
  {	.freq			= 5070,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfb, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfd, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f0, 0x07ec, 0x07e8, 0x0204, 0x0205, 0x0206),
  },
  {	.freq			= 5080,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfc, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f4, 0x07f0, 0x07ec, 0x0203, 0x0204, 0x0205),
  },
  {	.freq			= 5090,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfd, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f8, 0x07f4, 0x07f0, 0x0202, 0x0203, 0x0204),
  },
  {	.freq			= 5100,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xfe, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x07fc, 0x07f8, 0x07f4, 0x0201, 0x0202, 0x0203),
  },
  {	.freq			= 5110,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xff, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x0800, 0x07fc, 0x07f8, 0x0200, 0x0201, 0x0202),
  },
  {	.freq			= 5120,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x00, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x0804, 0x0800, 0x07fc, 0x01ff, 0x0200, 0x0201),
  },
  {	.freq			= 5130,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x01, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0a,
		   0x00, 0x9f, 0x00, 0xfb, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0808, 0x0804, 0x0800, 0x01fe, 0x01ff, 0x0200),
  },
  {	.freq			= 5140,
	RADIOREGS3(0xc6, 0x01, 0x01, 0x02, 0x02, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x07, 0x00, 0x70, 0x00, 0x0a,
		   0x00, 0x9f, 0x00, 0xfb, 0x00, 0x07, 0x00, 0x70,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x080c, 0x0808, 0x0804, 0x01fd, 0x01fe, 0x01ff),
  },
  {	.freq			= 5160,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x04, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x07, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfb, 0x00, 0x07, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0814, 0x0810, 0x080c, 0x01fb, 0x01fc, 0x01fd),
  },
  {	.freq			= 5170,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x05, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfb, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0818, 0x0814, 0x0810, 0x01fa, 0x01fb, 0x01fc),
  },
  {	.freq			= 5180,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x06, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x081c, 0x0818, 0x0814, 0x01f9, 0x01fa, 0x01fb),
  },
  {	.freq			= 5190,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x07, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0820, 0x081c, 0x0818, 0x01f8, 0x01f9, 0x01fa),
  },
  {	.freq			= 5200,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x08, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0824, 0x0820, 0x081c, 0x01f7, 0x01f8, 0x01f9),
  },
  {	.freq			= 5210,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x09, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0828, 0x0824, 0x0820, 0x01f6, 0x01f7, 0x01f8),
  },
  {	.freq			= 5220,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x082c, 0x0828, 0x0824, 0x01f5, 0x01f6, 0x01f7),
  },
  {	.freq			= 5230,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xea, 0x00, 0x06, 0x00, 0x70, 0x00, 0x08,
		   0x00, 0x9e, 0x00, 0xea, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x08, 0x00, 0x6e, 0x00),
	PHYREGS(0x0830, 0x082c, 0x0828, 0x01f4, 0x01f5, 0x01f6),
  },
  {	.freq			= 5240,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xe9, 0x00, 0x05, 0x00, 0x70, 0x00, 0x08,
		   0x00, 0x9d, 0x00, 0xe9, 0x00, 0x05, 0x00, 0x70,
		   0x00, 0x08, 0x00, 0x6d, 0x00),
	PHYREGS(0x0834, 0x0830, 0x082c, 0x01f3, 0x01f4, 0x01f5),
  },
  {	.freq			= 5250,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xe9, 0x00, 0x05, 0x00, 0x70, 0x00, 0x08,
		   0x00, 0x9d, 0x00, 0xe9, 0x00, 0x05, 0x00, 0x70,
		   0x00, 0x08, 0x00, 0x6d, 0x00),
	PHYREGS(0x0838, 0x0834, 0x0830, 0x01f2, 0x01f3, 0x01f4),
  },
  {	.freq			= 5260,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xd9, 0x00, 0x05, 0x00, 0x70, 0x00, 0x08,
		   0x00, 0x9d, 0x00, 0xd9, 0x00, 0x05, 0x00, 0x70,
		   0x00, 0x08, 0x00, 0x6d, 0x00),
	PHYREGS(0x083c, 0x0838, 0x0834, 0x01f1, 0x01f2, 0x01f3),
  },
  {	.freq			= 5270,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xd8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xd8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0840, 0x083c, 0x0838, 0x01f0, 0x01f1, 0x01f2),
  },
  {	.freq			= 5280,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x10, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xc8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xc8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0844, 0x0840, 0x083c, 0x01f0, 0x01f0, 0x01f1),
  },
  {	.freq			= 5290,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x11, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0f, 0x00,
		   0xff, 0xc8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xc8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0848, 0x0844, 0x0840, 0x01ef, 0x01f0, 0x01f0),
  },
  {	.freq			= 5300,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x12, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xc8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xc8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x084c, 0x0848, 0x0844, 0x01ee, 0x01ef, 0x01f0),
  },
  {	.freq			= 5310,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x13, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xc8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xc8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0850, 0x084c, 0x0848, 0x01ed, 0x01ee, 0x01ef),
  },
  {	.freq			= 5320,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x14, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xb8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xb8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0854, 0x0850, 0x084c, 0x01ec, 0x01ed, 0x01ee),
  },
  {	.freq			= 5330,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x15, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xb7, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9b, 0x00, 0xb7, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6b, 0x00),
	PHYREGS(0x0858, 0x0854, 0x0850, 0x01eb, 0x01ec, 0x01ed),
  },
  {	.freq			= 5340,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x16, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xb7, 0x00, 0x03, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9b, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6b, 0x00),
	PHYREGS(0x085c, 0x0858, 0x0854, 0x01ea, 0x01eb, 0x01ec),
  },
  {	.freq			= 5350,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x17, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xa7, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9b, 0x00, 0xa7, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x6b, 0x00),
	PHYREGS(0x0860, 0x085c, 0x0858, 0x01e9, 0x01ea, 0x01eb),
  },
  {	.freq			= 5360,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x18, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xa6, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9b, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x6b, 0x00),
	PHYREGS(0x0864, 0x0860, 0x085c, 0x01e8, 0x01e9, 0x01ea),
  },
  {	.freq			= 5370,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x19, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0xa6, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9b, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x5b, 0x00),
	PHYREGS(0x0868, 0x0864, 0x0860, 0x01e7, 0x01e8, 0x01e9),
  },
  {	.freq			= 5380,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x96, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9a, 0x00, 0x96, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x5a, 0x00),
	PHYREGS(0x086c, 0x0868, 0x0864, 0x01e6, 0x01e7, 0x01e8),
  },
  {	.freq			= 5390,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8f, 0x0e, 0x00,
		   0xff, 0x95, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9a, 0x00, 0x95, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x5a, 0x00),
	PHYREGS(0x0870, 0x086c, 0x0868, 0x01e5, 0x01e6, 0x01e7),
  },
  {	.freq			= 5400,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x95, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9a, 0x00, 0x95, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x5a, 0x00),
	PHYREGS(0x0874, 0x0870, 0x086c, 0x01e5, 0x01e5, 0x01e6),
  },
  {	.freq			= 5410,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x95, 0x00, 0x03, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x9a, 0x00, 0x95, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x5a, 0x00),
	PHYREGS(0x0878, 0x0874, 0x0870, 0x01e4, 0x01e5, 0x01e5),
  },
  {	.freq			= 5420,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x95, 0x00, 0x03, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x9a, 0x00, 0x95, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x5a, 0x00),
	PHYREGS(0x087c, 0x0878, 0x0874, 0x01e3, 0x01e4, 0x01e5),
  },
  {	.freq			= 5430,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xc8, 0x85, 0x00, 0x02, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x99, 0x00, 0x85, 0x00, 0x02, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x59, 0x00),
	PHYREGS(0x0880, 0x087c, 0x0878, 0x01e2, 0x01e3, 0x01e4),
  },
  {	.freq			= 5440,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x20, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x84, 0x00, 0x02, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x99, 0x00, 0x84, 0x00, 0x02, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x59, 0x00),
	PHYREGS(0x0884, 0x0880, 0x087c, 0x01e1, 0x01e2, 0x01e3),
  },
  {	.freq			= 5450,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x21, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x84, 0x00, 0x02, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x99, 0x00, 0x84, 0x00, 0x02, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x59, 0x00),
	PHYREGS(0x0888, 0x0884, 0x0880, 0x01e0, 0x01e1, 0x01e2),
  },
  {	.freq			= 5460,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x22, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x84, 0x00, 0x02, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x99, 0x00, 0x84, 0x00, 0x02, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x69, 0x00),
	PHYREGS(0x088c, 0x0888, 0x0884, 0x01df, 0x01e0, 0x01e1),
  },
  {	.freq			= 5470,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x23, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x74, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x99, 0x00, 0x74, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x69, 0x00),
	PHYREGS(0x0890, 0x088c, 0x0888, 0x01de, 0x01df, 0x01e0),
  },
  {	.freq			= 5480,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x24, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0894, 0x0890, 0x088c, 0x01dd, 0x01de, 0x01df),
  },
  {	.freq			= 5490,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x25, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0d, 0x00,
		   0xc8, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0898, 0x0894, 0x0890, 0x01dd, 0x01dd, 0x01de),
  },
  {	.freq			= 5500,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x26, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x78, 0x00),
	PHYREGS(0x089c, 0x0898, 0x0894, 0x01dc, 0x01dd, 0x01dd),
  },
  {	.freq			= 5510,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x27, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x78, 0x00),
	PHYREGS(0x08a0, 0x089c, 0x0898, 0x01db, 0x01dc, 0x01dd),
  },
  {	.freq			= 5520,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x28, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x78, 0x00),
	PHYREGS(0x08a4, 0x08a0, 0x089c, 0x01da, 0x01db, 0x01dc),
  },
  {	.freq			= 5530,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x29, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x63, 0x00, 0x01, 0x00, 0x70, 0x00, 0x03,
		   0x00, 0x98, 0x00, 0x63, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x03, 0x00, 0x78, 0x00),
	PHYREGS(0x08a8, 0x08a4, 0x08a0, 0x01d9, 0x01da, 0x01db),
  },
  {	.freq			= 5540,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x62, 0x00, 0x00, 0x00, 0x70, 0x00, 0x03,
		   0x00, 0x97, 0x00, 0x62, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x03, 0x00, 0x77, 0x00),
	PHYREGS(0x08ac, 0x08a8, 0x08a4, 0x01d8, 0x01d9, 0x01da),
  },
  {	.freq			= 5550,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x62, 0x00, 0x00, 0x00, 0x70, 0x00, 0x03,
		   0x00, 0x97, 0x00, 0x62, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x03, 0x00, 0x77, 0x00),
	PHYREGS(0x08b0, 0x08ac, 0x08a8, 0x01d7, 0x01d8, 0x01d9),
  },
  {	.freq			= 5560,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x62, 0x00, 0x00, 0x00, 0x70, 0x00, 0x03,
		   0x00, 0x97, 0x00, 0x62, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x03, 0x00, 0x77, 0x00),
	PHYREGS(0x08b4, 0x08b0, 0x08ac, 0x01d7, 0x01d7, 0x01d8),
  },
  {	.freq			= 5570,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x52, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x52, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x76, 0x00),
	PHYREGS(0x08b8, 0x08b4, 0x08b0, 0x01d6, 0x01d7, 0x01d7),
  },
  {	.freq			= 5580,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x52, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x52, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x76, 0x00),
	PHYREGS(0x08bc, 0x08b8, 0x08b4, 0x01d5, 0x01d6, 0x01d7),
  },
  {	.freq			= 5590,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8d, 0x0b, 0x00,
		   0x84, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x76, 0x00),
	PHYREGS(0x08c0, 0x08bc, 0x08b8, 0x01d4, 0x01d5, 0x01d6),
  },
  {	.freq			= 5600,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x30, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x76, 0x00),
	PHYREGS(0x08c4, 0x08c0, 0x08bc, 0x01d3, 0x01d4, 0x01d5),
  },
  {	.freq			= 5610,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x31, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x76, 0x00),
	PHYREGS(0x08c8, 0x08c4, 0x08c0, 0x01d2, 0x01d3, 0x01d4),
  },
  {	.freq			= 5620,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x32, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x76, 0x00),
	PHYREGS(0x08cc, 0x08c8, 0x08c4, 0x01d2, 0x01d2, 0x01d3),
  },
  {	.freq			= 5630,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x33, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x76, 0x00),
	PHYREGS(0x08d0, 0x08cc, 0x08c8, 0x01d1, 0x01d2, 0x01d2),
  },
  {	.freq			= 5640,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x34, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x95, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x75, 0x00),
	PHYREGS(0x08d4, 0x08d0, 0x08cc, 0x01d0, 0x01d1, 0x01d2),
  },
  {	.freq			= 5650,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x35, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x50, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x95, 0x00, 0x50, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x75, 0x00),
	PHYREGS(0x08d8, 0x08d4, 0x08d0, 0x01cf, 0x01d0, 0x01d1),
  },
  {	.freq			= 5660,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x36, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x50, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x95, 0x00, 0x50, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x75, 0x00),
	PHYREGS(0x08dc, 0x08d8, 0x08d4, 0x01ce, 0x01cf, 0x01d0),
  },
  {	.freq			= 5670,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x37, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x74, 0x00),
	PHYREGS(0x08e0, 0x08dc, 0x08d8, 0x01ce, 0x01ce, 0x01cf),
  },
  {	.freq			= 5680,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x38, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x74, 0x00),
	PHYREGS(0x08e4, 0x08e0, 0x08dc, 0x01cd, 0x01ce, 0x01ce),
  },
  {	.freq			= 5690,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x39, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8b, 0x09, 0x00,
		   0x70, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x74, 0x00),
	PHYREGS(0x08e8, 0x08e4, 0x08e0, 0x01cc, 0x01cd, 0x01ce),
  },
  {	.freq			= 5700,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x74, 0x00),
	PHYREGS(0x08ec, 0x08e8, 0x08e4, 0x01cb, 0x01cc, 0x01cd),
  },
  {	.freq			= 5710,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x74, 0x00),
	PHYREGS(0x08f0, 0x08ec, 0x08e8, 0x01ca, 0x01cb, 0x01cc),
  },
  {	.freq			= 5720,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x74, 0x00),
	PHYREGS(0x08f4, 0x08f0, 0x08ec, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5725,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x79, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x74, 0x00),
	PHYREGS(0x08f6, 0x08f2, 0x08ee, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5730,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x84, 0x00),
	PHYREGS(0x08f8, 0x08f4, 0x08f0, 0x01c9, 0x01c9, 0x01ca),
  },
  {	.freq			= 5735,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x7b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x83, 0x00),
	PHYREGS(0x08fa, 0x08f6, 0x08f2, 0x01c8, 0x01c9, 0x01ca),
  },
  {	.freq			= 5740,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x83, 0x00),
	PHYREGS(0x08fc, 0x08f8, 0x08f4, 0x01c8, 0x01c9, 0x01c9),
  },
  {	.freq			= 5745,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x83, 0x00),
	PHYREGS(0x08fe, 0x08fa, 0x08f6, 0x01c8, 0x01c8, 0x01c9),
  },
  {	.freq			= 5750,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x83, 0x00),
	PHYREGS(0x0900, 0x08fc, 0x08f8, 0x01c7, 0x01c8, 0x01c9),
  },
  {	.freq			= 5755,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7f, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x83, 0x00),
	PHYREGS(0x0902, 0x08fe, 0x08fa, 0x01c7, 0x01c8, 0x01c8),
  },
  {	.freq			= 5760,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x40, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x20, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x20, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x83, 0x00),
	PHYREGS(0x0904, 0x0900, 0x08fc, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5765,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x81, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x20, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x20, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x0906, 0x0902, 0x08fe, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5770,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x41, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x20, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x20, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x0908, 0x0904, 0x0900, 0x01c6, 0x01c6, 0x01c7),
  },
  {	.freq			= 5775,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x83, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x20, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x20, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x090a, 0x0906, 0x0902, 0x01c5, 0x01c6, 0x01c7),
  },
  {	.freq			= 5780,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x42, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x8a, 0x06, 0x00,
		   0x40, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x090c, 0x0908, 0x0904, 0x01c5, 0x01c6, 0x01c6),
  },
  {	.freq			= 5785,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x85, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x090e, 0x090a, 0x0906, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5790,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x43, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x0910, 0x090c, 0x0908, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5795,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x87, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x8a, 0x06, 0x00,
		   0x40, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x0912, 0x090e, 0x090a, 0x01c4, 0x01c4, 0x01c5),
  },
  {	.freq			= 5800,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x44, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x0914, 0x0910, 0x090c, 0x01c3, 0x01c4, 0x01c5),
  },
  {	.freq			= 5805,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x89, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x0916, 0x0912, 0x090e, 0x01c3, 0x01c4, 0x01c4),
  },
  {	.freq			= 5810,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x45, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x0918, 0x0914, 0x0910, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5815,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x091a, 0x0916, 0x0912, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5820,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x46, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x091c, 0x0918, 0x0914, 0x01c2, 0x01c2, 0x01c3),
  },
  {	.freq			= 5825,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x82, 0x00),
	PHYREGS(0x091e, 0x091a, 0x0916, 0x01c1, 0x01c2, 0x01c3),
  },
  {	.freq			= 5830,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x47, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x72, 0x00),
	PHYREGS(0x0920, 0x091c, 0x0918, 0x01c1, 0x01c2, 0x01c2),
  },
  {	.freq			= 5840,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x48, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x72, 0x00),
	PHYREGS(0x0924, 0x0920, 0x091c, 0x01c0, 0x01c1, 0x01c2),
  },
  {	.freq			= 5850,
	RADIOREGS3(0xe0, 0x00, 0x01, 0x02, 0x49, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x72, 0x00),
	PHYREGS(0x0928, 0x0924, 0x0920, 0x01bf, 0x01c0, 0x01c1),
  },
  {	.freq			= 5860,
	RADIOREGS3(0xde, 0x00, 0x01, 0x02, 0x4a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x72, 0x00),
	PHYREGS(0x092c, 0x0928, 0x0924, 0x01bf, 0x01bf, 0x01c0),
  },
  {	.freq			= 5870,
	RADIOREGS3(0xdb, 0x00, 0x01, 0x02, 0x4b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x71, 0x00),
	PHYREGS(0x0930, 0x092c, 0x0928, 0x01be, 0x01bf, 0x01bf),
  },
  {	.freq			= 5880,
	RADIOREGS3(0xd8, 0x00, 0x01, 0x02, 0x4c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x71, 0x00),
	PHYREGS(0x0934, 0x0930, 0x092c, 0x01bd, 0x01be, 0x01bf),
  },
  {	.freq			= 5890,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x88, 0x04, 0x00,
		   0x20, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x71, 0x00),
	PHYREGS(0x0938, 0x0934, 0x0930, 0x01bc, 0x01bd, 0x01be),
  },
  {	.freq			= 5900,
	RADIOREGS3(0xd3, 0x00, 0x01, 0x02, 0x4e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x87, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x71, 0x00),
	PHYREGS(0x093c, 0x0938, 0x0934, 0x01bc, 0x01bc, 0x01bd),
  },
  {	.freq			= 5910,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x87, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x71, 0x00),
	PHYREGS(0x0940, 0x093c, 0x0938, 0x01bb, 0x01bc, 0x01bc),
  },
  {	.freq			= 2412,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x6c, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x04, 0x04, 0x04, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x1f, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0b, 0x00, 0x1f, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0b),
	PHYREGS(0x03c9, 0x03c5, 0x03c1, 0x043a, 0x043f, 0x0443),
  },
  {	.freq			= 2417,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x71, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x1f, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0a, 0x00, 0x1f, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0a),
	PHYREGS(0x03cb, 0x03c7, 0x03c3, 0x0438, 0x043d, 0x0441),
  },
  {	.freq			= 2422,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x76, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x0e, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0a, 0x00, 0x0e, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0a),
	PHYREGS(0x03cd, 0x03c9, 0x03c5, 0x0436, 0x043a, 0x043f),
  },
  {	.freq			= 2427,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x7b, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x0d, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x0a, 0x00, 0x0d, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x0a),
	PHYREGS(0x03cf, 0x03cb, 0x03c7, 0x0434, 0x0438, 0x043d),
  },
  {	.freq			= 2432,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x80, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x0c, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x0a, 0x00, 0x0c, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x0a),
	PHYREGS(0x03d1, 0x03cd, 0x03c9, 0x0431, 0x0436, 0x043a),
  },
  {	.freq			= 2437,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x85, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x0b, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x0a),
	PHYREGS(0x03d3, 0x03cf, 0x03cb, 0x042f, 0x0434, 0x0438),
  },
  {	.freq			= 2442,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8a, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x09, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x0a, 0x00, 0x09, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x0a),
	PHYREGS(0x03d5, 0x03d1, 0x03cd, 0x042d, 0x0431, 0x0436),
  },
  {	.freq			= 2447,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8f, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x09, 0x00, 0x08, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x09),
	PHYREGS(0x03d7, 0x03d3, 0x03cf, 0x042b, 0x042f, 0x0434),
  },
  {	.freq			= 2452,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x94, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x07, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x09, 0x00, 0x07, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x09),
	PHYREGS(0x03d9, 0x03d5, 0x03d1, 0x0429, 0x042d, 0x0431),
  },
  {	.freq			= 2457,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x99, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x06, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x09, 0x00, 0x06, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x09),
	PHYREGS(0x03db, 0x03d7, 0x03d3, 0x0427, 0x042b, 0x042f),
  },
  {	.freq			= 2462,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x9e, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x05, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x09, 0x00, 0x05, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x09),
	PHYREGS(0x03dd, 0x03d9, 0x03d5, 0x0424, 0x0429, 0x042d),
  },
  {	.freq			= 2467,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa3, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x08, 0x00, 0x04, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x08),
	PHYREGS(0x03df, 0x03db, 0x03d7, 0x0422, 0x0427, 0x042b),
  },
  {	.freq			= 2472,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa8, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x03, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x08, 0x00, 0x03, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x08),
	PHYREGS(0x03e1, 0x03dd, 0x03d9, 0x0420, 0x0424, 0x0429),
  },
  {	.freq			= 2484,
	RADIOREGS3(0xff, 0x01, 0x03, 0x09, 0xb4, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x08),
	PHYREGS(0x03e6, 0x03e2, 0x03de, 0x041b, 0x041f, 0x0424),
  },
};

static const struct b43_nphy_channeltab_entry_rev3 b43_nphy_channeltab_rev6[] = {
  {	.freq			= 4920,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xec, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07b4, 0x07b0, 0x07ac, 0x0214, 0x0215, 0x0216),
  },
  {	.freq			= 4930,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xed, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07b8, 0x07b4, 0x07b0, 0x0213, 0x0214, 0x0215),
  },
  {	.freq			= 4940,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xee, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07bc, 0x07b8, 0x07b4, 0x0212, 0x0213, 0x0214),
  },
  {	.freq			= 4950,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xef, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c0, 0x07bc, 0x07b8, 0x0211, 0x0212, 0x0213),
  },
  {	.freq			= 4960,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf0, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c4, 0x07c0, 0x07bc, 0x020f, 0x0211, 0x0212),
  },
  {	.freq			= 4970,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf1, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c8, 0x07c4, 0x07c0, 0x020e, 0x020f, 0x0211),
  },
  {	.freq			= 4980,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf2, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07cc, 0x07c8, 0x07c4, 0x020d, 0x020e, 0x020f),
  },
  {	.freq			= 4990,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf3, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d0, 0x07cc, 0x07c8, 0x020c, 0x020d, 0x020e),
  },
  {	.freq			= 5000,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf4, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d4, 0x07d0, 0x07cc, 0x020b, 0x020c, 0x020d),
  },
  {	.freq			= 5010,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf5, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d8, 0x07d4, 0x07d0, 0x020a, 0x020b, 0x020c),
  },
  {	.freq			= 5020,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf6, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07dc, 0x07d8, 0x07d4, 0x0209, 0x020a, 0x020b),
  },
  {	.freq			= 5030,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf7, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e0, 0x07dc, 0x07d8, 0x0208, 0x0209, 0x020a),
  },
  {	.freq			= 5040,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf8, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e4, 0x07e0, 0x07dc, 0x0207, 0x0208, 0x0209),
  },
  {	.freq			= 5050,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf9, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e8, 0x07e4, 0x07e0, 0x0206, 0x0207, 0x0208),
  },
  {	.freq			= 5060,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfa, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07ec, 0x07e8, 0x07e4, 0x0205, 0x0206, 0x0207),
  },
  {	.freq			= 5070,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfb, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfd, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f0, 0x07ec, 0x07e8, 0x0204, 0x0205, 0x0206),
  },
  {	.freq			= 5080,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfc, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfd, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f4, 0x07f0, 0x07ec, 0x0203, 0x0204, 0x0205),
  },
  {	.freq			= 5090,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfd, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfd, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f8, 0x07f4, 0x07f0, 0x0202, 0x0203, 0x0204),
  },
  {	.freq			= 5100,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xfe, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfd, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07fc, 0x07f8, 0x07f4, 0x0201, 0x0202, 0x0203),
  },
  {	.freq			= 5110,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xff, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x0800, 0x07fc, 0x07f8, 0x0200, 0x0201, 0x0202),
  },
  {	.freq			= 5120,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x00, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x0804, 0x0800, 0x07fc, 0x01ff, 0x0200, 0x0201),
  },
  {	.freq			= 5130,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x01, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x0808, 0x0804, 0x0800, 0x01fe, 0x01ff, 0x0200),
  },
  {	.freq			= 5140,
	RADIOREGS3(0xc6, 0x01, 0x01, 0x02, 0x02, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfb, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x080c, 0x0808, 0x0804, 0x01fd, 0x01fe, 0x01ff),
  },
  {	.freq			= 5160,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x04, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x07, 0x00, 0x77, 0x00, 0x0e,
		   0x00, 0x6f, 0x00, 0xfa, 0x00, 0x07, 0x00, 0x77,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x0814, 0x0810, 0x080c, 0x01fb, 0x01fc, 0x01fd),
  },
  {	.freq			= 5170,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x05, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x07, 0x00, 0x77, 0x00, 0x0e,
		   0x00, 0x6f, 0x00, 0xfa, 0x00, 0x07, 0x00, 0x77,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x0818, 0x0814, 0x0810, 0x01fa, 0x01fb, 0x01fc),
  },
  {	.freq			= 5180,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x06, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xf9, 0x00, 0x06, 0x00, 0x77, 0x00, 0x0e,
		   0x00, 0x6f, 0x00, 0xf9, 0x00, 0x06, 0x00, 0x77,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x081c, 0x0818, 0x0814, 0x01f9, 0x01fa, 0x01fb),
  },
  {	.freq			= 5190,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x07, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xf9, 0x00, 0x06, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xf9, 0x00, 0x06, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0820, 0x081c, 0x0818, 0x01f8, 0x01f9, 0x01fa),
  },
  {	.freq			= 5200,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x08, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xf9, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xf9, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0824, 0x0820, 0x081c, 0x01f7, 0x01f8, 0x01f9),
  },
  {	.freq			= 5210,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x09, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xf9, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xf9, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0828, 0x0824, 0x0820, 0x01f6, 0x01f7, 0x01f8),
  },
  {	.freq			= 5220,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xfe, 0xd8, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xd8, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x082c, 0x0828, 0x0824, 0x01f5, 0x01f6, 0x01f7),
  },
  {	.freq			= 5230,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xee, 0xd8, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xd8, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0830, 0x082c, 0x0828, 0x01f4, 0x01f5, 0x01f6),
  },
  {	.freq			= 5240,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xee, 0xc8, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xc8, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0834, 0x0830, 0x082c, 0x01f3, 0x01f4, 0x01f5),
  },
  {	.freq			= 5250,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xed, 0xc7, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xc7, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0838, 0x0834, 0x0830, 0x01f2, 0x01f3, 0x01f4),
  },
  {	.freq			= 5260,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0e, 0x00,
		   0xed, 0xc7, 0x00, 0x04, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xc7, 0x00, 0x04, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x083c, 0x0838, 0x0834, 0x01f1, 0x01f2, 0x01f3),
  },
  {	.freq			= 5270,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8e, 0x0e, 0x00,
		   0xed, 0xc7, 0x00, 0x04, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xc7, 0x00, 0x04, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0840, 0x083c, 0x0838, 0x01f0, 0x01f1, 0x01f2),
  },
  {	.freq			= 5280,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x10, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0844, 0x0840, 0x083c, 0x01f0, 0x01f0, 0x01f1),
  },
  {	.freq			= 5290,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x11, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0848, 0x0844, 0x0840, 0x01ef, 0x01f0, 0x01f0),
  },
  {	.freq			= 5300,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x12, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x084c, 0x0848, 0x0844, 0x01ee, 0x01ef, 0x01f0),
  },
  {	.freq			= 5310,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x13, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0850, 0x084c, 0x0848, 0x01ed, 0x01ee, 0x01ef),
  },
  {	.freq			= 5320,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x14, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdb, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0854, 0x0850, 0x084c, 0x01ec, 0x01ed, 0x01ee),
  },
  {	.freq			= 5330,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x15, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xcb, 0xa6, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0b,
		   0x00, 0x6f, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x0858, 0x0854, 0x0850, 0x01eb, 0x01ec, 0x01ed),
  },
  {	.freq			= 5340,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x16, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xca, 0xa6, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0b,
		   0x00, 0x6f, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x085c, 0x0858, 0x0854, 0x01ea, 0x01eb, 0x01ec),
  },
  {	.freq			= 5350,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x17, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xca, 0xa6, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0b,
		   0x00, 0x6f, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x0860, 0x085c, 0x0858, 0x01e9, 0x01ea, 0x01eb),
  },
  {	.freq			= 5360,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x18, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xc9, 0x95, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x95, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0864, 0x0860, 0x085c, 0x01e8, 0x01e9, 0x01ea),
  },
  {	.freq			= 5370,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x19, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xc9, 0x95, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x95, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0868, 0x0864, 0x0860, 0x01e7, 0x01e8, 0x01e9),
  },
  {	.freq			= 5380,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x95, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x95, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x086c, 0x0868, 0x0864, 0x01e6, 0x01e7, 0x01e8),
  },
  {	.freq			= 5390,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x84, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0870, 0x086c, 0x0868, 0x01e5, 0x01e6, 0x01e7),
  },
  {	.freq			= 5400,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x84, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0874, 0x0870, 0x086c, 0x01e5, 0x01e5, 0x01e6),
  },
  {	.freq			= 5410,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb7, 0x84, 0x00, 0x02, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x02, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0878, 0x0874, 0x0870, 0x01e4, 0x01e5, 0x01e5),
  },
  {	.freq			= 5420,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xa7, 0x84, 0x00, 0x02, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x02, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x087c, 0x0878, 0x0874, 0x01e3, 0x01e4, 0x01e5),
  },
  {	.freq			= 5430,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0b, 0x00,
		   0xa6, 0x84, 0x00, 0x02, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x02, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0880, 0x087c, 0x0878, 0x01e2, 0x01e3, 0x01e4),
  },
  {	.freq			= 5440,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x20, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0xa6, 0x84, 0x00, 0x02, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x02, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0884, 0x0880, 0x087c, 0x01e1, 0x01e2, 0x01e3),
  },
  {	.freq			= 5450,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x21, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x95, 0x84, 0x00, 0x01, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x01, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0888, 0x0884, 0x0880, 0x01e0, 0x01e1, 0x01e2),
  },
  {	.freq			= 5460,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x22, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x95, 0x84, 0x00, 0x01, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x01, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x088c, 0x0888, 0x0884, 0x01df, 0x01e0, 0x01e1),
  },
  {	.freq			= 5470,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x23, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x94, 0x73, 0x00, 0x01, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x01, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0890, 0x088c, 0x0888, 0x01de, 0x01df, 0x01e0),
  },
  {	.freq			= 5480,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x24, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x84, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0894, 0x0890, 0x088c, 0x01dd, 0x01de, 0x01df),
  },
  {	.freq			= 5490,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x25, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x83, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0898, 0x0894, 0x0890, 0x01dd, 0x01dd, 0x01de),
  },
  {	.freq			= 5500,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x26, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x82, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x089c, 0x0898, 0x0894, 0x01dc, 0x01dd, 0x01dd),
  },
  {	.freq			= 5510,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x27, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x82, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08a0, 0x089c, 0x0898, 0x01db, 0x01dc, 0x01dd),
  },
  {	.freq			= 5520,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x28, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x72, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08a4, 0x08a0, 0x089c, 0x01da, 0x01db, 0x01dc),
  },
  {	.freq			= 5530,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x29, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x09, 0x00,
		   0x72, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08a8, 0x08a4, 0x08a0, 0x01d9, 0x01da, 0x01db),
  },
  {	.freq			= 5540,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x09, 0x00,
		   0x71, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08ac, 0x08a8, 0x08a4, 0x01d8, 0x01d9, 0x01da),
  },
  {	.freq			= 5550,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08b0, 0x08ac, 0x08a8, 0x01d7, 0x01d8, 0x01d9),
  },
  {	.freq			= 5560,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08b4, 0x08b0, 0x08ac, 0x01d7, 0x01d7, 0x01d8),
  },
  {	.freq			= 5570,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x62, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x62, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08b8, 0x08b4, 0x08b0, 0x01d6, 0x01d7, 0x01d7),
  },
  {	.freq			= 5580,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x08, 0x00,
		   0x60, 0x62, 0x00, 0x00, 0x00, 0x77, 0x00, 0x08,
		   0x00, 0x6f, 0x00, 0x62, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x08, 0x00, 0x6f, 0x00),
	PHYREGS(0x08bc, 0x08b8, 0x08b4, 0x01d5, 0x01d6, 0x01d7),
  },
  {	.freq			= 5590,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x08, 0x00,
		   0x50, 0x61, 0x00, 0x00, 0x00, 0x77, 0x00, 0x08,
		   0x00, 0x6f, 0x00, 0x61, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x08, 0x00, 0x6f, 0x00),
	PHYREGS(0x08c0, 0x08bc, 0x08b8, 0x01d4, 0x01d5, 0x01d6),
  },
  {	.freq			= 5600,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x30, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x77, 0x00, 0x08,
		   0x00, 0x6f, 0x00, 0x51, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x08, 0x00, 0x6f, 0x00),
	PHYREGS(0x08c4, 0x08c0, 0x08bc, 0x01d3, 0x01d4, 0x01d5),
  },
  {	.freq			= 5610,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x31, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x77, 0x00, 0x08,
		   0x00, 0x6f, 0x00, 0x51, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x08, 0x00, 0x6f, 0x00),
	PHYREGS(0x08c8, 0x08c4, 0x08c0, 0x01d2, 0x01d3, 0x01d4),
  },
  {	.freq			= 5620,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x32, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x50, 0x00, 0x00, 0x00, 0x77, 0x00, 0x07,
		   0x00, 0x6f, 0x00, 0x50, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x07, 0x00, 0x6f, 0x00),
	PHYREGS(0x08cc, 0x08c8, 0x08c4, 0x01d2, 0x01d2, 0x01d3),
  },
  {	.freq			= 5630,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x33, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x50, 0x50, 0x00, 0x00, 0x00, 0x77, 0x00, 0x07,
		   0x00, 0x6f, 0x00, 0x50, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x07, 0x00, 0x6f, 0x00),
	PHYREGS(0x08d0, 0x08cc, 0x08c8, 0x01d1, 0x01d2, 0x01d2),
  },
  {	.freq			= 5640,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x34, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x50, 0x00, 0x00, 0x00, 0x77, 0x00, 0x07,
		   0x00, 0x6f, 0x00, 0x50, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x07, 0x00, 0x6f, 0x00),
	PHYREGS(0x08d4, 0x08d0, 0x08cc, 0x01d0, 0x01d1, 0x01d2),
  },
  {	.freq			= 5650,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x35, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x77, 0x00, 0x07,
		   0x00, 0x6f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x07, 0x00, 0x6f, 0x00),
	PHYREGS(0x08d8, 0x08d4, 0x08d0, 0x01cf, 0x01d0, 0x01d1),
  },
  {	.freq			= 5660,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x36, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6f, 0x00),
	PHYREGS(0x08dc, 0x08d8, 0x08d4, 0x01ce, 0x01cf, 0x01d0),
  },
  {	.freq			= 5670,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x37, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6f, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6f, 0x00),
	PHYREGS(0x08e0, 0x08dc, 0x08d8, 0x01ce, 0x01ce, 0x01cf),
  },
  {	.freq			= 5680,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x38, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6f, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6f, 0x00),
	PHYREGS(0x08e4, 0x08e0, 0x08dc, 0x01cd, 0x01ce, 0x01ce),
  },
  {	.freq			= 5690,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x39, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6f, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6f, 0x00),
	PHYREGS(0x08e8, 0x08e4, 0x08e0, 0x01cc, 0x01cd, 0x01ce),
  },
  {	.freq			= 5700,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08ec, 0x08e8, 0x08e4, 0x01cb, 0x01cc, 0x01cd),
  },
  {	.freq			= 5710,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08f0, 0x08ec, 0x08e8, 0x01ca, 0x01cb, 0x01cc),
  },
  {	.freq			= 5720,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08f4, 0x08f0, 0x08ec, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5725,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x79, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08f6, 0x08f2, 0x08ee, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5730,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08f8, 0x08f4, 0x08f0, 0x01c9, 0x01c9, 0x01ca),
  },
  {	.freq			= 5735,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x7b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6d, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6d, 0x00),
	PHYREGS(0x08fa, 0x08f6, 0x08f2, 0x01c8, 0x01c9, 0x01ca),
  },
  {	.freq			= 5740,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6d, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6d, 0x00),
	PHYREGS(0x08fc, 0x08f8, 0x08f4, 0x01c8, 0x01c9, 0x01c9),
  },
  {	.freq			= 5745,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6d, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6d, 0x00),
	PHYREGS(0x08fe, 0x08fa, 0x08f6, 0x01c8, 0x01c8, 0x01c9),
  },
  {	.freq			= 5750,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x20, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6d, 0x00, 0x20, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6d, 0x00),
	PHYREGS(0x0900, 0x08fc, 0x08f8, 0x01c7, 0x01c8, 0x01c9),
  },
  {	.freq			= 5755,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7f, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x10, 0x20, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6c, 0x00, 0x20, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6c, 0x00),
	PHYREGS(0x0902, 0x08fe, 0x08fa, 0x01c7, 0x01c8, 0x01c8),
  },
  {	.freq			= 5760,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x40, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x05, 0x00,
		   0x10, 0x20, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6c, 0x00, 0x20, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6c, 0x00),
	PHYREGS(0x0904, 0x0900, 0x08fc, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5765,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x81, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x86, 0x05, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6c, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6c, 0x00),
	PHYREGS(0x0906, 0x0902, 0x08fe, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5770,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x41, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x0908, 0x0904, 0x0900, 0x01c6, 0x01c6, 0x01c7),
  },
  {	.freq			= 5775,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x83, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x090a, 0x0906, 0x0902, 0x01c5, 0x01c6, 0x01c7),
  },
  {	.freq			= 5780,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x42, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x090c, 0x0908, 0x0904, 0x01c5, 0x01c6, 0x01c6),
  },
  {	.freq			= 5785,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x85, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x090e, 0x090a, 0x0906, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5790,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x43, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x0910, 0x090c, 0x0908, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5795,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x87, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x0912, 0x090e, 0x090a, 0x01c4, 0x01c4, 0x01c5),
  },
  {	.freq			= 5800,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x44, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x0914, 0x0910, 0x090c, 0x01c3, 0x01c4, 0x01c5),
  },
  {	.freq			= 5805,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x89, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6a, 0x00),
	PHYREGS(0x0916, 0x0912, 0x090e, 0x01c3, 0x01c4, 0x01c4),
  },
  {	.freq			= 5810,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x45, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6a, 0x00),
	PHYREGS(0x0918, 0x0914, 0x0910, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5815,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6a, 0x00),
	PHYREGS(0x091a, 0x0916, 0x0912, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5820,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x46, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6a, 0x00),
	PHYREGS(0x091c, 0x0918, 0x0914, 0x01c2, 0x01c2, 0x01c3),
  },
  {	.freq			= 5825,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x69, 0x00),
	PHYREGS(0x091e, 0x091a, 0x0916, 0x01c1, 0x01c2, 0x01c3),
  },
  {	.freq			= 5830,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x47, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x69, 0x00),
	PHYREGS(0x0920, 0x091c, 0x0918, 0x01c1, 0x01c2, 0x01c2),
  },
  {	.freq			= 5840,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x48, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x69, 0x00),
	PHYREGS(0x0924, 0x0920, 0x091c, 0x01c0, 0x01c1, 0x01c2),
  },
  {	.freq			= 5850,
	RADIOREGS3(0xe0, 0x00, 0x01, 0x02, 0x49, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x69, 0x00),
	PHYREGS(0x0928, 0x0924, 0x0920, 0x01bf, 0x01c0, 0x01c1),
  },
  {	.freq			= 5860,
	RADIOREGS3(0xde, 0x00, 0x01, 0x02, 0x4a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x69, 0x00),
	PHYREGS(0x092c, 0x0928, 0x0924, 0x01bf, 0x01bf, 0x01c0),
  },
  {	.freq			= 5870,
	RADIOREGS3(0xdb, 0x00, 0x01, 0x02, 0x4b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0930, 0x092c, 0x0928, 0x01be, 0x01bf, 0x01bf),
  },
  {	.freq			= 5880,
	RADIOREGS3(0xd8, 0x00, 0x01, 0x02, 0x4c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0934, 0x0930, 0x092c, 0x01bd, 0x01be, 0x01bf),
  },
  {	.freq			= 5890,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0938, 0x0934, 0x0930, 0x01bc, 0x01bd, 0x01be),
  },
  {	.freq			= 5900,
	RADIOREGS3(0xd3, 0x00, 0x01, 0x02, 0x4e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x093c, 0x0938, 0x0934, 0x01bc, 0x01bc, 0x01bd),
  },
  {	.freq			= 5910,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0940, 0x093c, 0x0938, 0x01bb, 0x01bc, 0x01bc),
  },
  {	.freq			= 2412,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x6c, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x04, 0x04, 0x04, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x78, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0b, 0x00, 0x0a, 0x00, 0x78, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0b, 0x00, 0x0a),
	PHYREGS(0x03c9, 0x03c5, 0x03c1, 0x043a, 0x043f, 0x0443),
  },
  {	.freq			= 2417,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x71, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x78, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0b, 0x00, 0x0a, 0x00, 0x78, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0b, 0x00, 0x0a),
	PHYREGS(0x03cb, 0x03c7, 0x03c3, 0x0438, 0x043d, 0x0441),
  },
  {	.freq			= 2422,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x76, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x67, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0b, 0x00, 0x0a, 0x00, 0x67, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0b, 0x00, 0x0a),
	PHYREGS(0x03cd, 0x03c9, 0x03c5, 0x0436, 0x043a, 0x043f),
  },
  {	.freq			= 2427,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x7b, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x57, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x0a, 0x00, 0x57, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x0a),
	PHYREGS(0x03cf, 0x03cb, 0x03c7, 0x0434, 0x0438, 0x043d),
  },
  {	.freq			= 2432,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x80, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x56, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x0a, 0x00, 0x56, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x0a),
	PHYREGS(0x03d1, 0x03cd, 0x03c9, 0x0431, 0x0436, 0x043a),
  },
  {	.freq			= 2437,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x85, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x46, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x0a, 0x00, 0x46, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x0a),
	PHYREGS(0x03d3, 0x03cf, 0x03cb, 0x042f, 0x0434, 0x0438),
  },
  {	.freq			= 2442,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8a, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x45, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x0a, 0x00, 0x45, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x0a),
	PHYREGS(0x03d5, 0x03d1, 0x03cd, 0x042d, 0x0431, 0x0436),
  },
  {	.freq			= 2447,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8f, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x34, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x09, 0x00, 0x34, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x09),
	PHYREGS(0x03d7, 0x03d3, 0x03cf, 0x042b, 0x042f, 0x0434),
  },
  {	.freq			= 2452,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x94, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x23, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x09, 0x00, 0x23, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x09),
	PHYREGS(0x03d9, 0x03d5, 0x03d1, 0x0429, 0x042d, 0x0431),
  },
  {	.freq			= 2457,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x99, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x12, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x09, 0x00, 0x12, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x09),
	PHYREGS(0x03db, 0x03d7, 0x03d3, 0x0427, 0x042b, 0x042f),
  },
  {	.freq			= 2462,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x9e, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x09, 0x00, 0x09, 0x00, 0x02, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x09, 0x00, 0x09),
	PHYREGS(0x03dd, 0x03d9, 0x03d5, 0x0424, 0x0429, 0x042d),
  },
  {	.freq			= 2467,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa3, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x09, 0x00, 0x09, 0x00, 0x01, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x09, 0x00, 0x09),
	PHYREGS(0x03df, 0x03db, 0x03d7, 0x0422, 0x0427, 0x042b),
  },
  {	.freq			= 2472,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa8, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x09, 0x00, 0x09, 0x00, 0x01, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x09, 0x00, 0x09),
	PHYREGS(0x03e1, 0x03dd, 0x03d9, 0x0420, 0x0424, 0x0429),
  },
  {	.freq			= 2484,
	RADIOREGS3(0xff, 0x01, 0x03, 0x09, 0xb4, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x20, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x09, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x09, 0x00, 0x09),
	PHYREGS(0x03e6, 0x03e2, 0x03de, 0x041b, 0x041f, 0x0424),
  },
};

static const struct b43_nphy_channeltab_entry_rev3 b43_nphy_channeltab_rev7_9[] = {
  {	.freq			= 4920,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xec, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0b, 0x00, 0x70, 0x00, 0x0f,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0b, 0x00, 0x70,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07b4, 0x07b0, 0x07ac, 0x0214, 0x0215, 0x0216),
  },
  {	.freq			= 4930,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xed, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0b, 0x00, 0x70, 0x00, 0x0e,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0b, 0x00, 0x70,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x07b8, 0x07b4, 0x07b0, 0x0213, 0x0214, 0x0215),
  },
  {	.freq			= 4940,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xee, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0b, 0x00, 0x70, 0x00, 0x0e,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0b, 0x00, 0x70,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x07bc, 0x07b8, 0x07b4, 0x0212, 0x0213, 0x0214),
  },
  {	.freq			= 4950,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xef, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0b, 0x00, 0x70, 0x00, 0x0e,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0b, 0x00, 0x70,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c0, 0x07bc, 0x07b8, 0x0211, 0x0212, 0x0213),
  },
  {	.freq			= 4960,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf0, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0e,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c4, 0x07c0, 0x07bc, 0x020f, 0x0211, 0x0212),
  },
  {	.freq			= 4970,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf1, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c8, 0x07c4, 0x07c0, 0x020e, 0x020f, 0x0211),
  },
  {	.freq			= 4980,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf2, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07cc, 0x07c8, 0x07c4, 0x020d, 0x020e, 0x020f),
  },
  {	.freq			= 4990,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf3, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d0, 0x07cc, 0x07c8, 0x020c, 0x020d, 0x020e),
  },
  {	.freq			= 5000,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf4, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d4, 0x07d0, 0x07cc, 0x020b, 0x020c, 0x020d),
  },
  {	.freq			= 5010,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf5, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x0a, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d8, 0x07d4, 0x07d0, 0x020a, 0x020b, 0x020c),
  },
  {	.freq			= 5020,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf6, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0d,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x07dc, 0x07d8, 0x07d4, 0x0209, 0x020a, 0x020b),
  },
  {	.freq			= 5030,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf7, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xff, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0c,
		   0x00, 0x9f, 0x00, 0xff, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e0, 0x07dc, 0x07d8, 0x0208, 0x0209, 0x020a),
  },
  {	.freq			= 5040,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf8, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0c,
		   0x00, 0x9f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e4, 0x07e0, 0x07dc, 0x0207, 0x0208, 0x0209),
  },
  {	.freq			= 5050,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf9, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0c,
		   0x00, 0x9f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e8, 0x07e4, 0x07e0, 0x0206, 0x0207, 0x0208),
  },
  {	.freq			= 5060,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfa, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x09, 0x00, 0x70, 0x00, 0x0c,
		   0x00, 0x9f, 0x00, 0xfd, 0x00, 0x09, 0x00, 0x70,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x07ec, 0x07e8, 0x07e4, 0x0205, 0x0206, 0x0207),
  },
  {	.freq			= 5070,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfb, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfd, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f0, 0x07ec, 0x07e8, 0x0204, 0x0205, 0x0206),
  },
  {	.freq			= 5080,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfc, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f4, 0x07f0, 0x07ec, 0x0203, 0x0204, 0x0205),
  },
  {	.freq			= 5090,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfd, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f8, 0x07f4, 0x07f0, 0x0202, 0x0203, 0x0204),
  },
  {	.freq			= 5100,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xfe, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x07fc, 0x07f8, 0x07f4, 0x0201, 0x0202, 0x0203),
  },
  {	.freq			= 5110,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xff, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x0800, 0x07fc, 0x07f8, 0x0200, 0x0201, 0x0202),
  },
  {	.freq			= 5120,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x00, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0b,
		   0x00, 0x9f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x0804, 0x0800, 0x07fc, 0x01ff, 0x0200, 0x0201),
  },
  {	.freq			= 5130,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x01, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x08, 0x00, 0x70, 0x00, 0x0a,
		   0x00, 0x9f, 0x00, 0xfb, 0x00, 0x08, 0x00, 0x70,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0808, 0x0804, 0x0800, 0x01fe, 0x01ff, 0x0200),
  },
  {	.freq			= 5140,
	RADIOREGS3(0xc6, 0x01, 0x01, 0x02, 0x02, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x07, 0x00, 0x70, 0x00, 0x0a,
		   0x00, 0x9f, 0x00, 0xfb, 0x00, 0x07, 0x00, 0x70,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x080c, 0x0808, 0x0804, 0x01fd, 0x01fe, 0x01ff),
  },
  {	.freq			= 5160,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x04, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x07, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfb, 0x00, 0x07, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0814, 0x0810, 0x080c, 0x01fb, 0x01fc, 0x01fd),
  },
  {	.freq			= 5170,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x05, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfb, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0818, 0x0814, 0x0810, 0x01fa, 0x01fb, 0x01fc),
  },
  {	.freq			= 5180,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x06, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x081c, 0x0818, 0x0814, 0x01f9, 0x01fa, 0x01fb),
  },
  {	.freq			= 5190,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x07, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0820, 0x081c, 0x0818, 0x01f8, 0x01f9, 0x01fa),
  },
  {	.freq			= 5200,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x08, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0824, 0x0820, 0x081c, 0x01f7, 0x01f8, 0x01f9),
  },
  {	.freq			= 5210,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x09, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x0828, 0x0824, 0x0820, 0x01f6, 0x01f7, 0x01f8),
  },
  {	.freq			= 5220,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xfe, 0xfa, 0x00, 0x06, 0x00, 0x70, 0x00, 0x09,
		   0x00, 0x9e, 0x00, 0xfa, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x09, 0x00, 0x6e, 0x00),
	PHYREGS(0x082c, 0x0828, 0x0824, 0x01f5, 0x01f6, 0x01f7),
  },
  {	.freq			= 5230,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xee, 0xea, 0x00, 0x06, 0x00, 0x70, 0x00, 0x08,
		   0x00, 0x9e, 0x00, 0xea, 0x00, 0x06, 0x00, 0x70,
		   0x00, 0x08, 0x00, 0x6e, 0x00),
	PHYREGS(0x0830, 0x082c, 0x0828, 0x01f4, 0x01f5, 0x01f6),
  },
  {	.freq			= 5240,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xee, 0xe9, 0x00, 0x05, 0x00, 0x70, 0x00, 0x08,
		   0x00, 0x9d, 0x00, 0xe9, 0x00, 0x05, 0x00, 0x70,
		   0x00, 0x08, 0x00, 0x6d, 0x00),
	PHYREGS(0x0834, 0x0830, 0x082c, 0x01f3, 0x01f4, 0x01f5),
  },
  {	.freq			= 5250,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xed, 0xe9, 0x00, 0x05, 0x00, 0x70, 0x00, 0x08,
		   0x00, 0x9d, 0x00, 0xe9, 0x00, 0x05, 0x00, 0x70,
		   0x00, 0x08, 0x00, 0x6d, 0x00),
	PHYREGS(0x0838, 0x0834, 0x0830, 0x01f2, 0x01f3, 0x01f4),
  },
  {	.freq			= 5260,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0e, 0x00,
		   0xed, 0xd9, 0x00, 0x05, 0x00, 0x70, 0x00, 0x08,
		   0x00, 0x9d, 0x00, 0xd9, 0x00, 0x05, 0x00, 0x70,
		   0x00, 0x08, 0x00, 0x6d, 0x00),
	PHYREGS(0x083c, 0x0838, 0x0834, 0x01f1, 0x01f2, 0x01f3),
  },
  {	.freq			= 5270,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8e, 0x0e, 0x00,
		   0xed, 0xd8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xd8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0840, 0x083c, 0x0838, 0x01f0, 0x01f1, 0x01f2),
  },
  {	.freq			= 5280,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x10, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xc8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xc8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0844, 0x0840, 0x083c, 0x01f0, 0x01f0, 0x01f1),
  },
  {	.freq			= 5290,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x11, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xc8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xc8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0848, 0x0844, 0x0840, 0x01ef, 0x01f0, 0x01f0),
  },
  {	.freq			= 5300,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x12, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xc8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xc8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x084c, 0x0848, 0x0844, 0x01ee, 0x01ef, 0x01f0),
  },
  {	.freq			= 5310,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x13, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xc8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xc8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0850, 0x084c, 0x0848, 0x01ed, 0x01ee, 0x01ef),
  },
  {	.freq			= 5320,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x14, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdb, 0xb8, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9c, 0x00, 0xb8, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6c, 0x00),
	PHYREGS(0x0854, 0x0850, 0x084c, 0x01ec, 0x01ed, 0x01ee),
  },
  {	.freq			= 5330,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x15, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xcb, 0xb7, 0x00, 0x04, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9b, 0x00, 0xb7, 0x00, 0x04, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6b, 0x00),
	PHYREGS(0x0858, 0x0854, 0x0850, 0x01eb, 0x01ec, 0x01ed),
  },
  {	.freq			= 5340,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x16, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xca, 0xb7, 0x00, 0x03, 0x00, 0x70, 0x00, 0x07,
		   0x00, 0x9b, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x07, 0x00, 0x6b, 0x00),
	PHYREGS(0x085c, 0x0858, 0x0854, 0x01ea, 0x01eb, 0x01ec),
  },
  {	.freq			= 5350,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x17, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xca, 0xa7, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9b, 0x00, 0xa7, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x6b, 0x00),
	PHYREGS(0x0860, 0x085c, 0x0858, 0x01e9, 0x01ea, 0x01eb),
  },
  {	.freq			= 5360,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x18, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xc9, 0xa6, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9b, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x6b, 0x00),
	PHYREGS(0x0864, 0x0860, 0x085c, 0x01e8, 0x01e9, 0x01ea),
  },
  {	.freq			= 5370,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x19, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xc9, 0xa6, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9b, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x7b, 0x00),
	PHYREGS(0x0868, 0x0864, 0x0860, 0x01e7, 0x01e8, 0x01e9),
  },
  {	.freq			= 5380,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x96, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9a, 0x00, 0x96, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x7a, 0x00),
	PHYREGS(0x086c, 0x0868, 0x0864, 0x01e6, 0x01e7, 0x01e8),
  },
  {	.freq			= 5390,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x95, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9a, 0x00, 0x95, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x7a, 0x00),
	PHYREGS(0x0870, 0x086c, 0x0868, 0x01e5, 0x01e6, 0x01e7),
  },
  {	.freq			= 5400,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x95, 0x00, 0x03, 0x00, 0x70, 0x00, 0x06,
		   0x00, 0x9a, 0x00, 0x95, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x06, 0x00, 0x7a, 0x00),
	PHYREGS(0x0874, 0x0870, 0x086c, 0x01e5, 0x01e5, 0x01e6),
  },
  {	.freq			= 5410,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb7, 0x95, 0x00, 0x03, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x9a, 0x00, 0x95, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x7a, 0x00),
	PHYREGS(0x0878, 0x0874, 0x0870, 0x01e4, 0x01e5, 0x01e5),
  },
  {	.freq			= 5420,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xa7, 0x95, 0x00, 0x03, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x9a, 0x00, 0x95, 0x00, 0x03, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x7a, 0x00),
	PHYREGS(0x087c, 0x0878, 0x0874, 0x01e3, 0x01e4, 0x01e5),
  },
  {	.freq			= 5430,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0b, 0x00,
		   0xa6, 0x85, 0x00, 0x02, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x99, 0x00, 0x85, 0x00, 0x02, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x79, 0x00),
	PHYREGS(0x0880, 0x087c, 0x0878, 0x01e2, 0x01e3, 0x01e4),
  },
  {	.freq			= 5440,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x20, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0xa6, 0x84, 0x00, 0x02, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x99, 0x00, 0x84, 0x00, 0x02, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x79, 0x00),
	PHYREGS(0x0884, 0x0880, 0x087c, 0x01e1, 0x01e2, 0x01e3),
  },
  {	.freq			= 5450,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x21, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x95, 0x84, 0x00, 0x02, 0x00, 0x70, 0x00, 0x05,
		   0x00, 0x99, 0x00, 0x84, 0x00, 0x02, 0x00, 0x70,
		   0x00, 0x05, 0x00, 0x79, 0x00),
	PHYREGS(0x0888, 0x0884, 0x0880, 0x01e0, 0x01e1, 0x01e2),
  },
  {	.freq			= 5460,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x22, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x95, 0x84, 0x00, 0x02, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x99, 0x00, 0x84, 0x00, 0x02, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x79, 0x00),
	PHYREGS(0x088c, 0x0888, 0x0884, 0x01df, 0x01e0, 0x01e1),
  },
  {	.freq			= 5470,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x23, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x94, 0x74, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x99, 0x00, 0x74, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x79, 0x00),
	PHYREGS(0x0890, 0x088c, 0x0888, 0x01de, 0x01df, 0x01e0),
  },
  {	.freq			= 5480,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x24, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x84, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x78, 0x00),
	PHYREGS(0x0894, 0x0890, 0x088c, 0x01dd, 0x01de, 0x01df),
  },
  {	.freq			= 5490,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x25, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x83, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x78, 0x00),
	PHYREGS(0x0898, 0x0894, 0x0890, 0x01dd, 0x01dd, 0x01de),
  },
  {	.freq			= 5500,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x26, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x82, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x78, 0x00),
	PHYREGS(0x089c, 0x0898, 0x0894, 0x01dc, 0x01dd, 0x01dd),
  },
  {	.freq			= 5510,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x27, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x82, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x78, 0x00),
	PHYREGS(0x08a0, 0x089c, 0x0898, 0x01db, 0x01dc, 0x01dd),
  },
  {	.freq			= 5520,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x28, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x72, 0x73, 0x00, 0x01, 0x00, 0x70, 0x00, 0x04,
		   0x00, 0x98, 0x00, 0x73, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x04, 0x00, 0x78, 0x00),
	PHYREGS(0x08a4, 0x08a0, 0x089c, 0x01da, 0x01db, 0x01dc),
  },
  {	.freq			= 5530,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x29, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x09, 0x00,
		   0x72, 0x63, 0x00, 0x01, 0x00, 0x70, 0x00, 0x03,
		   0x00, 0x98, 0x00, 0x63, 0x00, 0x01, 0x00, 0x70,
		   0x00, 0x03, 0x00, 0x78, 0x00),
	PHYREGS(0x08a8, 0x08a4, 0x08a0, 0x01d9, 0x01da, 0x01db),
  },
  {	.freq			= 5540,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x09, 0x00,
		   0x71, 0x62, 0x00, 0x00, 0x00, 0x70, 0x00, 0x03,
		   0x00, 0x97, 0x00, 0x62, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x03, 0x00, 0x77, 0x00),
	PHYREGS(0x08ac, 0x08a8, 0x08a4, 0x01d8, 0x01d9, 0x01da),
  },
  {	.freq			= 5550,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x62, 0x00, 0x00, 0x00, 0x70, 0x00, 0x03,
		   0x00, 0x97, 0x00, 0x62, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x03, 0x00, 0x77, 0x00),
	PHYREGS(0x08b0, 0x08ac, 0x08a8, 0x01d7, 0x01d8, 0x01d9),
  },
  {	.freq			= 5560,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x62, 0x00, 0x00, 0x00, 0x70, 0x00, 0x03,
		   0x00, 0x97, 0x00, 0x62, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x03, 0x00, 0x77, 0x00),
	PHYREGS(0x08b4, 0x08b0, 0x08ac, 0x01d7, 0x01d7, 0x01d8),
  },
  {	.freq			= 5570,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x52, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x52, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x76, 0x00),
	PHYREGS(0x08b8, 0x08b4, 0x08b0, 0x01d6, 0x01d7, 0x01d7),
  },
  {	.freq			= 5580,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x08, 0x00,
		   0x60, 0x52, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x52, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x86, 0x00),
	PHYREGS(0x08bc, 0x08b8, 0x08b4, 0x01d5, 0x01d6, 0x01d7),
  },
  {	.freq			= 5590,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x08, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x86, 0x00),
	PHYREGS(0x08c0, 0x08bc, 0x08b8, 0x01d4, 0x01d5, 0x01d6),
  },
  {	.freq			= 5600,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x30, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x86, 0x00),
	PHYREGS(0x08c4, 0x08c0, 0x08bc, 0x01d3, 0x01d4, 0x01d5),
  },
  {	.freq			= 5610,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x31, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x86, 0x00),
	PHYREGS(0x08c8, 0x08c4, 0x08c0, 0x01d2, 0x01d3, 0x01d4),
  },
  {	.freq			= 5620,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x32, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x86, 0x00),
	PHYREGS(0x08cc, 0x08c8, 0x08c4, 0x01d2, 0x01d2, 0x01d3),
  },
  {	.freq			= 5630,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x33, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x96, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x86, 0x00),
	PHYREGS(0x08d0, 0x08cc, 0x08c8, 0x01d1, 0x01d2, 0x01d2),
  },
  {	.freq			= 5640,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x34, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x51, 0x00, 0x00, 0x00, 0x70, 0x00, 0x02,
		   0x00, 0x95, 0x00, 0x51, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x02, 0x00, 0x85, 0x00),
	PHYREGS(0x08d4, 0x08d0, 0x08cc, 0x01d0, 0x01d1, 0x01d2),
  },
  {	.freq			= 5650,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x35, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x50, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x95, 0x00, 0x50, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x85, 0x00),
	PHYREGS(0x08d8, 0x08d4, 0x08d0, 0x01cf, 0x01d0, 0x01d1),
  },
  {	.freq			= 5660,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x36, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x50, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x95, 0x00, 0x50, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x85, 0x00),
	PHYREGS(0x08dc, 0x08d8, 0x08d4, 0x01ce, 0x01cf, 0x01d0),
  },
  {	.freq			= 5670,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x37, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x84, 0x00),
	PHYREGS(0x08e0, 0x08dc, 0x08d8, 0x01ce, 0x01ce, 0x01cf),
  },
  {	.freq			= 5680,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x38, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x84, 0x00),
	PHYREGS(0x08e4, 0x08e0, 0x08dc, 0x01cd, 0x01ce, 0x01ce),
  },
  {	.freq			= 5690,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x39, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x94, 0x00),
	PHYREGS(0x08e8, 0x08e4, 0x08e0, 0x01cc, 0x01cd, 0x01ce),
  },
  {	.freq			= 5700,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x94, 0x00),
	PHYREGS(0x08ec, 0x08e8, 0x08e4, 0x01cb, 0x01cc, 0x01cd),
  },
  {	.freq			= 5710,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x94, 0x00),
	PHYREGS(0x08f0, 0x08ec, 0x08e8, 0x01ca, 0x01cb, 0x01cc),
  },
  {	.freq			= 5720,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x94, 0x00),
	PHYREGS(0x08f4, 0x08f0, 0x08ec, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5725,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x79, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x40, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x94, 0x00),
	PHYREGS(0x08f6, 0x08f2, 0x08ee, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5730,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x01,
		   0x00, 0x94, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x01, 0x00, 0x94, 0x00),
	PHYREGS(0x08f8, 0x08f4, 0x08f0, 0x01c9, 0x01c9, 0x01ca),
  },
  {	.freq			= 5735,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x7b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x93, 0x00),
	PHYREGS(0x08fa, 0x08f6, 0x08f2, 0x01c8, 0x01c9, 0x01ca),
  },
  {	.freq			= 5740,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x93, 0x00),
	PHYREGS(0x08fc, 0x08f8, 0x08f4, 0x01c8, 0x01c9, 0x01c9),
  },
  {	.freq			= 5745,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x93, 0x00),
	PHYREGS(0x08fe, 0x08fa, 0x08f6, 0x01c8, 0x01c8, 0x01c9),
  },
  {	.freq			= 5750,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x93, 0x00),
	PHYREGS(0x0900, 0x08fc, 0x08f8, 0x01c7, 0x01c8, 0x01c9),
  },
  {	.freq			= 5755,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7f, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x10, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x30, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x93, 0x00),
	PHYREGS(0x0902, 0x08fe, 0x08fa, 0x01c7, 0x01c8, 0x01c8),
  },
  {	.freq			= 5760,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x40, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x05, 0x00,
		   0x10, 0x20, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x93, 0x00, 0x20, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x93, 0x00),
	PHYREGS(0x0904, 0x0900, 0x08fc, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5765,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x81, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x86, 0x05, 0x00,
		   0x10, 0x20, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x20, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0906, 0x0902, 0x08fe, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5770,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x41, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x20, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x20, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0908, 0x0904, 0x0900, 0x01c6, 0x01c6, 0x01c7),
  },
  {	.freq			= 5775,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x83, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x20, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x20, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x090a, 0x0906, 0x0902, 0x01c5, 0x01c6, 0x01c7),
  },
  {	.freq			= 5780,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x42, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x090c, 0x0908, 0x0904, 0x01c5, 0x01c6, 0x01c6),
  },
  {	.freq			= 5785,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x85, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x090e, 0x090a, 0x0906, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5790,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x43, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0910, 0x090c, 0x0908, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5795,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x87, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0912, 0x090e, 0x090a, 0x01c4, 0x01c4, 0x01c5),
  },
  {	.freq			= 5800,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x44, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0914, 0x0910, 0x090c, 0x01c3, 0x01c4, 0x01c5),
  },
  {	.freq			= 5805,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x89, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0916, 0x0912, 0x090e, 0x01c3, 0x01c4, 0x01c4),
  },
  {	.freq			= 5810,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x45, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0918, 0x0914, 0x0910, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5815,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x091a, 0x0916, 0x0912, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5820,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x46, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x091c, 0x0918, 0x0914, 0x01c2, 0x01c2, 0x01c3),
  },
  {	.freq			= 5825,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x091e, 0x091a, 0x0916, 0x01c1, 0x01c2, 0x01c3),
  },
  {	.freq			= 5830,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x47, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0920, 0x091c, 0x0918, 0x01c1, 0x01c2, 0x01c2),
  },
  {	.freq			= 5840,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x48, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x10, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0924, 0x0920, 0x091c, 0x01c0, 0x01c1, 0x01c2),
  },
  {	.freq			= 5850,
	RADIOREGS3(0xe0, 0x00, 0x01, 0x02, 0x49, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x0928, 0x0924, 0x0920, 0x01bf, 0x01c0, 0x01c1),
  },
  {	.freq			= 5860,
	RADIOREGS3(0xde, 0x00, 0x01, 0x02, 0x4a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x92, 0x00),
	PHYREGS(0x092c, 0x0928, 0x0924, 0x01bf, 0x01bf, 0x01c0),
  },
  {	.freq			= 5870,
	RADIOREGS3(0xdb, 0x00, 0x01, 0x02, 0x4b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x91, 0x00),
	PHYREGS(0x0930, 0x092c, 0x0928, 0x01be, 0x01bf, 0x01bf),
  },
  {	.freq			= 5880,
	RADIOREGS3(0xd8, 0x00, 0x01, 0x02, 0x4c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x91, 0x00),
	PHYREGS(0x0934, 0x0930, 0x092c, 0x01bd, 0x01be, 0x01bf),
  },
  {	.freq			= 5890,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x91, 0x00),
	PHYREGS(0x0938, 0x0934, 0x0930, 0x01bc, 0x01bd, 0x01be),
  },
  {	.freq			= 5900,
	RADIOREGS3(0xd3, 0x00, 0x01, 0x02, 0x4e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x91, 0x00),
	PHYREGS(0x093c, 0x0938, 0x0934, 0x01bc, 0x01bc, 0x01bd),
  },
  {	.freq			= 5910,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
		   0x00, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
		   0x00, 0x00, 0x00, 0x91, 0x00),
	PHYREGS(0x0940, 0x093c, 0x0938, 0x01bb, 0x01bc, 0x01bc),
  },
  {	.freq			= 2412,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x6c, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x04, 0x04, 0x04, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x89, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0b, 0x00, 0x89, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0b),
	PHYREGS(0x03c9, 0x03c5, 0x03c1, 0x043a, 0x043f, 0x0443),
  },
  {	.freq			= 2417,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x71, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x89, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0a, 0x00, 0x89, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0a),
	PHYREGS(0x03cb, 0x03c7, 0x03c3, 0x0438, 0x043d, 0x0441),
  },
  {	.freq			= 2422,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x76, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x89, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0f, 0x00, 0x0a, 0x00, 0x89, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0f, 0x00, 0x0a),
	PHYREGS(0x03cd, 0x03c9, 0x03c5, 0x0436, 0x043a, 0x043f),
  },
  {	.freq			= 2427,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x7b, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x78, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x0a, 0x00, 0x78, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x0a),
	PHYREGS(0x03cf, 0x03cb, 0x03c7, 0x0434, 0x0438, 0x043d),
  },
  {	.freq			= 2432,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x80, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x77, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x0a, 0x00, 0x77, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x0a),
	PHYREGS(0x03d1, 0x03cd, 0x03c9, 0x0431, 0x0436, 0x043a),
  },
  {	.freq			= 2437,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x85, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x76, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x0a, 0x00, 0x76, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x0a),
	PHYREGS(0x03d3, 0x03cf, 0x03cb, 0x042f, 0x0434, 0x0438),
  },
  {	.freq			= 2442,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8a, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x66, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x0a, 0x00, 0x66, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x0a),
	PHYREGS(0x03d5, 0x03d1, 0x03cd, 0x042d, 0x0431, 0x0436),
  },
  {	.freq			= 2447,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8f, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x55, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x09, 0x00, 0x55, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x09),
	PHYREGS(0x03d7, 0x03d3, 0x03cf, 0x042b, 0x042f, 0x0434),
  },
  {	.freq			= 2452,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x94, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x45, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0e, 0x00, 0x09, 0x00, 0x45, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0e, 0x00, 0x09),
	PHYREGS(0x03d9, 0x03d5, 0x03d1, 0x0429, 0x042d, 0x0431),
  },
  {	.freq			= 2457,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x99, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x34, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x09, 0x00, 0x34, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x09),
	PHYREGS(0x03db, 0x03d7, 0x03d3, 0x0427, 0x042b, 0x042f),
  },
  {	.freq			= 2462,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x9e, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x33, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x09, 0x00, 0x33, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x09),
	PHYREGS(0x03dd, 0x03d9, 0x03d5, 0x0424, 0x0429, 0x042d),
  },
  {	.freq			= 2467,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa3, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x22, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x08, 0x00, 0x22, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x08),
	PHYREGS(0x03df, 0x03db, 0x03d7, 0x0422, 0x0427, 0x042b),
  },
  {	.freq			= 2472,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa8, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x11, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x08, 0x00, 0x11, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x08),
	PHYREGS(0x03e1, 0x03dd, 0x03d9, 0x0420, 0x0424, 0x0429),
  },
  {	.freq			= 2484,
	RADIOREGS3(0xff, 0x01, 0x03, 0x09, 0xb4, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x20, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0d, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0d, 0x00, 0x08),
	PHYREGS(0x03e6, 0x03e2, 0x03de, 0x041b, 0x041f, 0x0424),
  },
};

static const struct b43_nphy_channeltab_entry_rev3 b43_nphy_channeltab_rev8[] = {
  {	.freq			= 4920,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xec, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07b4, 0x07b0, 0x07ac, 0x0214, 0x0215, 0x0216),
  },
  {	.freq			= 4930,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xed, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07b8, 0x07b4, 0x07b0, 0x0213, 0x0214, 0x0215),
  },
  {	.freq			= 4940,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xee, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07bc, 0x07b8, 0x07b4, 0x0212, 0x0213, 0x0214),
  },
  {	.freq			= 4950,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xef, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x00, 0x00, 0x00, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c0, 0x07bc, 0x07b8, 0x0211, 0x0212, 0x0213),
  },
  {	.freq			= 4960,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf0, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c4, 0x07c0, 0x07bc, 0x020f, 0x0211, 0x0212),
  },
  {	.freq			= 4970,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf1, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07c8, 0x07c4, 0x07c0, 0x020e, 0x020f, 0x0211),
  },
  {	.freq			= 4980,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf2, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07cc, 0x07c8, 0x07c4, 0x020d, 0x020e, 0x020f),
  },
  {	.freq			= 4990,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf3, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d0, 0x07cc, 0x07c8, 0x020c, 0x020d, 0x020e),
  },
  {	.freq			= 5000,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf4, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d4, 0x07d0, 0x07cc, 0x020b, 0x020c, 0x020d),
  },
  {	.freq			= 5010,
	RADIOREGS3(0xff, 0x01, 0x01, 0x01, 0xf5, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07d8, 0x07d4, 0x07d0, 0x020a, 0x020b, 0x020c),
  },
  {	.freq			= 5020,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf6, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07dc, 0x07d8, 0x07d4, 0x0209, 0x020a, 0x020b),
  },
  {	.freq			= 5030,
	RADIOREGS3(0xf7, 0x01, 0x01, 0x01, 0xf7, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e0, 0x07dc, 0x07d8, 0x0208, 0x0209, 0x020a),
  },
  {	.freq			= 5040,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf8, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e4, 0x07e0, 0x07dc, 0x0207, 0x0208, 0x0209),
  },
  {	.freq			= 5050,
	RADIOREGS3(0xef, 0x01, 0x01, 0x01, 0xf9, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07e8, 0x07e4, 0x07e0, 0x0206, 0x0207, 0x0208),
  },
  {	.freq			= 5060,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfa, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfe, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfe, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07ec, 0x07e8, 0x07e4, 0x0205, 0x0206, 0x0207),
  },
  {	.freq			= 5070,
	RADIOREGS3(0xe6, 0x01, 0x01, 0x01, 0xfb, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfd, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f0, 0x07ec, 0x07e8, 0x0204, 0x0205, 0x0206),
  },
  {	.freq			= 5080,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfc, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfd, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f4, 0x07f0, 0x07ec, 0x0203, 0x0204, 0x0205),
  },
  {	.freq			= 5090,
	RADIOREGS3(0xde, 0x01, 0x01, 0x01, 0xfd, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x01, 0x01, 0x01, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x09, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfd, 0x00, 0x09, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07f8, 0x07f4, 0x07f0, 0x0202, 0x0203, 0x0204),
  },
  {	.freq			= 5100,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xfe, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfd, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfd, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x07fc, 0x07f8, 0x07f4, 0x0201, 0x0202, 0x0203),
  },
  {	.freq			= 5110,
	RADIOREGS3(0xd6, 0x01, 0x01, 0x01, 0xff, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x0800, 0x07fc, 0x07f8, 0x0200, 0x0201, 0x0202),
  },
  {	.freq			= 5120,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x00, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x0804, 0x0800, 0x07fc, 0x01ff, 0x0200, 0x0201),
  },
  {	.freq			= 5130,
	RADIOREGS3(0xce, 0x01, 0x01, 0x02, 0x01, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfc, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfc, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x0808, 0x0804, 0x0800, 0x01fe, 0x01ff, 0x0200),
  },
  {	.freq			= 5140,
	RADIOREGS3(0xc6, 0x01, 0x01, 0x02, 0x02, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfb, 0x00, 0x08, 0x00, 0x77, 0x00, 0x0f,
		   0x00, 0x6f, 0x00, 0xfb, 0x00, 0x08, 0x00, 0x77,
		   0x00, 0x0f, 0x00, 0x6f, 0x00),
	PHYREGS(0x080c, 0x0808, 0x0804, 0x01fd, 0x01fe, 0x01ff),
  },
  {	.freq			= 5160,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x04, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x07, 0x00, 0x77, 0x00, 0x0e,
		   0x00, 0x6f, 0x00, 0xfa, 0x00, 0x07, 0x00, 0x77,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x0814, 0x0810, 0x080c, 0x01fb, 0x01fc, 0x01fd),
  },
  {	.freq			= 5170,
	RADIOREGS3(0xbe, 0x01, 0x01, 0x02, 0x05, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xfa, 0x00, 0x07, 0x00, 0x77, 0x00, 0x0e,
		   0x00, 0x6f, 0x00, 0xfa, 0x00, 0x07, 0x00, 0x77,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x0818, 0x0814, 0x0810, 0x01fa, 0x01fb, 0x01fc),
  },
  {	.freq			= 5180,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x06, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xf9, 0x00, 0x06, 0x00, 0x77, 0x00, 0x0e,
		   0x00, 0x6f, 0x00, 0xf9, 0x00, 0x06, 0x00, 0x77,
		   0x00, 0x0e, 0x00, 0x6f, 0x00),
	PHYREGS(0x081c, 0x0818, 0x0814, 0x01f9, 0x01fa, 0x01fb),
  },
  {	.freq			= 5190,
	RADIOREGS3(0xb6, 0x01, 0x01, 0x02, 0x07, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xf9, 0x00, 0x06, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xf9, 0x00, 0x06, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0820, 0x081c, 0x0818, 0x01f8, 0x01f9, 0x01fa),
  },
  {	.freq			= 5200,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x08, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xf9, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xf9, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0824, 0x0820, 0x081c, 0x01f7, 0x01f8, 0x01f9),
  },
  {	.freq			= 5210,
	RADIOREGS3(0xaf, 0x01, 0x01, 0x02, 0x09, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8f, 0x0f, 0x00,
		   0xff, 0xf9, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xf9, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0828, 0x0824, 0x0820, 0x01f6, 0x01f7, 0x01f8),
  },
  {	.freq			= 5220,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xfe, 0xd8, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xd8, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x082c, 0x0828, 0x0824, 0x01f5, 0x01f6, 0x01f7),
  },
  {	.freq			= 5230,
	RADIOREGS3(0xa7, 0x01, 0x01, 0x02, 0x0b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xee, 0xd8, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xd8, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0830, 0x082c, 0x0828, 0x01f4, 0x01f5, 0x01f6),
  },
  {	.freq			= 5240,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xee, 0xc8, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xc8, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0834, 0x0830, 0x082c, 0x01f3, 0x01f4, 0x01f5),
  },
  {	.freq			= 5250,
	RADIOREGS3(0xa0, 0x01, 0x01, 0x02, 0x0d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0f, 0x00,
		   0xed, 0xc7, 0x00, 0x05, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xc7, 0x00, 0x05, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x0838, 0x0834, 0x0830, 0x01f2, 0x01f3, 0x01f4),
  },
  {	.freq			= 5260,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x02, 0x02, 0x02, 0x8e, 0x0e, 0x00,
		   0xed, 0xc7, 0x00, 0x04, 0x00, 0x77, 0x00, 0x0d,
		   0x00, 0x6f, 0x00, 0xc7, 0x00, 0x04, 0x00, 0x77,
		   0x00, 0x0d, 0x00, 0x6f, 0x00),
	PHYREGS(0x083c, 0x0838, 0x0834, 0x01f1, 0x01f2, 0x01f3),
  },
  {	.freq			= 5270,
	RADIOREGS3(0x98, 0x01, 0x01, 0x02, 0x0f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8e, 0x0e, 0x00,
		   0xed, 0xc7, 0x00, 0x04, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xc7, 0x00, 0x04, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0840, 0x083c, 0x0838, 0x01f0, 0x01f1, 0x01f2),
  },
  {	.freq			= 5280,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x10, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0844, 0x0840, 0x083c, 0x01f0, 0x01f0, 0x01f1),
  },
  {	.freq			= 5290,
	RADIOREGS3(0x91, 0x01, 0x01, 0x02, 0x11, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0848, 0x0844, 0x0840, 0x01ef, 0x01f0, 0x01f0),
  },
  {	.freq			= 5300,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x12, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x084c, 0x0848, 0x0844, 0x01ee, 0x01ef, 0x01f0),
  },
  {	.freq			= 5310,
	RADIOREGS3(0x8a, 0x01, 0x01, 0x02, 0x13, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdc, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0850, 0x084c, 0x0848, 0x01ed, 0x01ee, 0x01ef),
  },
  {	.freq			= 5320,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x14, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0e, 0x00,
		   0xdb, 0xb7, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0c,
		   0x00, 0x6f, 0x00, 0xb7, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0c, 0x00, 0x6f, 0x00),
	PHYREGS(0x0854, 0x0850, 0x084c, 0x01ec, 0x01ed, 0x01ee),
  },
  {	.freq			= 5330,
	RADIOREGS3(0x83, 0x01, 0x01, 0x02, 0x15, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xcb, 0xa6, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0b,
		   0x00, 0x6f, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x0858, 0x0854, 0x0850, 0x01eb, 0x01ec, 0x01ed),
  },
  {	.freq			= 5340,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x16, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8d, 0x0d, 0x00,
		   0xca, 0xa6, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0b,
		   0x00, 0x6f, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x085c, 0x0858, 0x0854, 0x01ea, 0x01eb, 0x01ec),
  },
  {	.freq			= 5350,
	RADIOREGS3(0x7c, 0x01, 0x01, 0x02, 0x17, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xca, 0xa6, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0b,
		   0x00, 0x6f, 0x00, 0xa6, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0b, 0x00, 0x6f, 0x00),
	PHYREGS(0x0860, 0x085c, 0x0858, 0x01e9, 0x01ea, 0x01eb),
  },
  {	.freq			= 5360,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x18, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xc9, 0x95, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x95, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0864, 0x0860, 0x085c, 0x01e8, 0x01e9, 0x01ea),
  },
  {	.freq			= 5370,
	RADIOREGS3(0x75, 0x01, 0x01, 0x02, 0x19, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0d, 0x00,
		   0xc9, 0x95, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x95, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0868, 0x0864, 0x0860, 0x01e7, 0x01e8, 0x01e9),
  },
  {	.freq			= 5380,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x95, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x95, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x086c, 0x0868, 0x0864, 0x01e6, 0x01e7, 0x01e8),
  },
  {	.freq			= 5390,
	RADIOREGS3(0x6e, 0x01, 0x01, 0x02, 0x1b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x84, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0870, 0x086c, 0x0868, 0x01e5, 0x01e6, 0x01e7),
  },
  {	.freq			= 5400,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb8, 0x84, 0x00, 0x03, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x03, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0874, 0x0870, 0x086c, 0x01e5, 0x01e5, 0x01e6),
  },
  {	.freq			= 5410,
	RADIOREGS3(0x67, 0x01, 0x01, 0x02, 0x1d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xb7, 0x84, 0x00, 0x02, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x02, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0878, 0x0874, 0x0870, 0x01e4, 0x01e5, 0x01e5),
  },
  {	.freq			= 5420,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0c, 0x00,
		   0xa7, 0x84, 0x00, 0x02, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x02, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x087c, 0x0878, 0x0874, 0x01e3, 0x01e4, 0x01e5),
  },
  {	.freq			= 5430,
	RADIOREGS3(0x61, 0x01, 0x01, 0x02, 0x1f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x03, 0x03, 0x03, 0x8c, 0x0b, 0x00,
		   0xa6, 0x84, 0x00, 0x02, 0x00, 0x77, 0x00, 0x0a,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x02, 0x00, 0x77,
		   0x00, 0x0a, 0x00, 0x6f, 0x00),
	PHYREGS(0x0880, 0x087c, 0x0878, 0x01e2, 0x01e3, 0x01e4),
  },
  {	.freq			= 5440,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x20, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0xa6, 0x84, 0x00, 0x02, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x02, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0884, 0x0880, 0x087c, 0x01e1, 0x01e2, 0x01e3),
  },
  {	.freq			= 5450,
	RADIOREGS3(0x5a, 0x01, 0x01, 0x02, 0x21, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x95, 0x84, 0x00, 0x01, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x01, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0888, 0x0884, 0x0880, 0x01e0, 0x01e1, 0x01e2),
  },
  {	.freq			= 5460,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x22, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x95, 0x84, 0x00, 0x01, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x84, 0x00, 0x01, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x088c, 0x0888, 0x0884, 0x01df, 0x01e0, 0x01e1),
  },
  {	.freq			= 5470,
	RADIOREGS3(0x53, 0x01, 0x01, 0x02, 0x23, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8b, 0x0b, 0x00,
		   0x94, 0x73, 0x00, 0x01, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x01, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0890, 0x088c, 0x0888, 0x01de, 0x01df, 0x01e0),
  },
  {	.freq			= 5480,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x24, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x84, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0894, 0x0890, 0x088c, 0x01dd, 0x01de, 0x01df),
  },
  {	.freq			= 5490,
	RADIOREGS3(0x4d, 0x01, 0x01, 0x02, 0x25, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x83, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x0898, 0x0894, 0x0890, 0x01dd, 0x01dd, 0x01de),
  },
  {	.freq			= 5500,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x26, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x82, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x089c, 0x0898, 0x0894, 0x01dc, 0x01dd, 0x01dd),
  },
  {	.freq			= 5510,
	RADIOREGS3(0x47, 0x01, 0x01, 0x02, 0x27, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x82, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08a0, 0x089c, 0x0898, 0x01db, 0x01dc, 0x01dd),
  },
  {	.freq			= 5520,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x28, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x0a, 0x00,
		   0x72, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08a4, 0x08a0, 0x089c, 0x01da, 0x01db, 0x01dc),
  },
  {	.freq			= 5530,
	RADIOREGS3(0x40, 0x01, 0x01, 0x02, 0x29, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x09, 0x00,
		   0x72, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08a8, 0x08a4, 0x08a0, 0x01d9, 0x01da, 0x01db),
  },
  {	.freq			= 5540,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x8a, 0x09, 0x00,
		   0x71, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08ac, 0x08a8, 0x08a4, 0x01d8, 0x01d9, 0x01da),
  },
  {	.freq			= 5550,
	RADIOREGS3(0x3a, 0x01, 0x01, 0x02, 0x2b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08b0, 0x08ac, 0x08a8, 0x01d7, 0x01d8, 0x01d9),
  },
  {	.freq			= 5560,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08b4, 0x08b0, 0x08ac, 0x01d7, 0x01d7, 0x01d8),
  },
  {	.freq			= 5570,
	RADIOREGS3(0x34, 0x01, 0x01, 0x02, 0x2d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x09, 0x00,
		   0x61, 0x62, 0x00, 0x00, 0x00, 0x77, 0x00, 0x09,
		   0x00, 0x6f, 0x00, 0x62, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x09, 0x00, 0x6f, 0x00),
	PHYREGS(0x08b8, 0x08b4, 0x08b0, 0x01d6, 0x01d7, 0x01d7),
  },
  {	.freq			= 5580,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x08, 0x00,
		   0x60, 0x62, 0x00, 0x00, 0x00, 0x77, 0x00, 0x08,
		   0x00, 0x6f, 0x00, 0x62, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x08, 0x00, 0x6f, 0x00),
	PHYREGS(0x08bc, 0x08b8, 0x08b4, 0x01d5, 0x01d6, 0x01d7),
  },
  {	.freq			= 5590,
	RADIOREGS3(0x2e, 0x01, 0x01, 0x02, 0x2f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x04, 0x04, 0x04, 0x89, 0x08, 0x00,
		   0x50, 0x61, 0x00, 0x00, 0x00, 0x77, 0x00, 0x08,
		   0x00, 0x6f, 0x00, 0x61, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x08, 0x00, 0x6f, 0x00),
	PHYREGS(0x08c0, 0x08bc, 0x08b8, 0x01d4, 0x01d5, 0x01d6),
  },
  {	.freq			= 5600,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x30, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x77, 0x00, 0x08,
		   0x00, 0x6f, 0x00, 0x51, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x08, 0x00, 0x6f, 0x00),
	PHYREGS(0x08c4, 0x08c0, 0x08bc, 0x01d3, 0x01d4, 0x01d5),
  },
  {	.freq			= 5610,
	RADIOREGS3(0x28, 0x01, 0x01, 0x02, 0x31, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x51, 0x00, 0x00, 0x00, 0x77, 0x00, 0x08,
		   0x00, 0x6f, 0x00, 0x51, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x08, 0x00, 0x6f, 0x00),
	PHYREGS(0x08c8, 0x08c4, 0x08c0, 0x01d2, 0x01d3, 0x01d4),
  },
  {	.freq			= 5620,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x32, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x89, 0x08, 0x00,
		   0x50, 0x50, 0x00, 0x00, 0x00, 0x77, 0x00, 0x07,
		   0x00, 0x6f, 0x00, 0x50, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x07, 0x00, 0x6f, 0x00),
	PHYREGS(0x08cc, 0x08c8, 0x08c4, 0x01d2, 0x01d2, 0x01d3),
  },
  {	.freq			= 5630,
	RADIOREGS3(0x21, 0x01, 0x01, 0x02, 0x33, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x50, 0x50, 0x00, 0x00, 0x00, 0x77, 0x00, 0x07,
		   0x00, 0x6f, 0x00, 0x50, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x07, 0x00, 0x6f, 0x00),
	PHYREGS(0x08d0, 0x08cc, 0x08c8, 0x01d1, 0x01d2, 0x01d2),
  },
  {	.freq			= 5640,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x34, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x50, 0x00, 0x00, 0x00, 0x77, 0x00, 0x07,
		   0x00, 0x6f, 0x00, 0x50, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x07, 0x00, 0x6f, 0x00),
	PHYREGS(0x08d4, 0x08d0, 0x08cc, 0x01d0, 0x01d1, 0x01d2),
  },
  {	.freq			= 5650,
	RADIOREGS3(0x1c, 0x01, 0x01, 0x02, 0x35, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x77, 0x00, 0x07,
		   0x00, 0x6f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x07, 0x00, 0x6f, 0x00),
	PHYREGS(0x08d8, 0x08d4, 0x08d0, 0x01cf, 0x01d0, 0x01d1),
  },
  {	.freq			= 5660,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x36, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x40, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6f, 0x00, 0x40, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6f, 0x00),
	PHYREGS(0x08dc, 0x08d8, 0x08d4, 0x01ce, 0x01cf, 0x01d0),
  },
  {	.freq			= 5670,
	RADIOREGS3(0x16, 0x01, 0x01, 0x02, 0x37, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x88, 0x07, 0x00,
		   0x40, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6f, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6f, 0x00),
	PHYREGS(0x08e0, 0x08dc, 0x08d8, 0x01ce, 0x01ce, 0x01cf),
  },
  {	.freq			= 5680,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x38, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6f, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6f, 0x00),
	PHYREGS(0x08e4, 0x08e0, 0x08dc, 0x01cd, 0x01ce, 0x01ce),
  },
  {	.freq			= 5690,
	RADIOREGS3(0x10, 0x01, 0x01, 0x02, 0x39, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6f, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6f, 0x00),
	PHYREGS(0x08e8, 0x08e4, 0x08e0, 0x01cc, 0x01cd, 0x01ce),
  },
  {	.freq			= 5700,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08ec, 0x08e8, 0x08e4, 0x01cb, 0x01cc, 0x01cd),
  },
  {	.freq			= 5710,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08f0, 0x08ec, 0x08e8, 0x01ca, 0x01cb, 0x01cc),
  },
  {	.freq			= 5720,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08f4, 0x08f0, 0x08ec, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5725,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x79, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x06, 0x00,
		   0x30, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08f6, 0x08f2, 0x08ee, 0x01c9, 0x01ca, 0x01cb),
  },
  {	.freq			= 5730,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6e, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6e, 0x00),
	PHYREGS(0x08f8, 0x08f4, 0x08f0, 0x01c9, 0x01c9, 0x01ca),
  },
  {	.freq			= 5735,
	RADIOREGS3(0x03, 0x01, 0x02, 0x04, 0x7b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6d, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6d, 0x00),
	PHYREGS(0x08fa, 0x08f6, 0x08f2, 0x01c8, 0x01c9, 0x01ca),
  },
  {	.freq			= 5740,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6d, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6d, 0x00),
	PHYREGS(0x08fc, 0x08f8, 0x08f4, 0x01c8, 0x01c9, 0x01c9),
  },
  {	.freq			= 5745,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x30, 0x00, 0x00, 0x00, 0x77, 0x00, 0x06,
		   0x00, 0x6d, 0x00, 0x30, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x06, 0x00, 0x6d, 0x00),
	PHYREGS(0x08fe, 0x08fa, 0x08f6, 0x01c8, 0x01c8, 0x01c9),
  },
  {	.freq			= 5750,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x3f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x20, 0x20, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6d, 0x00, 0x20, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6d, 0x00),
	PHYREGS(0x0900, 0x08fc, 0x08f8, 0x01c7, 0x01c8, 0x01c9),
  },
  {	.freq			= 5755,
	RADIOREGS3(0xfe, 0x00, 0x02, 0x04, 0x7f, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x87, 0x05, 0x00,
		   0x10, 0x20, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6c, 0x00, 0x20, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6c, 0x00),
	PHYREGS(0x0902, 0x08fe, 0x08fa, 0x01c7, 0x01c8, 0x01c8),
  },
  {	.freq			= 5760,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x40, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x05, 0x00,
		   0x10, 0x20, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6c, 0x00, 0x20, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6c, 0x00),
	PHYREGS(0x0904, 0x0900, 0x08fc, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5765,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x81, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x86, 0x05, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6c, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6c, 0x00),
	PHYREGS(0x0906, 0x0902, 0x08fe, 0x01c6, 0x01c7, 0x01c8),
  },
  {	.freq			= 5770,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x41, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x0908, 0x0904, 0x0900, 0x01c6, 0x01c6, 0x01c7),
  },
  {	.freq			= 5775,
	RADIOREGS3(0xf8, 0x00, 0x02, 0x04, 0x83, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x090a, 0x0906, 0x0902, 0x01c5, 0x01c6, 0x01c7),
  },
  {	.freq			= 5780,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x42, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x05, 0x05, 0x05, 0x86, 0x04, 0x00,
		   0x10, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x090c, 0x0908, 0x0904, 0x01c5, 0x01c6, 0x01c6),
  },
  {	.freq			= 5785,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x85, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x090e, 0x090a, 0x0906, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5790,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x43, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x10, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x10, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x0910, 0x090c, 0x0908, 0x01c4, 0x01c5, 0x01c6),
  },
  {	.freq			= 5795,
	RADIOREGS3(0xf2, 0x00, 0x02, 0x04, 0x87, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x0912, 0x090e, 0x090a, 0x01c4, 0x01c4, 0x01c5),
  },
  {	.freq			= 5800,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x44, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6b, 0x00),
	PHYREGS(0x0914, 0x0910, 0x090c, 0x01c3, 0x01c4, 0x01c5),
  },
  {	.freq			= 5805,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x89, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6a, 0x00),
	PHYREGS(0x0916, 0x0912, 0x090e, 0x01c3, 0x01c4, 0x01c4),
  },
  {	.freq			= 5810,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x45, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6a, 0x00),
	PHYREGS(0x0918, 0x0914, 0x0910, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5815,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8b, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6a, 0x00),
	PHYREGS(0x091a, 0x0916, 0x0912, 0x01c2, 0x01c3, 0x01c4),
  },
  {	.freq			= 5820,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x46, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x6a, 0x00),
	PHYREGS(0x091c, 0x0918, 0x0914, 0x01c2, 0x01c2, 0x01c3),
  },
  {	.freq			= 5825,
	RADIOREGS3(0xed, 0x00, 0x02, 0x04, 0x8d, 0x07, 0x07, 0x04,
		   0x10, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x69, 0x00),
	PHYREGS(0x091e, 0x091a, 0x0916, 0x01c1, 0x01c2, 0x01c3),
  },
  {	.freq			= 5830,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x47, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x05,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x05, 0x00, 0x69, 0x00),
	PHYREGS(0x0920, 0x091c, 0x0918, 0x01c1, 0x01c2, 0x01c2),
  },
  {	.freq			= 5840,
	RADIOREGS3(0x0a, 0x01, 0x01, 0x02, 0x48, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x86, 0x04, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x69, 0x00),
	PHYREGS(0x0924, 0x0920, 0x091c, 0x01c0, 0x01c1, 0x01c2),
  },
  {	.freq			= 5850,
	RADIOREGS3(0xe0, 0x00, 0x01, 0x02, 0x49, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x69, 0x00),
	PHYREGS(0x0928, 0x0924, 0x0920, 0x01bf, 0x01c0, 0x01c1),
  },
  {	.freq			= 5860,
	RADIOREGS3(0xde, 0x00, 0x01, 0x02, 0x4a, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x69, 0x00),
	PHYREGS(0x092c, 0x0928, 0x0924, 0x01bf, 0x01bf, 0x01c0),
  },
  {	.freq			= 5870,
	RADIOREGS3(0xdb, 0x00, 0x01, 0x02, 0x4b, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0930, 0x092c, 0x0928, 0x01be, 0x01bf, 0x01bf),
  },
  {	.freq			= 5880,
	RADIOREGS3(0xd8, 0x00, 0x01, 0x02, 0x4c, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0934, 0x0930, 0x092c, 0x01bd, 0x01be, 0x01bf),
  },
  {	.freq			= 5890,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4d, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0938, 0x0934, 0x0930, 0x01bc, 0x01bd, 0x01be),
  },
  {	.freq			= 5900,
	RADIOREGS3(0xd3, 0x00, 0x01, 0x02, 0x4e, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x093c, 0x0938, 0x0934, 0x01bc, 0x01bc, 0x01bd),
  },
  {	.freq			= 5910,
	RADIOREGS3(0xd6, 0x00, 0x01, 0x02, 0x4f, 0x05, 0x05, 0x04,
		   0x0c, 0x01, 0x06, 0x06, 0x06, 0x85, 0x03, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x04,
		   0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77,
		   0x00, 0x04, 0x00, 0x68, 0x00),
	PHYREGS(0x0940, 0x093c, 0x0938, 0x01bb, 0x01bc, 0x01bc),
  },
  {	.freq			= 2412,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x6c, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x04, 0x04, 0x04, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x78, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0b, 0x00, 0x0a, 0x00, 0x89, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0b, 0x00, 0x0a),
	PHYREGS(0x03c9, 0x03c5, 0x03c1, 0x043a, 0x043f, 0x0443),
  },
  {	.freq			= 2417,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x71, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x78, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0b, 0x00, 0x0a, 0x00, 0x89, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0b, 0x00, 0x0a),
	PHYREGS(0x03cb, 0x03c7, 0x03c3, 0x0438, 0x043d, 0x0441),
  },
  {	.freq			= 2422,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x76, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x67, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0b, 0x00, 0x0a, 0x00, 0x89, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0b, 0x00, 0x0a),
	PHYREGS(0x03cd, 0x03c9, 0x03c5, 0x0436, 0x043a, 0x043f),
  },
  {	.freq			= 2427,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x7b, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x57, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x0a, 0x00, 0x78, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x0a),
	PHYREGS(0x03cf, 0x03cb, 0x03c7, 0x0434, 0x0438, 0x043d),
  },
  {	.freq			= 2432,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x80, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x56, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x0a, 0x00, 0x77, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x0a),
	PHYREGS(0x03d1, 0x03cd, 0x03c9, 0x0431, 0x0436, 0x043a),
  },
  {	.freq			= 2437,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x85, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x46, 0x00, 0x03, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x0a, 0x00, 0x76, 0x00, 0x03, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x0a),
	PHYREGS(0x03d3, 0x03cf, 0x03cb, 0x042f, 0x0434, 0x0438),
  },
  {	.freq			= 2442,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8a, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x05, 0x05, 0x05, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x45, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x0a, 0x00, 0x66, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x0a),
	PHYREGS(0x03d5, 0x03d1, 0x03cd, 0x042d, 0x0431, 0x0436),
  },
  {	.freq			= 2447,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x8f, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x34, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x09, 0x00, 0x55, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x09),
	PHYREGS(0x03d7, 0x03d3, 0x03cf, 0x042b, 0x042f, 0x0434),
  },
  {	.freq			= 2452,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x94, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x23, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x09, 0x00, 0x45, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x09),
	PHYREGS(0x03d9, 0x03d5, 0x03d1, 0x0429, 0x042d, 0x0431),
  },
  {	.freq			= 2457,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x99, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x12, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x0a, 0x00, 0x09, 0x00, 0x34, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x0a, 0x00, 0x09),
	PHYREGS(0x03db, 0x03d7, 0x03d3, 0x0427, 0x042b, 0x042f),
  },
  {	.freq			= 2462,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0x9e, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x09, 0x00, 0x09, 0x00, 0x33, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x09, 0x00, 0x09),
	PHYREGS(0x03dd, 0x03d9, 0x03d5, 0x0424, 0x0429, 0x042d),
  },
  {	.freq			= 2467,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa3, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x06, 0x06, 0x06, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x09, 0x00, 0x09, 0x00, 0x22, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x09, 0x00, 0x09),
	PHYREGS(0x03df, 0x03db, 0x03d7, 0x0422, 0x0427, 0x042b),
  },
  {	.freq			= 2472,
	RADIOREGS3(0x00, 0x01, 0x03, 0x09, 0xa8, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x30, 0x00,
		   0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x09, 0x00, 0x09, 0x00, 0x11, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x09, 0x00, 0x09),
	PHYREGS(0x03e1, 0x03dd, 0x03d9, 0x0420, 0x0424, 0x0429),
  },
  {	.freq			= 2484,
	RADIOREGS3(0xff, 0x01, 0x03, 0x09, 0xb4, 0x08, 0x08, 0x04,
		   0x16, 0x01, 0x07, 0x07, 0x07, 0x8f, 0x20, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x70, 0x00,
		   0x09, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00,
		   0x70, 0x00, 0x09, 0x00, 0x09),
	PHYREGS(0x03e6, 0x03e2, 0x03de, 0x041b, 0x041f, 0x0424),
  },
};

/* TODO: add support for rev4+ devices by searching in rev4+ tables */
const struct b43_nphy_channeltab_entry_rev3 *
b43_nphy_get_chantabent_rev3(struct b43_wldev *dev, u16 freq)
{
	const struct b43_nphy_channeltab_entry_rev3 *e;
	unsigned int i;

	for (i = 0; i < ARRAY_SIZE(b43_nphy_channeltab_rev3); i++) {
		e = &(b43_nphy_channeltab_rev3[i]);
		if (e->freq == freq)
			return e;
	}

	return NULL;
}
