/* bnx2.h: QLogic bnx2 network driver.
 *
 * Copyright (c) 2004-2014 Broadcom Corporation
 * Copyright (c) 2014-2015 QLogic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * Written by: Michael Chan  (mchan@broadcom.com)
 */


#ifndef BNX2_H
#define BNX2_H

/* Hardware data structures and register definitions automatically
 * generated from RTL code. Do not modify.
 */

/*
 *  tx_bd definition
 */
struct bnx2_tx_bd {
	u32 tx_bd_haddr_hi;
	u32 tx_bd_haddr_lo;
	u32 tx_bd_mss_nbytes;
		#define TX_BD_TCP6_OFF2_SHL		(14)
	u32 tx_bd_vlan_tag_flags;
		#define TX_BD_FLAGS_CONN_FAULT		(1<<0)
		#define TX_BD_FLAGS_TCP6_OFF0_MSK	(3<<1)
		#define TX_BD_FLAGS_TCP6_OFF0_SHL	(1)
		#define TX_BD_FLAGS_TCP_UDP_CKSUM	(1<<1)
		#define TX_BD_FLAGS_IP_CKSUM		(1<<2)
		#define TX_BD_FLAGS_VLAN_TAG		(1<<3)
		#define TX_BD_FLAGS_COAL_NOW		(1<<4)
		#define TX_BD_FLAGS_DONT_GEN_CRC	(1<<5)
		#define TX_BD_FLAGS_END			(1<<6)
		#define TX_BD_FLAGS_START		(1<<7)
		#define TX_BD_FLAGS_SW_OPTION_WORD	(0x1f<<8)
		#define TX_BD_FLAGS_TCP6_OFF4_SHL	(12)
		#define TX_BD_FLAGS_SW_FLAGS		(1<<13)
		#define TX_BD_FLAGS_SW_SNAP		(1<<14)
		#define TX_BD_FLAGS_SW_LSO		(1<<15)

};


/*
 *  rx_bd definition
 */
struct bnx2_rx_bd {
	u32 rx_bd_haddr_hi;
	u32 rx_bd_haddr_lo;
	u32 rx_bd_len;
	u32 rx_bd_flags;
		#define RX_BD_FLAGS_NOPUSH		(1<<0)
		#define RX_BD_FLAGS_DUMMY		(1<<1)
		#define RX_BD_FLAGS_END			(1<<2)
		#define RX_BD_FLAGS_START		(1<<3)

};

#define BNX2_RX_ALIGN			16

/*
 *  status_block definition
 */
struct status_block {
	u32 status_attn_bits;
		#define STATUS_ATTN_BITS_LINK_STATE		(1L<<0)
		#define STATUS_ATTN_BITS_TX_SCHEDULER_ABORT	(1L<<1)
		#define STATUS_ATTN_BITS_TX_BD_READ_ABORT	(1L<<2)
		#define STATUS_ATTN_BITS_TX_BD_CACHE_ABORT	(1L<<3)
		#define STATUS_ATTN_BITS_TX_PROCESSOR_ABORT	(1L<<4)
		#define STATUS_ATTN_BITS_TX_DMA_ABORT		(1L<<5)
		#define STATUS_ATTN_BITS_TX_PATCHUP_ABORT	(1L<<6)
		#define STATUS_ATTN_BITS_TX_ASSEMBLER_ABORT	(1L<<7)
		#define STATUS_ATTN_BITS_RX_PARSER_MAC_ABORT	(1L<<8)
		#define STATUS_ATTN_BITS_RX_PARSER_CATCHUP_ABORT	(1L<<9)
		#define STATUS_ATTN_BITS_RX_MBUF_ABORT		(1L<<10)
		#define STATUS_ATTN_BITS_RX_LOOKUP_ABORT	(1L<<11)
		#define STATUS_ATTN_BITS_RX_PROCESSOR_ABORT	(1L<<12)
		#define STATUS_ATTN_BITS_RX_V2P_ABORT		(1L<<13)
		#define STATUS_ATTN_BITS_RX_BD_CACHE_ABORT	(1L<<14)
		#define STATUS_ATTN_BITS_RX_DMA_ABORT		(1L<<15)
		#define STATUS_ATTN_BITS_COMPLETION_ABORT	(1L<<16)
		#define STATUS_ATTN_BITS_HOST_COALESCE_ABORT	(1L<<17)
		#define STATUS_ATTN_BITS_MAILBOX_QUEUE_ABORT	(1L<<18)
		#define STATUS_ATTN_BITS_CONTEXT_ABORT		(1L<<19)
		#define STATUS_ATTN_BITS_CMD_SCHEDULER_ABORT	(1L<<20)
		#define STATUS_ATTN_BITS_CMD_PROCESSOR_ABORT	(1L<<21)
		#define STATUS_ATTN_BITS_MGMT_PROCESSOR_ABORT	(1L<<22)
		#define STATUS_ATTN_BITS_MAC_ABORT		(1L<<23)
		#define STATUS_ATTN_BITS_TIMER_ABORT		(1L<<24)
		#define STATUS_ATTN_BITS_DMAE_ABORT		(1L<<25)
		#define STATUS_ATTN_BITS_FLSH_ABORT		(1L<<26)
		#define STATUS_ATTN_BITS_GRC_ABORT		(1L<<27)
		#define STATUS_ATTN_BITS_EPB_ERROR		(1L<<30)
		#define STATUS_ATTN_BITS_PARITY_ERROR		(1L<<31)

	u32 status_attn_bits_ack;
#if defined(__BIG_ENDIAN)
	u16 status_tx_quick_consumer_index0;
	u16 status_tx_quick_consumer_index1;
	u16 status_tx_quick_consumer_index2;
	u16 status_tx_quick_consumer_index3;
	u16 status_rx_quick_consumer_index0;
	u16 status_rx_quick_consumer_index1;
	u16 status_rx_quick_consumer_index2;
	u16 status_rx_quick_consumer_index3;
	u16 status_rx_quick_consumer_index4;
	u16 status_rx_quick_consumer_index5;
	u16 status_rx_quick_consumer_index6;
	u16 status_rx_quick_consumer_index7;
	u16 status_rx_quick_consumer_index8;
	u16 status_rx_quick_consumer_index9;
	u16 status_rx_quick_consumer_index10;
	u16 status_rx_quick_consumer_index11;
	u16 status_rx_quick_consumer_index12;
	u16 status_rx_quick_consumer_index13;
	u16 status_rx_quick_consumer_index14;
	u16 status_rx_quick_consumer_index15;
	u16 status_completion_producer_index;
	u16 status_cmd_consumer_index;
	u16 status_idx;
	u8 status_unused;
	u8 status_blk_num;
#elif defined(__LITTLE_ENDIAN)
	u16 status_tx_quick_consumer_index1;
	u16 status_tx_quick_consumer_index0;
	u16 status_tx_quick_consumer_index3;
	u16 status_tx_quick_consumer_index2;
	u16 status_rx_quick_consumer_index1;
	u16 status_rx_quick_consumer_index0;
	u16 status_rx_quick_consumer_index3;
	u16 status_rx_quick_consumer_index2;
	u16 status_rx_quick_consumer_index5;
	u16 status_rx_quick_consumer_index4;
	u16 status_rx_quick_consumer_index7;
	u16 status_rx_quick_consumer_index6;
	u16 status_rx_quick_consumer_index9;
	u16 status_rx_quick_consumer_index8;
	u16 status_rx_quick_consumer_index11;
	u16 status_rx_quick_consumer_index10;
	u16 status_rx_quick_consumer_index13;
	u16 status_rx_quick_consumer_index12;
	u16 status_rx_quick_consumer_index15;
	u16 status_rx_quick_consumer_index14;
	u16 status_cmd_consumer_index;
	u16 status_completion_producer_index;
	u8 status_blk_num;
	u8 status_unused;
	u16 status_idx;
#endif
};

/*
 *  status_block definition
 */
struct status_block_msix {
#if defined(__BIG_ENDIAN)
	u16 status_tx_quick_consumer_index;
	u16 status_rx_quick_consumer_index;
	u16 status_completion_producer_index;
	u16 status_cmd_consumer_index;
	u32 status_unused;
	u16 status_idx;
	u8 status_unused2;
	u8 status_blk_num;
#elif defined(__LITTLE_ENDIAN)
	u16 status_rx_quick_consumer_index;
	u16 status_tx_quick_consumer_index;
	u16 status_cmd_consumer_index;
	u16 status_completion_producer_index;
	u32 status_unused;
	u8 status_blk_num;
	u8 status_unused2;
	u16 status_idx;
#endif
};

#define BNX2_SBLK_MSIX_ALIGN_SIZE	128


/*
 *  statistics_block definition
 */
struct statistics_block {
	u32 stat_IfHCInOctets_hi;
	u32 stat_IfHCInOctets_lo;
	u32 stat_IfHCInBadOctets_hi;
	u32 stat_IfHCInBadOctets_lo;
	u32 stat_IfHCOutOctets_hi;
	u32 stat_IfHCOutOctets_lo;
	u32 stat_IfHCOutBadOctets_hi;
	u32 stat_IfHCOutBadOctets_lo;
	u32 stat_IfHCInUcastPkts_hi;
	u32 stat_IfHCInUcastPkts_lo;
	u32 stat_IfHCInMulticastPkts_hi;
	u32 stat_IfHCInMulticastPkts_lo;
	u32 stat_IfHCInBroadcastPkts_hi;
	u32 stat_IfHCInBroadcastPkts_lo;
	u32 stat_IfHCOutUcastPkts_hi;
	u32 stat_IfHCOutUcastPkts_lo;
	u32 stat_IfHCOutMulticastPkts_hi;
	u32 stat_IfHCOutMulticastPkts_lo;
	u32 stat_IfHCOutBroadcastPkts_hi;
	u32 stat_IfHCOutBroadcastPkts_lo;
	u32 stat_emac_tx_stat_dot3statsinternalmactransmiterrors;
	u32 stat_Dot3StatsCarrierSenseErrors;
	u32 stat_Dot3StatsFCSErrors;
	u32 stat_Dot3StatsAlignmentErrors;
	u32 stat_Dot3StatsSingleCollisionFrames;
	u32 stat_Dot3StatsMultipleCollisionFrames;
	u32 stat_Dot3StatsDeferredTransmissions;
	u32 stat_Dot3StatsExcessiveCollisions;
	u32 stat_Dot3StatsLateCollisions;
	u32 stat_EtherStatsCollisions;
	u32 stat_EtherStatsFragments;
	u32 stat_EtherStatsJabbers;
	u32 stat_EtherStatsUndersizePkts;
	u32 stat_EtherStatsOverrsizePkts;
	u32 stat_EtherStatsPktsRx64Octets;
	u32 stat_EtherStatsPktsRx65Octetsto127Octets;
	u32 stat_EtherStatsPktsRx128Octetsto255Octets;
	u32 stat_EtherStatsPktsRx256Octetsto511Octets;
	u32 stat_EtherStatsPktsRx512Octetsto1023Octets;
	u32 stat_EtherStatsPktsRx1024Octetsto1522Octets;
	u32 stat_EtherStatsPktsRx1523Octetsto9022Octets;
	u32 stat_EtherStatsPktsTx64Octets;
	u32 stat_EtherStatsPktsTx65Octetsto127Octets;
	u32 stat_EtherStatsPktsTx128Octetsto255Octets;
	u32 stat_EtherStatsPktsTx256Octetsto511Octets;
	u32 stat_EtherStatsPktsTx512Octetsto1023Octets;
	u32 stat_EtherStatsPktsTx1024Octetsto1522Octets;
	u32 stat_EtherStatsPktsTx1523Octetsto9022Octets;
	u32 stat_XonPauseFramesReceived;
	u32 stat_XoffPauseFramesReceived;
	u32 stat_OutXonSent;
	u32 stat_OutXoffSent;
	u32 stat_FlowControlDone;
	u32 stat_MacControlFramesReceived;
	u32 stat_XoffStateEntered;
	u32 stat_IfInFramesL2FilterDiscards;
	u32 stat_IfInRuleCheckerDiscards;
	u32 stat_IfInFTQDiscards;
	u32 stat_IfInMBUFDiscards;
	u32 stat_IfInRuleCheckerP4Hit;
	u32 stat_CatchupInRuleCheckerDiscards;
	u32 stat_CatchupInFTQDiscards;
	u32 stat_CatchupInMBUFDiscards;
	u32 stat_CatchupInRuleCheckerP4Hit;
	u32 stat_GenStat00;
	u32 stat_GenStat01;
	u32 stat_GenStat02;
	u32 stat_GenStat03;
	u32 stat_GenStat04;
	u32 stat_GenStat05;
	u32 stat_GenStat06;
	u32 stat_GenStat07;
	u32 stat_GenStat08;
	u32 stat_GenStat09;
	u32 stat_GenStat10;
	u32 stat_GenStat11;
	u32 stat_GenStat12;
	u32 stat_GenStat13;
	u32 stat_GenStat14;
	u32 stat_GenStat15;
	u32 stat_FwRxDrop;
};


/*
 *  l2_fhdr definition
 */
struct l2_fhdr {
	u32 l2_fhdr_status;
		#define L2_FHDR_STATUS_RULE_CLASS	(0x7<<0)
		#define L2_FHDR_STATUS_RULE_P2		(1<<3)
		#define L2_FHDR_STATUS_RULE_P3		(1<<4)
		#define L2_FHDR_STATUS_RULE_P4		(1<<5)
		#define L2_FHDR_STATUS_L2_VLAN_TAG	(1<<6)
		#define L2_FHDR_STATUS_L2_LLC_SNAP	(1<<7)
		#define L2_FHDR_STATUS_RSS_HASH		(1<<8)
		#define L2_FHDR_STATUS_IP_DATAGRAM	(1<<13)
		#define L2_FHDR_STATUS_TCP_SEGMENT	(1<<14)
		#define L2_FHDR_STATUS_UDP_DATAGRAM	(1<<15)

		#define L2_FHDR_STATUS_SPLIT		(1<<16)
		#define L2_FHDR_ERRORS_BAD_CRC		(1<<17)
		#define L2_FHDR_ERRORS_PHY_DECODE	(1<<18)
		#define L2_FHDR_ERRORS_ALIGNMENT	(1<<19)
		#define L2_FHDR_ERRORS_TOO_SHORT	(1<<20)
		#define L2_FHDR_ERRORS_GIANT_FRAME	(1<<21)
		#define L2_FHDR_ERRORS_TCP_XSUM		(1<<28)
		#define L2_FHDR_ERRORS_UDP_XSUM		(1<<31)

		#define L2_FHDR_STATUS_USE_RXHASH	\
			(L2_FHDR_STATUS_TCP_SEGMENT | L2_FHDR_STATUS_RSS_HASH)

	u32 l2_fhdr_hash;
#if defined(__BIG_ENDIAN)
	u16 l2_fhdr_pkt_len;
	u16 l2_fhdr_vlan_tag;
	u16 l2_fhdr_ip_xsum;
	u16 l2_fhdr_tcp_udp_xsum;
#elif defined(__LITTLE_ENDIAN)
	u16 l2_fhdr_vlan_tag;
	u16 l2_fhdr_pkt_len;
	u16 l2_fhdr_tcp_udp_xsum;
	u16 l2_fhdr_ip_xsum;
#endif
};

#define BNX2_RX_OFFSET		(sizeof(struct l2_fhdr) + 2)

/*
 *  l2_context definition
 */
#define BNX2_L2CTX_TYPE					0x00000000
#define BNX2_L2CTX_TYPE_SIZE_L2				 ((0xc0/0x20)<<16)
#define BNX2_L2CTX_TYPE_TYPE				 (0xf<<28)
#define BNX2_L2CTX_TYPE_TYPE_EMPTY			 (0<<28)
#define BNX2_L2CTX_TYPE_TYPE_L2				 (1<<28)

#define BNX2_L2CTX_TX_HOST_BIDX				0x00000088
#define BNX2_L2CTX_EST_NBD				0x00000088
#define BNX2_L2CTX_CMD_TYPE				0x00000088
#define BNX2_L2CTX_CMD_TYPE_TYPE			 (0xf<<24)
#define BNX2_L2CTX_CMD_TYPE_TYPE_L2			 (0<<24)
#define BNX2_L2CTX_CMD_TYPE_TYPE_TCP			 (1<<24)

#define BNX2_L2CTX_TX_HOST_BSEQ				0x00000090
#define BNX2_L2CTX_TSCH_BSEQ				0x00000094
#define BNX2_L2CTX_TBDR_BSEQ				0x00000098
#define BNX2_L2CTX_TBDR_BOFF				0x0000009c
#define BNX2_L2CTX_TBDR_BIDX				0x0000009c
#define BNX2_L2CTX_TBDR_BHADDR_HI			0x000000a0
#define BNX2_L2CTX_TBDR_BHADDR_LO			0x000000a4
#define BNX2_L2CTX_TXP_BOFF				0x000000a8
#define BNX2_L2CTX_TXP_BIDX				0x000000a8
#define BNX2_L2CTX_TXP_BSEQ				0x000000ac

#define BNX2_L2CTX_TYPE_XI				0x00000080
#define BNX2_L2CTX_CMD_TYPE_XI				0x00000240
#define BNX2_L2CTX_TBDR_BHADDR_HI_XI			0x00000258
#define BNX2_L2CTX_TBDR_BHADDR_LO_XI			0x0000025c

/*
 *  l2_bd_chain_context definition
 */
#define BNX2_L2CTX_BD_PRE_READ				0x00000000
#define BNX2_L2CTX_CTX_SIZE				0x00000000
#define BNX2_L2CTX_CTX_TYPE				0x00000000
#define BNX2_L2CTX_FLOW_CTRL_ENABLE			 0x000000ff
#define BNX2_L2CTX_CTX_TYPE_SIZE_L2			 ((0x20/20)<<16)
#define BNX2_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE		 (0xf<<28)
#define BNX2_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE_UNDEFINED	 (0<<28)
#define BNX2_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE_VALUE	 (1<<28)

#define BNX2_L2CTX_HOST_BDIDX				0x00000004
#define BNX2_L2CTX_L5_STATUSB_NUM_SHIFT			 16
#define BNX2_L2CTX_L2_STATUSB_NUM_SHIFT			 24
#define BNX2_L2CTX_L5_STATUSB_NUM(sb_id)		\
	(((sb_id) > 0) ? (((sb_id) + 7) << BNX2_L2CTX_L5_STATUSB_NUM_SHIFT) : 0)
#define BNX2_L2CTX_L2_STATUSB_NUM(sb_id)		\
	(((sb_id) > 0) ? (((sb_id) + 7) << BNX2_L2CTX_L2_STATUSB_NUM_SHIFT) : 0)
#define BNX2_L2CTX_HOST_BSEQ				0x00000008
#define BNX2_L2CTX_NX_BSEQ				0x0000000c
#define BNX2_L2CTX_NX_BDHADDR_HI			0x00000010
#define BNX2_L2CTX_NX_BDHADDR_LO			0x00000014
#define BNX2_L2CTX_NX_BDIDX				0x00000018

#define BNX2_L2CTX_HOST_PG_BDIDX			0x00000044
#define BNX2_L2CTX_PG_BUF_SIZE				0x00000048
#define BNX2_L2CTX_RBDC_KEY				0x0000004c
#define BNX2_L2CTX_RBDC_JUMBO_KEY			 0x3ffe
#define BNX2_L2CTX_NX_PG_BDHADDR_HI			0x00000050
#define BNX2_L2CTX_NX_PG_BDHADDR_LO			0x00000054

/*
 *  pci_config_l definition
 *  offset: 0000
 */
#define BNX2_PCICFG_MSI_CONTROL				0x00000058
#define BNX2_PCICFG_MSI_CONTROL_ENABLE			 (1L<<16)

#define BNX2_PCICFG_MISC_CONFIG				0x00000068
#define BNX2_PCICFG_MISC_CONFIG_TARGET_BYTE_SWAP	 (1L<<2)
#define BNX2_PCICFG_MISC_CONFIG_TARGET_MB_WORD_SWAP	 (1L<<3)
#define BNX2_PCICFG_MISC_CONFIG_RESERVED1		 (1L<<4)
#define BNX2_PCICFG_MISC_CONFIG_CLOCK_CTL_ENA		 (1L<<5)
#define BNX2_PCICFG_MISC_CONFIG_TARGET_GRC_WORD_SWAP	 (1L<<6)
#define BNX2_PCICFG_MISC_CONFIG_REG_WINDOW_ENA		 (1L<<7)
#define BNX2_PCICFG_MISC_CONFIG_CORE_RST_REQ		 (1L<<8)
#define BNX2_PCICFG_MISC_CONFIG_CORE_RST_BSY		 (1L<<9)
#define BNX2_PCICFG_MISC_CONFIG_GRC_WIN1_SWAP_EN	 (1L<<10)
#define BNX2_PCICFG_MISC_CONFIG_GRC_WIN2_SWAP_EN	 (1L<<11)
#define BNX2_PCICFG_MISC_CONFIG_GRC_WIN3_SWAP_EN	 (1L<<12)
#define BNX2_PCICFG_MISC_CONFIG_ASIC_METAL_REV		 (0xffL<<16)
#define BNX2_PCICFG_MISC_CONFIG_ASIC_BASE_REV		 (0xfL<<24)
#define BNX2_PCICFG_MISC_CONFIG_ASIC_ID			 (0xfL<<28)

#define BNX2_PCICFG_MISC_STATUS				0x0000006c
#define BNX2_PCICFG_MISC_STATUS_INTA_VALUE		 (1L<<0)
#define BNX2_PCICFG_MISC_STATUS_32BIT_DET		 (1L<<1)
#define BNX2_PCICFG_MISC_STATUS_M66EN			 (1L<<2)
#define BNX2_PCICFG_MISC_STATUS_PCIX_DET		 (1L<<3)
#define BNX2_PCICFG_MISC_STATUS_PCIX_SPEED		 (0x3L<<4)
#define BNX2_PCICFG_MISC_STATUS_PCIX_SPEED_66		 (0L<<4)
#define BNX2_PCICFG_MISC_STATUS_PCIX_SPEED_100		 (1L<<4)
#define BNX2_PCICFG_MISC_STATUS_PCIX_SPEED_133		 (2L<<4)
#define BNX2_PCICFG_MISC_STATUS_PCIX_SPEED_PCI_MODE	 (3L<<4)
#define BNX2_PCICFG_MISC_STATUS_BAD_MEM_WRITE_BE	 (1L<<8)

#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS		0x00000070
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET	 (0xfL<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_32MHZ	 (0L<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_38MHZ	 (1L<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_48MHZ	 (2L<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_55MHZ	 (3L<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_66MHZ	 (4L<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_80MHZ	 (5L<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_95MHZ	 (6L<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_133MHZ	 (7L<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_LOW	 (0xfL<<0)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_DISABLE	 (1L<<6)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT	 (1L<<7)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC	 (0x7L<<8)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_UNDEF	 (0L<<8)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_12	 (1L<<8)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_6	 (2L<<8)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_62	 (4L<<8)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_MIN_POWER	 (1L<<11)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED	 (0xfL<<12)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_100	 (0L<<12)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_80	 (1L<<12)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_50	 (2L<<12)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_40	 (4L<<12)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_25	 (8L<<12)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_STOP	 (1L<<16)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_RESERVED_17	 (1L<<17)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_RESERVED_18	 (1L<<18)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_RESERVED_19	 (1L<<19)
#define BNX2_PCICFG_PCI_CLOCK_CONTROL_BITS_RESERVED	 (0xfffL<<20)

#define BNX2_PCICFG_REG_WINDOW_ADDRESS			0x00000078
#define BNX2_PCICFG_REG_WINDOW_ADDRESS_VAL		 (0xfffffL<<2)

#define BNX2_PCICFG_REG_WINDOW				0x00000080
#define BNX2_PCICFG_INT_ACK_CMD				0x00000084
#define BNX2_PCICFG_INT_ACK_CMD_INDEX			 (0xffffL<<0)
#define BNX2_PCICFG_INT_ACK_CMD_INDEX_VALID		 (1L<<16)
#define BNX2_PCICFG_INT_ACK_CMD_USE_INT_HC_PARAM	 (1L<<17)
#define BNX2_PCICFG_INT_ACK_CMD_MASK_INT		 (1L<<18)
#define BNX2_PCICFG_INT_ACK_CMD_INTERRUPT_NUM		 (0xfL<<24)
#define BNX2_PCICFG_INT_ACK_CMD_INT_NUM_SHIFT		 24

#define BNX2_PCICFG_STATUS_BIT_SET_CMD			0x00000088
#define BNX2_PCICFG_STATUS_BIT_CLEAR_CMD		0x0000008c
#define BNX2_PCICFG_MAILBOX_QUEUE_ADDR			0x00000090
#define BNX2_PCICFG_MAILBOX_QUEUE_DATA			0x00000094

#define BNX2_PCICFG_DEVICE_CONTROL			0x000000b4
#define BNX2_PCICFG_DEVICE_STATUS_NO_PEND		 ((1L<<5)<<16)

/*
 *  pci_reg definition
 *  offset: 0x400
 */
#define BNX2_PCI_GRC_WINDOW_ADDR			0x00000400
#define BNX2_PCI_GRC_WINDOW_ADDR_VALUE			 (0x1ffL<<13)
#define BNX2_PCI_GRC_WINDOW_ADDR_SEP_WIN		 (1L<<31)

#define BNX2_PCI_GRC_WINDOW2_BASE		 	 0xc000
#define BNX2_PCI_GRC_WINDOW3_BASE		 	 0xe000

#define BNX2_PCI_CONFIG_1				0x00000404
#define BNX2_PCI_CONFIG_1_RESERVED0			 (0xffL<<0)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY			 (0x7L<<8)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY_OFF		 (0L<<8)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY_16		 (1L<<8)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY_32		 (2L<<8)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY_64		 (3L<<8)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY_128		 (4L<<8)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY_256		 (5L<<8)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY_512		 (6L<<8)
#define BNX2_PCI_CONFIG_1_READ_BOUNDARY_1024		 (7L<<8)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY		 (0x7L<<11)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY_OFF		 (0L<<11)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY_16		 (1L<<11)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY_32		 (2L<<11)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY_64		 (3L<<11)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY_128		 (4L<<11)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY_256		 (5L<<11)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY_512		 (6L<<11)
#define BNX2_PCI_CONFIG_1_WRITE_BOUNDARY_1024		 (7L<<11)
#define BNX2_PCI_CONFIG_1_RESERVED1			 (0x3ffffL<<14)

#define BNX2_PCI_CONFIG_2				0x00000408
#define BNX2_PCI_CONFIG_2_BAR1_SIZE			 (0xfL<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_DISABLED		 (0L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_64K			 (1L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_128K		 (2L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_256K		 (3L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_512K		 (4L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_1M			 (5L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_2M			 (6L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_4M			 (7L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_8M			 (8L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_16M			 (9L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_32M			 (10L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_64M			 (11L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_128M		 (12L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_256M		 (13L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_512M		 (14L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_SIZE_1G			 (15L<<0)
#define BNX2_PCI_CONFIG_2_BAR1_64ENA			 (1L<<4)
#define BNX2_PCI_CONFIG_2_EXP_ROM_RETRY			 (1L<<5)
#define BNX2_PCI_CONFIG_2_CFG_CYCLE_RETRY		 (1L<<6)
#define BNX2_PCI_CONFIG_2_FIRST_CFG_DONE		 (1L<<7)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE			 (0xffL<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_DISABLED		 (0L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_1K		 (1L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_2K		 (2L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_4K		 (3L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_8K		 (4L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_16K		 (5L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_32K		 (6L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_64K		 (7L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_128K		 (8L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_256K		 (9L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_512K		 (10L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_1M		 (11L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_2M		 (12L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_4M		 (13L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_8M		 (14L<<8)
#define BNX2_PCI_CONFIG_2_EXP_ROM_SIZE_16M		 (15L<<8)
#define BNX2_PCI_CONFIG_2_MAX_SPLIT_LIMIT		 (0x1fL<<16)
#define BNX2_PCI_CONFIG_2_MAX_READ_LIMIT		 (0x3L<<21)
#define BNX2_PCI_CONFIG_2_MAX_READ_LIMIT_512		 (0L<<21)
#define BNX2_PCI_CONFIG_2_MAX_READ_LIMIT_1K		 (1L<<21)
#define BNX2_PCI_CONFIG_2_MAX_READ_LIMIT_2K		 (2L<<21)
#define BNX2_PCI_CONFIG_2_MAX_READ_LIMIT_4K		 (3L<<21)
#define BNX2_PCI_CONFIG_2_FORCE_32_BIT_MSTR		 (1L<<23)
#define BNX2_PCI_CONFIG_2_FORCE_32_BIT_TGT		 (1L<<24)
#define BNX2_PCI_CONFIG_2_KEEP_REQ_ASSERT		 (1L<<25)
#define BNX2_PCI_CONFIG_2_RESERVED0			 (0x3fL<<26)
#define BNX2_PCI_CONFIG_2_BAR_PREFETCH_XI		 (1L<<16)
#define BNX2_PCI_CONFIG_2_RESERVED0_XI			 (0x7fffL<<17)

#define BNX2_PCI_CONFIG_3				0x0000040c
#define BNX2_PCI_CONFIG_3_STICKY_BYTE			 (0xffL<<0)
#define BNX2_PCI_CONFIG_3_REG_STICKY_BYTE		 (0xffL<<8)
#define BNX2_PCI_CONFIG_3_FORCE_PME			 (1L<<24)
#define BNX2_PCI_CONFIG_3_PME_STATUS			 (1L<<25)
#define BNX2_PCI_CONFIG_3_PME_ENABLE			 (1L<<26)
#define BNX2_PCI_CONFIG_3_PM_STATE			 (0x3L<<27)
#define BNX2_PCI_CONFIG_3_VAUX_PRESET			 (1L<<30)
#define BNX2_PCI_CONFIG_3_PCI_POWER			 (1L<<31)

#define BNX2_PCI_PM_DATA_A				0x00000410
#define BNX2_PCI_PM_DATA_A_PM_DATA_0_PRG		 (0xffL<<0)
#define BNX2_PCI_PM_DATA_A_PM_DATA_1_PRG		 (0xffL<<8)
#define BNX2_PCI_PM_DATA_A_PM_DATA_2_PRG		 (0xffL<<16)
#define BNX2_PCI_PM_DATA_A_PM_DATA_3_PRG		 (0xffL<<24)

#define BNX2_PCI_PM_DATA_B				0x00000414
#define BNX2_PCI_PM_DATA_B_PM_DATA_4_PRG		 (0xffL<<0)
#define BNX2_PCI_PM_DATA_B_PM_DATA_5_PRG		 (0xffL<<8)
#define BNX2_PCI_PM_DATA_B_PM_DATA_6_PRG		 (0xffL<<16)
#define BNX2_PCI_PM_DATA_B_PM_DATA_7_PRG		 (0xffL<<24)

#define BNX2_PCI_SWAP_DIAG0				0x00000418
#define BNX2_PCI_SWAP_DIAG1				0x0000041c
#define BNX2_PCI_EXP_ROM_ADDR				0x00000420
#define BNX2_PCI_EXP_ROM_ADDR_ADDRESS			 (0x3fffffL<<2)
#define BNX2_PCI_EXP_ROM_ADDR_REQ			 (1L<<31)

#define BNX2_PCI_EXP_ROM_DATA				0x00000424
#define BNX2_PCI_VPD_INTF				0x00000428
#define BNX2_PCI_VPD_INTF_INTF_REQ			 (1L<<0)

#define BNX2_PCI_VPD_ADDR_FLAG				0x0000042c
#define BNX2_PCI_VPD_ADDR_FLAG_MSK			0x0000ffff
#define BNX2_PCI_VPD_ADDR_FLAG_SL			0L
#define BNX2_PCI_VPD_ADDR_FLAG_ADDRESS			 (0x1fffL<<2)
#define BNX2_PCI_VPD_ADDR_FLAG_WR			 (1L<<15)

#define BNX2_PCI_VPD_DATA				0x00000430
#define BNX2_PCI_ID_VAL1				0x00000434
#define BNX2_PCI_ID_VAL1_DEVICE_ID			 (0xffffL<<0)
#define BNX2_PCI_ID_VAL1_VENDOR_ID			 (0xffffL<<16)

#define BNX2_PCI_ID_VAL2				0x00000438
#define BNX2_PCI_ID_VAL2_SUBSYSTEM_VENDOR_ID		 (0xffffL<<0)
#define BNX2_PCI_ID_VAL2_SUBSYSTEM_ID			 (0xffffL<<16)

#define BNX2_PCI_ID_VAL3				0x0000043c
#define BNX2_PCI_ID_VAL3_CLASS_CODE			 (0xffffffL<<0)
#define BNX2_PCI_ID_VAL3_REVISION_ID			 (0xffL<<24)

#define BNX2_PCI_ID_VAL4				0x00000440
#define BNX2_PCI_ID_VAL4_CAP_ENA			 (0xfL<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_0			 (0L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_1			 (1L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_2			 (2L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_3			 (3L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_4			 (4L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_5			 (5L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_6			 (6L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_7			 (7L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_8			 (8L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_9			 (9L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_10			 (10L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_11			 (11L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_12			 (12L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_13			 (13L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_14			 (14L<<0)
#define BNX2_PCI_ID_VAL4_CAP_ENA_15			 (15L<<0)
#define BNX2_PCI_ID_VAL4_RESERVED0			 (0x3L<<4)
#define BNX2_PCI_ID_VAL4_PM_SCALE_PRG			 (0x3L<<6)
#define BNX2_PCI_ID_VAL4_PM_SCALE_PRG_0			 (0L<<6)
#define BNX2_PCI_ID_VAL4_PM_SCALE_PRG_1			 (1L<<6)
#define BNX2_PCI_ID_VAL4_PM_SCALE_PRG_2			 (2L<<6)
#define BNX2_PCI_ID_VAL4_PM_SCALE_PRG_3			 (3L<<6)
#define BNX2_PCI_ID_VAL4_MSI_PV_MASK_CAP		 (1L<<8)
#define BNX2_PCI_ID_VAL4_MSI_LIMIT			 (0x7L<<9)
#define BNX2_PCI_ID_VAL4_MULTI_MSG_CAP			 (0x7L<<12)
#define BNX2_PCI_ID_VAL4_MSI_ENABLE			 (1L<<15)
#define BNX2_PCI_ID_VAL4_MAX_64_ADVERTIZE		 (1L<<16)
#define BNX2_PCI_ID_VAL4_MAX_133_ADVERTIZE		 (1L<<17)
#define BNX2_PCI_ID_VAL4_RESERVED2			 (0x7L<<18)
#define BNX2_PCI_ID_VAL4_MAX_CUMULATIVE_SIZE_B21	 (0x3L<<21)
#define BNX2_PCI_ID_VAL4_MAX_SPLIT_SIZE_B21		 (0x3L<<23)
#define BNX2_PCI_ID_VAL4_MAX_CUMULATIVE_SIZE_B0		 (1L<<25)
#define BNX2_PCI_ID_VAL4_MAX_MEM_READ_SIZE_B10		 (0x3L<<26)
#define BNX2_PCI_ID_VAL4_MAX_SPLIT_SIZE_B0		 (1L<<28)
#define BNX2_PCI_ID_VAL4_RESERVED3			 (0x7L<<29)
#define BNX2_PCI_ID_VAL4_RESERVED3_XI			 (0xffffL<<16)

#define BNX2_PCI_ID_VAL5				0x00000444
#define BNX2_PCI_ID_VAL5_D1_SUPPORT			 (1L<<0)
#define BNX2_PCI_ID_VAL5_D2_SUPPORT			 (1L<<1)
#define BNX2_PCI_ID_VAL5_PME_IN_D0			 (1L<<2)
#define BNX2_PCI_ID_VAL5_PME_IN_D1			 (1L<<3)
#define BNX2_PCI_ID_VAL5_PME_IN_D2			 (1L<<4)
#define BNX2_PCI_ID_VAL5_PME_IN_D3_HOT			 (1L<<5)
#define BNX2_PCI_ID_VAL5_RESERVED0_TE			 (0x3ffffffL<<6)
#define BNX2_PCI_ID_VAL5_PM_VERSION_XI			 (0x7L<<6)
#define BNX2_PCI_ID_VAL5_NO_SOFT_RESET_XI		 (1L<<9)
#define BNX2_PCI_ID_VAL5_RESERVED0_XI			 (0x3fffffL<<10)

#define BNX2_PCI_PCIX_EXTENDED_STATUS			0x00000448
#define BNX2_PCI_PCIX_EXTENDED_STATUS_NO_SNOOP		 (1L<<8)
#define BNX2_PCI_PCIX_EXTENDED_STATUS_LONG_BURST	 (1L<<9)
#define BNX2_PCI_PCIX_EXTENDED_STATUS_SPLIT_COMP_MSG_CLASS	 (0xfL<<16)
#define BNX2_PCI_PCIX_EXTENDED_STATUS_SPLIT_COMP_MSG_IDX	 (0xffL<<24)

#define BNX2_PCI_ID_VAL6				0x0000044c
#define BNX2_PCI_ID_VAL6_MAX_LAT			 (0xffL<<0)
#define BNX2_PCI_ID_VAL6_MIN_GNT			 (0xffL<<8)
#define BNX2_PCI_ID_VAL6_BIST				 (0xffL<<16)
#define BNX2_PCI_ID_VAL6_RESERVED0			 (0xffL<<24)

#define BNX2_PCI_MSI_DATA				0x00000450
#define BNX2_PCI_MSI_DATA_MSI_DATA			 (0xffffL<<0)

#define BNX2_PCI_MSI_ADDR_H				0x00000454
#define BNX2_PCI_MSI_ADDR_L				0x00000458
#define BNX2_PCI_MSI_ADDR_L_VAL				 (0x3fffffffL<<2)

#define BNX2_PCI_CFG_ACCESS_CMD				0x0000045c
#define BNX2_PCI_CFG_ACCESS_CMD_ADR			 (0x3fL<<2)
#define BNX2_PCI_CFG_ACCESS_CMD_RD_REQ			 (1L<<27)
#define BNX2_PCI_CFG_ACCESS_CMD_WR_REQ			 (0xfL<<28)

#define BNX2_PCI_CFG_ACCESS_DATA			0x00000460
#define BNX2_PCI_MSI_MASK				0x00000464
#define BNX2_PCI_MSI_MASK_MSI_MASK			 (0xffffffffL<<0)

#define BNX2_PCI_MSI_PEND				0x00000468
#define BNX2_PCI_MSI_PEND_MSI_PEND			 (0xffffffffL<<0)

#define BNX2_PCI_PM_DATA_C				0x0000046c
#define BNX2_PCI_PM_DATA_C_PM_DATA_8_PRG		 (0xffL<<0)
#define BNX2_PCI_PM_DATA_C_RESERVED0			 (0xffffffL<<8)

#define BNX2_PCI_MSIX_CONTROL				0x000004c0
#define BNX2_PCI_MSIX_CONTROL_MSIX_TBL_SIZ		 (0x7ffL<<0)
#define BNX2_PCI_MSIX_CONTROL_RESERVED0			 (0x1fffffL<<11)

#define BNX2_PCI_MSIX_TBL_OFF_BIR			0x000004c4
#define BNX2_PCI_MSIX_TBL_OFF_BIR_MSIX_TBL_BIR		 (0x7L<<0)
#define BNX2_PCI_MSIX_TBL_OFF_BIR_MSIX_TBL_OFF		 (0x1fffffffL<<3)

#define BNX2_PCI_MSIX_PBA_OFF_BIT			0x000004c8
#define BNX2_PCI_MSIX_PBA_OFF_BIT_MSIX_PBA_BIR		 (0x7L<<0)
#define BNX2_PCI_MSIX_PBA_OFF_BIT_MSIX_PBA_OFF		 (0x1fffffffL<<3)

#define BNX2_PCI_PCIE_CAPABILITY			0x000004d0
#define BNX2_PCI_PCIE_CAPABILITY_INTERRUPT_MSG_NUM	 (0x1fL<<0)
#define BNX2_PCI_PCIE_CAPABILITY_COMPLY_PCIE_1_1	 (1L<<5)

#define BNX2_PCI_DEVICE_CAPABILITY			0x000004d4
#define BNX2_PCI_DEVICE_CAPABILITY_MAX_PL_SIZ_SUPPORTED	 (0x7L<<0)
#define BNX2_PCI_DEVICE_CAPABILITY_EXTENDED_TAG_SUPPORT	 (1L<<5)
#define BNX2_PCI_DEVICE_CAPABILITY_L0S_ACCEPTABLE_LATENCY	 (0x7L<<6)
#define BNX2_PCI_DEVICE_CAPABILITY_L1_ACCEPTABLE_LATENCY	 (0x7L<<9)
#define BNX2_PCI_DEVICE_CAPABILITY_ROLE_BASED_ERR_RPT	 (1L<<15)

#define BNX2_PCI_LINK_CAPABILITY			0x000004dc
#define BNX2_PCI_LINK_CAPABILITY_MAX_LINK_SPEED		 (0xfL<<0)
#define BNX2_PCI_LINK_CAPABILITY_MAX_LINK_SPEED_0001	 (1L<<0)
#define BNX2_PCI_LINK_CAPABILITY_MAX_LINK_SPEED_0010	 (1L<<0)
#define BNX2_PCI_LINK_CAPABILITY_MAX_LINK_WIDTH		 (0x1fL<<4)
#define BNX2_PCI_LINK_CAPABILITY_CLK_POWER_MGMT		 (1L<<9)
#define BNX2_PCI_LINK_CAPABILITY_ASPM_SUPPORT		 (0x3L<<10)
#define BNX2_PCI_LINK_CAPABILITY_L0S_EXIT_LAT		 (0x7L<<12)
#define BNX2_PCI_LINK_CAPABILITY_L0S_EXIT_LAT_101	 (5L<<12)
#define BNX2_PCI_LINK_CAPABILITY_L0S_EXIT_LAT_110	 (6L<<12)
#define BNX2_PCI_LINK_CAPABILITY_L1_EXIT_LAT		 (0x7L<<15)
#define BNX2_PCI_LINK_CAPABILITY_L1_EXIT_LAT_001	 (1L<<15)
#define BNX2_PCI_LINK_CAPABILITY_L1_EXIT_LAT_010	 (2L<<15)
#define BNX2_PCI_LINK_CAPABILITY_L0S_EXIT_COMM_LAT	 (0x7L<<18)
#define BNX2_PCI_LINK_CAPABILITY_L0S_EXIT_COMM_LAT_101	 (5L<<18)
#define BNX2_PCI_LINK_CAPABILITY_L0S_EXIT_COMM_LAT_110	 (6L<<18)
#define BNX2_PCI_LINK_CAPABILITY_L1_EXIT_COMM_LAT	 (0x7L<<21)
#define BNX2_PCI_LINK_CAPABILITY_L1_EXIT_COMM_LAT_001	 (1L<<21)
#define BNX2_PCI_LINK_CAPABILITY_L1_EXIT_COMM_LAT_010	 (2L<<21)
#define BNX2_PCI_LINK_CAPABILITY_PORT_NUM		 (0xffL<<24)

#define BNX2_PCI_PCIE_DEVICE_CAPABILITY_2		0x000004e4
#define BNX2_PCI_PCIE_DEVICE_CAPABILITY_2_CMPL_TO_RANGE_SUPP	 (0xfL<<0)
#define BNX2_PCI_PCIE_DEVICE_CAPABILITY_2_CMPL_TO_DISABL_SUPP	 (1L<<4)
#define BNX2_PCI_PCIE_DEVICE_CAPABILITY_2_RESERVED	 (0x7ffffffL<<5)

#define BNX2_PCI_PCIE_LINK_CAPABILITY_2			0x000004e8
#define BNX2_PCI_PCIE_LINK_CAPABILITY_2_RESERVED	 (0xffffffffL<<0)

#define BNX2_PCI_GRC_WINDOW1_ADDR			0x00000610
#define BNX2_PCI_GRC_WINDOW1_ADDR_VALUE			 (0x1ffL<<13)

#define BNX2_PCI_GRC_WINDOW2_ADDR			0x00000614
#define BNX2_PCI_GRC_WINDOW2_ADDR_VALUE			 (0x1ffL<<13)

#define BNX2_PCI_GRC_WINDOW3_ADDR			0x00000618
#define BNX2_PCI_GRC_WINDOW3_ADDR_VALUE			 (0x1ffL<<13)

#define BNX2_MSIX_TABLE_ADDR				 0x318000
#define BNX2_MSIX_PBA_ADDR				 0x31c000

/*
 *  misc_reg definition
 *  offset: 0x800
 */
#define BNX2_MISC_COMMAND				0x00000800
#define BNX2_MISC_COMMAND_ENABLE_ALL			 (1L<<0)
#define BNX2_MISC_COMMAND_DISABLE_ALL			 (1L<<1)
#define BNX2_MISC_COMMAND_SW_RESET			 (1L<<4)
#define BNX2_MISC_COMMAND_POR_RESET			 (1L<<5)
#define BNX2_MISC_COMMAND_HD_RESET			 (1L<<6)
#define BNX2_MISC_COMMAND_CMN_SW_RESET			 (1L<<7)
#define BNX2_MISC_COMMAND_PAR_ERROR			 (1L<<8)
#define BNX2_MISC_COMMAND_CS16_ERR			 (1L<<9)
#define BNX2_MISC_COMMAND_CS16_ERR_LOC			 (0xfL<<12)
#define BNX2_MISC_COMMAND_PAR_ERR_RAM			 (0x7fL<<16)
#define BNX2_MISC_COMMAND_POWERDOWN_EVENT		 (1L<<23)
#define BNX2_MISC_COMMAND_SW_SHUTDOWN			 (1L<<24)
#define BNX2_MISC_COMMAND_SHUTDOWN_EN			 (1L<<25)
#define BNX2_MISC_COMMAND_DINTEG_ATTN_EN		 (1L<<26)
#define BNX2_MISC_COMMAND_PCIE_LINK_IN_L23		 (1L<<27)
#define BNX2_MISC_COMMAND_PCIE_DIS			 (1L<<28)

#define BNX2_MISC_CFG					0x00000804
#define BNX2_MISC_CFG_GRC_TMOUT				 (1L<<0)
#define BNX2_MISC_CFG_NVM_WR_EN				 (0x3L<<1)
#define BNX2_MISC_CFG_NVM_WR_EN_PROTECT			 (0L<<1)
#define BNX2_MISC_CFG_NVM_WR_EN_PCI			 (1L<<1)
#define BNX2_MISC_CFG_NVM_WR_EN_ALLOW			 (2L<<1)
#define BNX2_MISC_CFG_NVM_WR_EN_ALLOW2			 (3L<<1)
#define BNX2_MISC_CFG_BIST_EN				 (1L<<3)
#define BNX2_MISC_CFG_CK25_OUT_ALT_SRC			 (1L<<4)
#define BNX2_MISC_CFG_RESERVED5_TE			 (1L<<5)
#define BNX2_MISC_CFG_RESERVED6_TE			 (1L<<6)
#define BNX2_MISC_CFG_CLK_CTL_OVERRIDE			 (1L<<7)
#define BNX2_MISC_CFG_LEDMODE				 (0x7L<<8)
#define BNX2_MISC_CFG_LEDMODE_MAC			 (0L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY1_TE			 (1L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY2_TE			 (2L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY3_TE			 (3L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY4_TE			 (4L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY5_TE			 (5L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY6_TE			 (6L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY7_TE			 (7L<<8)
#define BNX2_MISC_CFG_MCP_GRC_TMOUT_TE			 (1L<<11)
#define BNX2_MISC_CFG_DBU_GRC_TMOUT_TE			 (1L<<12)
#define BNX2_MISC_CFG_LEDMODE_XI			 (0xfL<<8)
#define BNX2_MISC_CFG_LEDMODE_MAC_XI			 (0L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY1_XI			 (1L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY2_XI			 (2L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY3_XI			 (3L<<8)
#define BNX2_MISC_CFG_LEDMODE_MAC2_XI			 (4L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY4_XI			 (5L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY5_XI			 (6L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY6_XI			 (7L<<8)
#define BNX2_MISC_CFG_LEDMODE_MAC3_XI			 (8L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY7_XI			 (9L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY8_XI			 (10L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY9_XI			 (11L<<8)
#define BNX2_MISC_CFG_LEDMODE_MAC4_XI			 (12L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY10_XI			 (13L<<8)
#define BNX2_MISC_CFG_LEDMODE_PHY11_XI			 (14L<<8)
#define BNX2_MISC_CFG_LEDMODE_UNUSED_XI			 (15L<<8)
#define BNX2_MISC_CFG_PORT_SELECT_XI			 (1L<<13)
#define BNX2_MISC_CFG_PARITY_MODE_XI			 (1L<<14)

#define BNX2_MISC_ID					0x00000808
#define BNX2_MISC_ID_BOND_ID				 (0xfL<<0)
#define BNX2_MISC_ID_BOND_ID_X				 (0L<<0)
#define BNX2_MISC_ID_BOND_ID_C				 (3L<<0)
#define BNX2_MISC_ID_BOND_ID_S				 (12L<<0)
#define BNX2_MISC_ID_CHIP_METAL				 (0xffL<<4)
#define BNX2_MISC_ID_CHIP_REV				 (0xfL<<12)
#define BNX2_MISC_ID_CHIP_NUM				 (0xffffL<<16)

#define BNX2_MISC_ENABLE_STATUS_BITS			0x0000080c
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_SCHEDULER_ENABLE	 (1L<<0)
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_BD_READ_ENABLE	 (1L<<1)
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_BD_CACHE_ENABLE	 (1L<<2)
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_PROCESSOR_ENABLE	 (1L<<3)
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_DMA_ENABLE	 (1L<<4)
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_PATCHUP_ENABLE	 (1L<<5)
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_PAYLOAD_Q_ENABLE	 (1L<<6)
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_HEADER_Q_ENABLE	 (1L<<7)
#define BNX2_MISC_ENABLE_STATUS_BITS_TX_ASSEMBLER_ENABLE	 (1L<<8)
#define BNX2_MISC_ENABLE_STATUS_BITS_EMAC_ENABLE	 (1L<<9)
#define BNX2_MISC_ENABLE_STATUS_BITS_RX_PARSER_MAC_ENABLE	 (1L<<10)
#define BNX2_MISC_ENABLE_STATUS_BITS_RX_PARSER_CATCHUP_ENABLE	 (1L<<11)
#define BNX2_MISC_ENABLE_STATUS_BITS_RX_MBUF_ENABLE	 (1L<<12)
#define BNX2_MISC_ENABLE_STATUS_BITS_RX_LOOKUP_ENABLE	 (1L<<13)
#define BNX2_MISC_ENABLE_STATUS_BITS_RX_PROCESSOR_ENABLE	 (1L<<14)
#define BNX2_MISC_ENABLE_STATUS_BITS_RX_V2P_ENABLE	 (1L<<15)
#define BNX2_MISC_ENABLE_STATUS_BITS_RX_BD_CACHE_ENABLE	 (1L<<16)
#define BNX2_MISC_ENABLE_STATUS_BITS_RX_DMA_ENABLE	 (1L<<17)
#define BNX2_MISC_ENABLE_STATUS_BITS_COMPLETION_ENABLE	 (1L<<18)
#define BNX2_MISC_ENABLE_STATUS_BITS_HOST_COALESCE_ENABLE	 (1L<<19)
#define BNX2_MISC_ENABLE_STATUS_BITS_MAILBOX_QUEUE_ENABLE	 (1L<<20)
#define BNX2_MISC_ENABLE_STATUS_BITS_CONTEXT_ENABLE	 (1L<<21)
#define BNX2_MISC_ENABLE_STATUS_BITS_CMD_SCHEDULER_ENABLE	 (1L<<22)
#define BNX2_MISC_ENABLE_STATUS_BITS_CMD_PROCESSOR_ENABLE	 (1L<<23)
#define BNX2_MISC_ENABLE_STATUS_BITS_MGMT_PROCESSOR_ENABLE	 (1L<<24)
#define BNX2_MISC_ENABLE_STATUS_BITS_TIMER_ENABLE	 (1L<<25)
#define BNX2_MISC_ENABLE_STATUS_BITS_DMA_ENGINE_ENABLE	 (1L<<26)
#define BNX2_MISC_ENABLE_STATUS_BITS_UMP_ENABLE		 (1L<<27)
#define BNX2_MISC_ENABLE_STATUS_BITS_RV2P_CMD_SCHEDULER_ENABLE	 (1L<<28)
#define BNX2_MISC_ENABLE_STATUS_BITS_RSVD_FUTURE_ENABLE	 (0x7L<<29)

#define BNX2_MISC_ENABLE_SET_BITS			0x00000810
#define BNX2_MISC_ENABLE_SET_BITS_TX_SCHEDULER_ENABLE	 (1L<<0)
#define BNX2_MISC_ENABLE_SET_BITS_TX_BD_READ_ENABLE	 (1L<<1)
#define BNX2_MISC_ENABLE_SET_BITS_TX_BD_CACHE_ENABLE	 (1L<<2)
#define BNX2_MISC_ENABLE_SET_BITS_TX_PROCESSOR_ENABLE	 (1L<<3)
#define BNX2_MISC_ENABLE_SET_BITS_TX_DMA_ENABLE		 (1L<<4)
#define BNX2_MISC_ENABLE_SET_BITS_TX_PATCHUP_ENABLE	 (1L<<5)
#define BNX2_MISC_ENABLE_SET_BITS_TX_PAYLOAD_Q_ENABLE	 (1L<<6)
#define BNX2_MISC_ENABLE_SET_BITS_TX_HEADER_Q_ENABLE	 (1L<<7)
#define BNX2_MISC_ENABLE_SET_BITS_TX_ASSEMBLER_ENABLE	 (1L<<8)
#define BNX2_MISC_ENABLE_SET_BITS_EMAC_ENABLE		 (1L<<9)
#define BNX2_MISC_ENABLE_SET_BITS_RX_PARSER_MAC_ENABLE	 (1L<<10)
#define BNX2_MISC_ENABLE_SET_BITS_RX_PARSER_CATCHUP_ENABLE	 (1L<<11)
#define BNX2_MISC_ENABLE_SET_BITS_RX_MBUF_ENABLE	 (1L<<12)
#define BNX2_MISC_ENABLE_SET_BITS_RX_LOOKUP_ENABLE	 (1L<<13)
#define BNX2_MISC_ENABLE_SET_BITS_RX_PROCESSOR_ENABLE	 (1L<<14)
#define BNX2_MISC_ENABLE_SET_BITS_RX_V2P_ENABLE		 (1L<<15)
#define BNX2_MISC_ENABLE_SET_BITS_RX_BD_CACHE_ENABLE	 (1L<<16)
#define BNX2_MISC_ENABLE_SET_BITS_RX_DMA_ENABLE		 (1L<<17)
#define BNX2_MISC_ENABLE_SET_BITS_COMPLETION_ENABLE	 (1L<<18)
#define BNX2_MISC_ENABLE_SET_BITS_HOST_COALESCE_ENABLE	 (1L<<19)
#define BNX2_MISC_ENABLE_SET_BITS_MAILBOX_QUEUE_ENABLE	 (1L<<20)
#define BNX2_MISC_ENABLE_SET_BITS_CONTEXT_ENABLE	 (1L<<21)
#define BNX2_MISC_ENABLE_SET_BITS_CMD_SCHEDULER_ENABLE	 (1L<<22)
#define BNX2_MISC_ENABLE_SET_BITS_CMD_PROCESSOR_ENABLE	 (1L<<23)
#define BNX2_MISC_ENABLE_SET_BITS_MGMT_PROCESSOR_ENABLE	 (1L<<24)
#define BNX2_MISC_ENABLE_SET_BITS_TIMER_ENABLE		 (1L<<25)
#define BNX2_MISC_ENABLE_SET_BITS_DMA_ENGINE_ENABLE	 (1L<<26)
#define BNX2_MISC_ENABLE_SET_BITS_UMP_ENABLE		 (1L<<27)
#define BNX2_MISC_ENABLE_SET_BITS_RV2P_CMD_SCHEDULER_ENABLE	 (1L<<28)
#define BNX2_MISC_ENABLE_SET_BITS_RSVD_FUTURE_ENABLE	 (0x7L<<29)

#define BNX2_MISC_ENABLE_CLR_BITS			0x00000814
#define BNX2_MISC_ENABLE_CLR_BITS_TX_SCHEDULER_ENABLE	 (1L<<0)
#define BNX2_MISC_ENABLE_CLR_BITS_TX_BD_READ_ENABLE	 (1L<<1)
#define BNX2_MISC_ENABLE_CLR_BITS_TX_BD_CACHE_ENABLE	 (1L<<2)
#define BNX2_MISC_ENABLE_CLR_BITS_TX_PROCESSOR_ENABLE	 (1L<<3)
#define BNX2_MISC_ENABLE_CLR_BITS_TX_DMA_ENABLE		 (1L<<4)
#define BNX2_MISC_ENABLE_CLR_BITS_TX_PATCHUP_ENABLE	 (1L<<5)
#define BNX2_MISC_ENABLE_CLR_BITS_TX_PAYLOAD_Q_ENABLE	 (1L<<6)
#define BNX2_MISC_ENABLE_CLR_BITS_TX_HEADER_Q_ENABLE	 (1L<<7)
#define BNX2_MISC_ENABLE_CLR_BITS_TX_ASSEMBLER_ENABLE	 (1L<<8)
#define BNX2_MISC_ENABLE_CLR_BITS_EMAC_ENABLE		 (1L<<9)
#define BNX2_MISC_ENABLE_CLR_BITS_RX_PARSER_MAC_ENABLE	 (1L<<10)
#define BNX2_MISC_ENABLE_CLR_BITS_RX_PARSER_CATCHUP_ENABLE	 (1L<<11)
#define BNX2_MISC_ENABLE_CLR_BITS_RX_MBUF_ENABLE	 (1L<<12)
#define BNX2_MISC_ENABLE_CLR_BITS_RX_LOOKUP_ENABLE	 (1L<<13)
#define BNX2_MISC_ENABLE_CLR_BITS_RX_PROCESSOR_ENABLE	 (1L<<14)
#define BNX2_MISC_ENABLE_CLR_BITS_RX_V2P_ENABLE		 (1L<<15)
#define BNX2_MISC_ENABLE_CLR_BITS_RX_BD_CACHE_ENABLE	 (1L<<16)
#define BNX2_MISC_ENABLE_CLR_BITS_RX_DMA_ENABLE		 (1L<<17)
#define BNX2_MISC_ENABLE_CLR_BITS_COMPLETION_ENABLE	 (1L<<18)
#define BNX2_MISC_ENABLE_CLR_BITS_HOST_COALESCE_ENABLE	 (1L<<19)
#define BNX2_MISC_ENABLE_CLR_BITS_MAILBOX_QUEUE_ENABLE	 (1L<<20)
#define BNX2_MISC_ENABLE_CLR_BITS_CONTEXT_ENABLE	 (1L<<21)
#define BNX2_MISC_ENABLE_CLR_BITS_CMD_SCHEDULER_ENABLE	 (1L<<22)
#define BNX2_MISC_ENABLE_CLR_BITS_CMD_PROCESSOR_ENABLE	 (1L<<23)
#define BNX2_MISC_ENABLE_CLR_BITS_MGMT_PROCESSOR_ENABLE	 (1L<<24)
#define BNX2_MISC_ENABLE_CLR_BITS_TIMER_ENABLE		 (1L<<25)
#define BNX2_MISC_ENABLE_CLR_BITS_DMA_ENGINE_ENABLE	 (1L<<26)
#define BNX2_MISC_ENABLE_CLR_BITS_UMP_ENABLE		 (1L<<27)
#define BNX2_MISC_ENABLE_CLR_BITS_RV2P_CMD_SCHEDULER_ENABLE	 (1L<<28)
#define BNX2_MISC_ENABLE_CLR_BITS_RSVD_FUTURE_ENABLE	 (0x7L<<29)

#define BNX2_MISC_CLOCK_CONTROL_BITS			0x00000818
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET	 (0xfL<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_32MHZ	 (0L<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_38MHZ	 (1L<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_48MHZ	 (2L<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_55MHZ	 (3L<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_66MHZ	 (4L<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_80MHZ	 (5L<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_95MHZ	 (6L<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_133MHZ	 (7L<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_LOW	 (0xfL<<0)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_DISABLE	 (1L<<6)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT	 (1L<<7)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC	 (0x7L<<8)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_UNDEF	 (0L<<8)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_12	 (1L<<8)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_6	 (2L<<8)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_62	 (4L<<8)
#define BNX2_MISC_CLOCK_CONTROL_BITS_RESERVED0_XI	 (0x7L<<8)
#define BNX2_MISC_CLOCK_CONTROL_BITS_MIN_POWER		 (1L<<11)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED	 (0xfL<<12)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_100	 (0L<<12)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_80	 (1L<<12)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_50	 (2L<<12)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_40	 (4L<<12)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_25	 (8L<<12)
#define BNX2_MISC_CLOCK_CONTROL_BITS_RESERVED1_XI	 (0xfL<<12)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_STOP	 (1L<<16)
#define BNX2_MISC_CLOCK_CONTROL_BITS_RESERVED_17_TE	 (1L<<17)
#define BNX2_MISC_CLOCK_CONTROL_BITS_RESERVED_18_TE	 (1L<<18)
#define BNX2_MISC_CLOCK_CONTROL_BITS_RESERVED_19_TE	 (1L<<19)
#define BNX2_MISC_CLOCK_CONTROL_BITS_RESERVED_TE	 (0xfffL<<20)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_MGMT_XI	 (1L<<17)
#define BNX2_MISC_CLOCK_CONTROL_BITS_RESERVED2_XI	 (0x3fL<<18)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_VCO_XI	 (0x7L<<24)
#define BNX2_MISC_CLOCK_CONTROL_BITS_RESERVED3_XI	 (1L<<27)
#define BNX2_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_XI	 (0xfL<<28)

#define BNX2_MISC_SPIO					0x0000081c
#define BNX2_MISC_SPIO_VALUE				 (0xffL<<0)
#define BNX2_MISC_SPIO_SET				 (0xffL<<8)
#define BNX2_MISC_SPIO_CLR				 (0xffL<<16)
#define BNX2_MISC_SPIO_FLOAT				 (0xffL<<24)

#define BNX2_MISC_SPIO_INT				0x00000820
#define BNX2_MISC_SPIO_INT_INT_STATE_TE			 (0xfL<<0)
#define BNX2_MISC_SPIO_INT_OLD_VALUE_TE			 (0xfL<<8)
#define BNX2_MISC_SPIO_INT_OLD_SET_TE			 (0xfL<<16)
#define BNX2_MISC_SPIO_INT_OLD_CLR_TE			 (0xfL<<24)
#define BNX2_MISC_SPIO_INT_INT_STATE_XI			 (0xffL<<0)
#define BNX2_MISC_SPIO_INT_OLD_VALUE_XI			 (0xffL<<8)
#define BNX2_MISC_SPIO_INT_OLD_SET_XI			 (0xffL<<16)
#define BNX2_MISC_SPIO_INT_OLD_CLR_XI			 (0xffL<<24)

#define BNX2_MISC_CONFIG_LFSR				0x00000824
#define BNX2_MISC_CONFIG_LFSR_DIV			 (0xffffL<<0)

#define BNX2_MISC_LFSR_MASK_BITS			0x00000828
#define BNX2_MISC_LFSR_MASK_BITS_TX_SCHEDULER_ENABLE	 (1L<<0)
#define BNX2_MISC_LFSR_MASK_BITS_TX_BD_READ_ENABLE	 (1L<<1)
#define BNX2_MISC_LFSR_MASK_BITS_TX_BD_CACHE_ENABLE	 (1L<<2)
#define BNX2_MISC_LFSR_MASK_BITS_TX_PROCESSOR_ENABLE	 (1L<<3)
#define BNX2_MISC_LFSR_MASK_BITS_TX_DMA_ENABLE		 (1L<<4)
#define BNX2_MISC_LFSR_MASK_BITS_TX_PATCHUP_ENABLE	 (1L<<5)
#define BNX2_MISC_LFSR_MASK_BITS_TX_PAYLOAD_Q_ENABLE	 (1L<<6)
#define BNX2_MISC_LFSR_MASK_BITS_TX_HEADER_Q_ENABLE	 (1L<<7)
#define BNX2_MISC_LFSR_MASK_BITS_TX_ASSEMBLER_ENABLE	 (1L<<8)
#define BNX2_MISC_LFSR_MASK_BITS_EMAC_ENABLE		 (1L<<9)
#define BNX2_MISC_LFSR_MASK_BITS_RX_PARSER_MAC_ENABLE	 (1L<<10)
#define BNX2_MISC_LFSR_MASK_BITS_RX_PARSER_CATCHUP_ENABLE	 (1L<<11)
#define BNX2_MISC_LFSR_MASK_BITS_RX_MBUF_ENABLE		 (1L<<12)
#define BNX2_MISC_LFSR_MASK_BITS_RX_LOOKUP_ENABLE	 (1L<<13)
#define BNX2_MISC_LFSR_MASK_BITS_RX_PROCESSOR_ENABLE	 (1L<<14)
#define BNX2_MISC_LFSR_MASK_BITS_RX_V2P_ENABLE		 (1L<<15)
#define BNX2_MISC_LFSR_MASK_BITS_RX_BD_CACHE_ENABLE	 (1L<<16)
#define BNX2_MISC_LFSR_MASK_BITS_RX_DMA_ENABLE		 (1L<<17)
#define BNX2_MISC_LFSR_MASK_BITS_COMPLETION_ENABLE	 (1L<<18)
#define BNX2_MISC_LFSR_MASK_BITS_HOST_COALESCE_ENABLE	 (1L<<19)
#define BNX2_MISC_LFSR_MASK_BITS_MAILBOX_QUEUE_ENABLE	 (1L<<20)
#define BNX2_MISC_LFSR_MASK_BITS_CONTEXT_ENABLE		 (1L<<21)
#define BNX2_MISC_LFSR_MASK_BITS_CMD_SCHEDULER_ENABLE	 (1L<<22)
#define BNX2_MISC_LFSR_MASK_BITS_CMD_PROCESSOR_ENABLE	 (1L<<23)
#define BNX2_MISC_LFSR_MASK_BITS_MGMT_PROCESSOR_ENABLE	 (1L<<24)
#define BNX2_MISC_LFSR_MASK_BITS_TIMER_ENABLE		 (1L<<25)
#define BNX2_MISC_LFSR_MASK_BITS_DMA_ENGINE_ENABLE	 (1L<<26)
#define BNX2_MISC_LFSR_MASK_BITS_UMP_ENABLE		 (1L<<27)
#define BNX2_MISC_LFSR_MASK_BITS_RV2P_CMD_SCHEDULER_ENABLE	 (1L<<28)
#define BNX2_MISC_LFSR_MASK_BITS_RSVD_FUTURE_ENABLE	 (0x7L<<29)

#define BNX2_MISC_ARB_REQ0				0x0000082c
#define BNX2_MISC_ARB_REQ1				0x00000830
#define BNX2_MISC_ARB_REQ2				0x00000834
#define BNX2_MISC_ARB_REQ3				0x00000838
#define BNX2_MISC_ARB_REQ4				0x0000083c
#define BNX2_MISC_ARB_FREE0				0x00000840
#define BNX2_MISC_ARB_FREE1				0x00000844
#define BNX2_MISC_ARB_FREE2				0x00000848
#define BNX2_MISC_ARB_FREE3				0x0000084c
#define BNX2_MISC_ARB_FREE4				0x00000850
#define BNX2_MISC_ARB_REQ_STATUS0			0x00000854
#define BNX2_MISC_ARB_REQ_STATUS1			0x00000858
#define BNX2_MISC_ARB_REQ_STATUS2			0x0000085c
#define BNX2_MISC_ARB_REQ_STATUS3			0x00000860
#define BNX2_MISC_ARB_REQ_STATUS4			0x00000864
#define BNX2_MISC_ARB_GNT0				0x00000868
#define BNX2_MISC_ARB_GNT0_0				 (0x7L<<0)
#define BNX2_MISC_ARB_GNT0_1				 (0x7L<<4)
#define BNX2_MISC_ARB_GNT0_2				 (0x7L<<8)
#define BNX2_MISC_ARB_GNT0_3				 (0x7L<<12)
#define BNX2_MISC_ARB_GNT0_4				 (0x7L<<16)
#define BNX2_MISC_ARB_GNT0_5				 (0x7L<<20)
#define BNX2_MISC_ARB_GNT0_6				 (0x7L<<24)
#define BNX2_MISC_ARB_GNT0_7				 (0x7L<<28)

#define BNX2_MISC_ARB_GNT1				0x0000086c
#define BNX2_MISC_ARB_GNT1_8				 (0x7L<<0)
#define BNX2_MISC_ARB_GNT1_9				 (0x7L<<4)
#define BNX2_MISC_ARB_GNT1_10				 (0x7L<<8)
#define BNX2_MISC_ARB_GNT1_11				 (0x7L<<12)
#define BNX2_MISC_ARB_GNT1_12				 (0x7L<<16)
#define BNX2_MISC_ARB_GNT1_13				 (0x7L<<20)
#define BNX2_MISC_ARB_GNT1_14				 (0x7L<<24)
#define BNX2_MISC_ARB_GNT1_15				 (0x7L<<28)

#define BNX2_MISC_ARB_GNT2				0x00000870
#define BNX2_MISC_ARB_GNT2_16				 (0x7L<<0)
#define BNX2_MISC_ARB_GNT2_17				 (0x7L<<4)
#define BNX2_MISC_ARB_GNT2_18				 (0x7L<<8)
#define BNX2_MISC_ARB_GNT2_19				 (0x7L<<12)
#define BNX2_MISC_ARB_GNT2_20				 (0x7L<<16)
#define BNX2_MISC_ARB_GNT2_21				 (0x7L<<20)
#define BNX2_MISC_ARB_GNT2_22				 (0x7L<<24)
#define BNX2_MISC_ARB_GNT2_23				 (0x7L<<28)

#define BNX2_MISC_ARB_GNT3				0x00000874
#define BNX2_MISC_ARB_GNT3_24				 (0x7L<<0)
#define BNX2_MISC_ARB_GNT3_25				 (0x7L<<4)
#define BNX2_MISC_ARB_GNT3_26				 (0x7L<<8)
#define BNX2_MISC_ARB_GNT3_27				 (0x7L<<12)
#define BNX2_MISC_ARB_GNT3_28				 (0x7L<<16)
#define BNX2_MISC_ARB_GNT3_29				 (0x7L<<20)
#define BNX2_MISC_ARB_GNT3_30				 (0x7L<<24)
#define BNX2_MISC_ARB_GNT3_31				 (0x7L<<28)

#define BNX2_MISC_RESERVED1				0x00000878
#define BNX2_MISC_RESERVED1_MISC_RESERVED1_VALUE	 (0x3fL<<0)

#define BNX2_MISC_RESERVED2				0x0000087c
#define BNX2_MISC_RESERVED2_PCIE_DIS			 (1L<<0)
#define BNX2_MISC_RESERVED2_LINK_IN_L23			 (1L<<1)

#define BNX2_MISC_SM_ASF_CONTROL			0x00000880
#define BNX2_MISC_SM_ASF_CONTROL_ASF_RST		 (1L<<0)
#define BNX2_MISC_SM_ASF_CONTROL_TSC_EN			 (1L<<1)
#define BNX2_MISC_SM_ASF_CONTROL_WG_TO			 (1L<<2)
#define BNX2_MISC_SM_ASF_CONTROL_HB_TO			 (1L<<3)
#define BNX2_MISC_SM_ASF_CONTROL_PA_TO			 (1L<<4)
#define BNX2_MISC_SM_ASF_CONTROL_PL_TO			 (1L<<5)
#define BNX2_MISC_SM_ASF_CONTROL_RT_TO			 (1L<<6)
#define BNX2_MISC_SM_ASF_CONTROL_SMB_EVENT		 (1L<<7)
#define BNX2_MISC_SM_ASF_CONTROL_STRETCH_EN		 (1L<<8)
#define BNX2_MISC_SM_ASF_CONTROL_STRETCH_PULSE		 (1L<<9)
#define BNX2_MISC_SM_ASF_CONTROL_RES			 (0x3L<<10)
#define BNX2_MISC_SM_ASF_CONTROL_SMB_EN			 (1L<<12)
#define BNX2_MISC_SM_ASF_CONTROL_SMB_BB_EN		 (1L<<13)
#define BNX2_MISC_SM_ASF_CONTROL_SMB_NO_ADDR_FILT	 (1L<<14)
#define BNX2_MISC_SM_ASF_CONTROL_SMB_AUTOREAD		 (1L<<15)
#define BNX2_MISC_SM_ASF_CONTROL_NIC_SMB_ADDR1		 (0x7fL<<16)
#define BNX2_MISC_SM_ASF_CONTROL_NIC_SMB_ADDR2		 (0x7fL<<23)
#define BNX2_MISC_SM_ASF_CONTROL_EN_NIC_SMB_ADDR_0	 (1L<<30)
#define BNX2_MISC_SM_ASF_CONTROL_SMB_EARLY_ATTN		 (1L<<31)

#define BNX2_MISC_SMB_IN				0x00000884
#define BNX2_MISC_SMB_IN_DAT_IN				 (0xffL<<0)
#define BNX2_MISC_SMB_IN_RDY				 (1L<<8)
#define BNX2_MISC_SMB_IN_DONE				 (1L<<9)
#define BNX2_MISC_SMB_IN_FIRSTBYTE			 (1L<<10)
#define BNX2_MISC_SMB_IN_STATUS				 (0x7L<<11)
#define BNX2_MISC_SMB_IN_STATUS_OK			 (0x0L<<11)
#define BNX2_MISC_SMB_IN_STATUS_PEC			 (0x1L<<11)
#define BNX2_MISC_SMB_IN_STATUS_OFLOW			 (0x2L<<11)
#define BNX2_MISC_SMB_IN_STATUS_STOP			 (0x3L<<11)
#define BNX2_MISC_SMB_IN_STATUS_TIMEOUT			 (0x4L<<11)

#define BNX2_MISC_SMB_OUT				0x00000888
#define BNX2_MISC_SMB_OUT_DAT_OUT			 (0xffL<<0)
#define BNX2_MISC_SMB_OUT_RDY				 (1L<<8)
#define BNX2_MISC_SMB_OUT_START				 (1L<<9)
#define BNX2_MISC_SMB_OUT_LAST				 (1L<<10)
#define BNX2_MISC_SMB_OUT_ACC_TYPE			 (1L<<11)
#define BNX2_MISC_SMB_OUT_ENB_PEC			 (1L<<12)
#define BNX2_MISC_SMB_OUT_GET_RX_LEN			 (1L<<13)
#define BNX2_MISC_SMB_OUT_SMB_READ_LEN			 (0x3fL<<14)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS		 (0xfL<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_OK		 (0L<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_FIRST_NACK	 (1L<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_UFLOW		 (2L<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_STOP		 (3L<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_TIMEOUT	 (4L<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_FIRST_LOST	 (5L<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_BADACK		 (6L<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_SUB_NACK	 (9L<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_STATUS_SUB_LOST	 (0xdL<<20)
#define BNX2_MISC_SMB_OUT_SMB_OUT_SLAVEMODE		 (1L<<24)
#define BNX2_MISC_SMB_OUT_SMB_OUT_DAT_EN		 (1L<<25)
#define BNX2_MISC_SMB_OUT_SMB_OUT_DAT_IN		 (1L<<26)
#define BNX2_MISC_SMB_OUT_SMB_OUT_CLK_EN		 (1L<<27)
#define BNX2_MISC_SMB_OUT_SMB_OUT_CLK_IN		 (1L<<28)

#define BNX2_MISC_SMB_WATCHDOG				0x0000088c
#define BNX2_MISC_SMB_WATCHDOG_WATCHDOG			 (0xffffL<<0)

#define BNX2_MISC_SMB_HEARTBEAT				0x00000890
#define BNX2_MISC_SMB_HEARTBEAT_HEARTBEAT		 (0xffffL<<0)

#define BNX2_MISC_SMB_POLL_ASF				0x00000894
#define BNX2_MISC_SMB_POLL_ASF_POLL_ASF			 (0xffffL<<0)

#define BNX2_MISC_SMB_POLL_LEGACY			0x00000898
#define BNX2_MISC_SMB_POLL_LEGACY_POLL_LEGACY		 (0xffffL<<0)

#define BNX2_MISC_SMB_RETRAN				0x0000089c
#define BNX2_MISC_SMB_RETRAN_RETRAN			 (0xffL<<0)

#define BNX2_MISC_SMB_TIMESTAMP				0x000008a0
#define BNX2_MISC_SMB_TIMESTAMP_TIMESTAMP		 (0xffffffffL<<0)

#define BNX2_MISC_PERR_ENA0				0x000008a4
#define BNX2_MISC_PERR_ENA0_COM_MISC_CTXC		 (1L<<0)
#define BNX2_MISC_PERR_ENA0_COM_MISC_REGF		 (1L<<1)
#define BNX2_MISC_PERR_ENA0_COM_MISC_SCPAD		 (1L<<2)
#define BNX2_MISC_PERR_ENA0_CP_MISC_CTXC		 (1L<<3)
#define BNX2_MISC_PERR_ENA0_CP_MISC_REGF		 (1L<<4)
#define BNX2_MISC_PERR_ENA0_CP_MISC_SCPAD		 (1L<<5)
#define BNX2_MISC_PERR_ENA0_CS_MISC_TMEM		 (1L<<6)
#define BNX2_MISC_PERR_ENA0_CTX_MISC_ACCM0		 (1L<<7)
#define BNX2_MISC_PERR_ENA0_CTX_MISC_ACCM1		 (1L<<8)
#define BNX2_MISC_PERR_ENA0_CTX_MISC_ACCM2		 (1L<<9)
#define BNX2_MISC_PERR_ENA0_CTX_MISC_ACCM3		 (1L<<10)
#define BNX2_MISC_PERR_ENA0_CTX_MISC_ACCM4		 (1L<<11)
#define BNX2_MISC_PERR_ENA0_CTX_MISC_ACCM5		 (1L<<12)
#define BNX2_MISC_PERR_ENA0_CTX_MISC_PGTBL		 (1L<<13)
#define BNX2_MISC_PERR_ENA0_DMAE_MISC_DR0		 (1L<<14)
#define BNX2_MISC_PERR_ENA0_DMAE_MISC_DR1		 (1L<<15)
#define BNX2_MISC_PERR_ENA0_DMAE_MISC_DR2		 (1L<<16)
#define BNX2_MISC_PERR_ENA0_DMAE_MISC_DR3		 (1L<<17)
#define BNX2_MISC_PERR_ENA0_DMAE_MISC_DR4		 (1L<<18)
#define BNX2_MISC_PERR_ENA0_DMAE_MISC_DW0		 (1L<<19)
#define BNX2_MISC_PERR_ENA0_DMAE_MISC_DW1		 (1L<<20)
#define BNX2_MISC_PERR_ENA0_DMAE_MISC_DW2		 (1L<<21)
#define BNX2_MISC_PERR_ENA0_HC_MISC_DMA			 (1L<<22)
#define BNX2_MISC_PERR_ENA0_MCP_MISC_REGF		 (1L<<23)
#define BNX2_MISC_PERR_ENA0_MCP_MISC_SCPAD		 (1L<<24)
#define BNX2_MISC_PERR_ENA0_MQ_MISC_CTX			 (1L<<25)
#define BNX2_MISC_PERR_ENA0_RBDC_MISC			 (1L<<26)
#define BNX2_MISC_PERR_ENA0_RBUF_MISC_MB		 (1L<<27)
#define BNX2_MISC_PERR_ENA0_RBUF_MISC_PTR		 (1L<<28)
#define BNX2_MISC_PERR_ENA0_RDE_MISC_RPC		 (1L<<29)
#define BNX2_MISC_PERR_ENA0_RDE_MISC_RPM		 (1L<<30)
#define BNX2_MISC_PERR_ENA0_RV2P_MISC_CB0REGS		 (1L<<31)
#define BNX2_MISC_PERR_ENA0_COM_DMAE_PERR_EN_XI		 (1L<<0)
#define BNX2_MISC_PERR_ENA0_CP_DMAE_PERR_EN_XI		 (1L<<1)
#define BNX2_MISC_PERR_ENA0_RPM_ACPIBEMEM_PERR_EN_XI	 (1L<<2)
#define BNX2_MISC_PERR_ENA0_CTX_USAGE_CNT_PERR_EN_XI	 (1L<<3)
#define BNX2_MISC_PERR_ENA0_CTX_PGTBL_PERR_EN_XI	 (1L<<4)
#define BNX2_MISC_PERR_ENA0_CTX_CACHE_PERR_EN_XI	 (1L<<5)
#define BNX2_MISC_PERR_ENA0_CTX_MIRROR_PERR_EN_XI	 (1L<<6)
#define BNX2_MISC_PERR_ENA0_COM_CTXC_PERR_EN_XI		 (1L<<7)
#define BNX2_MISC_PERR_ENA0_COM_SCPAD_PERR_EN_XI	 (1L<<8)
#define BNX2_MISC_PERR_ENA0_CP_CTXC_PERR_EN_XI		 (1L<<9)
#define BNX2_MISC_PERR_ENA0_CP_SCPAD_PERR_EN_XI		 (1L<<10)
#define BNX2_MISC_PERR_ENA0_RXP_RBUFC_PERR_EN_XI	 (1L<<11)
#define BNX2_MISC_PERR_ENA0_RXP_CTXC_PERR_EN_XI		 (1L<<12)
#define BNX2_MISC_PERR_ENA0_RXP_SCPAD_PERR_EN_XI	 (1L<<13)
#define BNX2_MISC_PERR_ENA0_TPAT_SCPAD_PERR_EN_XI	 (1L<<14)
#define BNX2_MISC_PERR_ENA0_TXP_CTXC_PERR_EN_XI		 (1L<<15)
#define BNX2_MISC_PERR_ENA0_TXP_SCPAD_PERR_EN_XI	 (1L<<16)
#define BNX2_MISC_PERR_ENA0_CS_TMEM_PERR_EN_XI		 (1L<<17)
#define BNX2_MISC_PERR_ENA0_MQ_CTX_PERR_EN_XI		 (1L<<18)
#define BNX2_MISC_PERR_ENA0_RPM_DFIFOMEM_PERR_EN_XI	 (1L<<19)
#define BNX2_MISC_PERR_ENA0_RPC_DFIFOMEM_PERR_EN_XI	 (1L<<20)
#define BNX2_MISC_PERR_ENA0_RBUF_PTRMEM_PERR_EN_XI	 (1L<<21)
#define BNX2_MISC_PERR_ENA0_RBUF_DATAMEM_PERR_EN_XI	 (1L<<22)
#define BNX2_MISC_PERR_ENA0_RV2P_P2IRAM_PERR_EN_XI	 (1L<<23)
#define BNX2_MISC_PERR_ENA0_RV2P_P1IRAM_PERR_EN_XI	 (1L<<24)
#define BNX2_MISC_PERR_ENA0_RV2P_CB1REGS_PERR_EN_XI	 (1L<<25)
#define BNX2_MISC_PERR_ENA0_RV2P_CB0REGS_PERR_EN_XI	 (1L<<26)
#define BNX2_MISC_PERR_ENA0_TPBUF_PERR_EN_XI		 (1L<<27)
#define BNX2_MISC_PERR_ENA0_THBUF_PERR_EN_XI		 (1L<<28)
#define BNX2_MISC_PERR_ENA0_TDMA_PERR_EN_XI		 (1L<<29)
#define BNX2_MISC_PERR_ENA0_TBDC_PERR_EN_XI		 (1L<<30)
#define BNX2_MISC_PERR_ENA0_TSCH_LR_PERR_EN_XI		 (1L<<31)

#define BNX2_MISC_PERR_ENA1				0x000008a8
#define BNX2_MISC_PERR_ENA1_RV2P_MISC_CB1REGS		 (1L<<0)
#define BNX2_MISC_PERR_ENA1_RV2P_MISC_P1IRAM		 (1L<<1)
#define BNX2_MISC_PERR_ENA1_RV2P_MISC_P2IRAM		 (1L<<2)
#define BNX2_MISC_PERR_ENA1_RXP_MISC_CTXC		 (1L<<3)
#define BNX2_MISC_PERR_ENA1_RXP_MISC_REGF		 (1L<<4)
#define BNX2_MISC_PERR_ENA1_RXP_MISC_SCPAD		 (1L<<5)
#define BNX2_MISC_PERR_ENA1_RXP_MISC_RBUFC		 (1L<<6)
#define BNX2_MISC_PERR_ENA1_TBDC_MISC			 (1L<<7)
#define BNX2_MISC_PERR_ENA1_TDMA_MISC			 (1L<<8)
#define BNX2_MISC_PERR_ENA1_THBUF_MISC_MB0		 (1L<<9)
#define BNX2_MISC_PERR_ENA1_THBUF_MISC_MB1		 (1L<<10)
#define BNX2_MISC_PERR_ENA1_TPAT_MISC_REGF		 (1L<<11)
#define BNX2_MISC_PERR_ENA1_TPAT_MISC_SCPAD		 (1L<<12)
#define BNX2_MISC_PERR_ENA1_TPBUF_MISC_MB		 (1L<<13)
#define BNX2_MISC_PERR_ENA1_TSCH_MISC_LR		 (1L<<14)
#define BNX2_MISC_PERR_ENA1_TXP_MISC_CTXC		 (1L<<15)
#define BNX2_MISC_PERR_ENA1_TXP_MISC_REGF		 (1L<<16)
#define BNX2_MISC_PERR_ENA1_TXP_MISC_SCPAD		 (1L<<17)
#define BNX2_MISC_PERR_ENA1_UMP_MISC_FIORX		 (1L<<18)
#define BNX2_MISC_PERR_ENA1_UMP_MISC_FIOTX		 (1L<<19)
#define BNX2_MISC_PERR_ENA1_UMP_MISC_RX			 (1L<<20)
#define BNX2_MISC_PERR_ENA1_UMP_MISC_TX			 (1L<<21)
#define BNX2_MISC_PERR_ENA1_RDMAQ_MISC			 (1L<<22)
#define BNX2_MISC_PERR_ENA1_CSQ_MISC			 (1L<<23)
#define BNX2_MISC_PERR_ENA1_CPQ_MISC			 (1L<<24)
#define BNX2_MISC_PERR_ENA1_MCPQ_MISC			 (1L<<25)
#define BNX2_MISC_PERR_ENA1_RV2PMQ_MISC			 (1L<<26)
#define BNX2_MISC_PERR_ENA1_RV2PPQ_MISC			 (1L<<27)
#define BNX2_MISC_PERR_ENA1_RV2PTQ_MISC			 (1L<<28)
#define BNX2_MISC_PERR_ENA1_RXPQ_MISC			 (1L<<29)
#define BNX2_MISC_PERR_ENA1_RXPCQ_MISC			 (1L<<30)
#define BNX2_MISC_PERR_ENA1_RLUPQ_MISC			 (1L<<31)
#define BNX2_MISC_PERR_ENA1_RBDC_PERR_EN_XI		 (1L<<0)
#define BNX2_MISC_PERR_ENA1_RDMA_DFIFO_PERR_EN_XI	 (1L<<2)
#define BNX2_MISC_PERR_ENA1_HC_STATS_PERR_EN_XI		 (1L<<3)
#define BNX2_MISC_PERR_ENA1_HC_MSIX_PERR_EN_XI		 (1L<<4)
#define BNX2_MISC_PERR_ENA1_HC_PRODUCSTB_PERR_EN_XI	 (1L<<5)
#define BNX2_MISC_PERR_ENA1_HC_CONSUMSTB_PERR_EN_XI	 (1L<<6)
#define BNX2_MISC_PERR_ENA1_TPATQ_PERR_EN_XI		 (1L<<7)
#define BNX2_MISC_PERR_ENA1_MCPQ_PERR_EN_XI		 (1L<<8)
#define BNX2_MISC_PERR_ENA1_TDMAQ_PERR_EN_XI		 (1L<<9)
#define BNX2_MISC_PERR_ENA1_TXPQ_PERR_EN_XI		 (1L<<10)
#define BNX2_MISC_PERR_ENA1_COMTQ_PERR_EN_XI		 (1L<<11)
#define BNX2_MISC_PERR_ENA1_COMQ_PERR_EN_XI		 (1L<<12)
#define BNX2_MISC_PERR_ENA1_RLUPQ_PERR_EN_XI		 (1L<<13)
#define BNX2_MISC_PERR_ENA1_RXPQ_PERR_EN_XI		 (1L<<14)
#define BNX2_MISC_PERR_ENA1_RV2PPQ_PERR_EN_XI		 (1L<<15)
#define BNX2_MISC_PERR_ENA1_RDMAQ_PERR_EN_XI		 (1L<<16)
#define BNX2_MISC_PERR_ENA1_TASQ_PERR_EN_XI		 (1L<<17)
#define BNX2_MISC_PERR_ENA1_TBDRQ_PERR_EN_XI		 (1L<<18)
#define BNX2_MISC_PERR_ENA1_TSCHQ_PERR_EN_XI		 (1L<<19)
#define BNX2_MISC_PERR_ENA1_COMXQ_PERR_EN_XI		 (1L<<20)
#define BNX2_MISC_PERR_ENA1_RXPCQ_PERR_EN_XI		 (1L<<21)
#define BNX2_MISC_PERR_ENA1_RV2PTQ_PERR_EN_XI		 (1L<<22)
#define BNX2_MISC_PERR_ENA1_RV2PMQ_PERR_EN_XI		 (1L<<23)
#define BNX2_MISC_PERR_ENA1_CPQ_PERR_EN_XI		 (1L<<24)
#define BNX2_MISC_PERR_ENA1_CSQ_PERR_EN_XI		 (1L<<25)
#define BNX2_MISC_PERR_ENA1_RLUP_CID_PERR_EN_XI		 (1L<<26)
#define BNX2_MISC_PERR_ENA1_RV2PCS_TMEM_PERR_EN_XI	 (1L<<27)
#define BNX2_MISC_PERR_ENA1_RV2PCSQ_PERR_EN_XI		 (1L<<28)
#define BNX2_MISC_PERR_ENA1_MQ_IDX_PERR_EN_XI		 (1L<<29)

#define BNX2_MISC_PERR_ENA2				0x000008ac
#define BNX2_MISC_PERR_ENA2_COMQ_MISC			 (1L<<0)
#define BNX2_MISC_PERR_ENA2_COMXQ_MISC			 (1L<<1)
#define BNX2_MISC_PERR_ENA2_COMTQ_MISC			 (1L<<2)
#define BNX2_MISC_PERR_ENA2_TSCHQ_MISC			 (1L<<3)
#define BNX2_MISC_PERR_ENA2_TBDRQ_MISC			 (1L<<4)
#define BNX2_MISC_PERR_ENA2_TXPQ_MISC			 (1L<<5)
#define BNX2_MISC_PERR_ENA2_TDMAQ_MISC			 (1L<<6)
#define BNX2_MISC_PERR_ENA2_TPATQ_MISC			 (1L<<7)
#define BNX2_MISC_PERR_ENA2_TASQ_MISC			 (1L<<8)
#define BNX2_MISC_PERR_ENA2_TGT_FIFO_PERR_EN_XI		 (1L<<0)
#define BNX2_MISC_PERR_ENA2_UMP_TX_PERR_EN_XI		 (1L<<1)
#define BNX2_MISC_PERR_ENA2_UMP_RX_PERR_EN_XI		 (1L<<2)
#define BNX2_MISC_PERR_ENA2_MCP_ROM_PERR_EN_XI		 (1L<<3)
#define BNX2_MISC_PERR_ENA2_MCP_SCPAD_PERR_EN_XI	 (1L<<4)
#define BNX2_MISC_PERR_ENA2_HB_MEM_PERR_EN_XI		 (1L<<5)
#define BNX2_MISC_PERR_ENA2_PCIE_REPLAY_PERR_EN_XI	 (1L<<6)

#define BNX2_MISC_DEBUG_VECTOR_SEL			0x000008b0
#define BNX2_MISC_DEBUG_VECTOR_SEL_0			 (0xfffL<<0)
#define BNX2_MISC_DEBUG_VECTOR_SEL_1			 (0xfffL<<12)
#define BNX2_MISC_DEBUG_VECTOR_SEL_1_XI			 (0xfffL<<15)

#define BNX2_MISC_VREG_CONTROL				0x000008b4
#define BNX2_MISC_VREG_CONTROL_1_2			 (0xfL<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_XI		 (0xfL<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_PLUS14_XI	 (0L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_PLUS12_XI	 (1L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_PLUS10_XI	 (2L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_PLUS8_XI	 (3L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_PLUS6_XI	 (4L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_PLUS4_XI	 (5L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_PLUS2_XI	 (6L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_NOM_XI		 (7L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_MINUS2_XI	 (8L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_MINUS4_XI	 (9L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_MINUS6_XI	 (10L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_MINUS8_XI	 (11L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_MINUS10_XI	 (12L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_MINUS12_XI	 (13L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_MINUS14_XI	 (14L<<0)
#define BNX2_MISC_VREG_CONTROL_1_0_MAIN_MINUS16_XI	 (15L<<0)
#define BNX2_MISC_VREG_CONTROL_2_5			 (0xfL<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_PLUS14		 (0L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_PLUS12		 (1L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_PLUS10		 (2L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_PLUS8		 (3L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_PLUS6		 (4L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_PLUS4		 (5L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_PLUS2		 (6L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_NOM			 (7L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_MINUS2		 (8L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_MINUS4		 (9L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_MINUS6		 (10L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_MINUS8		 (11L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_MINUS10		 (12L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_MINUS12		 (13L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_MINUS14		 (14L<<4)
#define BNX2_MISC_VREG_CONTROL_2_5_MINUS16		 (15L<<4)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT			 (0xfL<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_PLUS14		 (0L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_PLUS12		 (1L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_PLUS10		 (2L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_PLUS8		 (3L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_PLUS6		 (4L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_PLUS4		 (5L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_PLUS2		 (6L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_NOM		 (7L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_MINUS2		 (8L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_MINUS4		 (9L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_MINUS6		 (10L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_MINUS8		 (11L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_MINUS10		 (12L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_MINUS12		 (13L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_MINUS14		 (14L<<8)
#define BNX2_MISC_VREG_CONTROL_1_0_MGMT_MINUS16		 (15L<<8)

#define BNX2_MISC_FINAL_CLK_CTL_VAL			0x000008b8
#define BNX2_MISC_FINAL_CLK_CTL_VAL_MISC_FINAL_CLK_CTL_VAL	 (0x3ffffffL<<6)

#define BNX2_MISC_GP_HW_CTL0				0x000008bc
#define BNX2_MISC_GP_HW_CTL0_TX_DRIVE			 (1L<<0)
#define BNX2_MISC_GP_HW_CTL0_RMII_MODE			 (1L<<1)
#define BNX2_MISC_GP_HW_CTL0_RMII_CRSDV_SEL		 (1L<<2)
#define BNX2_MISC_GP_HW_CTL0_RVMII_MODE			 (1L<<3)
#define BNX2_MISC_GP_HW_CTL0_FLASH_SAMP_SCLK_NEGEDGE_TE	 (1L<<4)
#define BNX2_MISC_GP_HW_CTL0_HIDDEN_REVISION_ID_TE	 (1L<<5)
#define BNX2_MISC_GP_HW_CTL0_HC_CNTL_TMOUT_CTR_RST_TE	 (1L<<6)
#define BNX2_MISC_GP_HW_CTL0_RESERVED1_XI		 (0x7L<<4)
#define BNX2_MISC_GP_HW_CTL0_ENA_CORE_RST_ON_MAIN_PWR_GOING_AWAY	 (1L<<7)
#define BNX2_MISC_GP_HW_CTL0_ENA_SEL_VAUX_B_IN_L2_TE	 (1L<<8)
#define BNX2_MISC_GP_HW_CTL0_GRC_BNK_FREE_FIX_TE	 (1L<<9)
#define BNX2_MISC_GP_HW_CTL0_LED_ACT_SEL_TE		 (1L<<10)
#define BNX2_MISC_GP_HW_CTL0_RESERVED2_XI		 (0x7L<<8)
#define BNX2_MISC_GP_HW_CTL0_UP1_DEF0			 (1L<<11)
#define BNX2_MISC_GP_HW_CTL0_FIBER_MODE_DIS_DEF		 (1L<<12)
#define BNX2_MISC_GP_HW_CTL0_FORCE2500_DEF		 (1L<<13)
#define BNX2_MISC_GP_HW_CTL0_AUTODETECT_DIS_DEF		 (1L<<14)
#define BNX2_MISC_GP_HW_CTL0_PARALLEL_DETECT_DEF	 (1L<<15)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_DAI		 (0xfL<<16)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_DAI_3MA		 (0L<<16)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_DAI_2P5MA		 (1L<<16)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_DAI_2P0MA		 (3L<<16)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_DAI_1P5MA		 (5L<<16)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_DAI_1P0MA		 (7L<<16)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_DAI_PWRDN		 (15L<<16)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_PRE2DIS		 (1L<<20)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_PRE1DIS		 (1L<<21)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_CTAT		 (0x3L<<22)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_CTAT_M6P		 (0L<<22)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_CTAT_M0P		 (1L<<22)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_CTAT_P0P		 (2L<<22)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_CTAT_P6P		 (3L<<22)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_PTAT		 (0x3L<<24)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_PTAT_M6P		 (0L<<24)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_PTAT_M0P		 (1L<<24)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_PTAT_P0P		 (2L<<24)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_PTAT_P6P		 (3L<<24)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_IAMP_ADJ		 (0x3L<<26)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_IAMP_ADJ_240UA	 (0L<<26)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_IAMP_ADJ_160UA	 (1L<<26)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_IAMP_ADJ_400UA	 (2L<<26)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_IAMP_ADJ_320UA	 (3L<<26)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_ICBUF_ADJ		 (0x3L<<28)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_ICBUF_ADJ_240UA	 (0L<<28)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_ICBUF_ADJ_160UA	 (1L<<28)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_ICBUF_ADJ_400UA	 (2L<<28)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_ICBUF_ADJ_320UA	 (3L<<28)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_XTAL_ADJ		 (0x3L<<30)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_XTAL_ADJ_1P57	 (0L<<30)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_XTAL_ADJ_1P45	 (1L<<30)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_XTAL_ADJ_1P62	 (2L<<30)
#define BNX2_MISC_GP_HW_CTL0_OSCCTRL_XTAL_ADJ_1P66	 (3L<<30)

#define BNX2_MISC_GP_HW_CTL1				0x000008c0
#define BNX2_MISC_GP_HW_CTL1_1_ATTN_BTN_PRSNT_TE	 (1L<<0)
#define BNX2_MISC_GP_HW_CTL1_1_ATTN_IND_PRSNT_TE	 (1L<<1)
#define BNX2_MISC_GP_HW_CTL1_1_PWR_IND_PRSNT_TE		 (1L<<2)
#define BNX2_MISC_GP_HW_CTL1_0_PCIE_LOOPBACK_TE		 (1L<<3)
#define BNX2_MISC_GP_HW_CTL1_RESERVED_SOFT_XI		 (0xffffL<<0)
#define BNX2_MISC_GP_HW_CTL1_RESERVED_HARD_XI		 (0xffffL<<16)

#define BNX2_MISC_NEW_HW_CTL				0x000008c4
#define BNX2_MISC_NEW_HW_CTL_MAIN_POR_BYPASS		 (1L<<0)
#define BNX2_MISC_NEW_HW_CTL_RINGOSC_ENABLE		 (1L<<1)
#define BNX2_MISC_NEW_HW_CTL_RINGOSC_SEL0		 (1L<<2)
#define BNX2_MISC_NEW_HW_CTL_RINGOSC_SEL1		 (1L<<3)
#define BNX2_MISC_NEW_HW_CTL_RESERVED_SHARED		 (0xfffL<<4)
#define BNX2_MISC_NEW_HW_CTL_RESERVED_SPLIT		 (0xffffL<<16)

#define BNX2_MISC_NEW_CORE_CTL				0x000008c8
#define BNX2_MISC_NEW_CORE_CTL_LINK_HOLDOFF_SUCCESS	 (1L<<0)
#define BNX2_MISC_NEW_CORE_CTL_LINK_HOLDOFF_REQ		 (1L<<1)
#define BNX2_MISC_NEW_CORE_CTL_DMA_ENABLE		 (1L<<16)
#define BNX2_MISC_NEW_CORE_CTL_RESERVED_CMN		 (0x3fffL<<2)
#define BNX2_MISC_NEW_CORE_CTL_RESERVED_TC		 (0xffffL<<16)

#define BNX2_MISC_ECO_HW_CTL				0x000008cc
#define BNX2_MISC_ECO_HW_CTL_LARGE_GRC_TMOUT_EN		 (1L<<0)
#define BNX2_MISC_ECO_HW_CTL_RESERVED_SOFT		 (0x7fffL<<1)
#define BNX2_MISC_ECO_HW_CTL_RESERVED_HARD		 (0xffffL<<16)

#define BNX2_MISC_ECO_CORE_CTL				0x000008d0
#define BNX2_MISC_ECO_CORE_CTL_RESERVED_SOFT		 (0xffffL<<0)
#define BNX2_MISC_ECO_CORE_CTL_RESERVED_HARD		 (0xffffL<<16)

#define BNX2_MISC_PPIO					0x000008d4
#define BNX2_MISC_PPIO_VALUE				 (0xfL<<0)
#define BNX2_MISC_PPIO_SET				 (0xfL<<8)
#define BNX2_MISC_PPIO_CLR				 (0xfL<<16)
#define BNX2_MISC_PPIO_FLOAT				 (0xfL<<24)

#define BNX2_MISC_PPIO_INT				0x000008d8
#define BNX2_MISC_PPIO_INT_INT_STATE			 (0xfL<<0)
#define BNX2_MISC_PPIO_INT_OLD_VALUE			 (0xfL<<8)
#define BNX2_MISC_PPIO_INT_OLD_SET			 (0xfL<<16)
#define BNX2_MISC_PPIO_INT_OLD_CLR			 (0xfL<<24)

#define BNX2_MISC_RESET_NUMS				0x000008dc
#define BNX2_MISC_RESET_NUMS_NUM_HARD_RESETS		 (0x7L<<0)
#define BNX2_MISC_RESET_NUMS_NUM_PCIE_RESETS		 (0x7L<<4)
#define BNX2_MISC_RESET_NUMS_NUM_PERSTB_RESETS		 (0x7L<<8)
#define BNX2_MISC_RESET_NUMS_NUM_CMN_RESETS		 (0x7L<<12)
#define BNX2_MISC_RESET_NUMS_NUM_PORT_RESETS		 (0x7L<<16)

#define BNX2_MISC_CS16_ERR				0x000008e0
#define BNX2_MISC_CS16_ERR_ENA_PCI			 (1L<<0)
#define BNX2_MISC_CS16_ERR_ENA_RDMA			 (1L<<1)
#define BNX2_MISC_CS16_ERR_ENA_TDMA			 (1L<<2)
#define BNX2_MISC_CS16_ERR_ENA_EMAC			 (1L<<3)
#define BNX2_MISC_CS16_ERR_ENA_CTX			 (1L<<4)
#define BNX2_MISC_CS16_ERR_ENA_TBDR			 (1L<<5)
#define BNX2_MISC_CS16_ERR_ENA_RBDC			 (1L<<6)
#define BNX2_MISC_CS16_ERR_ENA_COM			 (1L<<7)
#define BNX2_MISC_CS16_ERR_ENA_CP			 (1L<<8)
#define BNX2_MISC_CS16_ERR_STA_PCI			 (1L<<16)
#define BNX2_MISC_CS16_ERR_STA_RDMA			 (1L<<17)
#define BNX2_MISC_CS16_ERR_STA_TDMA			 (1L<<18)
#define BNX2_MISC_CS16_ERR_STA_EMAC			 (1L<<19)
#define BNX2_MISC_CS16_ERR_STA_CTX			 (1L<<20)
#define BNX2_MISC_CS16_ERR_STA_TBDR			 (1L<<21)
#define BNX2_MISC_CS16_ERR_STA_RBDC			 (1L<<22)
#define BNX2_MISC_CS16_ERR_STA_COM			 (1L<<23)
#define BNX2_MISC_CS16_ERR_STA_CP			 (1L<<24)

#define BNX2_MISC_SPIO_EVENT				0x000008e4
#define BNX2_MISC_SPIO_EVENT_ENABLE			 (0xffL<<0)

#define BNX2_MISC_PPIO_EVENT				0x000008e8
#define BNX2_MISC_PPIO_EVENT_ENABLE			 (0xfL<<0)

#define BNX2_MISC_DUAL_MEDIA_CTRL			0x000008ec
#define BNX2_MISC_DUAL_MEDIA_CTRL_BOND_ID		 (0xffL<<0)
#define BNX2_MISC_DUAL_MEDIA_CTRL_BOND_ID_X		 (0L<<0)
#define BNX2_MISC_DUAL_MEDIA_CTRL_BOND_ID_C		 (3L<<0)
#define BNX2_MISC_DUAL_MEDIA_CTRL_BOND_ID_S		 (12L<<0)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY_CTRL_STRAP	 (0x7L<<8)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PORT_SWAP_PIN		 (1L<<11)
#define BNX2_MISC_DUAL_MEDIA_CTRL_SERDES1_SIGDET	 (1L<<12)
#define BNX2_MISC_DUAL_MEDIA_CTRL_SERDES0_SIGDET	 (1L<<13)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY1_SIGDET		 (1L<<14)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY0_SIGDET		 (1L<<15)
#define BNX2_MISC_DUAL_MEDIA_CTRL_LCPLL_RST		 (1L<<16)
#define BNX2_MISC_DUAL_MEDIA_CTRL_SERDES1_RST		 (1L<<17)
#define BNX2_MISC_DUAL_MEDIA_CTRL_SERDES0_RST		 (1L<<18)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY1_RST		 (1L<<19)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY0_RST		 (1L<<20)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY_CTRL		 (0x7L<<21)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PORT_SWAP		 (1L<<24)
#define BNX2_MISC_DUAL_MEDIA_CTRL_STRAP_OVERRIDE	 (1L<<25)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ	 (0xfL<<26)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_SER1_IDDQ	 (1L<<26)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_SER0_IDDQ	 (2L<<26)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_PHY1_IDDQ	 (4L<<26)
#define BNX2_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_PHY0_IDDQ	 (8L<<26)

#define BNX2_MISC_OTP_CMD1				0x000008f0
#define BNX2_MISC_OTP_CMD1_FMODE			 (0x7L<<0)
#define BNX2_MISC_OTP_CMD1_FMODE_IDLE			 (0L<<0)
#define BNX2_MISC_OTP_CMD1_FMODE_WRITE			 (1L<<0)
#define BNX2_MISC_OTP_CMD1_FMODE_INIT			 (2L<<0)
#define BNX2_MISC_OTP_CMD1_FMODE_SET			 (3L<<0)
#define BNX2_MISC_OTP_CMD1_FMODE_RST			 (4L<<0)
#define BNX2_MISC_OTP_CMD1_FMODE_VERIFY			 (5L<<0)
#define BNX2_MISC_OTP_CMD1_FMODE_RESERVED0		 (6L<<0)
#define BNX2_MISC_OTP_CMD1_FMODE_RESERVED1		 (7L<<0)
#define BNX2_MISC_OTP_CMD1_USEPINS			 (1L<<8)
#define BNX2_MISC_OTP_CMD1_PROGSEL			 (1L<<9)
#define BNX2_MISC_OTP_CMD1_PROGSTART			 (1L<<10)
#define BNX2_MISC_OTP_CMD1_PCOUNT			 (0x7L<<16)
#define BNX2_MISC_OTP_CMD1_PBYP				 (1L<<19)
#define BNX2_MISC_OTP_CMD1_VSEL				 (0xfL<<20)
#define BNX2_MISC_OTP_CMD1_TM				 (0x7L<<27)
#define BNX2_MISC_OTP_CMD1_SADBYP			 (1L<<30)
#define BNX2_MISC_OTP_CMD1_DEBUG			 (1L<<31)

#define BNX2_MISC_OTP_CMD2				0x000008f4
#define BNX2_MISC_OTP_CMD2_OTP_ROM_ADDR			 (0x3ffL<<0)
#define BNX2_MISC_OTP_CMD2_DOSEL			 (0x7fL<<16)
#define BNX2_MISC_OTP_CMD2_DOSEL_0			 (0L<<16)
#define BNX2_MISC_OTP_CMD2_DOSEL_1			 (1L<<16)
#define BNX2_MISC_OTP_CMD2_DOSEL_127			 (127L<<16)

#define BNX2_MISC_OTP_STATUS				0x000008f8
#define BNX2_MISC_OTP_STATUS_DATA			 (0xffL<<0)
#define BNX2_MISC_OTP_STATUS_VALID			 (1L<<8)
#define BNX2_MISC_OTP_STATUS_BUSY			 (1L<<9)
#define BNX2_MISC_OTP_STATUS_BUSYSM			 (1L<<10)
#define BNX2_MISC_OTP_STATUS_DONE			 (1L<<11)

#define BNX2_MISC_OTP_SHIFT1_CMD			0x000008fc
#define BNX2_MISC_OTP_SHIFT1_CMD_RESET_MODE_N		 (1L<<0)
#define BNX2_MISC_OTP_SHIFT1_CMD_SHIFT_DONE		 (1L<<1)
#define BNX2_MISC_OTP_SHIFT1_CMD_SHIFT_START		 (1L<<2)
#define BNX2_MISC_OTP_SHIFT1_CMD_LOAD_DATA		 (1L<<3)
#define BNX2_MISC_OTP_SHIFT1_CMD_SHIFT_SELECT		 (0x1fL<<8)

#define BNX2_MISC_OTP_SHIFT1_DATA			0x00000900
#define BNX2_MISC_OTP_SHIFT2_CMD			0x00000904
#define BNX2_MISC_OTP_SHIFT2_CMD_RESET_MODE_N		 (1L<<0)
#define BNX2_MISC_OTP_SHIFT2_CMD_SHIFT_DONE		 (1L<<1)
#define BNX2_MISC_OTP_SHIFT2_CMD_SHIFT_START		 (1L<<2)
#define BNX2_MISC_OTP_SHIFT2_CMD_LOAD_DATA		 (1L<<3)
#define BNX2_MISC_OTP_SHIFT2_CMD_SHIFT_SELECT		 (0x1fL<<8)

#define BNX2_MISC_OTP_SHIFT2_DATA			0x00000908
#define BNX2_MISC_BIST_CS0				0x0000090c
#define BNX2_MISC_BIST_CS0_MBIST_EN			 (1L<<0)
#define BNX2_MISC_BIST_CS0_BIST_SETUP			 (0x3L<<1)
#define BNX2_MISC_BIST_CS0_MBIST_ASYNC_RESET		 (1L<<3)
#define BNX2_MISC_BIST_CS0_MBIST_DONE			 (1L<<8)
#define BNX2_MISC_BIST_CS0_MBIST_GO			 (1L<<9)
#define BNX2_MISC_BIST_CS0_BIST_OVERRIDE		 (1L<<31)

#define BNX2_MISC_BIST_MEMSTATUS0			0x00000910
#define BNX2_MISC_BIST_CS1				0x00000914
#define BNX2_MISC_BIST_CS1_MBIST_EN			 (1L<<0)
#define BNX2_MISC_BIST_CS1_BIST_SETUP			 (0x3L<<1)
#define BNX2_MISC_BIST_CS1_MBIST_ASYNC_RESET		 (1L<<3)
#define BNX2_MISC_BIST_CS1_MBIST_DONE			 (1L<<8)
#define BNX2_MISC_BIST_CS1_MBIST_GO			 (1L<<9)

#define BNX2_MISC_BIST_MEMSTATUS1			0x00000918
#define BNX2_MISC_BIST_CS2				0x0000091c
#define BNX2_MISC_BIST_CS2_MBIST_EN			 (1L<<0)
#define BNX2_MISC_BIST_CS2_BIST_SETUP			 (0x3L<<1)
#define BNX2_MISC_BIST_CS2_MBIST_ASYNC_RESET		 (1L<<3)
#define BNX2_MISC_BIST_CS2_MBIST_DONE			 (1L<<8)
#define BNX2_MISC_BIST_CS2_MBIST_GO			 (1L<<9)

#define BNX2_MISC_BIST_MEMSTATUS2			0x00000920
#define BNX2_MISC_BIST_CS3				0x00000924
#define BNX2_MISC_BIST_CS3_MBIST_EN			 (1L<<0)
#define BNX2_MISC_BIST_CS3_BIST_SETUP			 (0x3L<<1)
#define BNX2_MISC_BIST_CS3_MBIST_ASYNC_RESET		 (1L<<3)
#define BNX2_MISC_BIST_CS3_MBIST_DONE			 (1L<<8)
#define BNX2_MISC_BIST_CS3_MBIST_GO			 (1L<<9)

#define BNX2_MISC_BIST_MEMSTATUS3			0x00000928
#define BNX2_MISC_BIST_CS4				0x0000092c
#define BNX2_MISC_BIST_CS4_MBIST_EN			 (1L<<0)
#define BNX2_MISC_BIST_CS4_BIST_SETUP			 (0x3L<<1)
#define BNX2_MISC_BIST_CS4_MBIST_ASYNC_RESET		 (1L<<3)
#define BNX2_MISC_BIST_CS4_MBIST_DONE			 (1L<<8)
#define BNX2_MISC_BIST_CS4_MBIST_GO			 (1L<<9)

#define BNX2_MISC_BIST_MEMSTATUS4			0x00000930
#define BNX2_MISC_BIST_CS5				0x00000934
#define BNX2_MISC_BIST_CS5_MBIST_EN			 (1L<<0)
#define BNX2_MISC_BIST_CS5_BIST_SETUP			 (0x3L<<1)
#define BNX2_MISC_BIST_CS5_MBIST_ASYNC_RESET		 (1L<<3)
#define BNX2_MISC_BIST_CS5_MBIST_DONE			 (1L<<8)
#define BNX2_MISC_BIST_CS5_MBIST_GO			 (1L<<9)

#define BNX2_MISC_BIST_MEMSTATUS5			0x00000938
#define BNX2_MISC_MEM_TM0				0x0000093c
#define BNX2_MISC_MEM_TM0_PCIE_REPLAY_TM		 (0xfL<<0)
#define BNX2_MISC_MEM_TM0_MCP_SCPAD			 (0xfL<<8)
#define BNX2_MISC_MEM_TM0_UMP_TM			 (0xffL<<16)
#define BNX2_MISC_MEM_TM0_HB_MEM_TM			 (0xfL<<24)

#define BNX2_MISC_USPLL_CTRL				0x00000940
#define BNX2_MISC_USPLL_CTRL_PH_DET_DIS			 (1L<<0)
#define BNX2_MISC_USPLL_CTRL_FREQ_DET_DIS		 (1L<<1)
#define BNX2_MISC_USPLL_CTRL_LCPX			 (0x3fL<<2)
#define BNX2_MISC_USPLL_CTRL_RX				 (0x3L<<8)
#define BNX2_MISC_USPLL_CTRL_VC_EN			 (1L<<10)
#define BNX2_MISC_USPLL_CTRL_VCO_MG			 (0x3L<<11)
#define BNX2_MISC_USPLL_CTRL_KVCO_XF			 (0x7L<<13)
#define BNX2_MISC_USPLL_CTRL_KVCO_XS			 (0x7L<<16)
#define BNX2_MISC_USPLL_CTRL_TESTD_EN			 (1L<<19)
#define BNX2_MISC_USPLL_CTRL_TESTD_SEL			 (0x7L<<20)
#define BNX2_MISC_USPLL_CTRL_TESTA_EN			 (1L<<23)
#define BNX2_MISC_USPLL_CTRL_TESTA_SEL			 (0x3L<<24)
#define BNX2_MISC_USPLL_CTRL_ATTEN_FREF			 (1L<<26)
#define BNX2_MISC_USPLL_CTRL_DIGITAL_RST		 (1L<<27)
#define BNX2_MISC_USPLL_CTRL_ANALOG_RST			 (1L<<28)
#define BNX2_MISC_USPLL_CTRL_LOCK			 (1L<<29)

#define BNX2_MISC_PERR_STATUS0				0x00000944
#define BNX2_MISC_PERR_STATUS0_COM_DMAE_PERR		 (1L<<0)
#define BNX2_MISC_PERR_STATUS0_CP_DMAE_PERR		 (1L<<1)
#define BNX2_MISC_PERR_STATUS0_RPM_ACPIBEMEM_PERR	 (1L<<2)
#define BNX2_MISC_PERR_STATUS0_CTX_USAGE_CNT_PERR	 (1L<<3)
#define BNX2_MISC_PERR_STATUS0_CTX_PGTBL_PERR		 (1L<<4)
#define BNX2_MISC_PERR_STATUS0_CTX_CACHE_PERR		 (1L<<5)
#define BNX2_MISC_PERR_STATUS0_CTX_MIRROR_PERR		 (1L<<6)
#define BNX2_MISC_PERR_STATUS0_COM_CTXC_PERR		 (1L<<7)
#define BNX2_MISC_PERR_STATUS0_COM_SCPAD_PERR		 (1L<<8)
#define BNX2_MISC_PERR_STATUS0_CP_CTXC_PERR		 (1L<<9)
#define BNX2_MISC_PERR_STATUS0_CP_SCPAD_PERR		 (1L<<10)
#define BNX2_MISC_PERR_STATUS0_RXP_RBUFC_PERR		 (1L<<11)
#define BNX2_MISC_PERR_STATUS0_RXP_CTXC_PERR		 (1L<<12)
#define BNX2_MISC_PERR_STATUS0_RXP_SCPAD_PERR		 (1L<<13)
#define BNX2_MISC_PERR_STATUS0_TPAT_SCPAD_PERR		 (1L<<14)
#define BNX2_MISC_PERR_STATUS0_TXP_CTXC_PERR		 (1L<<15)
#define BNX2_MISC_PERR_STATUS0_TXP_SCPAD_PERR		 (1L<<16)
#define BNX2_MISC_PERR_STATUS0_CS_TMEM_PERR		 (1L<<17)
#define BNX2_MISC_PERR_STATUS0_MQ_CTX_PERR		 (1L<<18)
#define BNX2_MISC_PERR_STATUS0_RPM_DFIFOMEM_PERR	 (1L<<19)
#define BNX2_MISC_PERR_STATUS0_RPC_DFIFOMEM_PERR	 (1L<<20)
#define BNX2_MISC_PERR_STATUS0_RBUF_PTRMEM_PERR		 (1L<<21)
#define BNX2_MISC_PERR_STATUS0_RBUF_DATAMEM_PERR	 (1L<<22)
#define BNX2_MISC_PERR_STATUS0_RV2P_P2IRAM_PERR		 (1L<<23)
#define BNX2_MISC_PERR_STATUS0_RV2P_P1IRAM_PERR		 (1L<<24)
#define BNX2_MISC_PERR_STATUS0_RV2P_CB1REGS_PERR	 (1L<<25)
#define BNX2_MISC_PERR_STATUS0_RV2P_CB0REGS_PERR	 (1L<<26)
#define BNX2_MISC_PERR_STATUS0_TPBUF_PERR		 (1L<<27)
#define BNX2_MISC_PERR_STATUS0_THBUF_PERR		 (1L<<28)
#define BNX2_MISC_PERR_STATUS0_TDMA_PERR		 (1L<<29)
#define BNX2_MISC_PERR_STATUS0_TBDC_PERR		 (1L<<30)
#define BNX2_MISC_PERR_STATUS0_TSCH_LR_PERR		 (1L<<31)

#define BNX2_MISC_PERR_STATUS1				0x00000948
#define BNX2_MISC_PERR_STATUS1_RBDC_PERR		 (1L<<0)
#define BNX2_MISC_PERR_STATUS1_RDMA_DFIFO_PERR		 (1L<<2)
#define BNX2_MISC_PERR_STATUS1_HC_STATS_PERR		 (1L<<3)
#define BNX2_MISC_PERR_STATUS1_HC_MSIX_PERR		 (1L<<4)
#define BNX2_MISC_PERR_STATUS1_HC_PRODUCSTB_PERR	 (1L<<5)
#define BNX2_MISC_PERR_STATUS1_HC_CONSUMSTB_PERR	 (1L<<6)
#define BNX2_MISC_PERR_STATUS1_TPATQ_PERR		 (1L<<7)
#define BNX2_MISC_PERR_STATUS1_MCPQ_PERR		 (1L<<8)
#define BNX2_MISC_PERR_STATUS1_TDMAQ_PERR		 (1L<<9)
#define BNX2_MISC_PERR_STATUS1_TXPQ_PERR		 (1L<<10)
#define BNX2_MISC_PERR_STATUS1_COMTQ_PERR		 (1L<<11)
#define BNX2_MISC_PERR_STATUS1_COMQ_PERR		 (1L<<12)
#define BNX2_MISC_PERR_STATUS1_RLUPQ_PERR		 (1L<<13)
#define BNX2_MISC_PERR_STATUS1_RXPQ_PERR		 (1L<<14)
#define BNX2_MISC_PERR_STATUS1_RV2PPQ_PERR		 (1L<<15)
#define BNX2_MISC_PERR_STATUS1_RDMAQ_PERR		 (1L<<16)
#define BNX2_MISC_PERR_STATUS1_TASQ_PERR		 (1L<<17)
#define BNX2_MISC_PERR_STATUS1_TBDRQ_PERR		 (1L<<18)
#define BNX2_MISC_PERR_STATUS1_TSCHQ_PERR		 (1L<<19)
#define BNX2_MISC_PERR_STATUS1_COMXQ_PERR		 (1L<<20)
#define BNX2_MISC_PERR_STATUS1_RXPCQ_PERR		 (1L<<21)
#define BNX2_MISC_PERR_STATUS1_RV2PTQ_PERR		 (1L<<22)
#define BNX2_MISC_PERR_STATUS1_RV2PMQ_PERR		 (1L<<23)
#define BNX2_MISC_PERR_STATUS1_CPQ_PERR			 (1L<<24)
#define BNX2_MISC_PERR_STATUS1_CSQ_PERR			 (1L<<25)
#define BNX2_MISC_PERR_STATUS1_RLUP_CID_PERR		 (1L<<26)
#define BNX2_MISC_PERR_STATUS1_RV2PCS_TMEM_PERR		 (1L<<27)
#define BNX2_MISC_PERR_STATUS1_RV2PCSQ_PERR		 (1L<<28)
#define BNX2_MISC_PERR_STATUS1_MQ_IDX_PERR		 (1L<<29)

#define BNX2_MISC_PERR_STATUS2				0x0000094c
#define BNX2_MISC_PERR_STATUS2_TGT_FIFO_PERR		 (1L<<0)
#define BNX2_MISC_PERR_STATUS2_UMP_TX_PERR		 (1L<<1)
#define BNX2_MISC_PERR_STATUS2_UMP_RX_PERR		 (1L<<2)
#define BNX2_MISC_PERR_STATUS2_MCP_ROM_PERR		 (1L<<3)
#define BNX2_MISC_PERR_STATUS2_MCP_SCPAD_PERR		 (1L<<4)
#define BNX2_MISC_PERR_STATUS2_HB_MEM_PERR		 (1L<<5)
#define BNX2_MISC_PERR_STATUS2_PCIE_REPLAY_PERR		 (1L<<6)

#define BNX2_MISC_LCPLL_CTRL0				0x00000950
#define BNX2_MISC_LCPLL_CTRL0_OAC			 (0x7L<<0)
#define BNX2_MISC_LCPLL_CTRL0_OAC_NEGTWENTY		 (0L<<0)
#define BNX2_MISC_LCPLL_CTRL0_OAC_ZERO			 (1L<<0)
#define BNX2_MISC_LCPLL_CTRL0_OAC_TWENTY		 (3L<<0)
#define BNX2_MISC_LCPLL_CTRL0_OAC_FORTY			 (7L<<0)
#define BNX2_MISC_LCPLL_CTRL0_ICP_CTRL			 (0x7L<<3)
#define BNX2_MISC_LCPLL_CTRL0_ICP_CTRL_360		 (0L<<3)
#define BNX2_MISC_LCPLL_CTRL0_ICP_CTRL_480		 (1L<<3)
#define BNX2_MISC_LCPLL_CTRL0_ICP_CTRL_600		 (3L<<3)
#define BNX2_MISC_LCPLL_CTRL0_ICP_CTRL_720		 (7L<<3)
#define BNX2_MISC_LCPLL_CTRL0_BIAS_CTRL			 (0x3L<<6)
#define BNX2_MISC_LCPLL_CTRL0_PLL_OBSERVE		 (0x7L<<8)
#define BNX2_MISC_LCPLL_CTRL0_VTH_CTRL			 (0x3L<<11)
#define BNX2_MISC_LCPLL_CTRL0_VTH_CTRL_0		 (0L<<11)
#define BNX2_MISC_LCPLL_CTRL0_VTH_CTRL_1		 (1L<<11)
#define BNX2_MISC_LCPLL_CTRL0_VTH_CTRL_2		 (2L<<11)
#define BNX2_MISC_LCPLL_CTRL0_PLLSEQSTART		 (1L<<13)
#define BNX2_MISC_LCPLL_CTRL0_RESERVED			 (1L<<14)
#define BNX2_MISC_LCPLL_CTRL0_CAPRETRY_EN		 (1L<<15)
#define BNX2_MISC_LCPLL_CTRL0_FREQMONITOR_EN		 (1L<<16)
#define BNX2_MISC_LCPLL_CTRL0_FREQDETRESTART_EN		 (1L<<17)
#define BNX2_MISC_LCPLL_CTRL0_FREQDETRETRY_EN		 (1L<<18)
#define BNX2_MISC_LCPLL_CTRL0_PLLFORCEFDONE_EN		 (1L<<19)
#define BNX2_MISC_LCPLL_CTRL0_PLLFORCEFDONE		 (1L<<20)
#define BNX2_MISC_LCPLL_CTRL0_PLLFORCEFPASS		 (1L<<21)
#define BNX2_MISC_LCPLL_CTRL0_PLLFORCECAPDONE_EN	 (1L<<22)
#define BNX2_MISC_LCPLL_CTRL0_PLLFORCECAPDONE		 (1L<<23)
#define BNX2_MISC_LCPLL_CTRL0_PLLFORCECAPPASS_EN	 (1L<<24)
#define BNX2_MISC_LCPLL_CTRL0_PLLFORCECAPPASS		 (1L<<25)
#define BNX2_MISC_LCPLL_CTRL0_CAPRESTART		 (1L<<26)
#define BNX2_MISC_LCPLL_CTRL0_CAPSELECTM_EN		 (1L<<27)

#define BNX2_MISC_LCPLL_CTRL1				0x00000954
#define BNX2_MISC_LCPLL_CTRL1_CAPSELECTM		 (0x1fL<<0)
#define BNX2_MISC_LCPLL_CTRL1_CAPFORCESLOWDOWN_EN	 (1L<<5)
#define BNX2_MISC_LCPLL_CTRL1_CAPFORCESLOWDOWN		 (1L<<6)
#define BNX2_MISC_LCPLL_CTRL1_SLOWDN_XOR		 (1L<<7)

#define BNX2_MISC_LCPLL_STATUS				0x00000958
#define BNX2_MISC_LCPLL_STATUS_FREQDONE_SM		 (1L<<0)
#define BNX2_MISC_LCPLL_STATUS_FREQPASS_SM		 (1L<<1)
#define BNX2_MISC_LCPLL_STATUS_PLLSEQDONE		 (1L<<2)
#define BNX2_MISC_LCPLL_STATUS_PLLSEQPASS		 (1L<<3)
#define BNX2_MISC_LCPLL_STATUS_PLLSTATE			 (0x7L<<4)
#define BNX2_MISC_LCPLL_STATUS_CAPSTATE			 (0x7L<<7)
#define BNX2_MISC_LCPLL_STATUS_CAPSELECT		 (0x1fL<<10)
#define BNX2_MISC_LCPLL_STATUS_SLOWDN_INDICATOR		 (1L<<15)
#define BNX2_MISC_LCPLL_STATUS_SLOWDN_INDICATOR_0	 (0L<<15)
#define BNX2_MISC_LCPLL_STATUS_SLOWDN_INDICATOR_1	 (1L<<15)

#define BNX2_MISC_OSCFUNDS_CTRL				0x0000095c
#define BNX2_MISC_OSCFUNDS_CTRL_FREQ_MON		 (1L<<5)
#define BNX2_MISC_OSCFUNDS_CTRL_FREQ_MON_OFF		 (0L<<5)
#define BNX2_MISC_OSCFUNDS_CTRL_FREQ_MON_ON		 (1L<<5)
#define BNX2_MISC_OSCFUNDS_CTRL_XTAL_ADJCM		 (0x3L<<6)
#define BNX2_MISC_OSCFUNDS_CTRL_XTAL_ADJCM_0		 (0L<<6)
#define BNX2_MISC_OSCFUNDS_CTRL_XTAL_ADJCM_1		 (1L<<6)
#define BNX2_MISC_OSCFUNDS_CTRL_XTAL_ADJCM_2		 (2L<<6)
#define BNX2_MISC_OSCFUNDS_CTRL_XTAL_ADJCM_3		 (3L<<6)
#define BNX2_MISC_OSCFUNDS_CTRL_ICBUF_ADJ		 (0x3L<<8)
#define BNX2_MISC_OSCFUNDS_CTRL_ICBUF_ADJ_0		 (0L<<8)
#define BNX2_MISC_OSCFUNDS_CTRL_ICBUF_ADJ_1		 (1L<<8)
#define BNX2_MISC_OSCFUNDS_CTRL_ICBUF_ADJ_2		 (2L<<8)
#define BNX2_MISC_OSCFUNDS_CTRL_ICBUF_ADJ_3		 (3L<<8)
#define BNX2_MISC_OSCFUNDS_CTRL_IAMP_ADJ		 (0x3L<<10)
#define BNX2_MISC_OSCFUNDS_CTRL_IAMP_ADJ_0		 (0L<<10)
#define BNX2_MISC_OSCFUNDS_CTRL_IAMP_ADJ_1		 (1L<<10)
#define BNX2_MISC_OSCFUNDS_CTRL_IAMP_ADJ_2		 (2L<<10)
#define BNX2_MISC_OSCFUNDS_CTRL_IAMP_ADJ_3		 (3L<<10)


/*
 *  nvm_reg definition
 *  offset: 0x6400
 */
#define BNX2_NVM_COMMAND				0x00006400
#define BNX2_NVM_COMMAND_RST				 (1L<<0)
#define BNX2_NVM_COMMAND_DONE				 (1L<<3)
#define BNX2_NVM_COMMAND_DOIT				 (1L<<4)
#define BNX2_NVM_COMMAND_WR				 (1L<<5)
#define BNX2_NVM_COMMAND_ERASE				 (1L<<6)
#define BNX2_NVM_COMMAND_FIRST				 (1L<<7)
#define BNX2_NVM_COMMAND_LAST				 (1L<<8)
#define BNX2_NVM_COMMAND_WREN				 (1L<<16)
#define BNX2_NVM_COMMAND_WRDI				 (1L<<17)
#define BNX2_NVM_COMMAND_EWSR				 (1L<<18)
#define BNX2_NVM_COMMAND_WRSR				 (1L<<19)
#define BNX2_NVM_COMMAND_RD_ID				 (1L<<20)
#define BNX2_NVM_COMMAND_RD_STATUS			 (1L<<21)
#define BNX2_NVM_COMMAND_MODE_256			 (1L<<22)

#define BNX2_NVM_STATUS					0x00006404
#define BNX2_NVM_STATUS_PI_FSM_STATE			 (0xfL<<0)
#define BNX2_NVM_STATUS_EE_FSM_STATE			 (0xfL<<4)
#define BNX2_NVM_STATUS_EQ_FSM_STATE			 (0xfL<<8)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_XI		 (0x1fL<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_IDLE_XI	 (0L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_CMD0_XI	 (1L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_CMD1_XI	 (2L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_CMD_FINISH0_XI	 (3L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_CMD_FINISH1_XI	 (4L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_ADDR0_XI	 (5L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_WRITE_DATA0_XI	 (6L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_WRITE_DATA1_XI	 (7L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_WRITE_DATA2_XI	 (8L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_READ_DATA0_XI	 (9L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_READ_DATA1_XI	 (10L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_READ_DATA2_XI	 (11L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_READ_STATUS_RDID0_XI	 (12L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_READ_STATUS_RDID1_XI	 (13L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_READ_STATUS_RDID2_XI	 (14L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_READ_STATUS_RDID3_XI	 (15L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_READ_STATUS_RDID4_XI	 (16L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_CHECK_BUSY0_XI	 (17L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_ST_WREN_XI	 (18L<<0)
#define BNX2_NVM_STATUS_SPI_FSM_STATE_SPI_WAIT_XI	 (19L<<0)

#define BNX2_NVM_WRITE					0x00006408
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE			 (0xffffffffL<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_BIT_BANG		 (0L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_EECLK		 (1L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_EEDATA		 (2L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_SCLK		 (4L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_CS_B		 (8L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_SO		 (16L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_SI		 (32L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_SI_XI		 (1L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_SO_XI		 (2L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_CS_B_XI		 (4L<<0)
#define BNX2_NVM_WRITE_NVM_WRITE_VALUE_SCLK_XI		 (8L<<0)

#define BNX2_NVM_ADDR					0x0000640c
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE			 (0xffffffL<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_BIT_BANG		 (0L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_EECLK		 (1L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_EEDATA		 (2L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_SCLK		 (4L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_CS_B		 (8L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_SO			 (16L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_SI			 (32L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_SI_XI		 (1L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_SO_XI		 (2L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_CS_B_XI		 (4L<<0)
#define BNX2_NVM_ADDR_NVM_ADDR_VALUE_SCLK_XI		 (8L<<0)

#define BNX2_NVM_READ					0x00006410
#define BNX2_NVM_READ_NVM_READ_VALUE			 (0xffffffffL<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_BIT_BANG		 (0L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_EECLK		 (1L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_EEDATA		 (2L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_SCLK		 (4L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_CS_B		 (8L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_SO			 (16L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_SI			 (32L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_SI_XI		 (1L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_SO_XI		 (2L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_CS_B_XI		 (4L<<0)
#define BNX2_NVM_READ_NVM_READ_VALUE_SCLK_XI		 (8L<<0)

#define BNX2_NVM_CFG1					0x00006414
#define BNX2_NVM_CFG1_FLASH_MODE			 (1L<<0)
#define BNX2_NVM_CFG1_BUFFER_MODE			 (1L<<1)
#define BNX2_NVM_CFG1_PASS_MODE				 (1L<<2)
#define BNX2_NVM_CFG1_BITBANG_MODE			 (1L<<3)
#define BNX2_NVM_CFG1_STATUS_BIT			 (0x7L<<4)
#define BNX2_NVM_CFG1_STATUS_BIT_FLASH_RDY		 (0L<<4)
#define BNX2_NVM_CFG1_STATUS_BIT_BUFFER_RDY		 (7L<<4)
#define BNX2_NVM_CFG1_SPI_CLK_DIV			 (0xfL<<7)
#define BNX2_NVM_CFG1_SEE_CLK_DIV			 (0x7ffL<<11)
#define BNX2_NVM_CFG1_STRAP_CONTROL_0			 (1L<<23)
#define BNX2_NVM_CFG1_PROTECT_MODE			 (1L<<24)
#define BNX2_NVM_CFG1_FLASH_SIZE			 (1L<<25)
#define BNX2_NVM_CFG1_FW_USTRAP_1			 (1L<<26)
#define BNX2_NVM_CFG1_FW_USTRAP_0			 (1L<<27)
#define BNX2_NVM_CFG1_FW_USTRAP_2			 (1L<<28)
#define BNX2_NVM_CFG1_FW_USTRAP_3			 (1L<<29)
#define BNX2_NVM_CFG1_FW_FLASH_TYPE_EN			 (1L<<30)
#define BNX2_NVM_CFG1_COMPAT_BYPASSS			 (1L<<31)

#define BNX2_NVM_CFG2					0x00006418
#define BNX2_NVM_CFG2_ERASE_CMD				 (0xffL<<0)
#define BNX2_NVM_CFG2_DUMMY				 (0xffL<<8)
#define BNX2_NVM_CFG2_STATUS_CMD			 (0xffL<<16)
#define BNX2_NVM_CFG2_READ_ID				 (0xffL<<24)

#define BNX2_NVM_CFG3					0x0000641c
#define BNX2_NVM_CFG3_BUFFER_RD_CMD			 (0xffL<<0)
#define BNX2_NVM_CFG3_WRITE_CMD				 (0xffL<<8)
#define BNX2_NVM_CFG3_BUFFER_WRITE_CMD			 (0xffL<<16)
#define BNX2_NVM_CFG3_READ_CMD				 (0xffL<<24)

#define BNX2_NVM_SW_ARB					0x00006420
#define BNX2_NVM_SW_ARB_ARB_REQ_SET0			 (1L<<0)
#define BNX2_NVM_SW_ARB_ARB_REQ_SET1			 (1L<<1)
#define BNX2_NVM_SW_ARB_ARB_REQ_SET2			 (1L<<2)
#define BNX2_NVM_SW_ARB_ARB_REQ_SET3			 (1L<<3)
#define BNX2_NVM_SW_ARB_ARB_REQ_CLR0			 (1L<<4)
#define BNX2_NVM_SW_ARB_ARB_REQ_CLR1			 (1L<<5)
#define BNX2_NVM_SW_ARB_ARB_REQ_CLR2			 (1L<<6)
#define BNX2_NVM_SW_ARB_ARB_REQ_CLR3			 (1L<<7)
#define BNX2_NVM_SW_ARB_ARB_ARB0			 (1L<<8)
#define BNX2_NVM_SW_ARB_ARB_ARB1			 (1L<<9)
#define BNX2_NVM_SW_ARB_ARB_ARB2			 (1L<<10)
#define BNX2_NVM_SW_ARB_ARB_ARB3			 (1L<<11)
#define BNX2_NVM_SW_ARB_REQ0				 (1L<<12)
#define BNX2_NVM_SW_ARB_REQ1				 (1L<<13)
#define BNX2_NVM_SW_ARB_REQ2				 (1L<<14)
#define BNX2_NVM_SW_ARB_REQ3				 (1L<<15)

#define BNX2_NVM_ACCESS_ENABLE				0x00006424
#define BNX2_NVM_ACCESS_ENABLE_EN			 (1L<<0)
#define BNX2_NVM_ACCESS_ENABLE_WR_EN			 (1L<<1)

#define BNX2_NVM_WRITE1					0x00006428
#define BNX2_NVM_WRITE1_WREN_CMD			 (0xffL<<0)
#define BNX2_NVM_WRITE1_WRDI_CMD			 (0xffL<<8)
#define BNX2_NVM_WRITE1_SR_DATA				 (0xffL<<16)

#define BNX2_NVM_CFG4					0x0000642c
#define BNX2_NVM_CFG4_FLASH_SIZE			 (0x7L<<0)
#define BNX2_NVM_CFG4_FLASH_SIZE_1MBIT			 (0L<<0)
#define BNX2_NVM_CFG4_FLASH_SIZE_2MBIT			 (1L<<0)
#define BNX2_NVM_CFG4_FLASH_SIZE_4MBIT			 (2L<<0)
#define BNX2_NVM_CFG4_FLASH_SIZE_8MBIT			 (3L<<0)
#define BNX2_NVM_CFG4_FLASH_SIZE_16MBIT			 (4L<<0)
#define BNX2_NVM_CFG4_FLASH_SIZE_32MBIT			 (5L<<0)
#define BNX2_NVM_CFG4_FLASH_SIZE_64MBIT			 (6L<<0)
#define BNX2_NVM_CFG4_FLASH_SIZE_128MBIT		 (7L<<0)
#define BNX2_NVM_CFG4_FLASH_VENDOR			 (1L<<3)
#define BNX2_NVM_CFG4_FLASH_VENDOR_ST			 (0L<<3)
#define BNX2_NVM_CFG4_FLASH_VENDOR_ATMEL		 (1L<<3)
#define BNX2_NVM_CFG4_MODE_256_EMPTY_BIT_LOC		 (0x3L<<4)
#define BNX2_NVM_CFG4_MODE_256_EMPTY_BIT_LOC_BIT8	 (0L<<4)
#define BNX2_NVM_CFG4_MODE_256_EMPTY_BIT_LOC_BIT9	 (1L<<4)
#define BNX2_NVM_CFG4_MODE_256_EMPTY_BIT_LOC_BIT10	 (2L<<4)
#define BNX2_NVM_CFG4_MODE_256_EMPTY_BIT_LOC_BIT11	 (3L<<4)
#define BNX2_NVM_CFG4_STATUS_BIT_POLARITY		 (1L<<6)
#define BNX2_NVM_CFG4_RESERVED				 (0x1ffffffL<<7)

#define BNX2_NVM_RECONFIG				0x00006430
#define BNX2_NVM_RECONFIG_ORIG_STRAP_VALUE		 (0xfL<<0)
#define BNX2_NVM_RECONFIG_ORIG_STRAP_VALUE_ST		 (0L<<0)
#define BNX2_NVM_RECONFIG_ORIG_STRAP_VALUE_ATMEL	 (1L<<0)
#define BNX2_NVM_RECONFIG_RECONFIG_STRAP_VALUE		 (0xfL<<4)
#define BNX2_NVM_RECONFIG_RESERVED			 (0x7fffffL<<8)
#define BNX2_NVM_RECONFIG_RECONFIG_DONE			 (1L<<31)



/*
 *  dma_reg definition
 *  offset: 0xc00
 */
#define BNX2_DMA_COMMAND				0x00000c00
#define BNX2_DMA_COMMAND_ENABLE				 (1L<<0)

#define BNX2_DMA_STATUS					0x00000c04
#define BNX2_DMA_STATUS_PAR_ERROR_STATE			 (1L<<0)
#define BNX2_DMA_STATUS_READ_TRANSFERS_STAT		 (1L<<16)
#define BNX2_DMA_STATUS_READ_DELAY_PCI_CLKS_STAT	 (1L<<17)
#define BNX2_DMA_STATUS_BIG_READ_TRANSFERS_STAT		 (1L<<18)
#define BNX2_DMA_STATUS_BIG_READ_DELAY_PCI_CLKS_STAT	 (1L<<19)
#define BNX2_DMA_STATUS_BIG_READ_RETRY_AFTER_DATA_STAT	 (1L<<20)
#define BNX2_DMA_STATUS_WRITE_TRANSFERS_STAT		 (1L<<21)
#define BNX2_DMA_STATUS_WRITE_DELAY_PCI_CLKS_STAT	 (1L<<22)
#define BNX2_DMA_STATUS_BIG_WRITE_TRANSFERS_STAT	 (1L<<23)
#define BNX2_DMA_STATUS_BIG_WRITE_DELAY_PCI_CLKS_STAT	 (1L<<24)
#define BNX2_DMA_STATUS_BIG_WRITE_RETRY_AFTER_DATA_STAT	 (1L<<25)
#define BNX2_DMA_STATUS_GLOBAL_ERR_XI			 (1L<<0)
#define BNX2_DMA_STATUS_BME_XI				 (1L<<4)

#define BNX2_DMA_CONFIG					0x00000c08
#define BNX2_DMA_CONFIG_DATA_BYTE_SWAP			 (1L<<0)
#define BNX2_DMA_CONFIG_DATA_WORD_SWAP			 (1L<<1)
#define BNX2_DMA_CONFIG_CNTL_BYTE_SWAP			 (1L<<4)
#define BNX2_DMA_CONFIG_CNTL_WORD_SWAP			 (1L<<5)
#define BNX2_DMA_CONFIG_ONE_DMA				 (1L<<6)
#define BNX2_DMA_CONFIG_CNTL_TWO_DMA			 (1L<<7)
#define BNX2_DMA_CONFIG_CNTL_FPGA_MODE			 (1L<<8)
#define BNX2_DMA_CONFIG_CNTL_PING_PONG_DMA		 (1L<<10)
#define BNX2_DMA_CONFIG_CNTL_PCI_COMP_DLY		 (1L<<11)
#define BNX2_DMA_CONFIG_NO_RCHANS_IN_USE		 (0xfL<<12)
#define BNX2_DMA_CONFIG_NO_WCHANS_IN_USE		 (0xfL<<16)
#define BNX2_DMA_CONFIG_PCI_CLK_CMP_BITS		 (0x7L<<20)
#define BNX2_DMA_CONFIG_PCI_FAST_CLK_CMP		 (1L<<23)
#define BNX2_DMA_CONFIG_BIG_SIZE			 (0xfL<<24)
#define BNX2_DMA_CONFIG_BIG_SIZE_NONE			 (0x0L<<24)
#define BNX2_DMA_CONFIG_BIG_SIZE_64			 (0x1L<<24)
#define BNX2_DMA_CONFIG_BIG_SIZE_128			 (0x2L<<24)
#define BNX2_DMA_CONFIG_BIG_SIZE_256			 (0x4L<<24)
#define BNX2_DMA_CONFIG_BIG_SIZE_512			 (0x8L<<24)
#define BNX2_DMA_CONFIG_DAT_WBSWAP_MODE_XI		 (0x3L<<0)
#define BNX2_DMA_CONFIG_CTL_WBSWAP_MODE_XI		 (0x3L<<4)
#define BNX2_DMA_CONFIG_MAX_PL_XI			 (0x7L<<12)
#define BNX2_DMA_CONFIG_MAX_PL_128B_XI			 (0L<<12)
#define BNX2_DMA_CONFIG_MAX_PL_256B_XI			 (1L<<12)
#define BNX2_DMA_CONFIG_MAX_PL_512B_XI			 (2L<<12)
#define BNX2_DMA_CONFIG_MAX_PL_EN_XI			 (1L<<15)
#define BNX2_DMA_CONFIG_MAX_RRS_XI			 (0x7L<<16)
#define BNX2_DMA_CONFIG_MAX_RRS_128B_XI			 (0L<<16)
#define BNX2_DMA_CONFIG_MAX_RRS_256B_XI			 (1L<<16)
#define BNX2_DMA_CONFIG_MAX_RRS_512B_XI			 (2L<<16)
#define BNX2_DMA_CONFIG_MAX_RRS_1024B_XI		 (3L<<16)
#define BNX2_DMA_CONFIG_MAX_RRS_2048B_XI		 (4L<<16)
#define BNX2_DMA_CONFIG_MAX_RRS_4096B_XI		 (5L<<16)
#define BNX2_DMA_CONFIG_MAX_RRS_EN_XI			 (1L<<19)
#define BNX2_DMA_CONFIG_NO_64SWAP_EN_XI			 (1L<<31)

#define BNX2_DMA_BLACKOUT				0x00000c0c
#define BNX2_DMA_BLACKOUT_RD_RETRY_BLACKOUT		 (0xffL<<0)
#define BNX2_DMA_BLACKOUT_2ND_RD_RETRY_BLACKOUT		 (0xffL<<8)
#define BNX2_DMA_BLACKOUT_WR_RETRY_BLACKOUT		 (0xffL<<16)

#define BNX2_DMA_READ_MASTER_SETTING_0			0x00000c10
#define BNX2_DMA_READ_MASTER_SETTING_0_TBDC_NO_SNOOP	 (1L<<0)
#define BNX2_DMA_READ_MASTER_SETTING_0_TBDC_RELAX_ORDER	 (1L<<1)
#define BNX2_DMA_READ_MASTER_SETTING_0_TBDC_PRIORITY	 (1L<<2)
#define BNX2_DMA_READ_MASTER_SETTING_0_TBDC_TRAFFIC_CLASS	 (0x7L<<4)
#define BNX2_DMA_READ_MASTER_SETTING_0_TBDC_PARAM_EN	 (1L<<7)
#define BNX2_DMA_READ_MASTER_SETTING_0_RBDC_NO_SNOOP	 (1L<<8)
#define BNX2_DMA_READ_MASTER_SETTING_0_RBDC_RELAX_ORDER	 (1L<<9)
#define BNX2_DMA_READ_MASTER_SETTING_0_RBDC_PRIORITY	 (1L<<10)
#define BNX2_DMA_READ_MASTER_SETTING_0_RBDC_TRAFFIC_CLASS	 (0x7L<<12)
#define BNX2_DMA_READ_MASTER_SETTING_0_RBDC_PARAM_EN	 (1L<<15)
#define BNX2_DMA_READ_MASTER_SETTING_0_TDMA_NO_SNOOP	 (1L<<16)
#define BNX2_DMA_READ_MASTER_SETTING_0_TDMA_RELAX_ORDER	 (1L<<17)
#define BNX2_DMA_READ_MASTER_SETTING_0_TDMA_PRIORITY	 (1L<<18)
#define BNX2_DMA_READ_MASTER_SETTING_0_TDMA_TRAFFIC_CLASS	 (0x7L<<20)
#define BNX2_DMA_READ_MASTER_SETTING_0_TDMA_PARAM_EN	 (1L<<23)
#define BNX2_DMA_READ_MASTER_SETTING_0_CTX_NO_SNOOP	 (1L<<24)
#define BNX2_DMA_READ_MASTER_SETTING_0_CTX_RELAX_ORDER	 (1L<<25)
#define BNX2_DMA_READ_MASTER_SETTING_0_CTX_PRIORITY	 (1L<<26)
#define BNX2_DMA_READ_MASTER_SETTING_0_CTX_TRAFFIC_CLASS	 (0x7L<<28)
#define BNX2_DMA_READ_MASTER_SETTING_0_CTX_PARAM_EN	 (1L<<31)

#define BNX2_DMA_READ_MASTER_SETTING_1			0x00000c14
#define BNX2_DMA_READ_MASTER_SETTING_1_COM_NO_SNOOP	 (1L<<0)
#define BNX2_DMA_READ_MASTER_SETTING_1_COM_RELAX_ORDER	 (1L<<1)
#define BNX2_DMA_READ_MASTER_SETTING_1_COM_PRIORITY	 (1L<<2)
#define BNX2_DMA_READ_MASTER_SETTING_1_COM_TRAFFIC_CLASS	 (0x7L<<4)
#define BNX2_DMA_READ_MASTER_SETTING_1_COM_PARAM_EN	 (1L<<7)
#define BNX2_DMA_READ_MASTER_SETTING_1_CP_NO_SNOOP	 (1L<<8)
#define BNX2_DMA_READ_MASTER_SETTING_1_CP_RELAX_ORDER	 (1L<<9)
#define BNX2_DMA_READ_MASTER_SETTING_1_CP_PRIORITY	 (1L<<10)
#define BNX2_DMA_READ_MASTER_SETTING_1_CP_TRAFFIC_CLASS	 (0x7L<<12)
#define BNX2_DMA_READ_MASTER_SETTING_1_CP_PARAM_EN	 (1L<<15)

#define BNX2_DMA_WRITE_MASTER_SETTING_0			0x00000c18
#define BNX2_DMA_WRITE_MASTER_SETTING_0_HC_NO_SNOOP	 (1L<<0)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_HC_RELAX_ORDER	 (1L<<1)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_HC_PRIORITY	 (1L<<2)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_HC_CS_VLD	 (1L<<3)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_HC_TRAFFIC_CLASS	 (0x7L<<4)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_HC_PARAM_EN	 (1L<<7)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_RDMA_NO_SNOOP	 (1L<<8)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_RDMA_RELAX_ORDER	 (1L<<9)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_RDMA_PRIORITY	 (1L<<10)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_RDMA_CS_VLD	 (1L<<11)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_RDMA_TRAFFIC_CLASS	 (0x7L<<12)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_RDMA_PARAM_EN	 (1L<<15)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_CTX_NO_SNOOP	 (1L<<24)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_CTX_RELAX_ORDER	 (1L<<25)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_CTX_PRIORITY	 (1L<<26)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_CTX_CS_VLD	 (1L<<27)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_CTX_TRAFFIC_CLASS	 (0x7L<<28)
#define BNX2_DMA_WRITE_MASTER_SETTING_0_CTX_PARAM_EN	 (1L<<31)

#define BNX2_DMA_WRITE_MASTER_SETTING_1			0x00000c1c
#define BNX2_DMA_WRITE_MASTER_SETTING_1_COM_NO_SNOOP	 (1L<<0)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_COM_RELAX_ORDER	 (1L<<1)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_COM_PRIORITY	 (1L<<2)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_COM_CS_VLD	 (1L<<3)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_COM_TRAFFIC_CLASS	 (0x7L<<4)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_COM_PARAM_EN	 (1L<<7)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_CP_NO_SNOOP	 (1L<<8)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_CP_RELAX_ORDER	 (1L<<9)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_CP_PRIORITY	 (1L<<10)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_CP_CS_VLD	 (1L<<11)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_CP_TRAFFIC_CLASS	 (0x7L<<12)
#define BNX2_DMA_WRITE_MASTER_SETTING_1_CP_PARAM_EN	 (1L<<15)

#define BNX2_DMA_ARBITER				0x00000c20
#define BNX2_DMA_ARBITER_NUM_READS			 (0x7L<<0)
#define BNX2_DMA_ARBITER_WR_ARB_MODE			 (1L<<4)
#define BNX2_DMA_ARBITER_WR_ARB_MODE_STRICT		 (0L<<4)
#define BNX2_DMA_ARBITER_WR_ARB_MODE_RND_RBN		 (1L<<4)
#define BNX2_DMA_ARBITER_RD_ARB_MODE			 (0x3L<<5)
#define BNX2_DMA_ARBITER_RD_ARB_MODE_STRICT		 (0L<<5)
#define BNX2_DMA_ARBITER_RD_ARB_MODE_RND_RBN		 (1L<<5)
#define BNX2_DMA_ARBITER_RD_ARB_MODE_WGT_RND_RBN	 (2L<<5)
#define BNX2_DMA_ARBITER_ALT_MODE_EN			 (1L<<8)
#define BNX2_DMA_ARBITER_RR_MODE			 (1L<<9)
#define BNX2_DMA_ARBITER_TIMER_MODE			 (1L<<10)
#define BNX2_DMA_ARBITER_OUSTD_READ_REQ			 (0xfL<<12)

#define BNX2_DMA_ARB_TIMERS				0x00000c24
#define BNX2_DMA_ARB_TIMERS_RD_DRR_WAIT_TIME		 (0xffL<<0)
#define BNX2_DMA_ARB_TIMERS_TM_MIN_TIMEOUT		 (0xffL<<12)
#define BNX2_DMA_ARB_TIMERS_TM_MAX_TIMEOUT		 (0xfffL<<20)

#define BNX2_DMA_DEBUG_VECT_PEEK			0x00000c2c
#define BNX2_DMA_DEBUG_VECT_PEEK_1_VALUE		 (0x7ffL<<0)
#define BNX2_DMA_DEBUG_VECT_PEEK_1_PEEK_EN		 (1L<<11)
#define BNX2_DMA_DEBUG_VECT_PEEK_1_SEL			 (0xfL<<12)
#define BNX2_DMA_DEBUG_VECT_PEEK_2_VALUE		 (0x7ffL<<16)
#define BNX2_DMA_DEBUG_VECT_PEEK_2_PEEK_EN		 (1L<<27)
#define BNX2_DMA_DEBUG_VECT_PEEK_2_SEL			 (0xfL<<28)

#define BNX2_DMA_TAG_RAM_00				0x00000c30
#define BNX2_DMA_TAG_RAM_00_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_00_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_00_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_00_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_00_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_00_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_00_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_00_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_00_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_00_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_00_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_00_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_00_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_00_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_01				0x00000c34
#define BNX2_DMA_TAG_RAM_01_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_01_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_01_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_01_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_01_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_01_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_01_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_01_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_01_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_01_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_01_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_01_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_01_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_01_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_02				0x00000c38
#define BNX2_DMA_TAG_RAM_02_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_02_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_02_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_02_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_02_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_02_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_02_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_02_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_02_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_02_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_02_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_02_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_02_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_02_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_03				0x00000c3c
#define BNX2_DMA_TAG_RAM_03_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_03_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_03_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_03_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_03_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_03_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_03_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_03_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_03_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_03_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_03_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_03_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_03_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_03_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_04				0x00000c40
#define BNX2_DMA_TAG_RAM_04_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_04_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_04_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_04_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_04_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_04_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_04_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_04_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_04_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_04_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_04_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_04_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_04_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_04_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_05				0x00000c44
#define BNX2_DMA_TAG_RAM_05_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_05_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_05_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_05_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_05_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_05_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_05_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_05_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_05_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_05_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_05_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_05_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_05_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_05_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_06				0x00000c48
#define BNX2_DMA_TAG_RAM_06_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_06_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_06_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_06_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_06_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_06_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_06_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_06_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_06_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_06_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_06_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_06_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_06_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_06_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_07				0x00000c4c
#define BNX2_DMA_TAG_RAM_07_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_07_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_07_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_07_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_07_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_07_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_07_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_07_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_07_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_07_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_07_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_07_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_07_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_07_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_08				0x00000c50
#define BNX2_DMA_TAG_RAM_08_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_08_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_08_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_08_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_08_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_08_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_08_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_08_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_08_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_08_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_08_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_08_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_08_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_08_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_09				0x00000c54
#define BNX2_DMA_TAG_RAM_09_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_09_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_09_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_09_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_09_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_09_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_09_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_09_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_09_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_09_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_09_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_09_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_09_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_09_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_10				0x00000c58
#define BNX2_DMA_TAG_RAM_10_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_10_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_10_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_10_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_10_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_10_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_10_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_10_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_10_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_10_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_10_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_10_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_10_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_10_VALID			 (1L<<10)

#define BNX2_DMA_TAG_RAM_11				0x00000c5c
#define BNX2_DMA_TAG_RAM_11_CHANNEL			 (0xfL<<0)
#define BNX2_DMA_TAG_RAM_11_MASTER			 (0x7L<<4)
#define BNX2_DMA_TAG_RAM_11_MASTER_CTX			 (0L<<4)
#define BNX2_DMA_TAG_RAM_11_MASTER_RBDC			 (1L<<4)
#define BNX2_DMA_TAG_RAM_11_MASTER_TBDC			 (2L<<4)
#define BNX2_DMA_TAG_RAM_11_MASTER_COM			 (3L<<4)
#define BNX2_DMA_TAG_RAM_11_MASTER_CP			 (4L<<4)
#define BNX2_DMA_TAG_RAM_11_MASTER_TDMA			 (5L<<4)
#define BNX2_DMA_TAG_RAM_11_SWAP			 (0x3L<<7)
#define BNX2_DMA_TAG_RAM_11_SWAP_CONFIG			 (0L<<7)
#define BNX2_DMA_TAG_RAM_11_SWAP_DATA			 (1L<<7)
#define BNX2_DMA_TAG_RAM_11_SWAP_CONTROL		 (2L<<7)
#define BNX2_DMA_TAG_RAM_11_FUNCTION			 (1L<<9)
#define BNX2_DMA_TAG_RAM_11_VALID			 (1L<<10)

#define BNX2_DMA_RCHAN_STAT_22				0x00000c60
#define BNX2_DMA_RCHAN_STAT_30				0x00000c64
#define BNX2_DMA_RCHAN_STAT_31				0x00000c68
#define BNX2_DMA_RCHAN_STAT_32				0x00000c6c
#define BNX2_DMA_RCHAN_STAT_40				0x00000c70
#define BNX2_DMA_RCHAN_STAT_41				0x00000c74
#define BNX2_DMA_RCHAN_STAT_42				0x00000c78
#define BNX2_DMA_RCHAN_STAT_50				0x00000c7c
#define BNX2_DMA_RCHAN_STAT_51				0x00000c80
#define BNX2_DMA_RCHAN_STAT_52				0x00000c84
#define BNX2_DMA_RCHAN_STAT_60				0x00000c88
#define BNX2_DMA_RCHAN_STAT_61				0x00000c8c
#define BNX2_DMA_RCHAN_STAT_62				0x00000c90
#define BNX2_DMA_RCHAN_STAT_70				0x00000c94
#define BNX2_DMA_RCHAN_STAT_71				0x00000c98
#define BNX2_DMA_RCHAN_STAT_72				0x00000c9c
#define BNX2_DMA_WCHAN_STAT_00				0x00000ca0
#define BNX2_DMA_WCHAN_STAT_00_WCHAN_STA_HOST_ADDR_LOW	 (0xffffffffL<<0)

#define BNX2_DMA_WCHAN_STAT_01				0x00000ca4
#define BNX2_DMA_WCHAN_STAT_01_WCHAN_STA_HOST_ADDR_HIGH	 (0xffffffffL<<0)

#define BNX2_DMA_WCHAN_STAT_02				0x00000ca8
#define BNX2_DMA_WCHAN_STAT_02_LENGTH			 (0xffffL<<0)
#define BNX2_DMA_WCHAN_STAT_02_WORD_SWAP		 (1L<<16)
#define BNX2_DMA_WCHAN_STAT_02_BYTE_SWAP		 (1L<<17)
#define BNX2_DMA_WCHAN_STAT_02_PRIORITY_LVL		 (1L<<18)

#define BNX2_DMA_WCHAN_STAT_10				0x00000cac
#define BNX2_DMA_WCHAN_STAT_11				0x00000cb0
#define BNX2_DMA_WCHAN_STAT_12				0x00000cb4
#define BNX2_DMA_WCHAN_STAT_20				0x00000cb8
#define BNX2_DMA_WCHAN_STAT_21				0x00000cbc
#define BNX2_DMA_WCHAN_STAT_22				0x00000cc0
#define BNX2_DMA_WCHAN_STAT_30				0x00000cc4
#define BNX2_DMA_WCHAN_STAT_31				0x00000cc8
#define BNX2_DMA_WCHAN_STAT_32				0x00000ccc
#define BNX2_DMA_WCHAN_STAT_40				0x00000cd0
#define BNX2_DMA_WCHAN_STAT_41				0x00000cd4
#define BNX2_DMA_WCHAN_STAT_42				0x00000cd8
#define BNX2_DMA_WCHAN_STAT_50				0x00000cdc
#define BNX2_DMA_WCHAN_STAT_51				0x00000ce0
#define BNX2_DMA_WCHAN_STAT_52				0x00000ce4
#define BNX2_DMA_WCHAN_STAT_60				0x00000ce8
#define BNX2_DMA_WCHAN_STAT_61				0x00000cec
#define BNX2_DMA_WCHAN_STAT_62				0x00000cf0
#define BNX2_DMA_WCHAN_STAT_70				0x00000cf4
#define BNX2_DMA_WCHAN_STAT_71				0x00000cf8
#define BNX2_DMA_WCHAN_STAT_72				0x00000cfc
#define BNX2_DMA_ARB_STAT_00				0x00000d00
#define BNX2_DMA_ARB_STAT_00_MASTER			 (0xffffL<<0)
#define BNX2_DMA_ARB_STAT_00_MASTER_ENC			 (0xffL<<16)
#define BNX2_DMA_ARB_STAT_00_CUR_BINMSTR		 (0xffL<<24)

#define BNX2_DMA_ARB_STAT_01				0x00000d04
#define BNX2_DMA_ARB_STAT_01_LPR_RPTR			 (0xfL<<0)
#define BNX2_DMA_ARB_STAT_01_LPR_WPTR			 (0xfL<<4)
#define BNX2_DMA_ARB_STAT_01_LPB_RPTR			 (0xfL<<8)
#define BNX2_DMA_ARB_STAT_01_LPB_WPTR			 (0xfL<<12)
#define BNX2_DMA_ARB_STAT_01_HPR_RPTR			 (0xfL<<16)
#define BNX2_DMA_ARB_STAT_01_HPR_WPTR			 (0xfL<<20)
#define BNX2_DMA_ARB_STAT_01_HPB_RPTR			 (0xfL<<24)
#define BNX2_DMA_ARB_STAT_01_HPB_WPTR			 (0xfL<<28)

#define BNX2_DMA_FUSE_CTRL0_CMD				0x00000f00
#define BNX2_DMA_FUSE_CTRL0_CMD_PWRUP_DONE		 (1L<<0)
#define BNX2_DMA_FUSE_CTRL0_CMD_SHIFT_DONE		 (1L<<1)
#define BNX2_DMA_FUSE_CTRL0_CMD_SHIFT			 (1L<<2)
#define BNX2_DMA_FUSE_CTRL0_CMD_LOAD			 (1L<<3)
#define BNX2_DMA_FUSE_CTRL0_CMD_SEL			 (0xfL<<8)

#define BNX2_DMA_FUSE_CTRL0_DATA			0x00000f04
#define BNX2_DMA_FUSE_CTRL1_CMD				0x00000f08
#define BNX2_DMA_FUSE_CTRL1_CMD_PWRUP_DONE		 (1L<<0)
#define BNX2_DMA_FUSE_CTRL1_CMD_SHIFT_DONE		 (1L<<1)
#define BNX2_DMA_FUSE_CTRL1_CMD_SHIFT			 (1L<<2)
#define BNX2_DMA_FUSE_CTRL1_CMD_LOAD			 (1L<<3)
#define BNX2_DMA_FUSE_CTRL1_CMD_SEL			 (0xfL<<8)

#define BNX2_DMA_FUSE_CTRL1_DATA			0x00000f0c
#define BNX2_DMA_FUSE_CTRL2_CMD				0x00000f10
#define BNX2_DMA_FUSE_CTRL2_CMD_PWRUP_DONE		 (1L<<0)
#define BNX2_DMA_FUSE_CTRL2_CMD_SHIFT_DONE		 (1L<<1)
#define BNX2_DMA_FUSE_CTRL2_CMD_SHIFT			 (1L<<2)
#define BNX2_DMA_FUSE_CTRL2_CMD_LOAD			 (1L<<3)
#define BNX2_DMA_FUSE_CTRL2_CMD_SEL			 (0xfL<<8)

#define BNX2_DMA_FUSE_CTRL2_DATA			0x00000f14


/*
 *  context_reg definition
 *  offset: 0x1000
 */
#define BNX2_CTX_COMMAND				0x00001000
#define BNX2_CTX_COMMAND_ENABLED			 (1L<<0)
#define BNX2_CTX_COMMAND_DISABLE_USAGE_CNT		 (1L<<1)
#define BNX2_CTX_COMMAND_DISABLE_PLRU			 (1L<<2)
#define BNX2_CTX_COMMAND_DISABLE_COMBINE_READ		 (1L<<3)
#define BNX2_CTX_COMMAND_FLUSH_AHEAD			 (0x1fL<<8)
#define BNX2_CTX_COMMAND_MEM_INIT			 (1L<<13)
#define BNX2_CTX_COMMAND_PAGE_SIZE			 (0xfL<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_256			 (0L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_512			 (1L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_1K			 (2L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_2K			 (3L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_4K			 (4L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_8K			 (5L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_16K			 (6L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_32K			 (7L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_64K			 (8L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_128K			 (9L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_256K			 (10L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_512K			 (11L<<16)
#define BNX2_CTX_COMMAND_PAGE_SIZE_1M			 (12L<<16)

#define BNX2_CTX_STATUS					0x00001004
#define BNX2_CTX_STATUS_LOCK_WAIT			 (1L<<0)
#define BNX2_CTX_STATUS_READ_STAT			 (1L<<16)
#define BNX2_CTX_STATUS_WRITE_STAT			 (1L<<17)
#define BNX2_CTX_STATUS_ACC_STALL_STAT			 (1L<<18)
#define BNX2_CTX_STATUS_LOCK_STALL_STAT			 (1L<<19)
#define BNX2_CTX_STATUS_EXT_READ_STAT			 (1L<<20)
#define BNX2_CTX_STATUS_EXT_WRITE_STAT			 (1L<<21)
#define BNX2_CTX_STATUS_MISS_STAT			 (1L<<22)
#define BNX2_CTX_STATUS_HIT_STAT			 (1L<<23)
#define BNX2_CTX_STATUS_DEAD_LOCK			 (1L<<24)
#define BNX2_CTX_STATUS_USAGE_CNT_ERR			 (1L<<25)
#define BNX2_CTX_STATUS_INVALID_PAGE			 (1L<<26)

#define BNX2_CTX_VIRT_ADDR				0x00001008
#define BNX2_CTX_VIRT_ADDR_VIRT_ADDR			 (0x7fffL<<6)

#define BNX2_CTX_PAGE_TBL				0x0000100c
#define BNX2_CTX_PAGE_TBL_PAGE_TBL			 (0x3fffL<<6)

#define BNX2_CTX_DATA_ADR				0x00001010
#define BNX2_CTX_DATA_ADR_DATA_ADR			 (0x7ffffL<<2)

#define BNX2_CTX_DATA					0x00001014
#define BNX2_CTX_LOCK					0x00001018
#define BNX2_CTX_LOCK_TYPE				 (0x7L<<0)
#define BNX2_CTX_LOCK_TYPE_LOCK_TYPE_VOID		 (0x0L<<0)
#define BNX2_CTX_LOCK_TYPE_LOCK_TYPE_PROTOCOL		 (0x1L<<0)
#define BNX2_CTX_LOCK_TYPE_LOCK_TYPE_TX			 (0x2L<<0)
#define BNX2_CTX_LOCK_TYPE_LOCK_TYPE_TIMER		 (0x4L<<0)
#define BNX2_CTX_LOCK_TYPE_LOCK_TYPE_COMPLETE		 (0x7L<<0)
#define BNX2_CTX_LOCK_TYPE_VOID_XI			 (0L<<0)
#define BNX2_CTX_LOCK_TYPE_PROTOCOL_XI			 (1L<<0)
#define BNX2_CTX_LOCK_TYPE_TX_XI			 (2L<<0)
#define BNX2_CTX_LOCK_TYPE_TIMER_XI			 (4L<<0)
#define BNX2_CTX_LOCK_TYPE_COMPLETE_XI			 (7L<<0)
#define BNX2_CTX_LOCK_CID_VALUE				 (0x3fffL<<7)
#define BNX2_CTX_LOCK_GRANTED				 (1L<<26)
#define BNX2_CTX_LOCK_MODE				 (0x7L<<27)
#define BNX2_CTX_LOCK_MODE_UNLOCK			 (0x0L<<27)
#define BNX2_CTX_LOCK_MODE_IMMEDIATE			 (0x1L<<27)
#define BNX2_CTX_LOCK_MODE_SURE				 (0x2L<<27)
#define BNX2_CTX_LOCK_STATUS				 (1L<<30)
#define BNX2_CTX_LOCK_REQ				 (1L<<31)

#define BNX2_CTX_CTX_CTRL				0x0000101c
#define BNX2_CTX_CTX_CTRL_CTX_ADDR			 (0x7ffffL<<2)
#define BNX2_CTX_CTX_CTRL_MOD_USAGE_CNT			 (0x3L<<21)
#define BNX2_CTX_CTX_CTRL_NO_RAM_ACC			 (1L<<23)
#define BNX2_CTX_CTX_CTRL_PREFETCH_SIZE			 (0x3L<<24)
#define BNX2_CTX_CTX_CTRL_ATTR				 (1L<<26)
#define BNX2_CTX_CTX_CTRL_WRITE_REQ			 (1L<<30)
#define BNX2_CTX_CTX_CTRL_READ_REQ			 (1L<<31)

#define BNX2_CTX_CTX_DATA				0x00001020
#define BNX2_CTX_ACCESS_STATUS				0x00001040
#define BNX2_CTX_ACCESS_STATUS_MASTERENCODED		 (0xfL<<0)
#define BNX2_CTX_ACCESS_STATUS_ACCESSMEMORYSM		 (0x3L<<10)
#define BNX2_CTX_ACCESS_STATUS_PAGETABLEINITSM		 (0x3L<<12)
#define BNX2_CTX_ACCESS_STATUS_ACCESSMEMORYINITSM	 (0x3L<<14)
#define BNX2_CTX_ACCESS_STATUS_QUALIFIED_REQUEST	 (0x7ffL<<17)
#define BNX2_CTX_ACCESS_STATUS_CAMMASTERENCODED_XI	 (0x1fL<<0)
#define BNX2_CTX_ACCESS_STATUS_CACHEMASTERENCODED_XI	 (0x1fL<<5)
#define BNX2_CTX_ACCESS_STATUS_REQUEST_XI		 (0x3fffffL<<10)

#define BNX2_CTX_DBG_LOCK_STATUS			0x00001044
#define BNX2_CTX_DBG_LOCK_STATUS_SM			 (0x3ffL<<0)
#define BNX2_CTX_DBG_LOCK_STATUS_MATCH			 (0x3ffL<<22)

#define BNX2_CTX_CACHE_CTRL_STATUS			0x00001048
#define BNX2_CTX_CACHE_CTRL_STATUS_RFIFO_OVERFLOW	 (1L<<0)
#define BNX2_CTX_CACHE_CTRL_STATUS_INVALID_READ_COMP	 (1L<<1)
#define BNX2_CTX_CACHE_CTRL_STATUS_FLUSH_START		 (1L<<6)
#define BNX2_CTX_CACHE_CTRL_STATUS_FREE_ENTRY_CNT	 (0x3fL<<7)
#define BNX2_CTX_CACHE_CTRL_STATUS_CACHE_ENTRY_NEEDED	 (0x3fL<<13)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN0_ACTIVE	 (1L<<19)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN1_ACTIVE	 (1L<<20)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN2_ACTIVE	 (1L<<21)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN3_ACTIVE	 (1L<<22)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN4_ACTIVE	 (1L<<23)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN5_ACTIVE	 (1L<<24)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN6_ACTIVE	 (1L<<25)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN7_ACTIVE	 (1L<<26)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN8_ACTIVE	 (1L<<27)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN9_ACTIVE	 (1L<<28)
#define BNX2_CTX_CACHE_CTRL_STATUS_RD_CHAN10_ACTIVE	 (1L<<29)

#define BNX2_CTX_CACHE_CTRL_SM_STATUS			0x0000104c
#define BNX2_CTX_CACHE_CTRL_SM_STATUS_CS_DWC		 (0x7L<<0)
#define BNX2_CTX_CACHE_CTRL_SM_STATUS_CS_WFIFOC		 (0x7L<<3)
#define BNX2_CTX_CACHE_CTRL_SM_STATUS_CS_RTAGC		 (0x7L<<6)
#define BNX2_CTX_CACHE_CTRL_SM_STATUS_CS_RFIFOC		 (0x7L<<9)
#define BNX2_CTX_CACHE_CTRL_SM_STATUS_INVALID_BLK_ADDR	 (0x7fffL<<16)

#define BNX2_CTX_CACHE_STATUS				0x00001050
#define BNX2_CTX_CACHE_STATUS_HELD_ENTRIES		 (0x3ffL<<0)
#define BNX2_CTX_CACHE_STATUS_MAX_HELD_ENTRIES		 (0x3ffL<<16)

#define BNX2_CTX_DMA_STATUS				0x00001054
#define BNX2_CTX_DMA_STATUS_RD_CHAN0_STATUS		 (0x3L<<0)
#define BNX2_CTX_DMA_STATUS_RD_CHAN1_STATUS		 (0x3L<<2)
#define BNX2_CTX_DMA_STATUS_RD_CHAN2_STATUS		 (0x3L<<4)
#define BNX2_CTX_DMA_STATUS_RD_CHAN3_STATUS		 (0x3L<<6)
#define BNX2_CTX_DMA_STATUS_RD_CHAN4_STATUS		 (0x3L<<8)
#define BNX2_CTX_DMA_STATUS_RD_CHAN5_STATUS		 (0x3L<<10)
#define BNX2_CTX_DMA_STATUS_RD_CHAN6_STATUS		 (0x3L<<12)
#define BNX2_CTX_DMA_STATUS_RD_CHAN7_STATUS		 (0x3L<<14)
#define BNX2_CTX_DMA_STATUS_RD_CHAN8_STATUS		 (0x3L<<16)
#define BNX2_CTX_DMA_STATUS_RD_CHAN9_STATUS		 (0x3L<<18)
#define BNX2_CTX_DMA_STATUS_RD_CHAN10_STATUS		 (0x3L<<20)

#define BNX2_CTX_REP_STATUS				0x00001058
#define BNX2_CTX_REP_STATUS_ERROR_ENTRY			 (0x3ffL<<0)
#define BNX2_CTX_REP_STATUS_ERROR_CLIENT_ID		 (0x1fL<<10)
#define BNX2_CTX_REP_STATUS_USAGE_CNT_MAX_ERR		 (1L<<16)
#define BNX2_CTX_REP_STATUS_USAGE_CNT_MIN_ERR		 (1L<<17)
#define BNX2_CTX_REP_STATUS_USAGE_CNT_MISS_ERR		 (1L<<18)

#define BNX2_CTX_CKSUM_ERROR_STATUS			0x0000105c
#define BNX2_CTX_CKSUM_ERROR_STATUS_CALCULATED		 (0xffffL<<0)
#define BNX2_CTX_CKSUM_ERROR_STATUS_EXPECTED		 (0xffffL<<16)

#define BNX2_CTX_CHNL_LOCK_STATUS_0			0x00001080
#define BNX2_CTX_CHNL_LOCK_STATUS_0_CID			 (0x3fffL<<0)
#define BNX2_CTX_CHNL_LOCK_STATUS_0_TYPE		 (0x3L<<14)
#define BNX2_CTX_CHNL_LOCK_STATUS_0_MODE		 (1L<<16)
#define BNX2_CTX_CHNL_LOCK_STATUS_0_MODE_XI		 (1L<<14)
#define BNX2_CTX_CHNL_LOCK_STATUS_0_TYPE_XI		 (0x7L<<15)

#define BNX2_CTX_CHNL_LOCK_STATUS_1			0x00001084
#define BNX2_CTX_CHNL_LOCK_STATUS_2			0x00001088
#define BNX2_CTX_CHNL_LOCK_STATUS_3			0x0000108c
#define BNX2_CTX_CHNL_LOCK_STATUS_4			0x00001090
#define BNX2_CTX_CHNL_LOCK_STATUS_5			0x00001094
#define BNX2_CTX_CHNL_LOCK_STATUS_6			0x00001098
#define BNX2_CTX_CHNL_LOCK_STATUS_7			0x0000109c
#define BNX2_CTX_CHNL_LOCK_STATUS_8			0x000010a0
#define BNX2_CTX_CHNL_LOCK_STATUS_9			0x000010a4

#define BNX2_CTX_CACHE_DATA				0x000010c4
#define BNX2_CTX_HOST_PAGE_TBL_CTRL			0x000010c8
#define BNX2_CTX_HOST_PAGE_TBL_CTRL_PAGE_TBL_ADDR	 (0x1ffL<<0)
#define BNX2_CTX_HOST_PAGE_TBL_CTRL_WRITE_REQ		 (1L<<30)
#define BNX2_CTX_HOST_PAGE_TBL_CTRL_READ_REQ		 (1L<<31)

#define BNX2_CTX_HOST_PAGE_TBL_DATA0			0x000010cc
#define BNX2_CTX_HOST_PAGE_TBL_DATA0_VALID		 (1L<<0)
#define BNX2_CTX_HOST_PAGE_TBL_DATA0_VALUE		 (0xffffffL<<8)

#define BNX2_CTX_HOST_PAGE_TBL_DATA1			0x000010d0
#define BNX2_CTX_CAM_CTRL				0x000010d4
#define BNX2_CTX_CAM_CTRL_CAM_ADDR			 (0x3ffL<<0)
#define BNX2_CTX_CAM_CTRL_RESET				 (1L<<27)
#define BNX2_CTX_CAM_CTRL_INVALIDATE			 (1L<<28)
#define BNX2_CTX_CAM_CTRL_SEARCH			 (1L<<29)
#define BNX2_CTX_CAM_CTRL_WRITE_REQ			 (1L<<30)
#define BNX2_CTX_CAM_CTRL_READ_REQ			 (1L<<31)


/*
 *  emac_reg definition
 *  offset: 0x1400
 */
#define BNX2_EMAC_MODE					0x00001400
#define BNX2_EMAC_MODE_RESET				 (1L<<0)
#define BNX2_EMAC_MODE_HALF_DUPLEX			 (1L<<1)
#define BNX2_EMAC_MODE_PORT				 (0x3L<<2)
#define BNX2_EMAC_MODE_PORT_NONE			 (0L<<2)
#define BNX2_EMAC_MODE_PORT_MII				 (1L<<2)
#define BNX2_EMAC_MODE_PORT_GMII			 (2L<<2)
#define BNX2_EMAC_MODE_PORT_MII_10M			 (3L<<2)
#define BNX2_EMAC_MODE_MAC_LOOP				 (1L<<4)
#define BNX2_EMAC_MODE_25G_MODE				 (1L<<5)
#define BNX2_EMAC_MODE_TAGGED_MAC_CTL			 (1L<<7)
#define BNX2_EMAC_MODE_TX_BURST				 (1L<<8)
#define BNX2_EMAC_MODE_MAX_DEFER_DROP_ENA		 (1L<<9)
#define BNX2_EMAC_MODE_EXT_LINK_POL			 (1L<<10)
#define BNX2_EMAC_MODE_FORCE_LINK			 (1L<<11)
#define BNX2_EMAC_MODE_SERDES_MODE			 (1L<<12)
#define BNX2_EMAC_MODE_BOND_OVRD			 (1L<<13)
#define BNX2_EMAC_MODE_MPKT				 (1L<<18)
#define BNX2_EMAC_MODE_MPKT