/*
 * Copyright 2010 Red Hat Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors: Ben Skeggs
 */

#include "nvc0.h"

static void
nve0_grctx_generate_icmd(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x400208, 0x80000000);
	nv_icmd(priv, 0x001000, 0x00000004);
	nv_icmd(priv, 0x000039, 0x00000000);
	nv_icmd(priv, 0x00003a, 0x00000000);
	nv_icmd(priv, 0x00003b, 0x00000000);
	nv_icmd(priv, 0x0000a9, 0x0000ffff);
	nv_icmd(priv, 0x000038, 0x0fac6881);
	nv_icmd(priv, 0x00003d, 0x00000001);
	nv_icmd(priv, 0x0000e8, 0x00000400);
	nv_icmd(priv, 0x0000e9, 0x00000400);
	nv_icmd(priv, 0x0000ea, 0x00000400);
	nv_icmd(priv, 0x0000eb, 0x00000400);
	nv_icmd(priv, 0x0000ec, 0x00000400);
	nv_icmd(priv, 0x0000ed, 0x00000400);
	nv_icmd(priv, 0x0000ee, 0x00000400);
	nv_icmd(priv, 0x0000ef, 0x00000400);
	nv_icmd(priv, 0x000078, 0x00000300);
	nv_icmd(priv, 0x000079, 0x00000300);
	nv_icmd(priv, 0x00007a, 0x00000300);
	nv_icmd(priv, 0x00007b, 0x00000300);
	nv_icmd(priv, 0x00007c, 0x00000300);
	nv_icmd(priv, 0x00007d, 0x00000300);
	nv_icmd(priv, 0x00007e, 0x00000300);
	nv_icmd(priv, 0x00007f, 0x00000300);
	nv_icmd(priv, 0x000050, 0x00000011);
	nv_icmd(priv, 0x000058, 0x00000008);
	nv_icmd(priv, 0x000059, 0x00000008);
	nv_icmd(priv, 0x00005a, 0x00000008);
	nv_icmd(priv, 0x00005b, 0x00000008);
	nv_icmd(priv, 0x00005c, 0x00000008);
	nv_icmd(priv, 0x00005d, 0x00000008);
	nv_icmd(priv, 0x00005e, 0x00000008);
	nv_icmd(priv, 0x00005f, 0x00000008);
	nv_icmd(priv, 0x000208, 0x00000001);
	nv_icmd(priv, 0x000209, 0x00000001);
	nv_icmd(priv, 0x00020a, 0x00000001);
	nv_icmd(priv, 0x00020b, 0x00000001);
	nv_icmd(priv, 0x00020c, 0x00000001);
	nv_icmd(priv, 0x00020d, 0x00000001);
	nv_icmd(priv, 0x00020e, 0x00000001);
	nv_icmd(priv, 0x00020f, 0x00000001);
	nv_icmd(priv, 0x000081, 0x00000001);
	nv_icmd(priv, 0x000085, 0x00000004);
	nv_icmd(priv, 0x000088, 0x00000400);
	nv_icmd(priv, 0x000090, 0x00000300);
	nv_icmd(priv, 0x000098, 0x00001001);
	nv_icmd(priv, 0x0000e3, 0x00000001);
	nv_icmd(priv, 0x0000da, 0x00000001);
	nv_icmd(priv, 0x0000f8, 0x00000003);
	nv_icmd(priv, 0x0000fa, 0x00000001);
	nv_icmd(priv, 0x00009f, 0x0000ffff);
	nv_icmd(priv, 0x0000a0, 0x0000ffff);
	nv_icmd(priv, 0x0000a1, 0x0000ffff);
	nv_icmd(priv, 0x0000a2, 0x0000ffff);
	nv_icmd(priv, 0x0000b1, 0x00000001);
	nv_icmd(priv, 0x0000ad, 0x0000013e);
	nv_icmd(priv, 0x0000e1, 0x00000010);
	nv_icmd(priv, 0x000290, 0x00000000);
	nv_icmd(priv, 0x000291, 0x00000000);
	nv_icmd(priv, 0x000292, 0x00000000);
	nv_icmd(priv, 0x000293, 0x00000000);
	nv_icmd(priv, 0x000294, 0x00000000);
	nv_icmd(priv, 0x000295, 0x00000000);
	nv_icmd(priv, 0x000296, 0x00000000);
	nv_icmd(priv, 0x000297, 0x00000000);
	nv_icmd(priv, 0x000298, 0x00000000);
	nv_icmd(priv, 0x000299, 0x00000000);
	nv_icmd(priv, 0x00029a, 0x00000000);
	nv_icmd(priv, 0x00029b, 0x00000000);
	nv_icmd(priv, 0x00029c, 0x00000000);
	nv_icmd(priv, 0x00029d, 0x00000000);
	nv_icmd(priv, 0x00029e, 0x00000000);
	nv_icmd(priv, 0x00029f, 0x00000000);
	nv_icmd(priv, 0x0003b0, 0x00000000);
	nv_icmd(priv, 0x0003b1, 0x00000000);
	nv_icmd(priv, 0x0003b2, 0x00000000);
	nv_icmd(priv, 0x0003b3, 0x00000000);
	nv_icmd(priv, 0x0003b4, 0x00000000);
	nv_icmd(priv, 0x0003b5, 0x00000000);
	nv_icmd(priv, 0x0003b6, 0x00000000);
	nv_icmd(priv, 0x0003b7, 0x00000000);
	nv_icmd(priv, 0x0003b8, 0x00000000);
	nv_icmd(priv, 0x0003b9, 0x00000000);
	nv_icmd(priv, 0x0003ba, 0x00000000);
	nv_icmd(priv, 0x0003bb, 0x00000000);
	nv_icmd(priv, 0x0003bc, 0x00000000);
	nv_icmd(priv, 0x0003bd, 0x00000000);
	nv_icmd(priv, 0x0003be, 0x00000000);
	nv_icmd(priv, 0x0003bf, 0x00000000);
	nv_icmd(priv, 0x0002a0, 0x00000000);
	nv_icmd(priv, 0x0002a1, 0x00000000);
	nv_icmd(priv, 0x0002a2, 0x00000000);
	nv_icmd(priv, 0x0002a3, 0x00000000);
	nv_icmd(priv, 0x0002a4, 0x00000000);
	nv_icmd(priv, 0x0002a5, 0x00000000);
	nv_icmd(priv, 0x0002a6, 0x00000000);
	nv_icmd(priv, 0x0002a7, 0x00000000);
	nv_icmd(priv, 0x0002a8, 0x00000000);
	nv_icmd(priv, 0x0002a9, 0x00000000);
	nv_icmd(priv, 0x0002aa, 0x00000000);
	nv_icmd(priv, 0x0002ab, 0x00000000);
	nv_icmd(priv, 0x0002ac, 0x00000000);
	nv_icmd(priv, 0x0002ad, 0x00000000);
	nv_icmd(priv, 0x0002ae, 0x00000000);
	nv_icmd(priv, 0x0002af, 0x00000000);
	nv_icmd(priv, 0x000420, 0x00000000);
	nv_icmd(priv, 0x000421, 0x00000000);
	nv_icmd(priv, 0x000422, 0x00000000);
	nv_icmd(priv, 0x000423, 0x00000000);
	nv_icmd(priv, 0x000424, 0x00000000);
	nv_icmd(priv, 0x000425, 0x00000000);
	nv_icmd(priv, 0x000426, 0x00000000);
	nv_icmd(priv, 0x000427, 0x00000000);
	nv_icmd(priv, 0x000428, 0x00000000);
	nv_icmd(priv, 0x000429, 0x00000000);
	nv_icmd(priv, 0x00042a, 0x00000000);
	nv_icmd(priv, 0x00042b, 0x00000000);
	nv_icmd(priv, 0x00042c, 0x00000000);
	nv_icmd(priv, 0x00042d, 0x00000000);
	nv_icmd(priv, 0x00042e, 0x00000000);
	nv_icmd(priv, 0x00042f, 0x00000000);
	nv_icmd(priv, 0x0002b0, 0x00000000);
	nv_icmd(priv, 0x0002b1, 0x00000000);
	nv_icmd(priv, 0x0002b2, 0x00000000);
	nv_icmd(priv, 0x0002b3, 0x00000000);
	nv_icmd(priv, 0x0002b4, 0x00000000);
	nv_icmd(priv, 0x0002b5, 0x00000000);
	nv_icmd(priv, 0x0002b6, 0x00000000);
	nv_icmd(priv, 0x0002b7, 0x00000000);
	nv_icmd(priv, 0x0002b8, 0x00000000);
	nv_icmd(priv, 0x0002b9, 0x00000000);
	nv_icmd(priv, 0x0002ba, 0x00000000);
	nv_icmd(priv, 0x0002bb, 0x00000000);
	nv_icmd(priv, 0x0002bc, 0x00000000);
	nv_icmd(priv, 0x0002bd, 0x00000000);
	nv_icmd(priv, 0x0002be, 0x00000000);
	nv_icmd(priv, 0x0002bf, 0x00000000);
	nv_icmd(priv, 0x000430, 0x00000000);
	nv_icmd(priv, 0x000431, 0x00000000);
	nv_icmd(priv, 0x000432, 0x00000000);
	nv_icmd(priv, 0x000433, 0x00000000);
	nv_icmd(priv, 0x000434, 0x00000000);
	nv_icmd(priv, 0x000435, 0x00000000);
	nv_icmd(priv, 0x000436, 0x00000000);
	nv_icmd(priv, 0x000437, 0x00000000);
	nv_icmd(priv, 0x000438, 0x00000000);
	nv_icmd(priv, 0x000439, 0x00000000);
	nv_icmd(priv, 0x00043a, 0x00000000);
	nv_icmd(priv, 0x00043b, 0x00000000);
	nv_icmd(priv, 0x00043c, 0x00000000);
	nv_icmd(priv, 0x00043d, 0x00000000);
	nv_icmd(priv, 0x00043e, 0x00000000);
	nv_icmd(priv, 0x00043f, 0x00000000);
	nv_icmd(priv, 0x0002c0, 0x00000000);
	nv_icmd(priv, 0x0002c1, 0x00000000);
	nv_icmd(priv, 0x0002c2, 0x00000000);
	nv_icmd(priv, 0x0002c3, 0x00000000);
	nv_icmd(priv, 0x0002c4, 0x00000000);
	nv_icmd(priv, 0x0002c5, 0x00000000);
	nv_icmd(priv, 0x0002c6, 0x00000000);
	nv_icmd(priv, 0x0002c7, 0x00000000);
	nv_icmd(priv, 0x0002c8, 0x00000000);
	nv_icmd(priv, 0x0002c9, 0x00000000);
	nv_icmd(priv, 0x0002ca, 0x00000000);
	nv_icmd(priv, 0x0002cb, 0x00000000);
	nv_icmd(priv, 0x0002cc, 0x00000000);
	nv_icmd(priv, 0x0002cd, 0x00000000);
	nv_icmd(priv, 0x0002ce, 0x00000000);
	nv_icmd(priv, 0x0002cf, 0x00000000);
	nv_icmd(priv, 0x0004d0, 0x00000000);
	nv_icmd(priv, 0x0004d1, 0x00000000);
	nv_icmd(priv, 0x0004d2, 0x00000000);
	nv_icmd(priv, 0x0004d3, 0x00000000);
	nv_icmd(priv, 0x0004d4, 0x00000000);
	nv_icmd(priv, 0x0004d5, 0x00000000);
	nv_icmd(priv, 0x0004d6, 0x00000000);
	nv_icmd(priv, 0x0004d7, 0x00000000);
	nv_icmd(priv, 0x0004d8, 0x00000000);
	nv_icmd(priv, 0x0004d9, 0x00000000);
	nv_icmd(priv, 0x0004da, 0x00000000);
	nv_icmd(priv, 0x0004db, 0x00000000);
	nv_icmd(priv, 0x0004dc, 0x00000000);
	nv_icmd(priv, 0x0004dd, 0x00000000);
	nv_icmd(priv, 0x0004de, 0x00000000);
	nv_icmd(priv, 0x0004df, 0x00000000);
	nv_icmd(priv, 0x000720, 0x00000000);
	nv_icmd(priv, 0x000721, 0x00000000);
	nv_icmd(priv, 0x000722, 0x00000000);
	nv_icmd(priv, 0x000723, 0x00000000);
	nv_icmd(priv, 0x000724, 0x00000000);
	nv_icmd(priv, 0x000725, 0x00000000);
	nv_icmd(priv, 0x000726, 0x00000000);
	nv_icmd(priv, 0x000727, 0x00000000);
	nv_icmd(priv, 0x000728, 0x00000000);
	nv_icmd(priv, 0x000729, 0x00000000);
	nv_icmd(priv, 0x00072a, 0x00000000);
	nv_icmd(priv, 0x00072b, 0x00000000);
	nv_icmd(priv, 0x00072c, 0x00000000);
	nv_icmd(priv, 0x00072d, 0x00000000);
	nv_icmd(priv, 0x00072e, 0x00000000);
	nv_icmd(priv, 0x00072f, 0x00000000);
	nv_icmd(priv, 0x0008c0, 0x00000000);
	nv_icmd(priv, 0x0008c1, 0x00000000);
	nv_icmd(priv, 0x0008c2, 0x00000000);
	nv_icmd(priv, 0x0008c3, 0x00000000);
	nv_icmd(priv, 0x0008c4, 0x00000000);
	nv_icmd(priv, 0x0008c5, 0x00000000);
	nv_icmd(priv, 0x0008c6, 0x00000000);
	nv_icmd(priv, 0x0008c7, 0x00000000);
	nv_icmd(priv, 0x0008c8, 0x00000000);
	nv_icmd(priv, 0x0008c9, 0x00000000);
	nv_icmd(priv, 0x0008ca, 0x00000000);
	nv_icmd(priv, 0x0008cb, 0x00000000);
	nv_icmd(priv, 0x0008cc, 0x00000000);
	nv_icmd(priv, 0x0008cd, 0x00000000);
	nv_icmd(priv, 0x0008ce, 0x00000000);
	nv_icmd(priv, 0x0008cf, 0x00000000);
	nv_icmd(priv, 0x000890, 0x00000000);
	nv_icmd(priv, 0x000891, 0x00000000);
	nv_icmd(priv, 0x000892, 0x00000000);
	nv_icmd(priv, 0x000893, 0x00000000);
	nv_icmd(priv, 0x000894, 0x00000000);
	nv_icmd(priv, 0x000895, 0x00000000);
	nv_icmd(priv, 0x000896, 0x00000000);
	nv_icmd(priv, 0x000897, 0x00000000);
	nv_icmd(priv, 0x000898, 0x00000000);
	nv_icmd(priv, 0x000899, 0x00000000);
	nv_icmd(priv, 0x00089a, 0x00000000);
	nv_icmd(priv, 0x00089b, 0x00000000);
	nv_icmd(priv, 0x00089c, 0x00000000);
	nv_icmd(priv, 0x00089d, 0x00000000);
	nv_icmd(priv, 0x00089e, 0x00000000);
	nv_icmd(priv, 0x00089f, 0x00000000);
	nv_icmd(priv, 0x0008e0, 0x00000000);
	nv_icmd(priv, 0x0008e1, 0x00000000);
	nv_icmd(priv, 0x0008e2, 0x00000000);
	nv_icmd(priv, 0x0008e3, 0x00000000);
	nv_icmd(priv, 0x0008e4, 0x00000000);
	nv_icmd(priv, 0x0008e5, 0x00000000);
	nv_icmd(priv, 0x0008e6, 0x00000000);
	nv_icmd(priv, 0x0008e7, 0x00000000);
	nv_icmd(priv, 0x0008e8, 0x00000000);
	nv_icmd(priv, 0x0008e9, 0x00000000);
	nv_icmd(priv, 0x0008ea, 0x00000000);
	nv_icmd(priv, 0x0008eb, 0x00000000);
	nv_icmd(priv, 0x0008ec, 0x00000000);
	nv_icmd(priv, 0x0008ed, 0x00000000);
	nv_icmd(priv, 0x0008ee, 0x00000000);
	nv_icmd(priv, 0x0008ef, 0x00000000);
	nv_icmd(priv, 0x0008a0, 0x00000000);
	nv_icmd(priv, 0x0008a1, 0x00000000);
	nv_icmd(priv, 0x0008a2, 0x00000000);
	nv_icmd(priv, 0x0008a3, 0x00000000);
	nv_icmd(priv, 0x0008a4, 0x00000000);
	nv_icmd(priv, 0x0008a5, 0x00000000);
	nv_icmd(priv, 0x0008a6, 0x00000000);
	nv_icmd(priv, 0x0008a7, 0x00000000);
	nv_icmd(priv, 0x0008a8, 0x00000000);
	nv_icmd(priv, 0x0008a9, 0x00000000);
	nv_icmd(priv, 0x0008aa, 0x00000000);
	nv_icmd(priv, 0x0008ab, 0x00000000);
	nv_icmd(priv, 0x0008ac, 0x00000000);
	nv_icmd(priv, 0x0008ad, 0x00000000);
	nv_icmd(priv, 0x0008ae, 0x00000000);
	nv_icmd(priv, 0x0008af, 0x00000000);
	nv_icmd(priv, 0x0008f0, 0x00000000);
	nv_icmd(priv, 0x0008f1, 0x00000000);
	nv_icmd(priv, 0x0008f2, 0x00000000);
	nv_icmd(priv, 0x0008f3, 0x00000000);
	nv_icmd(priv, 0x0008f4, 0x00000000);
	nv_icmd(priv, 0x0008f5, 0x00000000);
	nv_icmd(priv, 0x0008f6, 0x00000000);
	nv_icmd(priv, 0x0008f7, 0x00000000);
	nv_icmd(priv, 0x0008f8, 0x00000000);
	nv_icmd(priv, 0x0008f9, 0x00000000);
	nv_icmd(priv, 0x0008fa, 0x00000000);
	nv_icmd(priv, 0x0008fb, 0x00000000);
	nv_icmd(priv, 0x0008fc, 0x00000000);
	nv_icmd(priv, 0x0008fd, 0x00000000);
	nv_icmd(priv, 0x0008fe, 0x00000000);
	nv_icmd(priv, 0x0008ff, 0x00000000);
	nv_icmd(priv, 0x00094c, 0x000000ff);
	nv_icmd(priv, 0x00094d, 0xffffffff);
	nv_icmd(priv, 0x00094e, 0x00000002);
	nv_icmd(priv, 0x0002ec, 0x00000001);
	nv_icmd(priv, 0x000303, 0x00000001);
	nv_icmd(priv, 0x0002e6, 0x00000001);
	nv_icmd(priv, 0x000466, 0x00000052);
	nv_icmd(priv, 0x000301, 0x3f800000);
	nv_icmd(priv, 0x000304, 0x30201000);
	nv_icmd(priv, 0x000305, 0x70605040);
	nv_icmd(priv, 0x000306, 0xb8a89888);
	nv_icmd(priv, 0x000307, 0xf8e8d8c8);
	nv_icmd(priv, 0x00030a, 0x00ffff00);
	nv_icmd(priv, 0x00030b, 0x0000001a);
	nv_icmd(priv, 0x00030c, 0x00000001);
	nv_icmd(priv, 0x000318, 0x00000001);
	nv_icmd(priv, 0x000340, 0x00000000);
	nv_icmd(priv, 0x000375, 0x00000001);
	nv_icmd(priv, 0x00037d, 0x00000006);
	nv_icmd(priv, 0x0003a0, 0x00000002);
	nv_icmd(priv, 0x0003aa, 0x00000001);
	nv_icmd(priv, 0x0003a9, 0x00000001);
	nv_icmd(priv, 0x000380, 0x00000001);
	nv_icmd(priv, 0x000383, 0x00000011);
	nv_icmd(priv, 0x000360, 0x00000040);
	nv_icmd(priv, 0x000366, 0x00000000);
	nv_icmd(priv, 0x000367, 0x00000000);
	nv_icmd(priv, 0x000368, 0x00000fff);
	nv_icmd(priv, 0x000370, 0x00000000);
	nv_icmd(priv, 0x000371, 0x00000000);
	nv_icmd(priv, 0x000372, 0x000fffff);
	nv_icmd(priv, 0x00037a, 0x00000012);
	nv_icmd(priv, 0x000619, 0x00000003);
	nv_icmd(priv, 0x000811, 0x00000003);
	nv_icmd(priv, 0x000812, 0x00000004);
	nv_icmd(priv, 0x000813, 0x00000006);
	nv_icmd(priv, 0x000814, 0x00000008);
	nv_icmd(priv, 0x000815, 0x0000000b);
	nv_icmd(priv, 0x000800, 0x00000001);
	nv_icmd(priv, 0x000801, 0x00000001);
	nv_icmd(priv, 0x000802, 0x00000001);
	nv_icmd(priv, 0x000803, 0x00000001);
	nv_icmd(priv, 0x000804, 0x00000001);
	nv_icmd(priv, 0x000805, 0x00000001);
	nv_icmd(priv, 0x000632, 0x00000001);
	nv_icmd(priv, 0x000633, 0x00000002);
	nv_icmd(priv, 0x000634, 0x00000003);
	nv_icmd(priv, 0x000635, 0x00000004);
	nv_icmd(priv, 0x000654, 0x3f800000);
	nv_icmd(priv, 0x000657, 0x3f800000);
	nv_icmd(priv, 0x000655, 0x3f800000);
	nv_icmd(priv, 0x000656, 0x3f800000);
	nv_icmd(priv, 0x0006cd, 0x3f800000);
	nv_icmd(priv, 0x0007f5, 0x3f800000);
	nv_icmd(priv, 0x0007dc, 0x39291909);
	nv_icmd(priv, 0x0007dd, 0x79695949);
	nv_icmd(priv, 0x0007de, 0xb9a99989);
	nv_icmd(priv, 0x0007df, 0xf9e9d9c9);
	nv_icmd(priv, 0x0007e8, 0x00003210);
	nv_icmd(priv, 0x0007e9, 0x00007654);
	nv_icmd(priv, 0x0007ea, 0x00000098);
	nv_icmd(priv, 0x0007ec, 0x39291909);
	nv_icmd(priv, 0x0007ed, 0x79695949);
	nv_icmd(priv, 0x0007ee, 0xb9a99989);
	nv_icmd(priv, 0x0007ef, 0xf9e9d9c9);
	nv_icmd(priv, 0x0007f0, 0x00003210);
	nv_icmd(priv, 0x0007f1, 0x00007654);
	nv_icmd(priv, 0x0007f2, 0x00000098);
	nv_icmd(priv, 0x0005a5, 0x00000001);
	nv_icmd(priv, 0x000980, 0x00000000);
	nv_icmd(priv, 0x000981, 0x00000000);
	nv_icmd(priv, 0x000982, 0x00000000);
	nv_icmd(priv, 0x000983, 0x00000000);
	nv_icmd(priv, 0x000984, 0x00000000);
	nv_icmd(priv, 0x000985, 0x00000000);
	nv_icmd(priv, 0x000986, 0x00000000);
	nv_icmd(priv, 0x000987, 0x00000000);
	nv_icmd(priv, 0x000988, 0x00000000);
	nv_icmd(priv, 0x000989, 0x00000000);
	nv_icmd(priv, 0x00098a, 0x00000000);
	nv_icmd(priv, 0x00098b, 0x00000000);
	nv_icmd(priv, 0x00098c, 0x00000000);
	nv_icmd(priv, 0x00098d, 0x00000000);
	nv_icmd(priv, 0x00098e, 0x00000000);
	nv_icmd(priv, 0x00098f, 0x00000000);
	nv_icmd(priv, 0x000990, 0x00000000);
	nv_icmd(priv, 0x000991, 0x00000000);
	nv_icmd(priv, 0x000992, 0x00000000);
	nv_icmd(priv, 0x000993, 0x00000000);
	nv_icmd(priv, 0x000994, 0x00000000);
	nv_icmd(priv, 0x000995, 0x00000000);
	nv_icmd(priv, 0x000996, 0x00000000);
	nv_icmd(priv, 0x000997, 0x00000000);
	nv_icmd(priv, 0x000998, 0x00000000);
	nv_icmd(priv, 0x000999, 0x00000000);
	nv_icmd(priv, 0x00099a, 0x00000000);
	nv_icmd(priv, 0x00099b, 0x00000000);
	nv_icmd(priv, 0x00099c, 0x00000000);
	nv_icmd(priv, 0x00099d, 0x00000000);
	nv_icmd(priv, 0x00099e, 0x00000000);
	nv_icmd(priv, 0x00099f, 0x00000000);
	nv_icmd(priv, 0x0009a0, 0x00000000);
	nv_icmd(priv, 0x0009a1, 0x00000000);
	nv_icmd(priv, 0x0009a2, 0x00000000);
	nv_icmd(priv, 0x0009a3, 0x00000000);
	nv_icmd(priv, 0x0009a4, 0x00000000);
	nv_icmd(priv, 0x0009a5, 0x00000000);
	nv_icmd(priv, 0x0009a6, 0x00000000);
	nv_icmd(priv, 0x0009a7, 0x00000000);
	nv_icmd(priv, 0x0009a8, 0x00000000);
	nv_icmd(priv, 0x0009a9, 0x00000000);
	nv_icmd(priv, 0x0009aa, 0x00000000);
	nv_icmd(priv, 0x0009ab, 0x00000000);
	nv_icmd(priv, 0x0009ac, 0x00000000);
	nv_icmd(priv, 0x0009ad, 0x00000000);
	nv_icmd(priv, 0x0009ae, 0x00000000);
	nv_icmd(priv, 0x0009af, 0x00000000);
	nv_icmd(priv, 0x0009b0, 0x00000000);
	nv_icmd(priv, 0x0009b1, 0x00000000);
	nv_icmd(priv, 0x0009b2, 0x00000000);
	nv_icmd(priv, 0x0009b3, 0x00000000);
	nv_icmd(priv, 0x0009b4, 0x00000000);
	nv_icmd(priv, 0x0009b5, 0x00000000);
	nv_icmd(priv, 0x0009b6, 0x00000000);
	nv_icmd(priv, 0x0009b7, 0x00000000);
	nv_icmd(priv, 0x0009b8, 0x00000000);
	nv_icmd(priv, 0x0009b9, 0x00000000);
	nv_icmd(priv, 0x0009ba, 0x00000000);
	nv_icmd(priv, 0x0009bb, 0x00000000);
	nv_icmd(priv, 0x0009bc, 0x00000000);
	nv_icmd(priv, 0x0009bd, 0x00000000);
	nv_icmd(priv, 0x0009be, 0x00000000);
	nv_icmd(priv, 0x0009bf, 0x00000000);
	nv_icmd(priv, 0x0009c0, 0x00000000);
	nv_icmd(priv, 0x0009c1, 0x00000000);
	nv_icmd(priv, 0x0009c2, 0x00000000);
	nv_icmd(priv, 0x0009c3, 0x00000000);
	nv_icmd(priv, 0x0009c4, 0x00000000);
	nv_icmd(priv, 0x0009c5, 0x00000000);
	nv_icmd(priv, 0x0009c6, 0x00000000);
	nv_icmd(priv, 0x0009c7, 0x00000000);
	nv_icmd(priv, 0x0009c8, 0x00000000);
	nv_icmd(priv, 0x0009c9, 0x00000000);
	nv_icmd(priv, 0x0009ca, 0x00000000);
	nv_icmd(priv, 0x0009cb, 0x00000000);
	nv_icmd(priv, 0x0009cc, 0x00000000);
	nv_icmd(priv, 0x0009cd, 0x00000000);
	nv_icmd(priv, 0x0009ce, 0x00000000);
	nv_icmd(priv, 0x0009cf, 0x00000000);
	nv_icmd(priv, 0x0009d0, 0x00000000);
	nv_icmd(priv, 0x0009d1, 0x00000000);
	nv_icmd(priv, 0x0009d2, 0x00000000);
	nv_icmd(priv, 0x0009d3, 0x00000000);
	nv_icmd(priv, 0x0009d4, 0x00000000);
	nv_icmd(priv, 0x0009d5, 0x00000000);
	nv_icmd(priv, 0x0009d6, 0x00000000);
	nv_icmd(priv, 0x0009d7, 0x00000000);
	nv_icmd(priv, 0x0009d8, 0x00000000);
	nv_icmd(priv, 0x0009d9, 0x00000000);
	nv_icmd(priv, 0x0009da, 0x00000000);
	nv_icmd(priv, 0x0009db, 0x00000000);
	nv_icmd(priv, 0x0009dc, 0x00000000);
	nv_icmd(priv, 0x0009dd, 0x00000000);
	nv_icmd(priv, 0x0009de, 0x00000000);
	nv_icmd(priv, 0x0009df, 0x00000000);
	nv_icmd(priv, 0x0009e0, 0x00000000);
	nv_icmd(priv, 0x0009e1, 0x00000000);
	nv_icmd(priv, 0x0009e2, 0x00000000);
	nv_icmd(priv, 0x0009e3, 0x00000000);
	nv_icmd(priv, 0x0009e4, 0x00000000);
	nv_icmd(priv, 0x0009e5, 0x00000000);
	nv_icmd(priv, 0x0009e6, 0x00000000);
	nv_icmd(priv, 0x0009e7, 0x00000000);
	nv_icmd(priv, 0x0009e8, 0x00000000);
	nv_icmd(priv, 0x0009e9, 0x00000000);
	nv_icmd(priv, 0x0009ea, 0x00000000);
	nv_icmd(priv, 0x0009eb, 0x00000000);
	nv_icmd(priv, 0x0009ec, 0x00000000);
	nv_icmd(priv, 0x0009ed, 0x00000000);
	nv_icmd(priv, 0x0009ee, 0x00000000);
	nv_icmd(priv, 0x0009ef, 0x00000000);
	nv_icmd(priv, 0x0009f0, 0x00000000);
	nv_icmd(priv, 0x0009f1, 0x00000000);
	nv_icmd(priv, 0x0009f2, 0x00000000);
	nv_icmd(priv, 0x0009f3, 0x00000000);
	nv_icmd(priv, 0x0009f4, 0x00000000);
	nv_icmd(priv, 0x0009f5, 0x00000000);
	nv_icmd(priv, 0x0009f6, 0x00000000);
	nv_icmd(priv, 0x0009f7, 0x00000000);
	nv_icmd(priv, 0x0009f8, 0x00000000);
	nv_icmd(priv, 0x0009f9, 0x00000000);
	nv_icmd(priv, 0x0009fa, 0x00000000);
	nv_icmd(priv, 0x0009fb, 0x00000000);
	nv_icmd(priv, 0x0009fc, 0x00000000);
	nv_icmd(priv, 0x0009fd, 0x00000000);
	nv_icmd(priv, 0x0009fe, 0x00000000);
	nv_icmd(priv, 0x0009ff, 0x00000000);
	nv_icmd(priv, 0x000468, 0x00000004);
	nv_icmd(priv, 0x00046c, 0x00000001);
	nv_icmd(priv, 0x000470, 0x00000000);
	nv_icmd(priv, 0x000471, 0x00000000);
	nv_icmd(priv, 0x000472, 0x00000000);
	nv_icmd(priv, 0x000473, 0x00000000);
	nv_icmd(priv, 0x000474, 0x00000000);
	nv_icmd(priv, 0x000475, 0x00000000);
	nv_icmd(priv, 0x000476, 0x00000000);
	nv_icmd(priv, 0x000477, 0x00000000);
	nv_icmd(priv, 0x000478, 0x00000000);
	nv_icmd(priv, 0x000479, 0x00000000);
	nv_icmd(priv, 0x00047a, 0x00000000);
	nv_icmd(priv, 0x00047b, 0x00000000);
	nv_icmd(priv, 0x00047c, 0x00000000);
	nv_icmd(priv, 0x00047d, 0x00000000);
	nv_icmd(priv, 0x00047e, 0x00000000);
	nv_icmd(priv, 0x00047f, 0x00000000);
	nv_icmd(priv, 0x000480, 0x00000000);
	nv_icmd(priv, 0x000481, 0x00000000);
	nv_icmd(priv, 0x000482, 0x00000000);
	nv_icmd(priv, 0x000483, 0x00000000);
	nv_icmd(priv, 0x000484, 0x00000000);
	nv_icmd(priv, 0x000485, 0x00000000);
	nv_icmd(priv, 0x000486, 0x00000000);
	nv_icmd(priv, 0x000487, 0x00000000);
	nv_icmd(priv, 0x000488, 0x00000000);
	nv_icmd(priv, 0x000489, 0x00000000);
	nv_icmd(priv, 0x00048a, 0x00000000);
	nv_icmd(priv, 0x00048b, 0x00000000);
	nv_icmd(priv, 0x00048c, 0x00000000);
	nv_icmd(priv, 0x00048d, 0x00000000);
	nv_icmd(priv, 0x00048e, 0x00000000);
	nv_icmd(priv, 0x00048f, 0x00000000);
	nv_icmd(priv, 0x000490, 0x00000000);
	nv_icmd(priv, 0x000491, 0x00000000);
	nv_icmd(priv, 0x000492, 0x00000000);
	nv_icmd(priv, 0x000493, 0x00000000);
	nv_icmd(priv, 0x000494, 0x00000000);
	nv_icmd(priv, 0x000495, 0x00000000);
	nv_icmd(priv, 0x000496, 0x00000000);
	nv_icmd(priv, 0x000497, 0x00000000);
	nv_icmd(priv, 0x000498, 0x00000000);
	nv_icmd(priv, 0x000499, 0x00000000);
	nv_icmd(priv, 0x00049a, 0x00000000);
	nv_icmd(priv, 0x00049b, 0x00000000);
	nv_icmd(priv, 0x00049c, 0x00000000);
	nv_icmd(priv, 0x00049d, 0x00000000);
	nv_icmd(priv, 0x00049e, 0x00000000);
	nv_icmd(priv, 0x00049f, 0x00000000);
	nv_icmd(priv, 0x0004a0, 0x00000000);
	nv_icmd(priv, 0x0004a1, 0x00000000);
	nv_icmd(priv, 0x0004a2, 0x00000000);
	nv_icmd(priv, 0x0004a3, 0x00000000);
	nv_icmd(priv, 0x0004a4, 0x00000000);
	nv_icmd(priv, 0x0004a5, 0x00000000);
	nv_icmd(priv, 0x0004a6, 0x00000000);
	nv_icmd(priv, 0x0004a7, 0x00000000);
	nv_icmd(priv, 0x0004a8, 0x00000000);
	nv_icmd(priv, 0x0004a9, 0x00000000);
	nv_icmd(priv, 0x0004aa, 0x00000000);
	nv_icmd(priv, 0x0004ab, 0x00000000);
	nv_icmd(priv, 0x0004ac, 0x00000000);
	nv_icmd(priv, 0x0004ad, 0x00000000);
	nv_icmd(priv, 0x0004ae, 0x00000000);
	nv_icmd(priv, 0x0004af, 0x00000000);
	nv_icmd(priv, 0x0004b0, 0x00000000);
	nv_icmd(priv, 0x0004b1, 0x00000000);
	nv_icmd(priv, 0x0004b2, 0x00000000);
	nv_icmd(priv, 0x0004b3, 0x00000000);
	nv_icmd(priv, 0x0004b4, 0x00000000);
	nv_icmd(priv, 0x0004b5, 0x00000000);
	nv_icmd(priv, 0x0004b6, 0x00000000);
	nv_icmd(priv, 0x0004b7, 0x00000000);
	nv_icmd(priv, 0x0004b8, 0x00000000);
	nv_icmd(priv, 0x0004b9, 0x00000000);
	nv_icmd(priv, 0x0004ba, 0x00000000);
	nv_icmd(priv, 0x0004bb, 0x00000000);
	nv_icmd(priv, 0x0004bc, 0x00000000);
	nv_icmd(priv, 0x0004bd, 0x00000000);
	nv_icmd(priv, 0x0004be, 0x00000000);
	nv_icmd(priv, 0x0004bf, 0x00000000);
	nv_icmd(priv, 0x0004c0, 0x00000000);
	nv_icmd(priv, 0x0004c1, 0x00000000);
	nv_icmd(priv, 0x0004c2, 0x00000000);
	nv_icmd(priv, 0x0004c3, 0x00000000);
	nv_icmd(priv, 0x0004c4, 0x00000000);
	nv_icmd(priv, 0x0004c5, 0x00000000);
	nv_icmd(priv, 0x0004c6, 0x00000000);
	nv_icmd(priv, 0x0004c7, 0x00000000);
	nv_icmd(priv, 0x0004c8, 0x00000000);
	nv_icmd(priv, 0x0004c9, 0x00000000);
	nv_icmd(priv, 0x0004ca, 0x00000000);
	nv_icmd(priv, 0x0004cb, 0x00000000);
	nv_icmd(priv, 0x0004cc, 0x00000000);
	nv_icmd(priv, 0x0004cd, 0x00000000);
	nv_icmd(priv, 0x0004ce, 0x00000000);
	nv_icmd(priv, 0x0004cf, 0x00000000);
	nv_icmd(priv, 0x000510, 0x3f800000);
	nv_icmd(priv, 0x000511, 0x3f800000);
	nv_icmd(priv, 0x000512, 0x3f800000);
	nv_icmd(priv, 0x000513, 0x3f800000);
	nv_icmd(priv, 0x000514, 0x3f800000);
	nv_icmd(priv, 0x000515, 0x3f800000);
	nv_icmd(priv, 0x000516, 0x3f800000);
	nv_icmd(priv, 0x000517, 0x3f800000);
	nv_icmd(priv, 0x000518, 0x3f800000);
	nv_icmd(priv, 0x000519, 0x3f800000);
	nv_icmd(priv, 0x00051a, 0x3f800000);
	nv_icmd(priv, 0x00051b, 0x3f800000);
	nv_icmd(priv, 0x00051c, 0x3f800000);
	nv_icmd(priv, 0x00051d, 0x3f800000);
	nv_icmd(priv, 0x00051e, 0x3f800000);
	nv_icmd(priv, 0x00051f, 0x3f800000);
	nv_icmd(priv, 0x000520, 0x000002b6);
	nv_icmd(priv, 0x000529, 0x00000001);
	nv_icmd(priv, 0x000530, 0xffff0000);
	nv_icmd(priv, 0x000531, 0xffff0000);
	nv_icmd(priv, 0x000532, 0xffff0000);
	nv_icmd(priv, 0x000533, 0xffff0000);
	nv_icmd(priv, 0x000534, 0xffff0000);
	nv_icmd(priv, 0x000535, 0xffff0000);
	nv_icmd(priv, 0x000536, 0xffff0000);
	nv_icmd(priv, 0x000537, 0xffff0000);
	nv_icmd(priv, 0x000538, 0xffff0000);
	nv_icmd(priv, 0x000539, 0xffff0000);
	nv_icmd(priv, 0x00053a, 0xffff0000);
	nv_icmd(priv, 0x00053b, 0xffff0000);
	nv_icmd(priv, 0x00053c, 0xffff0000);
	nv_icmd(priv, 0x00053d, 0xffff0000);
	nv_icmd(priv, 0x00053e, 0xffff0000);
	nv_icmd(priv, 0x00053f, 0xffff0000);
	nv_icmd(priv, 0x000585, 0x0000003f);
	nv_icmd(priv, 0x000576, 0x00000003);
	nv_icmd(priv, 0x00057b, 0x00000059);
	nv_icmd(priv, 0x000586, 0x00000040);
	nv_icmd(priv, 0x000582, 0x00000080);
	nv_icmd(priv, 0x000583, 0x00000080);
	nv_icmd(priv, 0x0005c2, 0x00000001);
	nv_icmd(priv, 0x000638, 0x00000001);
	nv_icmd(priv, 0x000639, 0x00000001);
	nv_icmd(priv, 0x00063a, 0x00000002);
	nv_icmd(priv, 0x00063b, 0x00000001);
	nv_icmd(priv, 0x00063c, 0x00000001);
	nv_icmd(priv, 0x00063d, 0x00000002);
	nv_icmd(priv, 0x00063e, 0x00000001);
	nv_icmd(priv, 0x0008b8, 0x00000001);
	nv_icmd(priv, 0x0008b9, 0x00000001);
	nv_icmd(priv, 0x0008ba, 0x00000001);
	nv_icmd(priv, 0x0008bb, 0x00000001);
	nv_icmd(priv, 0x0008bc, 0x00000001);
	nv_icmd(priv, 0x0008bd, 0x00000001);
	nv_icmd(priv, 0x0008be, 0x00000001);
	nv_icmd(priv, 0x0008bf, 0x00000001);
	nv_icmd(priv, 0x000900, 0x00000001);
	nv_icmd(priv, 0x000901, 0x00000001);
	nv_icmd(priv, 0x000902, 0x00000001);
	nv_icmd(priv, 0x000903, 0x00000001);
	nv_icmd(priv, 0x000904, 0x00000001);
	nv_icmd(priv, 0x000905, 0x00000001);
	nv_icmd(priv, 0x000906, 0x00000001);
	nv_icmd(priv, 0x000907, 0x00000001);
	nv_icmd(priv, 0x000908, 0x00000002);
	nv_icmd(priv, 0x000909, 0x00000002);
	nv_icmd(priv, 0x00090a, 0x00000002);
	nv_icmd(priv, 0x00090b, 0x00000002);
	nv_icmd(priv, 0x00090c, 0x00000002);
	nv_icmd(priv, 0x00090d, 0x00000002);
	nv_icmd(priv, 0x00090e, 0x00000002);
	nv_icmd(priv, 0x00090f, 0x00000002);
	nv_icmd(priv, 0x000910, 0x00000001);
	nv_icmd(priv, 0x000911, 0x00000001);
	nv_icmd(priv, 0x000912, 0x00000001);
	nv_icmd(priv, 0x000913, 0x00000001);
	nv_icmd(priv, 0x000914, 0x00000001);
	nv_icmd(priv, 0x000915, 0x00000001);
	nv_icmd(priv, 0x000916, 0x00000001);
	nv_icmd(priv, 0x000917, 0x00000001);
	nv_icmd(priv, 0x000918, 0x00000001);
	nv_icmd(priv, 0x000919, 0x00000001);
	nv_icmd(priv, 0x00091a, 0x00000001);
	nv_icmd(priv, 0x00091b, 0x00000001);
	nv_icmd(priv, 0x00091c, 0x00000001);
	nv_icmd(priv, 0x00091d, 0x00000001);
	nv_icmd(priv, 0x00091e, 0x00000001);
	nv_icmd(priv, 0x00091f, 0x00000001);
	nv_icmd(priv, 0x000920, 0x00000002);
	nv_icmd(priv, 0x000921, 0x00000002);
	nv_icmd(priv, 0x000922, 0x00000002);
	nv_icmd(priv, 0x000923, 0x00000002);
	nv_icmd(priv, 0x000924, 0x00000002);
	nv_icmd(priv, 0x000925, 0x00000002);
	nv_icmd(priv, 0x000926, 0x00000002);
	nv_icmd(priv, 0x000927, 0x00000002);
	nv_icmd(priv, 0x000928, 0x00000001);
	nv_icmd(priv, 0x000929, 0x00000001);
	nv_icmd(priv, 0x00092a, 0x00000001);
	nv_icmd(priv, 0x00092b, 0x00000001);
	nv_icmd(priv, 0x00092c, 0x00000001);
	nv_icmd(priv, 0x00092d, 0x00000001);
	nv_icmd(priv, 0x00092e, 0x00000001);
	nv_icmd(priv, 0x00092f, 0x00000001);
	nv_icmd(priv, 0x000648, 0x00000001);
	nv_icmd(priv, 0x000649, 0x00000001);
	nv_icmd(priv, 0x00064a, 0x00000001);
	nv_icmd(priv, 0x00064b, 0x00000001);
	nv_icmd(priv, 0x00064c, 0x00000001);
	nv_icmd(priv, 0x00064d, 0x00000001);
	nv_icmd(priv, 0x00064e, 0x00000001);
	nv_icmd(priv, 0x00064f, 0x00000001);
	nv_icmd(priv, 0x000650, 0x00000001);
	nv_icmd(priv, 0x000658, 0x0000000f);
	nv_icmd(priv, 0x0007ff, 0x0000000a);
	nv_icmd(priv, 0x00066a, 0x40000000);
	nv_icmd(priv, 0x00066b, 0x10000000);
	nv_icmd(priv, 0x00066c, 0xffff0000);
	nv_icmd(priv, 0x00066d, 0xffff0000);
	nv_icmd(priv, 0x0007af, 0x00000008);
	nv_icmd(priv, 0x0007b0, 0x00000008);
	nv_icmd(priv, 0x0007f6, 0x00000001);
	nv_icmd(priv, 0x0006b2, 0x00000055);
	nv_icmd(priv, 0x0007ad, 0x00000003);
	nv_icmd(priv, 0x000937, 0x00000001);
	nv_icmd(priv, 0x000971, 0x00000008);
	nv_icmd(priv, 0x000972, 0x00000040);
	nv_icmd(priv, 0x000973, 0x0000012c);
	nv_icmd(priv, 0x00097c, 0x00000040);
	nv_icmd(priv, 0x000979, 0x00000003);
	nv_icmd(priv, 0x000975, 0x00000020);
	nv_icmd(priv, 0x000976, 0x00000001);
	nv_icmd(priv, 0x000977, 0x00000020);
	nv_icmd(priv, 0x000978, 0x00000001);
	nv_icmd(priv, 0x000957, 0x00000003);
	nv_icmd(priv, 0x00095e, 0x20164010);
	nv_icmd(priv, 0x00095f, 0x00000020);
	nv_icmd(priv, 0x00097d, 0x00000020);
	nv_icmd(priv, 0x000683, 0x00000006);
	nv_icmd(priv, 0x000685, 0x003fffff);
	nv_icmd(priv, 0x000687, 0x003fffff);
	nv_icmd(priv, 0x0006a0, 0x00000005);
	nv_icmd(priv, 0x000840, 0x00400008);
	nv_icmd(priv, 0x000841, 0x08000080);
	nv_icmd(priv, 0x000842, 0x00400008);
	nv_icmd(priv, 0x000843, 0x08000080);
	nv_icmd(priv, 0x0006aa, 0x00000001);
	nv_icmd(priv, 0x0006ab, 0x00000002);
	nv_icmd(priv, 0x0006ac, 0x00000080);
	nv_icmd(priv, 0x0006ad, 0x00000100);
	nv_icmd(priv, 0x0006ae, 0x00000100);
	nv_icmd(priv, 0x0006b1, 0x00000011);
	nv_icmd(priv, 0x0006bb, 0x000000cf);
	nv_icmd(priv, 0x0006ce, 0x2a712488);
	nv_icmd(priv, 0x000739, 0x4085c000);
	nv_icmd(priv, 0x00073a, 0x00000080);
	nv_icmd(priv, 0x000786, 0x80000100);
	nv_icmd(priv, 0x00073c, 0x00010100);
	nv_icmd(priv, 0x00073d, 0x02800000);
	nv_icmd(priv, 0x000787, 0x000000cf);
	nv_icmd(priv, 0x00078c, 0x00000008);
	nv_icmd(priv, 0x000792, 0x00000001);
	nv_icmd(priv, 0x000794, 0x00000001);
	nv_icmd(priv, 0x000795, 0x00000001);
	nv_icmd(priv, 0x000796, 0x00000001);
	nv_icmd(priv, 0x000797, 0x000000cf);
	nv_icmd(priv, 0x000836, 0x00000001);
	nv_icmd(priv, 0x00079a, 0x00000002);
	nv_icmd(priv, 0x000833, 0x04444480);
	nv_icmd(priv, 0x0007a1, 0x00000001);
	nv_icmd(priv, 0x0007a3, 0x00000001);
	nv_icmd(priv, 0x0007a4, 0x00000001);
	nv_icmd(priv, 0x0007a5, 0x00000001);
	nv_icmd(priv, 0x000831, 0x00000004);
	nv_icmd(priv, 0x000b07, 0x00000002);
	nv_icmd(priv, 0x000b08, 0x00000100);
	nv_icmd(priv, 0x000b09, 0x00000100);
	nv_icmd(priv, 0x000b0a, 0x00000001);
	nv_icmd(priv, 0x000a04, 0x000000ff);
	nv_icmd(priv, 0x000a0b, 0x00000040);
	nv_icmd(priv, 0x00097f, 0x00000100);
	nv_icmd(priv, 0x000a02, 0x00000001);
	nv_icmd(priv, 0x000809, 0x00000007);
	nv_icmd(priv, 0x00c221, 0x00000040);
	nv_icmd(priv, 0x00c1b0, 0x0000000f);
	nv_icmd(priv, 0x00c1b1, 0x0000000f);
	nv_icmd(priv, 0x00c1b2, 0x0000000f);
	nv_icmd(priv, 0x00c1b3, 0x0000000f);
	nv_icmd(priv, 0x00c1b4, 0x0000000f);
	nv_icmd(priv, 0x00c1b5, 0x0000000f);
	nv_icmd(priv, 0x00c1b6, 0x0000000f);
	nv_icmd(priv, 0x00c1b7, 0x0000000f);
	nv_icmd(priv, 0x00c1b8, 0x0fac6881);
	nv_icmd(priv, 0x00c1b9, 0x00fac688);
	nv_icmd(priv, 0x00c401, 0x00000001);
	nv_icmd(priv, 0x00c402, 0x00010001);
	nv_icmd(priv, 0x00c403, 0x00000001);
	nv_icmd(priv, 0x00c404, 0x00000001);
	nv_icmd(priv, 0x00c40e, 0x00000020);
	nv_icmd(priv, 0x00c500, 0x00000003);
	nv_icmd(priv, 0x01e100, 0x00000001);
	nv_icmd(priv, 0x001000, 0x00000002);
	nv_icmd(priv, 0x0006aa, 0x00000001);
	nv_icmd(priv, 0x0006ad, 0x00000100);
	nv_icmd(priv, 0x0006ae, 0x00000100);
	nv_icmd(priv, 0x0006b1, 0x00000011);
	nv_icmd(priv, 0x00078c, 0x00000008);
	nv_icmd(priv, 0x000792, 0x00000001);
	nv_icmd(priv, 0x000794, 0x00000001);
	nv_icmd(priv, 0x000795, 0x00000001);
	nv_icmd(priv, 0x000796, 0x00000001);
	nv_icmd(priv, 0x000797, 0x000000cf);
	nv_icmd(priv, 0x00079a, 0x00000002);
	nv_icmd(priv, 0x000833, 0x04444480);
	nv_icmd(priv, 0x0007a1, 0x00000001);
	nv_icmd(priv, 0x0007a3, 0x00000001);
	nv_icmd(priv, 0x0007a4, 0x00000001);
	nv_icmd(priv, 0x0007a5, 0x00000001);
	nv_icmd(priv, 0x000831, 0x00000004);
	nv_icmd(priv, 0x01e100, 0x00000001);
	nv_icmd(priv, 0x001000, 0x00000008);
	nv_icmd(priv, 0x000039, 0x00000000);
	nv_icmd(priv, 0x00003a, 0x00000000);
	nv_icmd(priv, 0x00003b, 0x00000000);
	nv_icmd(priv, 0x000380, 0x00000001);
	nv_icmd(priv, 0x000366, 0x00000000);
	nv_icmd(priv, 0x000367, 0x00000000);
	nv_icmd(priv, 0x000368, 0x00000fff);
	nv_icmd(priv, 0x000370, 0x00000000);
	nv_icmd(priv, 0x000371, 0x00000000);
	nv_icmd(priv, 0x000372, 0x000fffff);
	nv_icmd(priv, 0x000813, 0x00000006);
	nv_icmd(priv, 0x000814, 0x00000008);
	nv_icmd(priv, 0x000957, 0x00000003);
	nv_icmd(priv, 0x000b07, 0x00000002);
	nv_icmd(priv, 0x000b08, 0x00000100);
	nv_icmd(priv, 0x000b09, 0x00000100);
	nv_icmd(priv, 0x000b0a, 0x00000001);
	nv_icmd(priv, 0x000a04, 0x000000ff);
	nv_icmd(priv, 0x00097f, 0x00000100);
	nv_icmd(priv, 0x000a02, 0x00000001);
	nv_icmd(priv, 0x000809, 0x00000007);
	nv_icmd(priv, 0x00c221, 0x00000040);
	nv_icmd(priv, 0x00c401, 0x00000001);
	nv_icmd(priv, 0x00c402, 0x00010001);
	nv_icmd(priv, 0x00c403, 0x00000001);
	nv_icmd(priv, 0x00c404, 0x00000001);
	nv_icmd(priv, 0x00c40e, 0x00000020);
	nv_icmd(priv, 0x00c500, 0x00000003);
	nv_icmd(priv, 0x01e100, 0x00000001);
	nv_icmd(priv, 0x001000, 0x00000001);
	nv_icmd(priv, 0x000b07, 0x00000002);
	nv_icmd(priv, 0x000b08, 0x00000100);
	nv_icmd(priv, 0x000b09, 0x00000100);
	nv_icmd(priv, 0x000b0a, 0x00000001);
	nv_icmd(priv, 0x01e100, 0x00000001);
	nv_wr32(priv, 0x400208, 0x00000000);
}

static void
nve0_grctx_generate_a097(struct nvc0_graph_priv *priv)
{
	nv_mthd(priv, 0xa097, 0x0800, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0840, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0880, 0x00000000);
	nv_mthd(priv, 0xa097, 0x08c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0900, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0940, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0980, 0x00000000);
	nv_mthd(priv, 0xa097, 0x09c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0804, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0844, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0884, 0x00000000);
	nv_mthd(priv, 0xa097, 0x08c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0904, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0944, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0984, 0x00000000);
	nv_mthd(priv, 0xa097, 0x09c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0808, 0x00000400);
	nv_mthd(priv, 0xa097, 0x0848, 0x00000400);
	nv_mthd(priv, 0xa097, 0x0888, 0x00000400);
	nv_mthd(priv, 0xa097, 0x08c8, 0x00000400);
	nv_mthd(priv, 0xa097, 0x0908, 0x00000400);
	nv_mthd(priv, 0xa097, 0x0948, 0x00000400);
	nv_mthd(priv, 0xa097, 0x0988, 0x00000400);
	nv_mthd(priv, 0xa097, 0x09c8, 0x00000400);
	nv_mthd(priv, 0xa097, 0x080c, 0x00000300);
	nv_mthd(priv, 0xa097, 0x084c, 0x00000300);
	nv_mthd(priv, 0xa097, 0x088c, 0x00000300);
	nv_mthd(priv, 0xa097, 0x08cc, 0x00000300);
	nv_mthd(priv, 0xa097, 0x090c, 0x00000300);
	nv_mthd(priv, 0xa097, 0x094c, 0x00000300);
	nv_mthd(priv, 0xa097, 0x098c, 0x00000300);
	nv_mthd(priv, 0xa097, 0x09cc, 0x00000300);
	nv_mthd(priv, 0xa097, 0x0810, 0x000000cf);
	nv_mthd(priv, 0xa097, 0x0850, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0890, 0x00000000);
	nv_mthd(priv, 0xa097, 0x08d0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0910, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0950, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0990, 0x00000000);
	nv_mthd(priv, 0xa097, 0x09d0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0814, 0x00000040);
	nv_mthd(priv, 0xa097, 0x0854, 0x00000040);
	nv_mthd(priv, 0xa097, 0x0894, 0x00000040);
	nv_mthd(priv, 0xa097, 0x08d4, 0x00000040);
	nv_mthd(priv, 0xa097, 0x0914, 0x00000040);
	nv_mthd(priv, 0xa097, 0x0954, 0x00000040);
	nv_mthd(priv, 0xa097, 0x0994, 0x00000040);
	nv_mthd(priv, 0xa097, 0x09d4, 0x00000040);
	nv_mthd(priv, 0xa097, 0x0818, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0858, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0898, 0x00000001);
	nv_mthd(priv, 0xa097, 0x08d8, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0918, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0958, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0998, 0x00000001);
	nv_mthd(priv, 0xa097, 0x09d8, 0x00000001);
	nv_mthd(priv, 0xa097, 0x081c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x085c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x089c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x08dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x091c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x095c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x099c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x09dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0820, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0860, 0x00000000);
	nv_mthd(priv, 0xa097, 0x08a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x08e0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0920, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0960, 0x00000000);
	nv_mthd(priv, 0xa097, 0x09a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x09e0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c00, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c10, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c20, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c30, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c40, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c50, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c60, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c70, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c80, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ca0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cb0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cc0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cd0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ce0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cf0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c04, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c14, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c24, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c34, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c44, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c54, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c64, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c74, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c84, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c94, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ca4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cb4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cc4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cd4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ce4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cf4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c08, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c18, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c28, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c38, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c48, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c58, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c68, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c78, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c88, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c98, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ca8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cb8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cc8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cd8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ce8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cf8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c0c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c1c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c2c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c3c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c4c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c5c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c6c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c7c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c8c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1c9c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cbc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ccc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cdc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1cfc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d00, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d10, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d20, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d30, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d40, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d50, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d60, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d70, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d80, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1da0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1db0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dc0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dd0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1de0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1df0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d04, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d14, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d24, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d34, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d44, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d54, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d64, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d74, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d84, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d94, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1da4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1db4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dc4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dd4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1de4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1df4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d08, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d18, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d28, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d38, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d48, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d58, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d68, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d78, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d88, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d98, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1da8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1db8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dc8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dd8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1de8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1df8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d0c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d1c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d2c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d3c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d4c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d5c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d6c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d7c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d8c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1d9c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dbc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dcc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ddc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1dfc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f00, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f08, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f10, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f18, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f20, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f28, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f30, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f38, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f40, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f48, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f50, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f58, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f60, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f68, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f70, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f78, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f04, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f0c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f14, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f1c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f24, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f2c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f34, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f3c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f44, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f4c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f54, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f5c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f64, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f6c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f74, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f7c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f80, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f88, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f98, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fa0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fa8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fb0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fb8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fc0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fc8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fd0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fd8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fe0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fe8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ff0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ff8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f84, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f8c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f94, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1f9c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fa4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fb4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fbc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fc4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fcc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fd4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fdc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fe4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1fec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ff4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1ffc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2000, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2040, 0x00000011);
	nv_mthd(priv, 0xa097, 0x2080, 0x00000020);
	nv_mthd(priv, 0xa097, 0x20c0, 0x00000030);
	nv_mthd(priv, 0xa097, 0x2100, 0x00000040);
	nv_mthd(priv, 0xa097, 0x2140, 0x00000051);
	nv_mthd(priv, 0xa097, 0x200c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x204c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x208c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x20cc, 0x00000001);
	nv_mthd(priv, 0xa097, 0x210c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x214c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x2010, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2050, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2090, 0x00000001);
	nv_mthd(priv, 0xa097, 0x20d0, 0x00000002);
	nv_mthd(priv, 0xa097, 0x2110, 0x00000003);
	nv_mthd(priv, 0xa097, 0x2150, 0x00000004);
	nv_mthd(priv, 0xa097, 0x0380, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03e0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0384, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03e4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0388, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03a8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03c8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03e8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x038c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03ac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x03ec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0700, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0710, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0720, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0730, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0704, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0714, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0724, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0734, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0708, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0718, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0728, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0738, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2800, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2804, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2808, 0x00000000);
	nv_mthd(priv, 0xa097, 0x280c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2810, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2814, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2818, 0x00000000);
	nv_mthd(priv, 0xa097, 0x281c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2820, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2824, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2828, 0x00000000);
	nv_mthd(priv, 0xa097, 0x282c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2830, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2834, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2838, 0x00000000);
	nv_mthd(priv, 0xa097, 0x283c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2840, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2844, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2848, 0x00000000);
	nv_mthd(priv, 0xa097, 0x284c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2850, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2854, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2858, 0x00000000);
	nv_mthd(priv, 0xa097, 0x285c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2860, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2864, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2868, 0x00000000);
	nv_mthd(priv, 0xa097, 0x286c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2870, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2874, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2878, 0x00000000);
	nv_mthd(priv, 0xa097, 0x287c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2880, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2884, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2888, 0x00000000);
	nv_mthd(priv, 0xa097, 0x288c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2890, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2894, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2898, 0x00000000);
	nv_mthd(priv, 0xa097, 0x289c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28a8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28ac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28b0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28b4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28b8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28bc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28c8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28d0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28d4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28d8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28e0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28e4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28e8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28ec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28f0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28f4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28f8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x28fc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2900, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2904, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2908, 0x00000000);
	nv_mthd(priv, 0xa097, 0x290c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2910, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2914, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2918, 0x00000000);
	nv_mthd(priv, 0xa097, 0x291c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2920, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2924, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2928, 0x00000000);
	nv_mthd(priv, 0xa097, 0x292c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2930, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2934, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2938, 0x00000000);
	nv_mthd(priv, 0xa097, 0x293c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2940, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2944, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2948, 0x00000000);
	nv_mthd(priv, 0xa097, 0x294c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2950, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2954, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2958, 0x00000000);
	nv_mthd(priv, 0xa097, 0x295c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2960, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2964, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2968, 0x00000000);
	nv_mthd(priv, 0xa097, 0x296c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2970, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2974, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2978, 0x00000000);
	nv_mthd(priv, 0xa097, 0x297c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2980, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2984, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2988, 0x00000000);
	nv_mthd(priv, 0xa097, 0x298c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2990, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2994, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2998, 0x00000000);
	nv_mthd(priv, 0xa097, 0x299c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29a8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29ac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29b0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29b4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29b8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29bc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29c8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29d0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29d4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29d8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29e0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29e4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29e8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29ec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29f0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29f4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29f8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x29fc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a00, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a20, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a40, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a60, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a80, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0aa0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ac0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ae0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b00, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b20, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b40, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b60, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b80, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ba0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bc0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0be0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a04, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a24, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a44, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a64, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a84, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0aa4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ac4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ae4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b04, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b24, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b44, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b64, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b84, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ba4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bc4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0be4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a08, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a28, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a48, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a68, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a88, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0aa8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ac8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ae8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b08, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b28, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b48, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b68, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b88, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ba8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bc8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0be8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a0c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a2c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a4c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a6c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a8c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0aac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0acc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0aec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b0c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b2c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b4c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b6c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b8c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bcc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a10, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a30, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a50, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a70, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ab0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ad0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0af0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b10, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b30, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b50, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b70, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bb0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bd0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bf0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a14, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a34, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a54, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a74, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0a94, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ab4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ad4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0af4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b14, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b34, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b54, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b74, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0b94, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bb4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bd4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0bf4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c00, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c10, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c20, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c30, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c40, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c50, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c60, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c70, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c80, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ca0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cb0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cc0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cd0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ce0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cf0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c04, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c14, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c24, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c34, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c44, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c54, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c64, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c74, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c84, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c94, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ca4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cb4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cc4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cd4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ce4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cf4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c08, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c18, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c28, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c38, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c48, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c58, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c68, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c78, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c88, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c98, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ca8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cb8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cc8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cd8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ce8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0cf8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0c0c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c1c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c2c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c3c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c4c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c5c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c6c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c7c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c8c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0c9c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0cac, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0cbc, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0ccc, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0cdc, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0cec, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0cfc, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0d00, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d08, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d10, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d18, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d20, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d28, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d30, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d38, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d04, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d0c, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d14, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d1c, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d24, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d2c, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d34, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d3c, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e00, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e10, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e20, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e30, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e40, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e50, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e60, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e70, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e80, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ea0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0eb0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ec0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ed0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ee0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ef0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0e04, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e14, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e24, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e34, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e44, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e54, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e64, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e74, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e84, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e94, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ea4, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0eb4, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ec4, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ed4, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ee4, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ef4, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e08, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e18, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e28, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e38, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e48, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e58, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e68, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e78, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e88, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0e98, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ea8, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0eb8, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ec8, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ed8, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ee8, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0ef8, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d40, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d48, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d50, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d58, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d44, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d4c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d54, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d5c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1e00, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e20, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e40, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e60, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e80, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ea0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ec0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ee0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e04, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e24, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e44, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e64, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e84, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ea4, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ec4, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ee4, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e08, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e28, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e48, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e68, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e88, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1ea8, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1ec8, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1ee8, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e0c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e2c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e4c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e6c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e8c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1eac, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ecc, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1eec, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e10, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e30, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e50, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e70, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e90, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1eb0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ed0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ef0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e14, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e34, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e54, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e74, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e94, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1eb4, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1ed4, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1ef4, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1e18, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e38, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e58, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e78, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1e98, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1eb8, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ed8, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1ef8, 0x00000001);
	nv_mthd(priv, 0xa097, 0x3400, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3404, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3408, 0x00000000);
	nv_mthd(priv, 0xa097, 0x340c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3410, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3414, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3418, 0x00000000);
	nv_mthd(priv, 0xa097, 0x341c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3420, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3424, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3428, 0x00000000);
	nv_mthd(priv, 0xa097, 0x342c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3430, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3434, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3438, 0x00000000);
	nv_mthd(priv, 0xa097, 0x343c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3440, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3444, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3448, 0x00000000);
	nv_mthd(priv, 0xa097, 0x344c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3450, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3454, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3458, 0x00000000);
	nv_mthd(priv, 0xa097, 0x345c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3460, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3464, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3468, 0x00000000);
	nv_mthd(priv, 0xa097, 0x346c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3470, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3474, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3478, 0x00000000);
	nv_mthd(priv, 0xa097, 0x347c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3480, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3484, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3488, 0x00000000);
	nv_mthd(priv, 0xa097, 0x348c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3490, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3494, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3498, 0x00000000);
	nv_mthd(priv, 0xa097, 0x349c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34a8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34ac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34b0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34b4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34b8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34bc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34c8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34d0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34d4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34d8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34e0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34e4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34e8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34ec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34f0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34f4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34f8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x34fc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3500, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3504, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3508, 0x00000000);
	nv_mthd(priv, 0xa097, 0x350c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3510, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3514, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3518, 0x00000000);
	nv_mthd(priv, 0xa097, 0x351c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3520, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3524, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3528, 0x00000000);
	nv_mthd(priv, 0xa097, 0x352c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3530, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3534, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3538, 0x00000000);
	nv_mthd(priv, 0xa097, 0x353c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3540, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3544, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3548, 0x00000000);
	nv_mthd(priv, 0xa097, 0x354c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3550, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3554, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3558, 0x00000000);
	nv_mthd(priv, 0xa097, 0x355c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3560, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3564, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3568, 0x00000000);
	nv_mthd(priv, 0xa097, 0x356c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3570, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3574, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3578, 0x00000000);
	nv_mthd(priv, 0xa097, 0x357c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3580, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3584, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3588, 0x00000000);
	nv_mthd(priv, 0xa097, 0x358c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3590, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3594, 0x00000000);
	nv_mthd(priv, 0xa097, 0x3598, 0x00000000);
	nv_mthd(priv, 0xa097, 0x359c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35a8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35ac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35b0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35b4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35b8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35bc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35c8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35d0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35d4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35d8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35e0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35e4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35e8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35ec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35f0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35f4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35f8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x35fc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x030c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1944, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1514, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d68, 0x0000ffff);
	nv_mthd(priv, 0xa097, 0x121c, 0x0fac6881);
	nv_mthd(priv, 0xa097, 0x0fac, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1538, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0fe0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0fe4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0fe8, 0x00000014);
	nv_mthd(priv, 0xa097, 0x0fec, 0x00000040);
	nv_mthd(priv, 0xa097, 0x0ff0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x179c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1228, 0x00000400);
	nv_mthd(priv, 0xa097, 0x122c, 0x00000300);
	nv_mthd(priv, 0xa097, 0x1230, 0x00010001);
	nv_mthd(priv, 0xa097, 0x07f8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x15b4, 0x00000001);
	nv_mthd(priv, 0xa097, 0x15cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1534, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0fb0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x15d0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x153c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x16b4, 0x00000003);
	nv_mthd(priv, 0xa097, 0x0fbc, 0x0000ffff);
	nv_mthd(priv, 0xa097, 0x0fc0, 0x0000ffff);
	nv_mthd(priv, 0xa097, 0x0fc4, 0x0000ffff);
	nv_mthd(priv, 0xa097, 0x0fc8, 0x0000ffff);
	nv_mthd(priv, 0xa097, 0x0df8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0dfc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1948, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1970, 0x00000001);
	nv_mthd(priv, 0xa097, 0x161c, 0x000009f0);
	nv_mthd(priv, 0xa097, 0x0dcc, 0x00000010);
	nv_mthd(priv, 0xa097, 0x163c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x15e4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1160, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1164, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1168, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x116c, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1170, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1174, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1178, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x117c, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1180, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1184, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1188, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x118c, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1190, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1194, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1198, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x119c, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11a0, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11a4, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11a8, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11ac, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11b0, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11b4, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11b8, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11bc, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11c0, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11c4, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11c8, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11cc, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11d0, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11d4, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11d8, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x11dc, 0x25e00040);
	nv_mthd(priv, 0xa097, 0x1880, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1884, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1888, 0x00000000);
	nv_mthd(priv, 0xa097, 0x188c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1890, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1894, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1898, 0x00000000);
	nv_mthd(priv, 0xa097, 0x189c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18a8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18ac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18b0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18b4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18b8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18bc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18c8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18d0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18d4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18d8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18e0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18e4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18e8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18ec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18f0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18f4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18f8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x18fc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0f84, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0f88, 0x00000000);
	nv_mthd(priv, 0xa097, 0x17c8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x17cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x17d0, 0x000000ff);
	nv_mthd(priv, 0xa097, 0x17d4, 0xffffffff);
	nv_mthd(priv, 0xa097, 0x17d8, 0x00000002);
	nv_mthd(priv, 0xa097, 0x17dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x15f4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x15f8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1434, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1438, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d74, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0dec, 0x00000001);
	nv_mthd(priv, 0xa097, 0x13a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1318, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1644, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0748, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0de8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1648, 0x00000000);
	nv_mthd(priv, 0xa097, 0x12a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1120, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1124, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1128, 0x00000000);
	nv_mthd(priv, 0xa097, 0x112c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1118, 0x00000000);
	nv_mthd(priv, 0xa097, 0x164c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1658, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1910, 0x00000290);
	nv_mthd(priv, 0xa097, 0x1518, 0x00000000);
	nv_mthd(priv, 0xa097, 0x165c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1520, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1604, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1570, 0x00000000);
	nv_mthd(priv, 0xa097, 0x13b0, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x13b4, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x020c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1670, 0x30201000);
	nv_mthd(priv, 0xa097, 0x1674, 0x70605040);
	nv_mthd(priv, 0xa097, 0x1678, 0xb8a89888);
	nv_mthd(priv, 0xa097, 0x167c, 0xf8e8d8c8);
	nv_mthd(priv, 0xa097, 0x166c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1680, 0x00ffff00);
	nv_mthd(priv, 0xa097, 0x12d0, 0x00000003);
	nv_mthd(priv, 0xa097, 0x12d4, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1684, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1688, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0dac, 0x00001b02);
	nv_mthd(priv, 0xa097, 0x0db0, 0x00001b02);
	nv_mthd(priv, 0xa097, 0x0db4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x168c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x15bc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x156c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x187c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1110, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0dc0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0dc4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0dc8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1234, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1690, 0x00000000);
	nv_mthd(priv, 0xa097, 0x12ac, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0790, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0794, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0798, 0x00000000);
	nv_mthd(priv, 0xa097, 0x079c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x07a0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x077c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1000, 0x00000010);
	nv_mthd(priv, 0xa097, 0x10fc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1290, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0218, 0x00000010);
	nv_mthd(priv, 0xa097, 0x12d8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x12dc, 0x00000010);
	nv_mthd(priv, 0xa097, 0x0d94, 0x00000001);
	nv_mthd(priv, 0xa097, 0x155c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1560, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1564, 0x00000fff);
	nv_mthd(priv, 0xa097, 0x1574, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1578, 0x00000000);
	nv_mthd(priv, 0xa097, 0x157c, 0x000fffff);
	nv_mthd(priv, 0xa097, 0x1354, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1610, 0x00000012);
	nv_mthd(priv, 0xa097, 0x1608, 0x00000000);
	nv_mthd(priv, 0xa097, 0x160c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x260c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x07ac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x162c, 0x00000003);
	nv_mthd(priv, 0xa097, 0x0210, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0320, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0324, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0328, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x032c, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0330, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0334, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0338, 0x3f800000);
	nv_mthd(priv, 0xa097, 0x0750, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0760, 0x39291909);
	nv_mthd(priv, 0xa097, 0x0764, 0x79695949);
	nv_mthd(priv, 0xa097, 0x0768, 0xb9a99989);
	nv_mthd(priv, 0xa097, 0x076c, 0xf9e9d9c9);
	nv_mthd(priv, 0xa097, 0x0770, 0x30201000);
	nv_mthd(priv, 0xa097, 0x0774, 0x70605040);
	nv_mthd(priv, 0xa097, 0x0778, 0x00009080);
	nv_mthd(priv, 0xa097, 0x0780, 0x39291909);
	nv_mthd(priv, 0xa097, 0x0784, 0x79695949);
	nv_mthd(priv, 0xa097, 0x0788, 0xb9a99989);
	nv_mthd(priv, 0xa097, 0x078c, 0xf9e9d9c9);
	nv_mthd(priv, 0xa097, 0x07d0, 0x30201000);
	nv_mthd(priv, 0xa097, 0x07d4, 0x70605040);
	nv_mthd(priv, 0xa097, 0x07d8, 0x00009080);
	nv_mthd(priv, 0xa097, 0x037c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0740, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0744, 0x00000000);
	nv_mthd(priv, 0xa097, 0x2600, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1918, 0x00000000);
	nv_mthd(priv, 0xa097, 0x191c, 0x00000900);
	nv_mthd(priv, 0xa097, 0x1920, 0x00000405);
	nv_mthd(priv, 0xa097, 0x1308, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1924, 0x00000000);
	nv_mthd(priv, 0xa097, 0x13ac, 0x00000000);
	nv_mthd(priv, 0xa097, 0x192c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x193c, 0x00002c1c);
	nv_mthd(priv, 0xa097, 0x0d7c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0f8c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x02c0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1510, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1940, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ff4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0ff8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x194c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1950, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1968, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1590, 0x0000003f);
	nv_mthd(priv, 0xa097, 0x07e8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x07ec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x07f0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x07f4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x196c, 0x00000011);
	nv_mthd(priv, 0xa097, 0x02e4, 0x0000b001);
	nv_mthd(priv, 0xa097, 0x036c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0370, 0x00000000);
	nv_mthd(priv, 0xa097, 0x197c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0fcc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0fd0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x02d8, 0x00000040);
	nv_mthd(priv, 0xa097, 0x1980, 0x00000080);
	nv_mthd(priv, 0xa097, 0x1504, 0x00000080);
	nv_mthd(priv, 0xa097, 0x1984, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0300, 0x00000001);
	nv_mthd(priv, 0xa097, 0x13a8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x12ec, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1310, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1314, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1380, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1384, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1388, 0x00000001);
	nv_mthd(priv, 0xa097, 0x138c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1390, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1394, 0x00000000);
	nv_mthd(priv, 0xa097, 0x139c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1398, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1594, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1598, 0x00000001);
	nv_mthd(priv, 0xa097, 0x159c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x15a0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x15a4, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0f54, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0f58, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0f5c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x19bc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0f9c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0fa0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x12cc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x12e8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x130c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1360, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1364, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1368, 0x00000000);
	nv_mthd(priv, 0xa097, 0x136c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1370, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1374, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1378, 0x00000000);
	nv_mthd(priv, 0xa097, 0x137c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x133c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1340, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1344, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1348, 0x00000001);
	nv_mthd(priv, 0xa097, 0x134c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1350, 0x00000002);
	nv_mthd(priv, 0xa097, 0x1358, 0x00000001);
	nv_mthd(priv, 0xa097, 0x12e4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x131c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1320, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1324, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1328, 0x00000000);
	nv_mthd(priv, 0xa097, 0x19c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1140, 0x00000000);
	nv_mthd(priv, 0xa097, 0x19c4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x19c8, 0x00001500);
	nv_mthd(priv, 0xa097, 0x135c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0f90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x19e0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x19e4, 0x00000001);
	nv_mthd(priv, 0xa097, 0x19e8, 0x00000001);
	nv_mthd(priv, 0xa097, 0x19ec, 0x00000001);
	nv_mthd(priv, 0xa097, 0x19f0, 0x00000001);
	nv_mthd(priv, 0xa097, 0x19f4, 0x00000001);
	nv_mthd(priv, 0xa097, 0x19f8, 0x00000001);
	nv_mthd(priv, 0xa097, 0x19fc, 0x00000001);
	nv_mthd(priv, 0xa097, 0x19cc, 0x00000001);
	nv_mthd(priv, 0xa097, 0x15b8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1a00, 0x00001111);
	nv_mthd(priv, 0xa097, 0x1a04, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1a08, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1a0c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1a10, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1a14, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1a18, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1a1c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d6c, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x0d70, 0xffff0000);
	nv_mthd(priv, 0xa097, 0x10f8, 0x00001010);
	nv_mthd(priv, 0xa097, 0x0d80, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d84, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d88, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d8c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0d90, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0da0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x07a4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x07a8, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1508, 0x80000000);
	nv_mthd(priv, 0xa097, 0x150c, 0x40000000);
	nv_mthd(priv, 0xa097, 0x1668, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0318, 0x00000008);
	nv_mthd(priv, 0xa097, 0x031c, 0x00000008);
	nv_mthd(priv, 0xa097, 0x0d9c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x0374, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0378, 0x00000020);
	nv_mthd(priv, 0xa097, 0x07dc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x074c, 0x00000055);
	nv_mthd(priv, 0xa097, 0x1420, 0x00000003);
	nv_mthd(priv, 0xa097, 0x17bc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x17c0, 0x00000000);
	nv_mthd(priv, 0xa097, 0x17c4, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1008, 0x00000008);
	nv_mthd(priv, 0xa097, 0x100c, 0x00000040);
	nv_mthd(priv, 0xa097, 0x1010, 0x0000012c);
	nv_mthd(priv, 0xa097, 0x0d60, 0x00000040);
	nv_mthd(priv, 0xa097, 0x075c, 0x00000003);
	nv_mthd(priv, 0xa097, 0x1018, 0x00000020);
	nv_mthd(priv, 0xa097, 0x101c, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1020, 0x00000020);
	nv_mthd(priv, 0xa097, 0x1024, 0x00000001);
	nv_mthd(priv, 0xa097, 0x1444, 0x00000000);
	nv_mthd(priv, 0xa097, 0x1448, 0x00000000);
	nv_mthd(priv, 0xa097, 0x144c, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0360, 0x20164010);
	nv_mthd(priv, 0xa097, 0x0364, 0x00000020);
	nv_mthd(priv, 0xa097, 0x0368, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0de4, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0204, 0x00000006);
	nv_mthd(priv, 0xa097, 0x0208, 0x00000000);
	nv_mthd(priv, 0xa097, 0x02cc, 0x003fffff);
	nv_mthd(priv, 0xa097, 0x02d0, 0x003fffff);
	nv_mthd(priv, 0xa097, 0x1220, 0x00000005);
	nv_mthd(priv, 0xa097, 0x0fdc, 0x00000000);
	nv_mthd(priv, 0xa097, 0x0f98, 0x00400008);
	nv_mthd(priv, 0xa097, 0x1284, 0x08000080);
	nv_mthd(priv, 0xa097, 0x1450, 0x00400008);
	nv_mthd(priv, 0xa097, 0x1454, 0x08000080);
	nv_mthd(priv, 0xa097, 0x0214, 0x00000000);
}

static void
nve0_grctx_generate_902d(struct nvc0_graph_priv *priv)
{
	nv_mthd(priv, 0x902d, 0x0200, 0x000000cf);
	nv_mthd(priv, 0x902d, 0x0204, 0x00000001);
	nv_mthd(priv, 0x902d, 0x0208, 0x00000020);
	nv_mthd(priv, 0x902d, 0x020c, 0x00000001);
	nv_mthd(priv, 0x902d, 0x0210, 0x00000000);
	nv_mthd(priv, 0x902d, 0x0214, 0x00000080);
	nv_mthd(priv, 0x902d, 0x0218, 0x00000100);
	nv_mthd(priv, 0x902d, 0x021c, 0x00000100);
	nv_mthd(priv, 0x902d, 0x0220, 0x00000000);
	nv_mthd(priv, 0x902d, 0x0224, 0x00000000);
	nv_mthd(priv, 0x902d, 0x0230, 0x000000cf);
	nv_mthd(priv, 0x902d, 0x0234, 0x00000001);
	nv_mthd(priv, 0x902d, 0x0238, 0x00000020);
	nv_mthd(priv, 0x902d, 0x023c, 0x00000001);
	nv_mthd(priv, 0x902d, 0x0244, 0x00000080);
	nv_mthd(priv, 0x902d, 0x0248, 0x00000100);
	nv_mthd(priv, 0x902d, 0x024c, 0x00000100);
	switch (nv_device(priv)->chipset) {
	case 0xe6:
		nv_mthd(priv, 0x902d, 0x3410, 0x80002006);
		break;
	case 0xe4:
	case 0xe7:
	default:
		nv_mthd(priv, 0x902d, 0x3410, 0x00000000);
		break;
	}
}

static void
nve0_graph_generate_unk40xx(struct nvc0_graph_priv *priv)
{
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x404004, 0x00000000);
		nv_wr32(priv, 0x404008, 0x00000000);
		nv_wr32(priv, 0x40400c, 0x00000000);
		break;
	default:
		break;
	}
	nv_wr32(priv, 0x404010, 0x0);
	nv_wr32(priv, 0x404014, 0x0);
	nv_wr32(priv, 0x404018, 0x0);
	nv_wr32(priv, 0x40401c, 0x0);
	nv_wr32(priv, 0x404020, 0x0);
	nv_wr32(priv, 0x404024, 0xe000);
	nv_wr32(priv, 0x404028, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x40402c, 0x00000000);
		nv_wr32(priv, 0x404030, 0x00000000);
		nv_wr32(priv, 0x404034, 0x00000000);
		nv_wr32(priv, 0x404038, 0x00000000);
		nv_wr32(priv, 0x40403c, 0x00000000);
		nv_wr32(priv, 0x404040, 0x00000000);
		nv_wr32(priv, 0x404044, 0x00000000);
		break;
	default:
		break;
	}
	nv_wr32(priv, 0x4040a8, 0x0);
	nv_wr32(priv, 0x4040ac, 0x0);
	nv_wr32(priv, 0x4040b0, 0x0);
	nv_wr32(priv, 0x4040b4, 0x0);
	nv_wr32(priv, 0x4040b8, 0x0);
	nv_wr32(priv, 0x4040bc, 0x0);
	nv_wr32(priv, 0x4040c0, 0x0);
	nv_wr32(priv, 0x4040c4, 0x0);
	nv_wr32(priv, 0x4040c8, 0xf800008f);
	nv_wr32(priv, 0x4040d0, 0x0);
	nv_wr32(priv, 0x4040d4, 0x0);
	nv_wr32(priv, 0x4040d8, 0x0);
	nv_wr32(priv, 0x4040dc, 0x0);
	nv_wr32(priv, 0x4040e0, 0x0);
	nv_wr32(priv, 0x4040e4, 0x0);
	nv_wr32(priv, 0x4040e8, 0x1000);
	nv_wr32(priv, 0x4040f8, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x404100, 0x00000000);
		nv_wr32(priv, 0x404104, 0x00000000);
		nv_wr32(priv, 0x404108, 0x00000000);
		nv_wr32(priv, 0x40410c, 0x00000000);
		nv_wr32(priv, 0x404110, 0x00000000);
		nv_wr32(priv, 0x404114, 0x00000000);
		nv_wr32(priv, 0x404118, 0x00000000);
		nv_wr32(priv, 0x40411c, 0x00000000);
		nv_wr32(priv, 0x404120, 0x00000000);
		nv_wr32(priv, 0x404124, 0x00000000);
		break;
	default:
		break;
	}
	nv_wr32(priv, 0x404130, 0x0);
	nv_wr32(priv, 0x404134, 0x0);
	nv_wr32(priv, 0x404138, 0x20000040);
	nv_wr32(priv, 0x404150, 0x2e);
	nv_wr32(priv, 0x404154, 0x400);
	nv_wr32(priv, 0x404158, 0x200);
	nv_wr32(priv, 0x404164, 0x55);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x40417c, 0x00000000);
		nv_wr32(priv, 0x404180, 0x00000000);
		break;
	default:
		break;
	}
	nv_wr32(priv, 0x4041a0, 0x0);
	nv_wr32(priv, 0x4041a4, 0x0);
	nv_wr32(priv, 0x4041a8, 0x0);
	nv_wr32(priv, 0x4041ac, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x404200, 0xa197);
		nv_wr32(priv, 0x404204, 0xa1c0);
		nv_wr32(priv, 0x404208, 0xa140);
		nv_wr32(priv, 0x40420c, 0x902d);
		break;
	default:
		nv_wr32(priv, 0x404200, 0x0);
		nv_wr32(priv, 0x404204, 0x0);
		nv_wr32(priv, 0x404208, 0x0);
		nv_wr32(priv, 0x40420c, 0x0);
		break;
	}
}

static void
nve0_graph_generate_unk44xx(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x404404, 0x0);
	nv_wr32(priv, 0x404408, 0x0);
	nv_wr32(priv, 0x40440c, 0x0);
	nv_wr32(priv, 0x404410, 0x0);
	nv_wr32(priv, 0x404414, 0x0);
	nv_wr32(priv, 0x404418, 0x0);
	nv_wr32(priv, 0x40441c, 0x0);
	nv_wr32(priv, 0x404420, 0x0);
	nv_wr32(priv, 0x404424, 0x0);
	nv_wr32(priv, 0x404428, 0x0);
	nv_wr32(priv, 0x40442c, 0x0);
	nv_wr32(priv, 0x404430, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		break;
	default:
		nv_wr32(priv, 0x404434, 0x0);
		break;
	}
	nv_wr32(priv, 0x404438, 0x0);
	nv_wr32(priv, 0x404460, 0x0);
	nv_wr32(priv, 0x404464, 0x0);
	nv_wr32(priv, 0x404468, 0xffffff);
	nv_wr32(priv, 0x40446c, 0x0);
	nv_wr32(priv, 0x404480, 0x1);
	nv_wr32(priv, 0x404498, 0x1);
}

static void
nve0_graph_generate_unk46xx(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x404604, 0x14);
	nv_wr32(priv, 0x404608, 0x0);
	nv_wr32(priv, 0x40460c, 0x3fff);
	nv_wr32(priv, 0x404610, 0x100);
	nv_wr32(priv, 0x404618, 0x0);
	nv_wr32(priv, 0x40461c, 0x0);
	nv_wr32(priv, 0x404620, 0x0);
	nv_wr32(priv, 0x404624, 0x0);
	nv_wr32(priv, 0x40462c, 0x0);
	nv_wr32(priv, 0x404630, 0x0);
	nv_wr32(priv, 0x404640, 0x0);
	nv_wr32(priv, 0x404654, 0x0);
	nv_wr32(priv, 0x404660, 0x0);
	nv_wr32(priv, 0x404678, 0x0);
	nv_wr32(priv, 0x40467c, 0x2);
	nv_wr32(priv, 0x404680, 0x0);
	nv_wr32(priv, 0x404684, 0x0);
	nv_wr32(priv, 0x404688, 0x0);
	nv_wr32(priv, 0x40468c, 0x0);
	nv_wr32(priv, 0x404690, 0x0);
	nv_wr32(priv, 0x404694, 0x0);
	nv_wr32(priv, 0x404698, 0x0);
	nv_wr32(priv, 0x40469c, 0x0);
	nv_wr32(priv, 0x4046a0, 0x7f0080);
	nv_wr32(priv, 0x4046a4, 0x0);
	nv_wr32(priv, 0x4046a8, 0x0);
	nv_wr32(priv, 0x4046ac, 0x0);
	nv_wr32(priv, 0x4046b0, 0x0);
	nv_wr32(priv, 0x4046b4, 0x0);
	nv_wr32(priv, 0x4046b8, 0x0);
	nv_wr32(priv, 0x4046bc, 0x0);
	nv_wr32(priv, 0x4046c0, 0x0);
	nv_wr32(priv, 0x4046c8, 0x0);
	nv_wr32(priv, 0x4046cc, 0x0);
	nv_wr32(priv, 0x4046d0, 0x0);
}

static void
nve0_graph_generate_unk47xx(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x404700, 0x0);
	nv_wr32(priv, 0x404704, 0x0);
	nv_wr32(priv, 0x404708, 0x0);
	nv_wr32(priv, 0x404718, 0x0);
	nv_wr32(priv, 0x40471c, 0x0);
	nv_wr32(priv, 0x404720, 0x0);
	nv_wr32(priv, 0x404724, 0x0);
	nv_wr32(priv, 0x404728, 0x0);
	nv_wr32(priv, 0x40472c, 0x0);
	nv_wr32(priv, 0x404730, 0x0);
	nv_wr32(priv, 0x404734, 0x100);
	nv_wr32(priv, 0x404738, 0x0);
	nv_wr32(priv, 0x40473c, 0x0);
	nv_wr32(priv, 0x404744, 0x0);
	nv_wr32(priv, 0x404748, 0x0);
	nv_wr32(priv, 0x404754, 0x0);
}

static void
nve0_graph_generate_unk58xx(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x405800, 0xf8000bf);
	nv_wr32(priv, 0x405830, 0x2180648);
	nv_wr32(priv, 0x405834, 0x8000000);
	nv_wr32(priv, 0x405838, 0x0);
	nv_wr32(priv, 0x405854, 0x0);
	nv_wr32(priv, 0x405870, 0x1);
	nv_wr32(priv, 0x405874, 0x1);
	nv_wr32(priv, 0x405878, 0x1);
	nv_wr32(priv, 0x40587c, 0x1);
	nv_wr32(priv, 0x405a00, 0x0);
	nv_wr32(priv, 0x405a04, 0x0);
	nv_wr32(priv, 0x405a18, 0x0);
}

static void
nve0_graph_generate_unk5bxx(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x405b00, 0x0);
	nv_wr32(priv, 0x405b10, 0x1000);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x405b20, 0x04000000);
		break;
	default:
		break;
	}
}

static void
nve0_graph_generate_unk60xx(struct nvc0_graph_priv *priv)
{
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x406020, 0x34103c1);
		break;
	default:
		nv_wr32(priv, 0x406020, 0x4103c1);
		break;
	}
	nv_wr32(priv, 0x406028, 0x1);
	nv_wr32(priv, 0x40602c, 0x1);
	nv_wr32(priv, 0x406030, 0x1);
	nv_wr32(priv, 0x406034, 0x1);
}

static void
nve0_graph_generate_unk64xx(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x4064a8, 0x0);
	nv_wr32(priv, 0x4064ac, 0x3fff);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x4064b0, 0x0);
		break;
	default:
		break;
	}
	nv_wr32(priv, 0x4064b4, 0x0);
	nv_wr32(priv, 0x4064b8, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x4064c0, 0x802000f0);
		nv_wr32(priv, 0x4064c4, 0x192ffff);
		nv_wr32(priv, 0x4064c8, 0x18007c0);
		break;
	default:
		nv_wr32(priv, 0x4064c0, 0x801a00f0);
		nv_wr32(priv, 0x4064c4, 0x192ffff);
		nv_wr32(priv, 0x4064c8, 0x1800600);
		break;
	}
	nv_wr32(priv, 0x4064cc, 0x0);
	nv_wr32(priv, 0x4064d0, 0x0);
	nv_wr32(priv, 0x4064d4, 0x0);
	nv_wr32(priv, 0x4064d8, 0x0);
	nv_wr32(priv, 0x4064dc, 0x0);
	nv_wr32(priv, 0x4064e0, 0x0);
	nv_wr32(priv, 0x4064e4, 0x0);
	nv_wr32(priv, 0x4064e8, 0x0);
	nv_wr32(priv, 0x4064ec, 0x0);
	nv_wr32(priv, 0x4064fc, 0x22a);
}

static void
nve0_graph_generate_unk70xx(struct nvc0_graph_priv *priv)
{
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		break;
	default:
		nv_wr32(priv, 0x407040, 0x0);
		break;
	}
}

static void
nve0_graph_generate_unk78xx(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x407804, 0x23);
	nv_wr32(priv, 0x40780c, 0xa418820);
	nv_wr32(priv, 0x407810, 0x62080e6);
	nv_wr32(priv, 0x407814, 0x20398a4);
	nv_wr32(priv, 0x407818, 0xe629062);
	nv_wr32(priv, 0x40781c, 0xa418820);
	nv_wr32(priv, 0x407820, 0xe6);
	nv_wr32(priv, 0x4078bc, 0x103);
}

static void
nve0_graph_generate_unk80xx(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x408000, 0x0);
	nv_wr32(priv, 0x408004, 0x0);
	nv_wr32(priv, 0x408008, 0x30);
	nv_wr32(priv, 0x40800c, 0x0);
	nv_wr32(priv, 0x408010, 0x0);
	nv_wr32(priv, 0x408014, 0x69);
	nv_wr32(priv, 0x408018, 0xe100e100);
	nv_wr32(priv, 0x408064, 0x0);
}

static void
nve0_graph_generate_unk88xx(struct nvc0_graph_priv *priv)
{
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x408800, 0x12802a3c);
		break;
	default:
		nv_wr32(priv, 0x408800, 0x2802a3c);
		break;
	}
	nv_wr32(priv, 0x408804, 0x40);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x408808, 0x1003e005);
		break;
	default:
		nv_wr32(priv, 0x408808, 0x1043e005);
		break;
	}
	nv_wr32(priv, 0x408840, 0xb);
	nv_wr32(priv, 0x408900, 0x3080b801);
	nv_wr32(priv, 0x408904, 0x62000001);
	nv_wr32(priv, 0x408908, 0xc8102f);
	nv_wr32(priv, 0x408980, 0x11d);
}

static void
nve0_graph_generate_gpc(struct nvc0_graph_priv *priv)
{
	int i;

	nv_wr32(priv, 0x418380, 0x16);
	nv_wr32(priv, 0x418400, 0x38004e00);
	nv_wr32(priv, 0x418404, 0x71e0ffff);
	nv_wr32(priv, 0x41840c, 0x1008);
	nv_wr32(priv, 0x418410, 0xfff0fff);
	nv_wr32(priv, 0x418414, 0x2200fff);
	nv_wr32(priv, 0x418450, 0x0);
	nv_wr32(priv, 0x418454, 0x0);
	nv_wr32(priv, 0x418458, 0x0);
	nv_wr32(priv, 0x41845c, 0x0);
	nv_wr32(priv, 0x418460, 0x0);
	nv_wr32(priv, 0x418464, 0x0);
	nv_wr32(priv, 0x418468, 0x1);
	nv_wr32(priv, 0x41846c, 0x0);
	nv_wr32(priv, 0x418470, 0x0);
	nv_wr32(priv, 0x418600, 0x1f);
	nv_wr32(priv, 0x418684, 0xf);
	nv_wr32(priv, 0x418700, 0x2);
	nv_wr32(priv, 0x418704, 0x80);
	nv_wr32(priv, 0x418708, 0x0);
	nv_wr32(priv, 0x41870c, 0x0);
	nv_wr32(priv, 0x418710, 0x0);
	nv_wr32(priv, 0x418800, 0x7006860a);
	nv_wr32(priv, 0x418808, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x41880c, 0x30);
		break;
	default:
		nv_wr32(priv, 0x41880c, 0x0);
		break;
	}
	nv_wr32(priv, 0x418810, 0x0);
	nv_wr32(priv, 0x418828, 0x44);
	nv_wr32(priv, 0x418830, 0x10000001);
	nv_wr32(priv, 0x4188d8, 0x8);
	nv_wr32(priv, 0x4188e0, 0x1000000);
	nv_wr32(priv, 0x4188e8, 0x0);
	nv_wr32(priv, 0x4188ec, 0x0);
	nv_wr32(priv, 0x4188f0, 0x0);
	nv_wr32(priv, 0x4188f4, 0x0);
	nv_wr32(priv, 0x4188f8, 0x0);
	nv_wr32(priv, 0x4188fc, 0x20100018);
	nv_wr32(priv, 0x41891c, 0xff00ff);
	nv_wr32(priv, 0x418924, 0x0);
	nv_wr32(priv, 0x418928, 0xffff00);
	nv_wr32(priv, 0x41892c, 0xff00);
	for (i = 0; i < 8; i++) {
		nv_wr32(priv, 0x418a00 + (i * 0x20), 0x0);
		nv_wr32(priv, 0x418a04 + (i * 0x20), 0x0);
		nv_wr32(priv, 0x418a08 + (i * 0x20), 0x0);
		nv_wr32(priv, 0x418a0c + (i * 0x20), 0x10000);
		nv_wr32(priv, 0x418a10 + (i * 0x20), 0x0);
		nv_wr32(priv, 0x418a14 + (i * 0x20), 0x0);
		nv_wr32(priv, 0x418a18 + (i * 0x20), 0x0);
	}
	nv_wr32(priv, 0x418b00, 0x6);
	nv_wr32(priv, 0x418b08, 0xa418820);
	nv_wr32(priv, 0x418b0c, 0x62080e6);
	nv_wr32(priv, 0x418b10, 0x20398a4);
	nv_wr32(priv, 0x418b14, 0xe629062);
	nv_wr32(priv, 0x418b18, 0xa418820);
	nv_wr32(priv, 0x418b1c, 0xe6);
	nv_wr32(priv, 0x418bb8, 0x103);
	nv_wr32(priv, 0x418c08, 0x1);
	nv_wr32(priv, 0x418c10, 0x0);
	nv_wr32(priv, 0x418c14, 0x0);
	nv_wr32(priv, 0x418c18, 0x0);
	nv_wr32(priv, 0x418c1c, 0x0);
	nv_wr32(priv, 0x418c20, 0x0);
	nv_wr32(priv, 0x418c24, 0x0);
	nv_wr32(priv, 0x418c28, 0x0);
	nv_wr32(priv, 0x418c2c, 0x0);
	nv_wr32(priv, 0x418c40, 0xffffffff);
	nv_wr32(priv, 0x418c6c, 0x1);
	nv_wr32(priv, 0x418c80, 0x20200004);
	nv_wr32(priv, 0x418c8c, 0x1);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x418d24, 0x0);
		break;
	default:
		break;
	}
	nv_wr32(priv, 0x419000, 0x780);
	nv_wr32(priv, 0x419004, 0x0);
	nv_wr32(priv, 0x419008, 0x0);
	nv_wr32(priv, 0x419014, 0x4);
}

static void
nve0_graph_generate_tpc(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x419848, 0x0);
	nv_wr32(priv, 0x419864, 0x129);
	nv_wr32(priv, 0x419888, 0x0);
	nv_wr32(priv, 0x419a00, 0xf0);
	nv_wr32(priv, 0x419a04, 0x1);
	nv_wr32(priv, 0x419a08, 0x21);
	nv_wr32(priv, 0x419a0c, 0x20000);
	nv_wr32(priv, 0x419a10, 0x0);
	nv_wr32(priv, 0x419a14, 0x200);
	nv_wr32(priv, 0x419a1c, 0xc000);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x419a20, 0x20800);
		break;
	default:
		nv_wr32(priv, 0x419a20, 0x800);
		break;
	}
	nv_wr32(priv, 0x419a30, 0x1);
	nv_wr32(priv, 0x419ac4, 0x37f440);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x419c00, 0x1a);
		break;
	default:
		nv_wr32(priv, 0x419c00, 0xa);
		break;
	}
	nv_wr32(priv, 0x419c04, 0x80000006);
	nv_wr32(priv, 0x419c08, 0x2);
	nv_wr32(priv, 0x419c20, 0x0);
	nv_wr32(priv, 0x419c24, 0x84210);
	nv_wr32(priv, 0x419c28, 0x3efbefbe);
	nv_wr32(priv, 0x419ce8, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x419cf4, 0x203);
		nv_wr32(priv, 0x419e04, 0x0);
		nv_wr32(priv, 0x419e08, 0x1d);
		nv_wr32(priv, 0x419e0c, 0x0);
		nv_wr32(priv, 0x419e10, 0x1c02);

		break;
	default:
		nv_wr32(priv, 0x419cf4, 0x3203);
		nv_wr32(priv, 0x419e04, 0x0);
		nv_wr32(priv, 0x419e08, 0x0);
		nv_wr32(priv, 0x419e0c, 0x0);
		nv_wr32(priv, 0x419e10, 0x402);
		break;
	}
	nv_wr32(priv, 0x419e44, 0x13eff2);
	nv_wr32(priv, 0x419e48, 0x0);
	nv_wr32(priv, 0x419e4c, 0x7f);
	nv_wr32(priv, 0x419e50, 0x0);
	nv_wr32(priv, 0x419e54, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x419e58, 0x1);
		break;
	default:
		nv_wr32(priv, 0x419e58, 0x0);
		break;
	}
	nv_wr32(priv, 0x419e5c, 0x0);
	nv_wr32(priv, 0x419e60, 0x0);
	nv_wr32(priv, 0x419e64, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x419e68, 0x2);
		break;
	default:
		nv_wr32(priv, 0x419e68, 0x0);
		break;
	}
	nv_wr32(priv, 0x419e6c, 0x0);
	nv_wr32(priv, 0x419e70, 0x0);
	nv_wr32(priv, 0x419e74, 0x0);
	nv_wr32(priv, 0x419e78, 0x0);
	nv_wr32(priv, 0x419e7c, 0x0);
	nv_wr32(priv, 0x419e80, 0x0);
	nv_wr32(priv, 0x419e84, 0x0);
	nv_wr32(priv, 0x419e88, 0x0);
	nv_wr32(priv, 0x419e8c, 0x0);
	nv_wr32(priv, 0x419e90, 0x0);
	nv_wr32(priv, 0x419e94, 0x0);
	nv_wr32(priv, 0x419e98, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xe4:
	case 0xe7:
	case 0xe6:
		nv_wr32(priv, 0x419eac, 0x1f8f);
		nv_wr32(priv, 0x419eb0, 0xd3f);
		break;
	case 0xf0:
		nv_wr32(priv, 0x419eac, 0x1fcf);
		nv_wr32(priv, 0x419eb0, 0xdb00da0);
		nv_wr32(priv, 0x419eb8, 0x0);
		break;
	}
	nv_wr32(priv, 0x419ec8, 0x1304f);
	nv_wr32(priv, 0x419f30, 0x0);
	nv_wr32(priv, 0x419f34, 0x0);
	nv_wr32(priv, 0x419f38, 0x0);
	nv_wr32(priv, 0x419f3c, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x419f40, 0x18);
		break;
	default:
		nv_wr32(priv, 0x419f40, 0x0);
		break;
	}
	nv_wr32(priv, 0x419f44, 0x0);
	nv_wr32(priv, 0x419f48, 0x0);
	nv_wr32(priv, 0x419f4c, 0x0);
	nv_wr32(priv, 0x419f58, 0x0);
	switch (nv_device(priv)->chipset) {
	case 0xe4:
	case 0xe7:
	case 0xe6:
		nv_wr32(priv, 0x419f70, 0x0);
		nv_wr32(priv, 0x419f78, 0xb);
		nv_wr32(priv, 0x419f7c, 0x27a);
		break;
	case 0xf0:
		nv_wr32(priv, 0x419f70, 0x7300);
		nv_wr32(priv, 0x419f78, 0xeb);
		nv_wr32(priv, 0x419f7c, 0x404);
		break;
	}
}

static void
nve0_graph_generate_tpcunk(struct nvc0_graph_priv *priv)
{
	nv_wr32(priv, 0x41be24, 0x6);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x41bec0, 0x10000000);
		break;
	default:
		nv_wr32(priv, 0x41bec0, 0x12180000);
		break;
	}
	nv_wr32(priv, 0x41bec4, 0x37f7f);
	switch (nv_device(priv)->chipset) {
	case 0xf0:
		nv_wr32(priv, 0x41bee4, 0x0);
		break;
	default:
		nv_wr32(priv, 0x41bee4, 0x6480430);
		break;
	}
	nv_wr32(priv, 0x41bf00, 0xa418820);
	nv_wr32(priv, 0x41bf04, 0x62080e6);
	nv_wr32(priv, 0x41bf08, 0x20398a4);
	nv_wr32(priv, 0x41bf0c, 0xe629062);
	nv_wr32(priv, 0x41bf10, 0xa418820);
	nv_wr32(priv, 0x41bf14, 0xe6);
	nv_wr32(priv, 0x41bfd0, 0x900103);
	nv_wr32(priv, 0x41bfe0, 0x400001);
	nv_wr32(priv, 0x41bfe4, 0x0);
}

int
nve0_grctx_generate(struct nvc0_graph_priv *priv)
{
	struct nvc0_grctx info;
	int ret, i, gpc, tpc, id;
	u32 data[6] = {}, data2[2] = {}, tmp;
	u32 tpc_set = 0, tpc_mask = 0;
	u32 magic[GPC_MAX][2], offset;
	u8 tpcnr[GPC_MAX], a, b;
	u8 shift, ntpcv;

	ret = nvc0_grctx_init(priv, &info);
	if (ret)
		return ret;

	nv_mask(priv, 0x000260, 0x00000001, 0x00000000);
	nv_wr32(priv, 0x400204, 0x00000000);
	nv_wr32(priv, 0x400208, 0x00000000);

	nve0_graph_generate_unk40xx(priv);
	nve0_graph_generate_unk44xx(priv);
	nve0_graph_generate_unk46xx(priv);
	nve0_graph_generate_unk47xx(priv);
	nve0_graph_generate_unk58xx(priv);
	nve0_graph_generate_unk5bxx(priv);
	nve0_graph_generate_unk60xx(priv);
	nve0_graph_generate_unk64xx(priv);
	nve0_graph_generate_unk70xx(priv);
	nve0_graph_generate_unk78xx(priv);
	nve0_graph_generate_unk80xx(priv);
	nve0_graph_generate_unk88xx(priv);
	nve0_graph_generate_gpc(priv);
	nve0_graph_generate_tpc(priv);
	nve0_graph_generate_tpcunk(priv);

	nv_wr32(priv, 0x404154, 0x0);

	mmio_data(0x003000, 0x0100, NV_MEM_ACCESS_RW | NV_MEM_ACCESS_SYS);
	mmio_data(0x008000, 0x0100, NV_MEM_ACCESS_RW | NV_MEM_ACCESS_SYS);
	mmio_data(0x060000, 0x1000, NV_MEM_ACCESS_RW);
	mmio_list(0x40800c, 0x00000000,  8, 1);
	mmio_list(0x408010, 0x80000000,  0, 0);
	mmio_list(0x419004, 0x00000000,  8, 1);
	mmio_list(0x419008, 0x00000000,  0, 0);
	mmio_list(0x4064cc, 0x80000000,  0, 0);
	mmio_list(0x408004, 0x00000000,  8, 0);
	mmio_list(0x408008, 0x80000030,  0, 0);
	mmio_list(0x418808, 0x00000000,  8, 0);
	mmio_list(0x41880c, 0x80000030,  0, 0);
	mmio_list(0x4064c8, 0x01800600,  0, 0);
	mmio_list(0x418810, 0x80000000, 12, 2);
	mmio_list(0x419848, 0x10000000, 12, 2);
	mmio_list(0x405830, 0x02180648,  0, 0);
	mmio_list(0x4064c4, 0x0192ffff,  0, 0);
	for (gpc = 0, offset = 0; gpc < priv->gpc_nr; gpc++) {
		u16 magic0 = 0x0218 * priv->tpc_nr[gpc];
		u16 magic1 = 0x0648 * priv->tpc_nr[gpc];
		magic[gpc][0]  = 0x10000000 | (magic0 << 16) | offset;
		magic[gpc][1]  = 0x00000000 | (magic1 << 16);
		offset += 0x0324 * priv->tpc_nr[gpc];
	}
	for (gpc = 0; gpc < priv->gpc_nr; gpc++) {
		mmio_list(GPC_UNIT(gpc, 0x30c0), magic[gpc][0], 0, 0);
		mmio_list(GPC_UNIT(gpc, 0x30e4), magic[gpc][1] | offset, 0, 0);
		offset += 0x07ff * priv->tpc_nr[gpc];
	}
	mmio_list(0x17e91c, 0x06060609, 0, 0);
	mmio_list(0x17e920, 0x00090a05, 0, 0);

	nv_wr32(priv, 0x418c6c, 0x1);
	nv_wr32(priv, 0x41980c, 0x10);
	nv_wr32(priv, 0x41be08, 0x4);
	nv_wr32(priv, 0x4064c0, 0x801a00f0);
	nv_wr32(priv, 0x405800, 0xf8000bf);
	nv_wr32(priv, 0x419c00, 0xa);

	for (tpc = 0, id = 0; tpc < 4; tpc++) {
		for (gpc = 0; gpc < priv->gpc_nr; gpc++) {
			if (tpc < priv->tpc_nr[gpc]) {
				nv_wr32(priv, TPC_UNIT(gpc, tpc, 0x0698), id);
				nv_wr32(priv, TPC_UNIT(gpc, tpc, 0x04e8), id);
				nv_wr32(priv, GPC_UNIT(gpc, 0x0c10 + tpc * 4), id);
				nv_wr32(priv, TPC_UNIT(gpc, tpc, 0x0088), id++);
			}

			nv_wr32(priv, GPC_UNIT(gpc, 0x0c08), priv->tpc_nr[gpc]);
			nv_wr32(priv, GPC_UNIT(gpc, 0x0c8c), priv->tpc_nr[gpc]);
		}
	}

	tmp = 0;
	for (i = 0; i < priv->gpc_nr; i++)
		tmp |= priv->tpc_nr[i] << (i * 4);
	nv_wr32(priv, 0x406028, tmp);
	nv_wr32(priv, 0x405870, tmp);

	nv_wr32(priv, 0x40602c, 0x0);
	nv_wr32(priv, 0x405874, 0x0);
	nv_wr32(priv, 0x406030, 0x0);
	nv_wr32(priv, 0x405878, 0x0);
	nv_wr32(priv, 0x406034, 0x0);
	nv_wr32(priv, 0x40587c, 0x0);

	/* calculate first set of magics */
	memcpy(tpcnr, priv->tpc_nr, sizeof(priv->tpc_nr));

	gpc = -1;
	for (tpc = 0; tpc < priv->tpc_total; tpc++) {
		do {
			gpc = (gpc + 1) % priv->gpc_nr;
		} while (!tpcnr[gpc]);
		tpcnr[gpc]--;

		data[tpc / 6] |= gpc << ((tpc % 6) * 5);
	}

	for (; tpc < 32; tpc++)
		data[tpc / 6] |= 7 << ((tpc % 6) * 5);

	/* and the second... */
	shift = 0;
	ntpcv = priv->tpc_total;
	while (!(ntpcv & (1 << 4))) {
		ntpcv <<= 1;
		shift++;
	}

	data2[0]  = ntpcv << 16;
	data2[0] |= shift << 21;
	data2[0] |= (((1 << (0 + 5)) % ntpcv) << 24);
	data2[0] |= priv->tpc_total << 8;
	data2[0] |= priv->magic_not_rop_nr;
	for (i = 1; i < 7; i++)
		data2[1] |= ((1 << (i + 5)) % ntpcv) << ((i - 1) * 5);

	/* and write it all the various parts of PGRAPH */
	nv_wr32(priv, 0x418bb8, (priv->tpc_total << 8) | priv->magic_not_rop_nr);
	for (i = 0; i < 6; i++)
		nv_wr32(priv, 0x418b08 + (i * 4), data[i]);

	nv_wr32(priv, 0x41bfd0, data2[0]);
	nv_wr32(priv, 0x41bfe4, data2[1]);
	for (i = 0; i < 6; i++)
		nv_wr32(priv, 0x41bf00 + (i * 4), data[i]);

	nv_wr32(priv, 0x4078bc, (priv->tpc_total << 8) | priv->magic_not_rop_nr);
	for (i = 0; i < 6; i++)
		nv_wr32(priv, 0x40780c + (i * 4), data[i]);


	memcpy(tpcnr, priv->tpc_nr, sizeof(priv->tpc_nr));
	for (gpc = 0; gpc < priv->gpc_nr; gpc++)
		tpc_mask |= ((1 << priv->tpc_nr[gpc]) - 1) << (gpc * 8);

	for (i = 0, gpc = -1, b = -1; i < 32; i++) {
		a = (i * (priv->tpc_total - 1)) / 32;
		if (a != b) {
			b = a;
			do {
				gpc = (gpc + 1) % priv->gpc_nr;
			} while (!tpcnr[gpc]);
			tpc = priv->tpc_nr[gpc] - tpcnr[gpc]--;

			tpc_set |= 1 << ((gpc * 8) + tpc);
		}

		nv_wr32(priv, 0x406800 + (i * 0x20), tpc_set);
		nv_wr32(priv, 0x406c00 + (i * 0x20), tpc_set ^ tpc_mask);
	}

	for (i = 0; i < 8; i++)
		nv_wr32(priv, 0x4064d0 + (i * 0x04), 0x00000000);

	nv_wr32(priv, 0x405b00, (priv->tpc_total << 8) | priv->gpc_nr);
	if (priv->gpc_nr == 1) {
		nv_mask(priv, 0x408850, 0x0000000f, priv->tpc_nr[0]);
		nv_mask(priv, 0x408958, 0x0000000f, priv->tpc_nr[0]);
	} else {
		nv_mask(priv, 0x408850, 0x0000000f, priv->gpc_nr);
		nv_mask(priv, 0x408958, 0x0000000f, priv->gpc_nr);
	}
	nv_mask(priv, 0x419f78, 0x00000001, 0x00000000);

	nve0_grctx_generate_icmd(priv);
	nve0_grctx_generate_a097(priv);
	nve0_grctx_generate_902d(priv);

	nv_mask(priv, 0x000260, 0x00000001, 0x00000001);
	nv_wr32(priv, 0x418800, 0x7026860a); //XXX
	nv_wr32(priv, 0x41be10, 0x00bb8bc7); //XXX
	return nvc0_grctx_fini(&info);
}
