/*
 * Copyright (C) 2005 - 2008 ServerEngines
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.  The full GNU General
 * Public License is included in this distribution in the file called COPYING.
 *
 * Contact Information:
 * linux-drivers@serverengines.com
 *
 * ServerEngines
 * 209 N. Fair Oaks Ave
 * Sunnyvale, CA 94085
 */
/*
 * Autogenerated by srcgen version: 0127
 */
#ifndef __host_struct_amap_h__
#define __host_struct_amap_h__
#include "be_cm.h"
#include "be_common.h"
#include "descriptors.h"

/* --- EQ_COMPLETION_MAJOR_CODE_ENUM --- */
#define EQ_MAJOR_CODE_COMPLETION        (0)	/* Completion event on a */
						  /* qcompletion ueue. */
#define EQ_MAJOR_CODE_ETH               (1)	/* Affiliated Ethernet Event. */
#define EQ_MAJOR_CODE_RESERVED          (2)	/* Reserved */
#define EQ_MAJOR_CODE_RDMA              (3)	/* Affiliated RDMA Event. */
#define EQ_MAJOR_CODE_ISCSI             (4)	/* Affiliated ISCSI Event */
#define EQ_MAJOR_CODE_UNAFFILIATED      (5)	/* Unaffiliated Event */

/* --- EQ_COMPLETION_MINOR_CODE_ENUM --- */
#define EQ_MINOR_CODE_COMPLETION        (0)	/* Completion event on a */
						  /* completion queue. */
#define EQ_MINOR_CODE_OTHER             (1)	/* Other Event (TBD). */

/* Queue Entry Definition for all 4 byte event queue types. */
struct BE_EQ_ENTRY_AMAP {
	u8 Valid;		/* DWORD 0 */
	u8 MajorCode[3];	/* DWORD 0 */
	u8 MinorCode[12];	/* DWORD 0 */
	u8 ResourceID[16];	/* DWORD 0 */
} __packed;
struct EQ_ENTRY_AMAP {
	u32 dw[1];
};

/*
 * --- ETH_EVENT_CODE ---
 * These codes are returned by the MPU when one of these events has occurred,
 * and the event is configured to report to an Event Queue when an event
 * is detected.
 */
#define ETH_EQ_LINK_STATUS              (0)	/* Link status change event */
						  /* detected. */
#define ETH_EQ_WATERMARK                (1)	/* watermark event detected. */
#define ETH_EQ_MAGIC_PKT                (2)	/* magic pkt event detected. */
#define ETH_EQ_ACPI_PKT0                (3)	/* ACPI interesting packet */
						  /* detected. */
#define ETH_EQ_ACPI_PKT1                (3)	/* ACPI interesting packet */
						  /* detected. */
#define ETH_EQ_ACPI_PKT2                (3)	/* ACPI interesting packet */
						  /* detected. */
#define ETH_EQ_ACPI_PKT3                (3)	/* ACPI interesting packet */
						  /* detected. */

/*
 * --- ETH_TX_COMPL_STATUS_ENUM ---
 * Status codes contained in Ethernet TX completion descriptors.
 */
#define ETH_COMP_VALID                  (0)
#define ETH_COMP_ERROR                  (1)
#define ETH_COMP_INVALID                (15)

/*
 * --- ETH_TX_COMPL_PORT_ENUM ---
 * Port indicator contained in Ethernet TX completion descriptors.
 */
#define ETH_COMP_PORT0                  (0)
#define ETH_COMP_PORT1                  (1)
#define ETH_COMP_MGMT                   (2)

/*
 * --- ETH_TX_COMPL_CT_ENUM ---
 * Completion type indicator contained in Ethernet TX completion descriptors.
 */
#define ETH_COMP_ETH                    (0)

/*
 * Work request block that the driver issues to the chip for
 * Ethernet transmissions. All control fields must be valid in each WRB for
 * a message. The controller, as specified by the flags, optionally writes
 * an entry to the Completion Ring and generate an event.
 */
struct BE_ETH_WRB_AMAP {
	u8 frag_pa_hi[32];	/* DWORD 0 */
	u8 frag_pa_lo[32];	/* DWORD 1 */
	u8 complete;	/* DWORD 2 */
	u8 event;		/* DWORD 2 */
	u8 crc;		/* DWORD 2 */
	u8 forward;		/* DWORD 2 */
	u8 ipsec;		/* DWORD 2 */
	u8 mgmt;		/* DWORD 2 */
	u8 ipcs;		/* DWORD 2 */
	u8 udpcs;		/* DWORD 2 */
	u8 tcpcs;		/* DWORD 2 */
	u8 lso;		/* DWORD 2 */
	u8 last;		/* DWORD 2 */
	u8 vlan;		/* DWORD 2 */
	u8 dbg[3];		/* DWORD 2 */
	u8 hash_val[3];	/* DWORD 2 */
	u8 lso_mss[14];	/* DWORD 2 */
	u8 frag_len[16];	/* DWORD 3 */
	u8 vlan_tag[16];	/* DWORD 3 */
} __packed;
struct ETH_WRB_AMAP {
	u32 dw[4];
};

/* This is an Ethernet transmit completion descriptor */
struct BE_ETH_TX_COMPL_AMAP {
	u8 user_bytes[16];	/* DWORD 0 */
	u8 nwh_bytes[8];	/* DWORD 0 */
	u8 lso;		/* DWORD 0 */
	u8 rsvd0[7];	/* DWORD 0 */
	u8 wrb_index[16];	/* DWORD 1 */
	u8 ct[2];		/* DWORD 1 */
	u8 port[2];		/* DWORD 1 */
	u8 rsvd1[8];	/* DWORD 1 */
	u8 status[4];	/* DWORD 1 */
	u8 rsvd2[16];	/* DWORD 2 */
	u8 ringid[11];	/* DWORD 2 */
	u8 hash_val[4];	/* DWORD 2 */
	u8 valid;		/* DWORD 2 */
	u8 rsvd3[32];	/* DWORD 3 */
} __packed;
struct ETH_TX_COMPL_AMAP {
	u32 dw[4];
};

/* Ethernet Receive Buffer descriptor */
struct BE_ETH_RX_D_AMAP {
	u8 fragpa_hi[32];	/* DWORD 0 */
	u8 fragpa_lo[32];	/* DWORD 1 */
} __packed;
struct ETH_RX_D_AMAP {
	u32 dw[2];
};

/* This is an Ethernet Receive Completion Descriptor */
struct BE_ETH_RX_COMPL_AMAP {
	u8 vlan_tag[16];	/* DWORD 0 */
	u8 pktsize[14];	/* DWORD 0 */
	u8 port;		/* DWORD 0 */
	u8 rsvd0;		/* DWORD 0 */
	u8 err;		/* DWORD 1 */
	u8 rsshp;		/* DWORD 1 */
	u8 ipf;		/* DWORD 1 */
	u8 tcpf;		/* DWORD 1 */
	u8 udpf;		/* DWORD 1 */
	u8 ipcksm;		/* DWORD 1 */
	u8 tcpcksm;		/* DWORD 1 */
	u8 udpcksm;		/* DWORD 1 */
	u8 macdst[6];	/* DWORD 1 */
	u8 vtp;		/* DWORD 1 */
	u8 vtm;		/* DWORD 1 */
	u8 fragndx[10];	/* DWORD 1 */
	u8 ct[2];		/* DWORD 1 */
	u8 ipsec;		/* DWORD 1 */
	u8 numfrags[3];	/* DWORD 1 */
	u8 rsvd1[31];	/* DWORD 2 */
	u8 valid;		/* DWORD 2 */
	u8 rsshash[32];	/* DWORD 3 */
} __packed;
struct ETH_RX_COMPL_AMAP {
	u32 dw[4];
};

#endif /* __host_struct_amap_h__ */
