/*
 * Copyright (c) 2012-2016, The Linux Foundation. All rights reserved.
 * Copyright (C) 2017 Linaro Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef __VENUS_HFI_VENUS_IO_H__
#define __VENUS_HFI_VENUS_IO_H__

#define VBIF_BASE				0x80000

#define VBIF_AXI_HALT_CTRL0			(VBIF_BASE + 0x208)
#define VBIF_AXI_HALT_CTRL1			(VBIF_BASE + 0x20c)

#define VBIF_AXI_HALT_CTRL0_HALT_REQ		BIT(0)
#define VBIF_AXI_HALT_CTRL1_HALT_ACK		BIT(0)
#define VBIF_AXI_HALT_ACK_TIMEOUT_US		500000

#define CPU_BASE				0xc0000
#define CPU_CS_BASE				(CPU_BASE + 0x12000)
#define CPU_IC_BASE				(CPU_BASE + 0x1f000)

#define CPU_CS_A2HSOFTINTCLR			(CPU_CS_BASE + 0x1c)

#define VIDC_CTRL_INIT				(CPU_CS_BASE + 0x48)
#define VIDC_CTRL_INIT_RESERVED_BITS31_1_MASK	0xfffffffe
#define VIDC_CTRL_INIT_RESERVED_BITS31_1_SHIFT	1
#define VIDC_CTRL_INIT_CTRL_MASK		0x1
#define VIDC_CTRL_INIT_CTRL_SHIFT		0

/* HFI control status */
#define CPU_CS_SCIACMDARG0			(CPU_CS_BASE + 0x4c)
#define CPU_CS_SCIACMDARG0_MASK			0xff
#define CPU_CS_SCIACMDARG0_SHIFT		0x0
#define CPU_CS_SCIACMDARG0_ERROR_STATUS_MASK	0xfe
#define CPU_CS_SCIACMDARG0_ERROR_STATUS_SHIFT	0x1
#define CPU_CS_SCIACMDARG0_INIT_STATUS_MASK	0x1
#define CPU_CS_SCIACMDARG0_INIT_STATUS_SHIFT	0x0
#define CPU_CS_SCIACMDARG0_PC_READY		BIT(8)
#define CPU_CS_SCIACMDARG0_INIT_IDLE_MSG_MASK	BIT(30)

/* HFI queue table info */
#define CPU_CS_SCIACMDARG1			(CPU_CS_BASE + 0x50)

/* HFI queue table address */
#define CPU_CS_SCIACMDARG2			(CPU_CS_BASE + 0x54)

/* Venus cpu */
#define CPU_CS_SCIACMDARG3			(CPU_CS_BASE + 0x58)

#define SFR_ADDR				(CPU_CS_BASE + 0x5c)
#define MMAP_ADDR				(CPU_CS_BASE + 0x60)
#define UC_REGION_ADDR				(CPU_CS_BASE + 0x64)
#define UC_REGION_SIZE				(CPU_CS_BASE + 0x68)

#define CPU_IC_SOFTINT				(CPU_IC_BASE + 0x18)
#define CPU_IC_SOFTINT_H2A_MASK			0x8000
#define CPU_IC_SOFTINT_H2A_SHIFT		0xf

/* Venus wrapper */
#define WRAPPER_BASE				0x000e0000

#define WRAPPER_HW_VERSION			(WRAPPER_BASE + 0x00)
#define WRAPPER_HW_VERSION_MAJOR_VERSION_MASK	0x78000000
#define WRAPPER_HW_VERSION_MAJOR_VERSION_SHIFT	28
#define WRAPPER_HW_VERSION_MINOR_VERSION_MASK	0xfff0000
#define WRAPPER_HW_VERSION_MINOR_VERSION_SHIFT	16
#define WRAPPER_HW_VERSION_STEP_VERSION_MASK	0xffff

#define WRAPPER_CLOCK_CONFIG			(WRAPPER_BASE + 0x04)

#define WRAPPER_INTR_STATUS			(WRAPPER_BASE + 0x0c)
#define WRAPPER_INTR_STATUS_A2HWD_MASK		0x10
#define WRAPPER_INTR_STATUS_A2HWD_SHIFT		0x4
#define WRAPPER_INTR_STATUS_A2H_MASK		0x4
#define WRAPPER_INTR_STATUS_A2H_SHIFT		0x2

#define WRAPPER_INTR_MASK			(WRAPPER_BASE + 0x10)
#define WRAPPER_INTR_MASK_A2HWD_BASK		0x10
#define WRAPPER_INTR_MASK_A2HWD_SHIFT		0x4
#define WRAPPER_INTR_MASK_A2HVCODEC_MASK	0x8
#define WRAPPER_INTR_MASK_A2HVCODEC_SHIFT	0x3
#define WRAPPER_INTR_MASK_A2HCPU_MASK		0x4
#define WRAPPER_INTR_MASK_A2HCPU_SHIFT		0x2

#define WRAPPER_INTR_CLEAR			(WRAPPER_BASE + 0x14)
#define WRAPPER_INTR_CLEAR_A2HWD_MASK		0x10
#define WRAPPER_INTR_CLEAR_A2HWD_SHIFT		0x4
#define WRAPPER_INTR_CLEAR_A2H_MASK		0x4
#define WRAPPER_INTR_CLEAR_A2H_SHIFT		0x2

#define WRAPPER_POWER_STATUS			(WRAPPER_BASE + 0x44)
#define WRAPPER_VDEC_VCODEC_POWER_CONTROL	(WRAPPER_BASE + 0x48)
#define WRAPPER_VENC_VCODEC_POWER_CONTROL	(WRAPPER_BASE + 0x4c)
#define WRAPPER_VDEC_VENC_AHB_BRIDGE_SYNC_RESET	(WRAPPER_BASE + 0x64)

#define WRAPPER_CPU_CLOCK_CONFIG		(WRAPPER_BASE + 0x2000)
#define WRAPPER_CPU_AXI_HALT			(WRAPPER_BASE + 0x2008)
#define WRAPPER_CPU_AXI_HALT_STATUS		(WRAPPER_BASE + 0x200c)

#define WRAPPER_CPU_CGC_DIS			(WRAPPER_BASE + 0x2010)
#define WRAPPER_CPU_STATUS			(WRAPPER_BASE + 0x2014)
#define WRAPPER_SW_RESET			(WRAPPER_BASE + 0x3000)

#endif
