# 栅格设置

>  **说明：**
> - 从API Version 7开始支持。后续版本如有新增内容，则采用上角标单独标记该内容的起始版本。
> 
> - 栅格布局的列宽、列间距由距离最近的GridContainer父组件决定。使用栅格属性的组件树上至少需要有1个GridContainer容器组件。


## 权限列表

无


## 属性


| 名称 | 参数类型 | 默认值 | 描述 |
| -------- | -------- | -------- | -------- |
| useSizeType | {<br/>xs?:&nbsp;number&nbsp;\|&nbsp;{&nbsp;span:&nbsp;number,&nbsp;offset:&nbsp;number&nbsp;},<br/>sm?:&nbsp;number&nbsp;\|&nbsp;{&nbsp;span:&nbsp;number,&nbsp;offset:&nbsp;number&nbsp;},<br/>md?:&nbsp;number&nbsp;\|&nbsp;{&nbsp;span:&nbsp;number,&nbsp;offset:&nbsp;number&nbsp;},<br/>lg?:&nbsp;number&nbsp;\|&nbsp;{&nbsp;span:&nbsp;number,&nbsp;offset:&nbsp;number&nbsp;}<br/>} | - | 设置在特定设备宽度类型下的占用列数和偏移列数，span:&nbsp;占用列数;&nbsp;offset:&nbsp;偏移列数。<br/>当值为number类型时，仅设置列数，&nbsp;当格式如{"span":&nbsp;1,&nbsp;"offset":&nbsp;0}时，指同时设置占用列数与偏移列数。<br/>-&nbsp;xs:&nbsp;指设备宽度类型为SizeType.XS时的占用列数和偏移列数。<br/>-&nbsp;sm:&nbsp;指设备宽度类型为SizeType.SM时的占用列数和偏移列数。<br/>-&nbsp;md:&nbsp;指设备宽度类型为SizeType.MD时的占用列数和偏移列数。<br/>-&nbsp;lg:&nbsp;指设备宽度类型为SizeType.LG时的占用列数和偏移列数。 |
| gridSpan | number | 1 | 默认占用列数，指useSizeType属性没有设置对应尺寸的列数（span)时，占用的栅格列数。<br/>>&nbsp;&nbsp;**说明：**<br/>>&nbsp;设置了栅格span属性，组件的宽度由栅格布局决定。 |
| gridOffset | number | 0 | 默认偏移列数，指useSizeType属性没有设置对应尺寸的偏移(offset)时，&nbsp;当前组件沿着父组件Start方向，偏移的列数，也就是当前组件位于第n列。<br/>>&nbsp;&nbsp;**说明：**<br/>>&nbsp;-配置该属性后，当前组件在父组件水平方向的布局不再跟随父组件原有的布局方式，而是沿着父组件的Start方向偏移一定位移。<br/>>&nbsp;-偏移位移&nbsp;=&nbsp;（列宽&nbsp;+&nbsp;间距）\*&nbsp;列数。<br/>>&nbsp;-设置了偏移(gridOffset)的组件之后的兄弟组件会根据该组件进行相对布局，类似相对布局。 |


## 示例

```ts
// xxx.ets
@Entry
@Component
struct GridContainerExample1 {
  build(){
    GridContainer() {
      Row({}) {
        Row() {
          Text('Left').fontSize(25)
        }
        .useSizeType({
          xs: { span: 1, offset: 0 }, sm: { span: 1, offset: 0 },
          md: { span: 1, offset: 0 }, lg: { span: 2, offset: 0 }
        })
        .height("100%")
        .backgroundColor(0x66bbb2cb)
        Row() {
          Text('Center').fontSize(25)
        }
        .useSizeType({
          xs: { span: 1, offset: 0 }, sm: { span: 2, offset: 1 },
          md: { span: 5, offset: 1 }, lg: { span: 7, offset: 2 }
        })
        .height("100%")
        .backgroundColor(0x66b6c5d1)
        Row() {
          Text('Right').fontSize(25)
        }
        .useSizeType({
          xs: { span: 1, offset: 0 }, sm: { span: 1, offset: 3 },
          md: { span: 2, offset: 6 }, lg: { span: 3, offset: 9 }
        })
        .height("100%")
        .backgroundColor(0x66bbb2cb)
      }
      .height(200)
    }
    .backgroundColor(0xf1f3f5)
    .margin({ top: 10 })
  }
}
```

**图1** 设备宽度为SM

![zh-cn_image_0000001174582872](figures/zh-cn_image_0000001174582872.png)

**图2** 设备宽度为MD

![zh-cn_image_0000001219744207](figures/zh-cn_image_0000001219744207.png)

**图3** 设备宽度为LG

![zh-cn_image_0000001219982727](figures/zh-cn_image_0000001219982727.png)