# License and Copyright Specifications

## Purpose
This document describes how code contributors, committers, and PMC members in the OpenHarmony community handle the license and copyright statements of repositories and source code files. It covers the following parts:
1. License file
2. NOTICE file
3. Copyright and license header

## Scope
This document applies only to the OpenHarmony community. It is not applicable to the scenario where the OpenHarmony project is used by individuals or enterprises to develop their products or the scenario where third-party open-source software is introduced. For details, see [Introducing Third-Party Open-Source Software](introducing-third-party-open-source-software.md).

## Improvements and Revisions
1. This document is drafted and maintained by the OpenHarmony PMC. What you are reading now is the latest version of this document.
2. Any addition, modification, or deletion of the principles mentioned in this document are traced in the tracing system.
3. The PMC finalizes the principles after thorough discussion in the community.

## License File
1. Each open-source repository must have a license file that is clearly documented and comply with the overall license principles in the OpenHarmony community. For example, a user-mode open-source repository uses Apache License 2.0, and a LiteOS kernel-mode open-source repository uses BSD 3-clause.
2. The license file of each open-source repository must be in plain text format and stored in the root directory of the code repository. The file must contain the full text of the license and be named **LICENSE**, without the file name extension .txt or .md.
3. If the source code of an open-source repository uses multiple licenses, describe the main license in the file named **LICENSE**. For other licenses, name them in the format of **LICENSE-*LicenseType*-*Remarks*** and place them in the root directory of the code repository or the root directory of the source code corresponding to the license. Describe the location and application scenarios of each license file in the main license.
4. The license file of each open-source software repository must cover all files in the repository. Ensure that the description of each license is accurate and concise, and do not contain unnecessary information such as licenses of source code that is not released in the repository. For example, the license of the dependent software to be downloaded separately should not be included in the repository and license.
5. If the open-source repository is released in binary mode, ensure that the license file is stored in a common location of the release format, for example, the top directory of the release folder or compressed package. For a .jar file, the license file can be stored in the **META-INF** directory.

## NOTICE File
1. If the distributed binary files contain third-party open-source software, provide a file named **NOTICE**. Include the following information in plain text in this file: name, version, rights holder statements, and license information of every third-party open-source software.
2. The **NOTICE** file is usually stored in the top directory of the release folder or compressed package. For a .jar file, the license file can be stored in the **META-INF** directory.


## Copyright and License Header
1. In principle, all files in the open-source repository must contain appropriate copyright and license header statements, except in the following scenarios:
* Adding the copyright and license header statement affects the functions of the file. For example, JSON files do not support comments, and therefore you should not add the copyright and license header to a JSON file.
* A file that is generated by the tool and contains the description indicating the automatic generation.
* A brief description file for users to read. Adding the copyright and license header affects the readability of the file, for example, **README**.

2. The format of the copyright and license header is as follows:
```
Copyright (C) [Year of the first release]-[Year of the current release] [Copyright holder]

The license header is subject to the specific license content. Example:

Apache License Version 2.0 license header:
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

BSD 3-Clause license header:
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of
   conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list
   of conditions and the following disclaimer in the documentation and/or other materials
   provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors may be used
   to endorse or promote products derived from this software without specific prior written
   permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
```
3. The year in the copyright header indicates the year when the work is released. If this is the first release, enter [Year of the first release]. If this is not the first release, enter [Year of the first release]-[Year of the current release].
4. The copyright holder is a legal entity, which can be an individual or a company. If the copyright holder contributes code on behalf of a company, enter the legal entity of the company.
5. The license header information must be consistent with the license information of the open-source repository. If a file is a dual license, the license header must clearly describe the application conditions of each license and include the license header description defined by each license.
