# Window Extension Ability
**WindowExtensionAbility** inherits from **ExtensionAbility**. The content in a **WindowExtensionAbility** object can be displayed as an ability component in other application windows.

> **NOTE**
>
> The initial APIs of this module are supported since API version 9. Newly added APIs will be marked with a superscript to indicate their earliest API version.
> 
> The APIs provided by this module are system APIs.
>
> The APIs of this module can be used only in the stage model.

## Modules to Import

```ts
import WindowExtensionAbility from '@ohos.application.WindowExtensionAbility';
```

## Attributes

**System capability**: SystemCapability.WindowManager.WindowManager.Core

| Name     | Type| Readable| Writable| Description                     |
| --------- | -------- | ---- | ---- | ------------------------- |
| context      | [ExtensionContext](js-apis-extension-context.md)   | Yes  | No  | Context of an Extension ability.     |

## WindowExtensionAbility.onConnect

onConnect(want: Want): rpc.RemoteObject

Called when this Window Extension ability is connected to an ability for the first time.

**System capability**: SystemCapability.WindowManager.WindowManager.Core

| Name| Type| Mandatory| Description|
| -------- | -------- | -------- | -------- |
| want | [Want](js-apis-application-Want.md) | Yes| Information related to this Window Extension ability, including the ability name and bundle name. |

**Return value**
| Type                                           | Description                |
| ----------------------------------------------- | -------------------- |
| [rpc.RemoteObject](js-apis-rpc.md#remoteobject) | Proxy of this Window Extension ability.|

**Example**

```ts
import rpc from '@ohos.rpc';

class StubTest extends rpc.RemoteObject {
    constructor(des) {
        super(des);
    }
    onRemoteRequest(code, data, reply, option) {
        return true;
    }
    queryLocalInterface(descriptor) {
        return null;
    }
    getInterfaceDescriptor() {
        return "";
    }
    sendRequest(code, data, reply, options) {
        return null;
    }
    getCallingPid() {
        return 1;
    }
    getCallingUid() {
        return 1;
    }
    attachLocalInterface(localInterface, descriptor){}
}

export default class MyWindowExtensionAbility extends WindowExtensionAbility {

  onConnect(want): rpc.RemoteObject {
    console.info('WindowExtAbility onConnect ' + want.abilityName);
    return new StubTest("test");
  }

}
```

## WindowExtensionAbility.onDisconnect

onDisconnect(want: Want): void

Called when this Window Extension ability is disconnected from all connected abilities.

**System capability**: SystemCapability.WindowManager.WindowManager.Core

| Name| Type| Mandatory| Description|
| -------- | -------- | -------- | -------- |
| want | [Want](js-apis-application-Want.md) | Yes| Information related to this Window Extension ability, including the ability name and bundle name. |


**Example**

```ts
export default class MyWindowExtensionAbility extends WindowExtensionAbility {

  onDisconnect(want) {
    console.info('WindowExtAbility onDisconnect ' + want.abilityName);
  }

}
```


## WindowExtensionAbility.onWindowReady

onWindowReady(window: Window): void

Called when a window is ready.

**System capability**: SystemCapability.WindowManager.WindowManager.Core

| Name| Type| Mandatory| Description|
| -------- | -------- | -------- | -------- |
| window | [Window](js-apis-window.md) | Yes| Current **Window** instance.|


**Example**

```ts
export default class MyWindowExtensionAbility extends WindowExtensionAbility {

  onWindowReady(window) {
    window.loadContent('WindowExtAbility/pages/index1').then(() => {
      window.getProperties().then((pro) => {
        console.log("WindowExtension " + JSON.stringify(pro));
      })
      window.show();
    })
  }

}
```
