# arp


## 命令功能

在以太网中，主机之间的通信是直接使用MAC地址（非IP地址）来通信的，所以，对于使用IP通信的协议，必须能够将IP地址转换成MAC地址，才能在局域网（以太网）内通信。解决这个问题的方法就是主机存储一张IP和MAC地址对应的表，即ARP缓存，主机要往一个局域网内的目的IP地址发送IP包时，就可以从ARP缓存表中查询到目的MAC地址。ARP缓存是由TCP/IP协议栈维护的，用户可通过ARP命令查看和修改ARP表。


## 命令格式

arp

arp [_-i IF_] -s _IPADDR HWADDR_

arp [_-i IF_] -d _IPADDR_


## 参数说明

  **表1** 参数说明

| 参数 | 参数说明 | 取值范围 | 
| -------- | -------- | -------- |
| 无 | 打印整个ARP缓存的内容。 | N/A | 
| -i&nbsp;IF | 指定的网络接口（可选参数）。 | N/A | 
| -s&nbsp;IPADDR<br/>HWADDR | 增加一条ARP表项，后面的参数是局域网中另一台主机的IP地址及其对应的MAC地址。 | N/A | 
| -d&nbsp;IPADDR | 删除一条ARP表项。 | N/A | 


## 使用指南

- arp命令用来查询和修改TCP/IP协议栈的ARP缓存表，增加非同一子网内的IP地址的ARP表项是没有意义的，协议栈会返回失败。

- 命令需要启动TCP/IP协议栈后才能使用。


## 使用实例

举例：

输入arp

  **示例：**打印整个 ARP 缓存表
  
```
OHOS # arp
Address                 HWaddress               Iface       Type
192.168.1.10            E6:2B:99:2C:4B:20       eth0        static
```

  **表2** 参数说明

| 参数 | 说明 | 
| -------- | -------- |
| Address | 表示网络设备的IPv4地址。 | 
| HWaddress | 表示网络设备的MAC地址。 | 
| Iface | 表示该ARP表项使用的接口名。 | 
| Type | 表示该ARP表项是动态的还是静态的，动态是指ARP表项由协议栈自动创建，静态是指ARP表项是由用户增加的。 | 
