# 信号


## 基本概念

信号(signal)是一种常用的进程间异步通信机制，用软件的方式模拟中断信号，当一个进程需要传递信息给另一个进程时，则会发送一个信号给内核，再由内核将信号传递至指定进程，而指定进程不必进行等待信号的动作。


## 运行机制

信号的运作流程分为三个部分，如表1：

  **表1** 信号的运作流程及相关接口（用户态接口）

| 功能分类 | 接口**名称** | 描述 | 
| -------- | -------- | -------- |
| 注册信号回调函数 | signal： | 注册信号总入口及注册和去注册某信号的回调函数。 | 
| 注册信号回调函数 | sigaction | 功能同signal，但增加了信号发送相关的配置选项，目前仅支持SIGINFO结构体中的部分参数。 | 
| 发送信号 | kill<br/>pthread_kill<br/>raise<br/>alarm<br/>abort | 发送信号给某个进程或进程内发送消息给某线程，为某进程下的线程设置信号标志位。 | 
| 触发回调 | 无 | 由系统调用与中断触发，内核态与用户态切换前会先进入用户态指定函数并处理完相应回调函数，再回到原用户态程序继续运行。 | 

> ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
> 信号机制为提供给用户态程序进程间通信的能力，故推荐使用上表1列出的用户态POSIX相关接口。
> 
> 注册回调函数：
> 
>   
> ```
> void *signal(int sig, void (*func)(int))(int);
> ```
> 
> a. 31 号信号，该信号用来注册该进程的回调函数处理入口，不可重复注册。
> 
> b. 0-30 号信号，该信号段用来注册与去注册回调函数。
> 
> 注册回调函数：
> 
>   
> ```
> int sigaction(int, const struct sigaction *__restrict, struct sigaction *__restrict);
> ```
> 
> 支持信号注册的配置修改和配置获取，目前仅支持SIGINFO的选项，SIGINFO内容见sigtimedwait接口内描述。
> 
> 发送信号：
> 
> a. 进程接收信号存在默认行为，单不支持POSIX标准所给出的STOP及COTINUE、COREDUMP功能。
> 
> b. 进程无法屏蔽SIGSTOP、SIGKILL、SIGCONT信号。
> 
> c. 某进程后被杀死后，若其父进程不回收该进程，其转为僵尸进程。
> 
> d. 进程接收到某信号后，直到该进程被调度后才会执行信号回调。
> 
> e. 进程结束后会发送SIGCHLD信号给父进程，该发送动作无法取消。
> 
> f. 无法通过信号唤醒处于DELAY状态的进程。
