# 概述

## 基本概念

*【 **写作要求**】*

*必选，描述本开发任务相关的基本概念，帮助开发者更好的理解开发任务。* *写作要求见下，完成写作后，请逐项自检*。

| 内容要求 | 是否满足 |
| -------- | -------- |
| 业界通用的概念不用赘述。 |  |
| 注意使用业界通用术语来表达，不用开发者无法理解的内部语言。 |  |


【写作样例】


XX系统音频模块支持音频业务的开发，提供音频相关的功能，主要包括音频播放、音频采集、音量管理和短音播放等。


在进行应用的开发前，开发者应了解以下基本概念：


- 采样
  采样就是把模拟信号数字化的过程，所有的模拟信号都需要通过采样转换为可以用0101来表示的数字信号。

- 采样率
  采样率为每秒从连续信号中提取并组成离散信号的采样次数，单位用赫兹（Hz）来表示。通常人耳能听到频率范围大约在20Hz～20kHz之间的声音。常用的音频采样频率有：8kHz、11.025kHz、22.05kHz、16kHz、37.8kHz、44.1kHz、48kHz、96kHz、192kHz等。

- 声道
  声道是指声音在录制或播放时在不同空间位置采集或回放的相互独立的音频信号，所以声道数也就是声音录制时的音源数量或回放时相应的扬声器数量。

- 音频帧
  音频数据是流式的，本身没有明确的一帧帧的概念，在实际的应用中，为了音频算法处理/传输的方便，一般约定俗成取2.5ms~60ms为单位的数据量为一帧音频。这个时间被称之为“采样时间”，其长度没有特别的标准，它是根据编解码器和具体应用的需求来决定的。


## 运作机制

*【 **写作要求**】*

*可选。如果机制比较简单，通过前面基本概念就可以说清楚，此章节可以不用提供，删除标题即可*。

*描述实现原理介绍机制，如关键步骤相关接口调用时机和触发时机，帮助开发者了解该功能的基本运作原理，以便更好的理解开发任务和定位问题*。

*写作要求见下，完成写作后，请逐项自检*。

| 内容要求 | 是否满足 |
| -------- | -------- |
| 仅描述开发任务相关的原理。 |  |
| 尽量图文配合，一般使用时序图、流程图等形式。文字描述与图形描述匹配。 |  |

【写作样例-1】

- 信号量初始化，为配置的N个信号量申请内存（N值可以由用户自行配置，受内存限制），并把所有的信号量初始化成未使用，并加入到未使用链表中供系统使用。

- 信号量创建，从未使用的信号量链表中获取一个信号量资源，并设定初值。

- 信号量申请，若其计数器值大于0，则直接减1返回成功。否则任务阻塞，等待其它任务释放该信号量，等待的超时时间可设定。当任务被一个信号量阻塞时，将该任务挂到信号量等待任务队列的队尾。

- 信号量释放，若没有任务等待该信号量，则直接将计数器加1返回。否则唤醒该信号量等待任务队列上的第一个任务。

- 信号量删除，将正在使用的信号量置为未使用信号量，并挂回到未使用链表。

- 信号量允许多个任务在同一时刻访问同一资源，但会限制同一时刻访问此资源的最大任务数目。访问同一资源的任务数达到该资源的最大数量时，会阻塞其他试图获取该资源的任务，直到有任务释放该信号量。
  

【写作样例-2】

**互斥锁运作原理**

多任务环境下会存在多个任务访问同一公共资源的场景，而有些公共资源是非共享的，需要任务进行独占式处理。互斥锁怎样来避免这种冲突呢？

用互斥锁处理非共享资源的同步访问时，如果有任务访问该资源，则互斥锁为加锁状态。此时其他任务如果想访问这个公共资源则会被阻塞，直到互斥锁被持有该锁的任务释放后，其他任务才能重新访问该公共资源，此时互斥锁再次上锁，如此确保同一时刻只有一个任务正在访问这个公共资源，保证了公共资源操作的完整性。



## 约束与限制

【写作要求】

*必选*。 *描述本开发任务过程中* *的约束条件，以及此操作约束带来相应的负面影响，包括但不限于如下几方面*：

- **功能限制**：  
  - 功能使用范围（明确不支持的场景）。
  - 规格限制。

* **操作限制**：

  * 已知问题的操作。
  * 潜在风险的操作（如引起性能降低）。
  * 引起性能降低的操作。

写作要求见下，完成写作后，请逐项自检。

| 内容要求 | 是否满足 |
| -------- | -------- |
| 明确功能限制或操作限制。 |  |
| 约束对指导任务开发有影响或体验有感知，否则不用体现。 |  |
| 容易出错的操作在步骤里描述，不在此体现。 |  |

【**写作样例**】

**互斥锁的约束与限制**：

- 两个任务不能对同一把互斥锁加锁。如果某任务对已被持有的互斥锁加锁，则该任务会被挂起，直到持有该锁的任务对互斥锁解锁，才能执行对这把互斥锁的加锁操作。

- 互斥锁不能在中断服务程序中使用。

- XXX作为实时操作系统需要保证任务调度的实时性，尽量避免任务的长时间阻塞，因此在获得互斥锁之后，应该尽快释放互斥锁。

- 持有互斥锁的过程中，不得再调用LOS_TaskPriSet等接口更改持有互斥锁任务的优先级。
