# 多模输入子系统

## 简介

OpenHarmony旨在为开发者提供NUI（Natural User Interface）的交互方式，有别于传统操作系统的输入，在OpenHarmony上，我们将多种维度的输入整合在一起，开发者可以借助应用程序框架、系统自带的UI组件或API接口轻松地实现具有多维、自然交互特点的应用程序。

具体来说，多模输入子系统基于Linux原生驱动和HDF驱动接收设备输入事件，如键盘、鼠标、触摸屏、触摸板等， 对输入事件进行归一化和标准化后通过innerSDK分发到ArkUI框架，ArkUI框架封装事件后转发到应用，或者innerSDK通过JsKit接口直接分发事件到应用。

![](figures/多模架构图.png)

## 目录

```
/foundation/multimodalinput/input
├── common                       # 公共代码
├── interfaces                   # 对外接口存放目录
│   └── native                   # 对外native层接口存放目录
│       └── innerkits            # 对系统内部子系统提供native层接口存放目录
├── service                      # 服务框架代码
├── sa_profile                   # 服务启动配置文件
├── uinput                       # 输入事件注入模块
```

## 使用

### 接口说明

多模输入目前提供的接口为按键事件注入接口，该接口仅对系统应用开放。

inputEventClient是处理注入事件类。

**表 1**  inputEventClient的主要接口

| 功能分类 |                      接口名                       |        描述        |
| :------: | :-----------------------------------------------: | :----------------: |
| 注入按键 | function injectEvent(keyEvent: KeyEvent): number; | 注入按键事件的接口 |

### 使用说明

当前仅提供了BACK按键的事件注入。

当系统应用需要返回上一层时，通过注入接口将BACK键注入到多模服务，多模服务再上传到应用，以实现返回到上一层级目录的效果。使用方式如下所示：

```
// 引入提供的js接口库
import inputEventClient from '@ohos.multimodalInput.inputEventClient';

// 调用注入事件接口
let keyEvent = {
    isPressed: true,        // 按键事件的按键类型：true：down false：up
    keyCode: 2,             // 按键对应的keycode, 例如back键的值为2
    keyDownDuration: 0,     // 按键按下到抬起的时长，单位ms
    isIntercepted: false    // 标注按键事件是否检测拦截
}
res = inputEventClient.injectEvent({KeyEvent: keyEvent});
```

> **说明：** 新增的接口能力需要兼容原有的能力。

### 设备能力支持

|    设备     | 触摸屏 | 触摸板 | 鼠标 | 键盘 |
| :---------: | :----: | :----: | :--: | :--: |
|   rk3568    |   是   |   是   |  是  |  是  |
| hi3516dv300 |   是   |   否   |  否  |  否  |

## 相关仓

**多模输入子系统**

[multimodalinput_input](https://gitee.com/openharmony/multimodalinput_input)

