# slider<a name="EN-US_TOPIC_0000001127125056"></a>

The  **<slider\>**  component is used to quickly adjust settings, such as volume and brightness.

## Child Component<a name="section9288143101012"></a>

Not supported

## Attributes<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row16974649114813"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p742485124819"><a name="p742485124819"></a><a name="p742485124819"></a>min</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p742465115481"><a name="p742465115481"></a><a name="p742465115481"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p144241151104815"><a name="p144241151104815"></a><a name="p144241151104815"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p15424751104814"><a name="p15424751104814"></a><a name="p15424751104814"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p14241451144812"><a name="p14241451144812"></a><a name="p14241451144812"></a>Minimum value of the slider.</p>
</td>
</tr>
<tr id="row497424913485"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p0424205134814"><a name="p0424205134814"></a><a name="p0424205134814"></a>max</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p10424155114487"><a name="p10424155114487"></a><a name="p10424155114487"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p942412519487"><a name="p942412519487"></a><a name="p942412519487"></a>100</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p12424115118483"><a name="p12424115118483"></a><a name="p12424115118483"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1842435134811"><a name="p1842435134811"></a><a name="p1842435134811"></a>Maximum value of the slider.</p>
</td>
</tr>
<tr id="row297464984810"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1042425184815"><a name="p1042425184815"></a><a name="p1042425184815"></a>step</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1342410513489"><a name="p1342410513489"></a><a name="p1342410513489"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p154248512485"><a name="p154248512485"></a><a name="p154248512485"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p94251151174812"><a name="p94251151174812"></a><a name="p94251151174812"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p134251351194814"><a name="p134251351194814"></a><a name="p134251351194814"></a>Step of each slide.</p>
</td>
</tr>
<tr id="row736464410486"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p144258513482"><a name="p144258513482"></a><a name="p144258513482"></a>value</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p134259510484"><a name="p134259510484"></a><a name="p134259510484"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p114257517483"><a name="p114257517483"></a><a name="p114257517483"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p64251851154813"><a name="p64251851154813"></a><a name="p64251851154813"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p442565119483"><a name="p442565119483"></a><a name="p442565119483"></a>Initial value of the slider.</p>
</td>
</tr>
<tr id="row465682516521"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p123951732185210"><a name="p123951732185210"></a><a name="p123951732185210"></a>mode<sup id="sup59311418187"><a name="sup59311418187"></a><a name="sup59311418187"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p0395183220521"><a name="p0395183220521"></a><a name="p0395183220521"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1639518325526"><a name="p1639518325526"></a><a name="p1639518325526"></a>outset</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p23951632105213"><a name="p23951632105213"></a><a name="p23951632105213"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p83958323527"><a name="p83958323527"></a><a name="p83958323527"></a>Slider style. Available values are as follows:</p>
<a name="ul742810911538"></a><a name="ul742810911538"></a><ul id="ul742810911538"><li><strong id="b6310165918435"><a name="b6310165918435"></a><a name="b6310165918435"></a>outset</strong>: The slider is on the sliding bar.</li><li><strong id="b144297112440"><a name="b144297112440"></a><a name="b144297112440"></a>inset</strong>: The slider is inside the sliding bar.<div class="note" id="note10509152215419"><a name="note10509152215419"></a><a name="note10509152215419"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p14509172218549"><a name="p14509172218549"></a><a name="p14509172218549"></a></p>
</div></div>
</li></ul>
</td>
</tr>
<tr id="row355472075219"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p339523215218"><a name="p339523215218"></a><a name="p339523215218"></a>showsteps<sup id="sup11798124781817"><a name="sup11798124781817"></a><a name="sup11798124781817"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p193951032185216"><a name="p193951032185216"></a><a name="p193951032185216"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p12395153214526"><a name="p12395153214526"></a><a name="p12395153214526"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1139593235218"><a name="p1139593235218"></a><a name="p1139593235218"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p639683265217"><a name="p639683265217"></a><a name="p639683265217"></a>Whether to display slider scales.</p>
<div class="note" id="note8765635135413"><a name="note8765635135413"></a><a name="note8765635135413"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p576523535418"><a name="p576523535418"></a><a name="p576523535418"></a></p>
</div></div>
</td>
</tr>
<tr id="row1711814164526"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p10396232195214"><a name="p10396232195214"></a><a name="p10396232195214"></a>showtips<sup id="sup14957135010188"><a name="sup14957135010188"></a><a name="sup14957135010188"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p6396832185213"><a name="p6396832185213"></a><a name="p6396832185213"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p8396132205215"><a name="p8396132205215"></a><a name="p8396132205215"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p123962032185210"><a name="p123962032185210"></a><a name="p123962032185210"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p16396133212520"><a name="p16396133212520"></a><a name="p16396133212520"></a>Whether a pop-up is displayed to show the percentage value on the slider.</p>
<div class="note" id="note0708645135419"><a name="note0708645135419"></a><a name="note0708645135419"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p4708154510548"><a name="p4708154510548"></a><a name="p4708154510548"></a></p>
</div></div>
</td>
</tr>
</tbody>
</table>

## Styles<a name="section5775351116"></a>

In addition to the styles in  [Universal Styles](js-components-common-styles.md), the following styles are supported.

<a name="table1196916173572"></a>
<table><thead align="left"><tr id="row15969161714572"><th class="cellrowborder" valign="top" width="17.688231176882315%" id="mcps1.1.6.1.1"><p id="p99691317115713"><a name="p99691317115713"></a><a name="p99691317115713"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="10.588941105889413%" id="mcps1.1.6.1.2"><p id="p1969141715570"><a name="p1969141715570"></a><a name="p1969141715570"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="24.18758124187582%" id="mcps1.1.6.1.3"><p id="p9969317105718"><a name="p9969317105718"></a><a name="p9969317105718"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="15.578442155784424%" id="mcps1.1.6.1.4"><p id="p12969517115717"><a name="p12969517115717"></a><a name="p12969517115717"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="31.95680431956805%" id="mcps1.1.6.1.5"><p id="p2969717175713"><a name="p2969717175713"></a><a name="p2969717175713"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row179691817175713"><td class="cellrowborder" valign="top" width="17.688231176882315%" headers="mcps1.1.6.1.1 "><p id="p796919179575"><a name="p796919179575"></a><a name="p796919179575"></a>color</p>
</td>
<td class="cellrowborder" valign="top" width="10.588941105889413%" headers="mcps1.1.6.1.2 "><p id="p119699173572"><a name="p119699173572"></a><a name="p119699173572"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="24.18758124187582%" headers="mcps1.1.6.1.3 "><p id="p796911714579"><a name="p796911714579"></a><a name="p796911714579"></a>#19000000</p>
</td>
<td class="cellrowborder" valign="top" width="15.578442155784424%" headers="mcps1.1.6.1.4 "><p id="p169699176574"><a name="p169699176574"></a><a name="p169699176574"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="31.95680431956805%" headers="mcps1.1.6.1.5 "><p id="p696910177571"><a name="p696910177571"></a><a name="p696910177571"></a>Background color of the slider.</p>
</td>
</tr>
<tr id="row179698172574"><td class="cellrowborder" valign="top" width="17.688231176882315%" headers="mcps1.1.6.1.1 "><p id="p12969717115711"><a name="p12969717115711"></a><a name="p12969717115711"></a>selected-color</p>
</td>
<td class="cellrowborder" valign="top" width="10.588941105889413%" headers="mcps1.1.6.1.2 "><p id="p13970121719579"><a name="p13970121719579"></a><a name="p13970121719579"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="24.18758124187582%" headers="mcps1.1.6.1.3 "><p id="p89701917165714"><a name="p89701917165714"></a><a name="p89701917165714"></a>#ff007dff</p>
</td>
<td class="cellrowborder" valign="top" width="15.578442155784424%" headers="mcps1.1.6.1.4 "><p id="p8970161713572"><a name="p8970161713572"></a><a name="p8970161713572"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="31.95680431956805%" headers="mcps1.1.6.1.5 "><p id="p1097011173571"><a name="p1097011173571"></a><a name="p1097011173571"></a>Selected color of the slider.</p>
</td>
</tr>
<tr id="row6970181735714"><td class="cellrowborder" valign="top" width="17.688231176882315%" headers="mcps1.1.6.1.1 "><p id="p1970141717579"><a name="p1970141717579"></a><a name="p1970141717579"></a>block-color</p>
</td>
<td class="cellrowborder" valign="top" width="10.588941105889413%" headers="mcps1.1.6.1.2 "><p id="p4970617165718"><a name="p4970617165718"></a><a name="p4970617165718"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="24.18758124187582%" headers="mcps1.1.6.1.3 "><p id="p297091755720"><a name="p297091755720"></a><a name="p297091755720"></a>#ffffff</p>
</td>
<td class="cellrowborder" valign="top" width="15.578442155784424%" headers="mcps1.1.6.1.4 "><p id="p3970121745715"><a name="p3970121745715"></a><a name="p3970121745715"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="31.95680431956805%" headers="mcps1.1.6.1.5 "><p id="p12970817175710"><a name="p12970817175710"></a><a name="p12970817175710"></a>Slider color.</p>
<div class="note" id="note29562075516"><a name="note29562075516"></a><a name="note29562075516"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p7956203555"><a name="p7956203555"></a><a name="p7956203555"></a></p>
</div></div>
</td>
</tr>
</tbody>
</table>

## Events<a name="section412849105010"></a>

In addition to the events in  [Universal Events](js-components-common-events.md), the following events are supported.

<a name="table836435619510"></a>
<table><thead align="left"><tr id="row153658563517"><th class="cellrowborder" valign="top" width="24.852485248524854%" id="mcps1.1.4.1.1"><p id="a426b8903842d48fa8012a24ff3c997eb"><a name="a426b8903842d48fa8012a24ff3c997eb"></a><a name="a426b8903842d48fa8012a24ff3c997eb"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="29.452945294529453%" id="mcps1.1.4.1.2"><p id="a53448ba47e5e4ae9bf7774c90820e970"><a name="a53448ba47e5e4ae9bf7774c90820e970"></a><a name="a53448ba47e5e4ae9bf7774c90820e970"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="45.69456945694569%" id="mcps1.1.4.1.3"><p id="add489ff50c444f24b759162c7f4bad9a"><a name="add489ff50c444f24b759162c7f4bad9a"></a><a name="add489ff50c444f24b759162c7f4bad9a"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row4467111418517"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p5786131515111"><a name="p5786131515111"></a><a name="p5786131515111"></a>change</p>
</td>
<td class="cellrowborder" valign="top" width="29.452945294529453%" headers="mcps1.1.4.1.2 "><p id="p145081649105418"><a name="p145081649105418"></a><a name="p145081649105418"></a><a href="#table12318174214516">ChangeEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="45.69456945694569%" headers="mcps1.1.4.1.3 "><p id="p078614157518"><a name="p078614157518"></a><a name="p078614157518"></a>Triggered when the value changes.</p>
</td>
</tr>
</tbody>
</table>

**Table  1**  ChangeEvent

<a name="table12318174214516"></a>
<table><thead align="left"><tr id="row631810427458"><th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.1"><p id="a82b31036c9c94b3d8a7702523f9b40ec"><a name="a82b31036c9c94b3d8a7702523f9b40ec"></a><a name="a82b31036c9c94b3d8a7702523f9b40ec"></a>Attribute</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.2"><p id="a916c9aa3c32e4903953063bb7424027c"><a name="a916c9aa3c32e4903953063bb7424027c"></a><a name="a916c9aa3c32e4903953063bb7424027c"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.3"><p id="af9aad173dc2f44f5be69c86fe5537af7"><a name="af9aad173dc2f44f5be69c86fe5537af7"></a><a name="af9aad173dc2f44f5be69c86fe5537af7"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1731934264512"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="a660dbbfaf8d349b7921fbe9a0b96574a"><a name="a660dbbfaf8d349b7921fbe9a0b96574a"></a><a name="a660dbbfaf8d349b7921fbe9a0b96574a"></a>progress(deprecated<sup id="sup119388266511"><a name="sup119388266511"></a><a name="sup119388266511"></a>5+</sup>)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="aab0506a4edc147beb25866891e5fddcd"><a name="aab0506a4edc147beb25866891e5fddcd"></a><a name="aab0506a4edc147beb25866891e5fddcd"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="aa3d09d0a55704a6097fb39739436c5db"><a name="aa3d09d0a55704a6097fb39739436c5db"></a><a name="aa3d09d0a55704a6097fb39739436c5db"></a>Current value of the slider.</p>
</td>
</tr>
<tr id="row1595014195562"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p1951151935610"><a name="p1951151935610"></a><a name="p1951151935610"></a>isEnd(deprecated<sup id="sup99714213583"><a name="sup99714213583"></a><a name="sup99714213583"></a>5+</sup>)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p89511819125613"><a name="p89511819125613"></a><a name="p89511819125613"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p129511219115620"><a name="p129511219115620"></a><a name="p129511219115620"></a>Whether the dragging operation ends. Available values are as follows:</p>
<a name="ul1332217234581"></a><a name="ul1332217234581"></a><ul id="ul1332217234581"><li><strong id="b184858101968"><a name="b184858101968"></a><a name="b184858101968"></a>true</strong>: The dragging ends.</li><li><strong id="b1099042014618"><a name="b1099042014618"></a><a name="b1099042014618"></a>false</strong>: The dragging is in progress.</li></ul>
</td>
</tr>
<tr id="row68961248174517"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="a7e263f0434c94a16a584943ddde92012"><a name="a7e263f0434c94a16a584943ddde92012"></a><a name="a7e263f0434c94a16a584943ddde92012"></a>value<sup id="sup11254165405316"><a name="sup11254165405316"></a><a name="sup11254165405316"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="a76ffd0f779234ab6a77e808500fca675"><a name="a76ffd0f779234ab6a77e808500fca675"></a><a name="a76ffd0f779234ab6a77e808500fca675"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="a85eddf1d320641a8b344aaadffe6d49e"><a name="a85eddf1d320641a8b344aaadffe6d49e"></a><a name="a85eddf1d320641a8b344aaadffe6d49e"></a>Current value of the slider.</p>
</td>
</tr>
<tr id="row1333335416456"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p733395494510"><a name="p733395494510"></a><a name="p733395494510"></a>mode<sup id="sup15843190155419"><a name="sup15843190155419"></a><a name="sup15843190155419"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p113333549459"><a name="p113333549459"></a><a name="p113333549459"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p933335415453"><a name="p933335415453"></a><a name="p933335415453"></a>Type of the change event. Available values are as follows:</p>
<a name="ul1998831814525"></a><a name="ul1998831814525"></a><ul id="ul1998831814525"><li><strong id="b163190216816"><a name="b163190216816"></a><a name="b163190216816"></a>start</strong>: The <strong id="b69665997"><a name="b69665997"></a><a name="b69665997"></a>value</strong> starts to change.</li><li><strong id="b1732713276817"><a name="b1732713276817"></a><a name="b1732713276817"></a>move</strong>: The <strong id="b12607157190"><a name="b12607157190"></a><a name="b12607157190"></a>value</strong> is changing with users' dragging.</li><li><strong id="b8771301819"><a name="b8771301819"></a><a name="b8771301819"></a>end</strong>: The <strong id="b670519441891"><a name="b670519441891"></a><a name="b670519441891"></a>value</strong> stops changing.</li></ul>
</td>
</tr>
</tbody>
</table>

## Example<a name="section166243517816"></a>

```
<!-- xxx.hml -->
<div class="container">
  <text>slider start value is {{startValue}}</text>
  <text>slider current value is {{currentValue}}</text>
  <text>slider end value is {{endValue}}</text>
  <slider min="0" max="100" value="{{value}}" onchange="setvalue" ></slider>
</div>
```

```
/* xxx.css */
.container {
  flex-direction: column;
  justify-content: center;
  align-items: center;
  
  
}
```

```
// xxx.js
export default {
  data: {
    value: 0,
    startValue: 0,
    currentValue: 0,
    endValue: 0,
  },
  setvalue(e) {
    if (e.mode == "start") {
      this.value = e.value;
      this.startValue = e.value;
    } else if (e.mode == "move") {
      this.value = e.value;
      this.currentValue = e.value;
    } else if (e.mode == "end") {
      this.value = e.value;
      this.endValue = e.value;
    }
  }
}
```

![](figures/slider.png)

