# Application Development Overview

The application development documents provide reference for you to develop applications using the APIs provided by OpenHarmony. They walk you through how to use JavaScript APIs to develop applications on the standard system.

The documents are carefully organized as follows:

### Getting Started

[Here](quick-start/Readme-EN.md) you'll learn how to quickly get started with OpenHarmony application development.

Browse the documents on the instructions for quickly building your first application and the basics about OpenHarmony applications.

Check out the development fundamentals, which comprise descriptions of the package structure configuration file for OpenHarmony applications and the instructions for use of resource files.

### Development

To facilitate your application development, we provide development guidelines for key features.

First thing first, familiarize yourself with the two cornerstone frameworks in OpenHarmony applications:

- Application framework: [Ability Development](ability/Readme-EN.md)
- UI framework: [UI Development](ui/Readme-EN.md)

All applications should be developed on top of these frameworks.

Then, equip yourself for developing the key features, with the following guidelines:
- [Window Manager](windowmanager/Readme-EN.md)
- [WebGL](webgl/Readme-EN.md)
- [Media](media/Readme-EN.md)
- [Security](security/Readme-EN.md)
- [Connectivity](connectivity/Readme-EN.md)
- [Data Management](database/Readme-EN.md)
- [Agent-Powered Scheduled Reminders](background-agent-scheduled-reminder/Readme-EN.md)
- [Background Task Management](background-task-management/Readme-EN.md)
- [Device Management](device/Readme-EN.md)
- [Device Usage Statistics](device-usage-statistics/Readme-EN.md)
- [DFX](dfx/Readme-EN.md)
- [Internationalization](internationalization/Readme-EN.md)

### Tools

DevEco Studio is a high-performance integrated development environment (IDE) recommended for developing OpenHarmony applications.
[Here](https://developer.harmonyos.com/en/docs/documentation/doc-guides/ohos-deveco-studio-overview-0000001263280421) you can learn everything about DevEco Studio, including how to use this tool to create a project and sign, debug, and run an application.

### Hands-On Tutorials

To make you better understand how functions work together and jumpstart your application development projects, we provide stripped-down, real-world [samples](https://gitee.com/openharmony/app_samples/blob/master/README.md) and [codelabs](https://gitee.com/openharmony/codelabs).

### API References

API references encompass all components and APIs available in OpenHarmony, helping you use and integrate APIs more effectively.

They are organized as follows:
-   [Component Reference (JavaScript-based Web-like Development Paradigm)](reference/arkui-js/Readme-EN.md)
-   [Component Reference (TypeScript-based Declarative Development Paradigm)](reference/arkui-ts/Readme-EN.md)
-   APIs
    -   [JS and TS APIs](reference/apis/Readme-EN.md)
    -   Native APIs
        -   [Standard Library](reference/native-lib/third_party_libc/musl.md)
        -   [Node_API](reference/native-lib/third_party_napi/napi.md)


### Readme

For details about the principles and basic information of each subsystem, see the README file in [docs/en/readme](../readme).
