# 启动恢复子系统<a name="ZH-CN_TOPIC_0000001124561621"></a>

-   [简介](#section11660541593)
-   [目录](#section161941989596)
-   [约束](#section1718733212019)
-   [使用说明](#section8533192617117)
-   [相关仓](#section1371113476307)

## 简介<a name="section11660541593"></a>

启动恢复负责在内核启动之后到应用启动之前的系统关键进程和服务的启动过程的功能。涉及以下组件：

-   init组件

    支持使用LiteOS-A和Linux内核的平台。

    负责处理从内核加载第一个用户态进程开始，到第一个应用程序启动之间的系统服务进程启动过程。启动恢复子系统除负责加载各系统关键进程之外，还需在启动的同时设置其对应权限，并在子进程启动后对指定进程实行保活（若进程意外退出要重新启动），对于核心进程意外退出时，启动恢复子系统还要执行系统重启操作。详见“[init启动引导组件](../device-dev/subsystems/subsys-boot-init.md)”部分。


-   appspawn应用孵化器组件

    提供了Lite和Standard两个版本，Lite版本支持使用LiteOS-A内核的平台；Standard版本支持使用Linux内核的平台。

    负责接受应用程序框架的命令孵化应用进程，设置其对应权限，并调用应用程序框架的入口。

-   bootstrap启动引导组件

    支持使用LiteOS-M内核的平台。

    提供了各服务和功能的启动入口标识。在SAMGR启动时，会调用boostrap标识的入口函数，并启动系统服务。

-   syspara系统参数组件

    负责提供获取与设置操作系统相关的系统属性。

    支持全量系统平台。支持的系统属性包括：默认系统属性、OEM厂商系统属性和自定义系统属性。OEM厂商部分仅提供默认值，具体值需OEM产品方按需进行调整，详见“[syspara系统属性组件](../device-dev/subsystems/subsys-boot-syspara.md)”部分。


## 目录<a name="section161941989596"></a>

**表 1**  启动恢复源代码目录结构

<a name="table2977131081412"></a>

<table><thead align="left"><tr id="row7977610131417"><th class="cellrowborder" valign="top" width="20.880000000000003%" id="mcps1.2.4.1.1"><p id="p18792459121314"><a name="p18792459121314"></a><a name="p18792459121314"></a>名称</p>
</th>
<th class="cellrowborder" valign="top" width="65.2%" id="mcps1.2.4.1.2"><p id="p77921459191317"><a name="p77921459191317"></a><a name="p77921459191317"></a>描述</p>
</th>
<th class="cellrowborder" valign="top" width="13.919999999999998%" id="mcps1.2.4.1.3"><p id="p101617019356"><a name="p101617019356"></a><a name="p101617019356"></a>适配平台</p>
</th>
</tr>
</thead>
<tbody><tr id="row17977171010144"><td class="cellrowborder" valign="top" width="20.880000000000003%" headers="mcps1.2.4.1.1 "><p id="p2793159171311"><a name="p2793159171311"></a><a name="p2793159171311"></a>base/startup/appspawn_lite</p>
</td>
<td class="cellrowborder" valign="top" width="65.2%" headers="mcps1.2.4.1.2 "><p id="p879375920132"><a name="p879375920132"></a><a name="p879375920132"></a>应用孵化器组件，appspawn进程，负责通过IPC机制接收Ability Manager Service消息，然后根据消息解析结果启动应用进程并赋予其对应权限。</p>
</td>
<td class="cellrowborder" valign="top" width="13.919999999999998%" headers="mcps1.2.4.1.3 ">LiteOS-A内核平台
</td>
</tr>
<tr id="row17977171010144"><td class="cellrowborder" valign="top" width="20.880000000000003%" headers="mcps1.2.4.1.1 "><p id="p2793159171311"><a name="p2793159171311"></a><a name="p2793159171311"></a>base/startup/appspawn_standard</p>
</td>
<td class="cellrowborder" valign="top" width="65.2%" headers="mcps1.2.4.1.2 "><p id="p879375920132"><a name="p879375920132"></a><a name="p879375920132"></a>应用孵化器组件，appspawn进程，负责通过IPC机制接收Ability Manager Service消息，然后根据消息解析结果启动应用进程并赋予其对应权限。</p>
</td>
<td class="cellrowborder" valign="top" width="13.919999999999998%" headers="mcps1.2.4.1.3 ">Linux内核平台
</td>
</tr>
<tr id="row6978161091412"><td class="cellrowborder" valign="top" width="20.880000000000003%" headers="mcps1.2.4.1.1 "><p id="p37931659101311"><a name="p37931659101311"></a><a name="p37931659101311"></a>base/startup/bootstrap_lite</p>
</td>
<td class="cellrowborder" valign="top" width="65.2%" headers="mcps1.2.4.1.2 "><p id="p6793059171318"><a name="p6793059171318"></a><a name="p6793059171318"></a>启动引导组件，启动系统核心服务外的其他服务。</p>
</td>
<td class="cellrowborder" valign="top" width="13.919999999999998%" headers="mcps1.2.4.1.3 ">LiteOS-M内核平台
</td>
</tr>
<tr id="row6978201031415"><td class="cellrowborder" align="left" valign="top" width="20.880000000000003%" headers="mcps1.2.4.1.1 "><p id="p117935599130"><a name="p117935599130"></a><a name="p117935599130"></a>base/startup/init_lite</p>
</td>
<td class="cellrowborder" valign="top" width="65.2%" headers="mcps1.2.4.1.2 "><p id="p0793185971316"><a name="p0793185971316"></a><a name="p0793185971316"></a>init组件，init进程，内核完成初始化后加载的第一个用户态进程，启动后解析/etc/init.cfg配置文件，并根据解析结果拉起其他系统关键进程，同时分别赋予其对应权限。</p>
</td>
<td class="cellrowborder" valign="top" width="13.919999999999998%" headers="mcps1.2.4.1.3 ">LiteOS-A内核平台以及Linux内核平台</td>
</tr>
<tr id="row1897841071415"><td class="cellrowborder" valign="top" width="20.880000000000003%" headers="mcps1.2.4.1.1 "><p id="p469782418557"><a name="p469782418557"></a><a name="p469782418557"></a>base/startup/syspara_lite</p>
</td>
<td class="cellrowborder" valign="top" width="65.2%" headers="mcps1.2.4.1.2 "><p id="p15697102412558"><a name="p15697102412558"></a><a name="p15697102412558"></a>系统属性组件。提供获取设备信息接口，如：产品名、品牌名、品类名、厂家名等。</p>
</td>
<td class="cellrowborder" valign="top" width="13.919999999999998%" headers="mcps1.2.4.1.3 ">全量平台</td>
</tr>
</tbody>
</table>


```
base/startup/
├── appspawn_standard         # 标准系统应用孵化器组件
│   ├── include               # 头文件目录
│   ├── parameter             # 系统参数
│   ├── src                   # 服务程序源码
│   └── test                  # 测试代码
├── appspawn_lite             # 小型系统应用孵化器组件
│   └── services
│       ├── include           # 应用孵化器组件头文件目录
│       ├── src               # 应用孵化器组件源文件目录
│       └── test              # 应用孵化器组件测试用例源文件目录
├── bootstrap_lite            # 启动引导组件
│   └── services
│       └── source            # 启动引导组件源文件目录
├── init_lite                 # init组件
│   ├── initsync              # 分阶段启动源文件目录
│   ├── interfaces            # 对外接口目录
│   └── services
│       ├── include           # init组件头文件目录
│       ├── src               # init组件源文件目录
│       └── test              # init组件测试用例源文件目录
└── syspara_lite              # 系统参数组件
    ├── adapter               # 系统参数适配层源文件目录
    ├── frameworks            # 系统参数组件源文件目录
    ├── hals                  # 系统参数组件硬件抽象层头文件目录
    ├── interfaces            # 系统参数组件对外接口目录
    └── simulator             # 模拟器适配
```

## 相关内容<a name="section1371113476307"></a>

[启动恢复子系统概述](../device-dev/subsystems/subsys-boot-overview.md)

[startup\_appspawn\_lite](https://gitee.com/openharmony/startup_appspawn_lite)

[startup\_appspawn](https://gitee.com/openharmony/startup_appspawn)

[startup\_bootstrap\_lite](https://gitee.com/openharmony/startup_bootstrap_lite)

[startup_init_lite](https://gitee.com/openharmony/startup_init_lite)

[startup\_syspara\_lite](https://gitee.com/openharmony/startup_syspara_lite)

