# 语言风格


## 人称及语态

【规则】使用第二人称。人称代词默认省略，必须出现时，推荐使用“开发者”而不是“你”。

| **正例** | **反例** |
| -------- | -------- |
| 使用IDE创建卡片工程。 | 我们使用IDE创建卡片工程。 |

【建议】尽量使用主动语态。即句子主语是执行动作的人或事物，而不是被操作的事物。

| 建议 | 不建议 |
| -------- | -------- |
| 配置参数A，声明支持B功能。 | A参数被配置后，即可支持B功能。 |


## 语气及用词

【规则】客观陈述内容，口吻友好。

| **正例** | **反例** |
| -------- | -------- |
| 确保配置正确。否则，会导致系统工作不正常。 | 你必须保证配置正确。否则后果自负。 |

【规则】避免使用口语化词语。

| **正例** | **反例** |
| -------- | -------- |
| 无 | “不准”、“……的话”、“就可以了”、“做……用”等。 |

【规则】避免行话。行话只有小部分人员能理解，且难以翻译。

| **正例** | **反例** |
| -------- | -------- |
| 非法访问内存空间 | 踩内存 |

【规则】避免成语和俗语。成语和俗语翻译时很难有效传达其确切含义，没有必要在技术资料中存在。

【规则】避免使用可能带有偏见或歧视含义的词汇，包括性别、种族、文化、年龄、技能、职业、宗教、经济水平等方面的偏见或歧视。

【规则】避免使用可能会引起操作者负面情绪的词语。

| **正例** | **反例** |
| -------- | -------- |
| 无 | “你已被踢出” |


## 用户视角

【规则】为目标用户（指目标读者，本文简称用户）写作：

- 明确文档面向的用户（如产品经理、开发者），从而明确用户关注的内容要点，提供且仅提供用户关注的内容。写作中，时刻站在用户视角，思考文章是否覆盖了内容要点、有无冗余。

- 针对不同技能水平（如新手、资深）的用户提供支撑信息。

- 按照用户认知习惯呈现信息（请参考“[清晰](#清晰)”）。

【规则】面向用户场景和用户任务写作：

- 文档内容应面向用户的真实场景和目标/任务，而非产品功能。

- 标题明确体现任务目标。

- 对于复杂任务流（超过5步），在操作开始前提供操作流程图或表。

- 提供清晰的、step-by-step的操作指导。适当配合界面截图使操作更直观，仅截取关键信息。

- 为用户任务就近提供操作支撑信息。

- 提供任务全流程所需的支撑信息，例如必要的背景信息、前提条件、准备动作、操作成功的验证方法、常见的故障处理和错误预防信息。

- 为所呈现的信息提供必要的理由（例如对用户理解或完成开发任务没有帮助的内部实现原理不需要提供）。


## 完整

【规则】避免任务场景缺失。开始写作前，应通过用户与任务分析活动，明确文档要提供哪些任务场景的指导信息。

【规则】通过写作模板来保证内容的完整性：

- OpenHarmony文档遵从结构化、模块化理念，对于每类信息，均根据用户的信息需求提供相应内容模板，即“[OpenHarmony文档写作模板](https://gitee.com/openharmony/docs/tree/master/zh-cn/contribute/template)”。请从中选择最贴近待写作内容的模板，保证知识点覆盖完整。

- 写作模板中“必选”的节点，禁止删除。

- 写作模板中“可选”的节点，在确定不涉及的情况下，删除即可。


## 具体

【规则】用具体的描述代替抽象/晦涩的描述。

| **正例** | 反例 |
| -------- | -------- |
| 在编译构建过程中，提示LABEL_VALUE_ERROR错误信息。 | 编译构建失败。 |

【规则】表示数量或程度时，避免用笼统的“多”“少”“大”，改为具体的、易于感知或衡量的数字。

| **正例** | 反例 |
| -------- | -------- |
| 文件大于16MB | 文件超限 |
| 等待30分钟左右 | 等待较长的时间 |
| CPU运行速度提升80% | 性能增强 |


## 简洁

【规则】使用主谓结构、主谓宾结构的句子，避免添加不必要的修饰成分。

【规则】避免使用长连句。同一句子中的逗号数不能超过5个。

【规则】禁止使用双重否定。

【规则】言简意赅，直接陈述观点。避免无意义的词语，包括表示程度、语气的词。

| **正例** | 反例 |
| -------- | -------- |
| 属性不允许重复定义。 | 每个属性最多只允许出现一次。 |
| 绑定服务与通知。 | 将服务与通知绑定就好了。 |

【规则】根据用户的技能水平，剔除不必要的信息。


## 清晰

【规则】确保语言描述清晰，不模糊，不晦涩，易理解（传递一个清楚的意思）：

- 遵循“[具体](#具体)”、“[简洁](#简洁)”的要求。

- 确保每个代词都有清晰的指代，能够通过上下文清晰获取其指代对象，便于理解与翻译。

- 参数取值原则、原理描述清晰易懂。
    | **正例** | 反例 |
  | -------- | -------- |
  | 当参数A设置为1时：<br/>-&nbsp;如果参数B设置为1，表示有下一级跳转，此时页签为方形9宫格。<br/>-&nbsp;如果参数B设置为0，表示无下一级跳转，此时页签自动变为圆形9宫格。 | 在参数A为1同时参数B为1，如有下一级跳转则页签为方形9宫格，若无下一级跳转则界面页签会自动变为圆形9宫格。 |

- 避免使用引起歧义的词。
    | **正例** | **反例** |
  | -------- | -------- |
  | 接通开发板电源。 | 按下开发板电源开关。 |

- 避免使用含义模糊的词，如表示程度、强调等语气的词。
    | **正例** | **反例** |
  | -------- | -------- |
  | 无 | -&nbsp;表示程度的词：较多（more）、较好（better）、基本地（basically）、决定性的（decisively）、最后的&nbsp;&nbsp;(&nbsp;finally&nbsp;)、很（very）、可能（may/maybe/could）、大概（probably）、通常(&nbsp;usually&nbsp;)、一般&nbsp;&nbsp;(&nbsp;generally&nbsp;)。<br/>-&nbsp;表示转折的词：当然（of&nbsp;&nbsp;course）、然而（however）。<br/>-&nbsp;表示量的词：有些（some）、非常（very）、大量（large&nbsp;&nbsp;number）、一些（several）、少许（few）。 |

【规则】确保逻辑清晰：

- 采用合理的逻辑结构（写作顺序），使章节/段落/步骤/句子顺序符合用户认知习惯。以下常用写作顺序可以独立使用，也可配合使用。
    | **逻辑结构（写作顺序）** | 特征 | 适用的典型信息类型（不限于） |
  | -------- | -------- | -------- |
  | 先总后分 | 先综述总论点（如特性概述、开发流程概述），再依次展开分论点（子特性详细介绍、开发任务流详细介绍）。<br/>总论点下的分论点做到完全穷尽（不遗漏）、相互独立（无交叠）。 | 功能/场景描述类<br/>开发指导类 |
  | 按时间顺序 | 时间、流程或因果上的有先有后。 | 开发指导类 |
  | 按空间/结构顺序 | 从上层到下层；从整体到局部。 | 架构描述类<br/>组网描述类 |
  | 按重要性顺序 | 从重要到次要；从基础到特殊。 | 开发指导类<br/>问题分析类 |
  | 按"情境-冲突-问题-回答"顺序 | 通过追溯问题的起源和发展，引入用户熟悉的情境，然后说明冲突，从而提出最初的问题，最后给出解决方案（也就是即将阐述的主题）。 | 功能/场景描述类 |

- 对于开发指导类内容，能让用户直观了解具体场景/任务的完整开发流程。

- 对于存在分支的步骤，提供明确的选取原则。

- 适当使用图、表，使逻辑和表意更直观。


## 一致

【规则】用词一致：术语、缩略语、描述同一对象的词汇要全文一致，符合用户的心理预期，禁止使用不同的词汇（包括中英文混用）描述同一事物或操作。

OpenHarmony常用词必须遵从下表。

| 正例 | 反例 |
| -------- | -------- |
| 登录 | 登陆 |
| 单击 | 点击 |
| 帐户 | 账户 |
| 帐号 | 账号 |
| 图像 | 图象 |
| 计费 | 记费 |
| 阈值 | 阀值 |
| 重写 | 复写 |
| 命令 | 指令 |
| 外形 | 外型 |

【规则】结构一致：相同文档或者同类信息，保持结构一致，有助于用户对文档结构的把握，方便信息的查找和理解。请优先在“[OpenHarmony文档写作模板](https://gitee.com/openharmony/docs/tree/master/zh-cn/contribute/template)”中选择最贴近待写作内容的模板，遵循模板要求写作。

【规则】句式一致：使用一致的句式，不但使技术文档对外表现出一致的风格，也有助于用户在理解内容时，符合已经形成的思维惯性，理解起来更简单。例如统一使用祈使句描述动作。

【规则】格式一致：同类元素如[代码块](style-guide-content-elements.md#代码与注释)、[文件路径](style-guide-content-elements.md#文件路径)等，格式保持一致，便于用户理解。

【建议】下表给出了另一部分常用词的推荐用法，请参考。

| 建议 | 不建议 |
| -------- | -------- |
| 界面 | 页面 |
| 短消息 | 短信 |
| 数据包 | 数据报 |
