# OpenHarmony安全设计规范

本文档主要参考业界标准和最佳实践，提供OpenHarmony安全设计规范，用于指导开发者进行设计。

## 1.访问通道控制

1-1	为了防止系统和资源被非法访问，除非标准协议约定，所有能对系统进行管理的接口，应具备接入认证机制并缺省启用。

**说明**：为减少系统攻击面，对于可对系统进行管理(包括配置、升级、调试等)的接口必须要启用认证机制，避免未授权的访问。

1-2	只保留运行维护所必需的对外通信连接，关闭不需要连接、端口。

**说明**：关闭不必要的通信端口，可大大降低安全威胁，是系统安全防护的基础手段。

## 2.应用安全

2-1	对于每一个需要授权访问的请求都需核实请求方的会话标识是否合法、请求方是否被授权执行此操作。

**说明**：避免越权访问。

2-2	认证处理过程在客户端实现是不可靠的，可被轻易绕过，因此对用户的最终认证处理过程必须放到服务端进行。

## 3.加密

3-1	应该使用经过验证的、安全的、公开的加密算法。

**说明**：算法的安全性不在于算法本身的机密性。

**示例**：推荐使用的密码算法：
1）分组密码算法：AES（密钥长度在128位及以上）
2）流密码算法：AES（密钥长度在128位及以上）（OFB或CTR模式）
3）非对称加密算法：RSA（推荐3072位)
4）哈希算法：SHA2（256位及以上）
5）密钥交换算法：DH（推荐3072位)
6）HMAC（基于哈希的消息验证码）算法：HMAC-SHA2
不安全的密码算法举例如下：MD5/DES/3DES（加密传输协议TLS/SSH密码协议中避免使用3DES，非密码协议场景必须保证密钥K1≠K2≠K3）/HMAC-SHA2-256-96/HMAC-SHA1-96/HMAC-MD5/HMAC-MD5-96/SSH服务所有带CBC模式的算法/匿名算法套件/DH512/DH1024/SKIPJACK/RC2/RSA（1024位及以下）/MD2/MD4/blowfish/RC4。
3-2	除标准协议外，避免使用差错控制编码（如奇偶校验、CRC）实现完整性校验。	

3-3	密码算法中使用到的随机数必须是密码学意义上的安全随机数。

**说明**：使用了不安全的随机数，容易导致密码算法的强度降低甚至算法的失效。

**示例**：可使用以下的安全随机数生成接口：
1) OpenSSL的RAND_bytes或RAND_priv_bytes；
2) OpenSSL FIPS模块中实现的DRBG；
3) JDK的java.security.SecureRandom；
4）类Unix平台的/dev/random文件

3-4	默认使用安全的密码算法，关闭或者禁用不安全的密码算法。在选择密码算法库时，应使用通过认证的或业界开源公认的或经评估认可的密码算法库。

**说明**：随着密码技术的发展以及计算能力的提升，一些密码算法变得不再安全，使用不安全的密码算法，有可能为用户的数据带来风险。同时非专业人员实现的密码算法，在技术上未经业界分析验证，有可能存在未知的缺陷，因此应使用通过认证的或业界开源公认的或经评估认可的密码算法库。

**示例**：密码算法相关示例请参考3-1。

3-5	使用分组密码算法时，应优先选择GCM模式。	

3-6	使用RSA算法进行加密操作时，应优先选择OAEP填充方式。

**说明**：学术界和业界针对RSA的PKCS1填充方式的攻击已经比较成熟，如果不使用OAEP填充替换PKCS1填充，攻击者解密密文的难度将大大降低。

3-7	使用非对称运算保护数据机密性时，避免使用私钥加密敏感数据。

**说明**：私钥加密无法保护数据的机密性。	

3-8	使用非对称算法时，加密和签名要使用不同的密钥对。

3-9	在同时需要对数据进行对称加密和数字签名时，使用先签名后加密的方式。检查程序里的密码算法函数调用次序，避免对密文的hash值进行签名（即对密文的hash值进行私钥运算）。

**说明**：如果对密文签名（即对密文的hash值签名），一旦攻击者可以通过网络嗅探的方式获得密文（也就可以获取密文hash值），就可以任意篡改密文消息的签名。

3-10  使用DH算法进行密钥协商的双方在接收到对方发送过来的“公钥”时，应判断公钥是不是0,1,p-1,p这样的特殊值并要求重新发起密钥协商。

**说明**：如果使用DH算法进行密钥协商的双方在接收到的对方发送的“公钥是某些特殊值“，则协商出的密钥也一定是某些已知的值。在这种情况下，攻击者可以尝试最多5个可能的密钥就可以轻易的解密密文。	

3-11	在SSL/TLS中协议中，如使用DH/ECDH算法进行密钥协商，出于前向安全考虑，选取包含DHE或ECDHE密钥交换算法的加密套件，避免选取仅包含DH/ECDH的加密套件。

3-12	密码协议中不要使用截短的消息认证码。

**说明**：密码协议中（如TLS、SSH、IKE等），使用消息认证码（MAC）验证消息的完整性，协议标准有时支持选取截短的消息认证码。此时，消息认证码安全性也因截短而降低，如针对多种密码协议（如TLS、SSH等）的SLOTH攻击就可以利用截短哈希值构造碰撞。

**示例**：截短消息认证码的配置举例：SSH协议中配置HMAC-MD5-96、HMAC-SHA1-96、HMAC-SHA2-256-96
哈希算法的标准输出长度如下，低于标准长度可视为截短：
1）SHA1/HMAC-SHA1，标准输出长度160比特
2）SHA224/HMAC-SHA224，标准输出长度224比特
3）SHA256/HMAC-SHA256，标准输出长度256比特
4）SHA384/HMAC-SHA384，标准输出长度384比特
5）SHA512/HMAC-SHA512，标准输出长度512比特
6）SHA-512/224/HMAC-SHA-512/224，标准输出长度224比特
7）SHA512/256/HMAC-SHA-512/256，标准输出长度256比特

3-13	使用HMAC保护数据完整性时，不能使用hash(key||message)或hash(message||key)的计算结果作为MAC值。

**说明**：攻击者可以通过在原始明文后面追加任意信息的方式篡改明文，破坏数据的完整性。

3-14	同一笔业务中，若既需要加密运算也需要计算MAC时，加密操作和计算MAC操作不能使用同一个对称密钥。

**说明**：如果加密和MAC密钥相同，一旦密钥泄露，攻击者可以有针对性的篡改机密信息。	
3-15	加密时避免使用固定的IV（如：硬编码，或固定在配置文件中）。

**说明**：CBC模式的随机IV值可确保相同的明文、相同的密钥加密出的密文完全不同，如果IV无法确保每次加密都不同，对于CBC模式，攻击者可以轻易的进行密文替换攻击；CBC模式之外的其他分组密码运算模式（如：OFB、CRT等），攻击者可以非常容易的解密密文。	

3-16	密码协议中避免选择匿名认证、无加密、弱身份认证、弱密钥交换、弱对称加密算法和弱消息认证算法的加密算法套件。

**说明**：容易造成安全上的薄弱环节从而降低系统的安全性。

**示例**：匿名认证举例：TLS_DH_anon_WITH_3DES_EDE_CBC_SHA、TLS_DH_anon_WITH_AES_256_CBC_SHA
弱身份认证举例：密钥长度小于2048比特的RSA/DSA密钥

3-17	推荐仅选择使用ECDHE作为密钥交换算法的加密套件。		

3-18	用于数据加解密的密钥不能硬编码在代码中，应采用根密钥等加密保护，同时根密钥也需采用适当的安全机制进行保护(如仅对部分密钥组件进行硬编码)。

**说明**：硬编码密钥容易被逆向分析破解。

3-19	功能设计中建议支持工作密钥更新方法（密钥更新方式：手动更新、自动更新等），并规定工作密钥更新规则（在线更新、离线更新、更新时间等）。

**说明**：密钥使用时间越长，密钥被破解的风险也越大；密钥加密的数据量越多，攻击者能够获取到密文的数据机会也越大，而对被同一个密钥加密的多个密文进行密码学分析相对比较容易，导致密钥越容易被破解；如果密钥已经泄露，那么密钥被使用的时间越久，损失越大。

**示例**：当密钥需要更新时，根据密钥生成的规则，重新生成新密钥，同时使用旧密钥解密已加密的数据，并使用新生成的密钥重新加密，同时销毁旧密钥；对于加密数据量很大的场景，可以考虑保留旧密钥，用于解密旧密钥加密的数据，同时使用更新后的密钥加密新数据。

3-20	密钥材料及密钥组件在保存时须限定其权限（如权限600或400）。		

3-21	对于内存中的密钥，释放前应对保存密钥的内存空间填充其他值。（如：全0）。

## 4.敏感数据保护

4-1	口令等认证凭据应该加密存储并提供访问控制。

4-2	认证凭据不需要还原的场景，应使用PBKDF2等不可逆的算法加密，对于性能敏感且安全性要求不高的场景可使用HMAC（认证凭据，盐值）（注：认证凭据、盐值位置可以互换）。

**示例**：1、认证凭据使用PBKDF2算法计算口令单向哈希时，迭代次数最低1000次。
2、盐值Salt为密码学意义上的安全随机数，由系统随机生成，盐值salt至少16字节，并按用户区分。
3、避免使用HASH(用户名||口令)、HMAC(用户名，口令)、HASH(口令 XOR salt)。

4-3	敏感数据如需通过非信任网络传输，应支持安全传输通道或者将数据加密后再传输的机制。

4-4	对敏感数据的访问，根据风险采取适当的安全机制（如认证、授权或加密等）。包含敏感数据的文件（例如，包含敏感数据的配置文件、日志文件、个人敏感数据文件、用户口令文件、密钥文件、证书文件、驱动文件、备份文件）和其目录的权限设置应只允许文件的属主或需要访问该文件/目录的用户拥有相应的权限。

4-5	日志、调试信息、错误提示等中应过滤或者屏蔽认证凭据。

## 5.系统管理和维护安全

5-1	对于系统自身操作维护类的接口的登录认证场景，应综合考虑实际业务场景及风险，采取下述一种或几种保护措施，实现口令防暴力破解机制：
1）锁定帐号；
2）锁定IP；
3）登录延迟；
4）验证码；		

5-2	对于系统自身操作维护类的口令，图形界面缺省不明文显示用户键入的所有口令。

5-3	口令输入框不能支持口令拷出。

5-4	应使用合适的安全协议，不安全协议应默认关闭。

**示例**：安全协议举例：SSHv2/TLS1.2/TLS1.3/IPSec/SFTP/SNMPv3等协议，及其业界最新安全版本。对于流密码算法，建议使用AES的OFB和CTR模式或chacha20流加密算法替换RC4算法。
不安全协议举例：TFTP、FTP、Telnet、SSL2.0、SSL3.0、TLS1.0、TLS1.1、SNMP v1/v2和SSHv1.x。

5-5	基于权限最小化原则，系统新建账号默认不授予任何权限，或者默认只指派最小权限（如：只读权限）的角色。

**说明**：保证当授权机制出现问题或授权机制被绕过时非法用户获得的权限也是最少的。	

## 6.隐私保护

6-1	收集或使用个人数据前以及将该个人数据发送给第三方之前，应明确提示用户，并获得用户的同意。

**说明**：增加透明性及用户控制能力，满足GDPR等法律法规要求。

6-2	正常业务需要的情况下，采集、处理、存储个人数据，应根据实际安全风险提供必要的安全保护机制（如认证、权限控制、日志记录等），以防止个人数据被泄漏、丢失、破坏。

6-3	在说明文档中对产品涉及用户隐私的功能进行描述：该功能处理用户个人数据的目的、范围、处理方式、时限。要求使用该功能时遵从当地适用的法律法规。

**说明**：增加透明性，满足GDPR等法律法规要求。

6-4	对于所涉及的个人数据，应支持在呈现界面上（如显示界面、文件存储/导出等）进行过滤或匿名化或假名化。

**说明**：降低个人隐私泄露的风险。

6-5	为避免位置追踪，除了有明确的需求之外，不能出于故障定位等维护目的进行用户精确位置信息定位。

**说明**：精确位置信息非常敏感，故障定位无需精确定位。

6-6	收集个人数据需基于使用目的所必需，满足最小化原则。用于问题定位的日志中记录个人数据遵循最小化原则。

**说明**：用于问题定位的日志如果出现个人数据，会引起用户的质疑。应避免打印个人数据，如果必须打印个人数据（如调试目的），必须对个人数据进行匿名化处理。

6-7	涉及个人数据处理的场景，需要提供相关机制，确保数据主体能够查询、更新以及删除所有数据主体的个人数据。

**说明**：确保数据主体的权利。

## 术语说明

| 序号 |     术语     | 定义                                                         |
| :--: | :----------: | ------------------------------------------------------------ |
|  1   |   认证凭据   | 认证凭据指用于证明真实性的身份而声明的私有或公共数据。常用的认证凭据有口令、预共享密钥、私钥、snmp团体字、智能卡、动态令牌卡、指纹、虹膜等。 |
|  2   |   个人数据   | 与一个身份已被识别或者身份可被识别的自然人（“数据主体”）相关的任何信息；身份可识别的自然人是指其身份可以通过诸如姓名、身份证号、位置数据等识别码或者通过一个或多个与自然人的身体、生理、精神、经济、文化或者社会身份相关的特定因素来直接或者间接地被识别。个人数据包括：自然人的email地址、电话号码、生物特征（指纹）、位置数据、IP地址、医疗信息、宗教信仰、社保号、婚姻状态等。 |
|  3   | 敏感个人数据 | 敏感个人数据是个人数据的一个重要子集，指的是涉及数据主体的最私密领域的信息或者一旦泄露可能会给数据主体造成重大不利影响的数据。包括种族、政治观点、宗教和哲学信仰、工会成员资格、基因数据、生物信息、健康和性生活状况，还包括可与自然人身份相关联的银行卡号、身份证号、护照号、口令等。敏感个人数据的处理需要更多更严格的保护措施。 |
|  4   |   敏感数据   | 敏感数据的具体范围取决于具体的应用场景，建议根据风险进行分析和判断。典型的敏感数据包括认证凭据（如口令、私钥、动态令牌卡）、加密秘钥、敏感个人数据等 |
|  5   |   数据主体   | 提供个人数据供数据控制者和处理者处理的人。数据主体能够通过个人数据识别，可以通过如姓名等直接识别也可以通过其个人数据的组合而间接识别出。 |
|  6   |    匿名化    | 是对个人数据进行不可逆改变的过程，个人数据匿名化处理后将无法直接或间接地识别数据主体或者识别需要不合理的耗费大量的时间，费用和精力。 |
|  7   |    假名化    | 为了限制通过个人数据来识别数据主体，个人数据中包含的身份信息可以被假名替代。这种替代就是假名化，假名化的两个属性是：（1）和假名相关联的其他属性不足以识别出这些属性关联的数据主体；（2）除假名分配者外，隐私相关方（例如数据控制者）在有限的努力下无法根据假名逆推出数据主体。假名化以后的数据依然属于个人数据。假名化也称作化名。 |
|  8   | 精确位置信息 | 经纬度、如GPS可以限定在几十米之内。精确位置信息的标准是能识别对应到具体的自然人的程度。 |
|  9   |   标准协议   | 本文中提及的“标准协议”指国际标准协议（如ETSI、3GPP、ITU-T等标准组织定义的标准）、区域性标准（如欧盟制定的标准）、国家行业标准（如中国工信部制定的标准）、事实行业标准（如UPnP组织定义的行业标准）。 |

