# 自适应布局


自适应布局是通过设定元素与外部容器的相对关系实现的。当外部容器大小、位置等发生变化时，元素即可以根据相对关系自动变化以适应外部环境的变化。通常自适应布局能根据vp/px变化进行无级连续的变化。


## 自适应拉伸

某单个内容或某组内容的显示宽度不是固定值，而是通过相对参照物的方式来确定其显示宽度。当参照物的宽度发生变化时，内容或内容间距的宽度随之发生自适应拉伸。

左右拉伸：例如，列表开关组合中，在窗口宽度变化时，开关控件固定宽度并相对列表的右边缘位置固定，整个组合与文本宽度均自适应变化。

![zh-cn_image_0000001258762686](figures/zh-cn_image_0000001258762686.gif)

均分拉伸：例如，在图标型网格中，当窗口宽度变化时，入口图标间距与图标离左右边缘间距同时均等变化。

![zh-cn_image_0000001291556325](figures/zh-cn_image_0000001291556325.gif)

自适应拉伸适用于文字、普通按钮、间距等展示宽度灵活，对宽高比不敏感的内容和内容组合。

当可能出现的拉伸宽度不足以显示默认内容时，应根据场景选择优先保证内容完整或者优先保证其他内容的屏效，并进行截断或换行等组合适配。

![zh-cn_image_0000001245276368](figures/zh-cn_image_0000001245276368.png)


## 自适应缩放

组件的显示大小是固定比例，通过相对参照物的方式来确定其宽或高。当参照物的大小发生变化时，元素的大小随之发生自适应缩放。

完整缩放：例如，在宽度或高度变化时，时钟始终保证表盘完整展示并根据较短边决定宽高。

![zh-cn_image_0000001291675753](figures/zh-cn_image_0000001291675753.gif)

占比缩放：例如，带主体和背景的插画，画面内容根据宽度变化裁切，根据高度变化按50%比例缩放。

![zh-cn_image_0000001245116688](figures/zh-cn_image_0000001245116688.gif)

自适应缩放适用于图片、圆形按钮、banner、反应真实物体形状的图像等必须保证宽高比的内容。

不推荐将所有元素同时缩放、或某内容放大过大超过屏幕50%。这将导致获取信息量不增反减，不符合用户预期。

![zh-cn_image_0000001292842113](figures/zh-cn_image_0000001292842113.gif)


## 自适应延伸

组件的显示数量不是固定的，而是通过相对参照物的方式来确定其显示数量。当参照物的宽度发生变化时，组件随之发生自适应延伸显示更多数量。

同功能内容延伸：例如，子页签和可滑动宫格在默认宽度下通过露出最后内容，提示右方有更多入口，在宽度变化时，可在每个元素宽度不变、保持滑动交互时显示更多数量。

![zh-cn_image_0000001291556369](figures/zh-cn_image_0000001291556369.gif)

不同功能内容延伸或隐藏：例如，默认处于同一排的不同音乐播放按钮优先级不同，在宽度变化时可延伸或隐藏低优先级的按钮，最大化适应不同窗口尺寸。

![zh-cn_image_0000001245276416](figures/zh-cn_image_0000001245276416.gif)

自适应延伸/隐藏适用于页签、操作块、推荐栏目等具有相同交互层级且有更多数据可以填充的内容。

注意：需要判断因隐藏而不展示的内容对功能完整性是否有影响，并考虑通过滑动或“更多”按钮提供查看使用该内容的方式。


## 自适应折行

定义了折行能力的组件，可以根据组件容器的可用空间，体现纵向布局或者横向布局。

例如，在宽度足够时，操作块位于同一行，在宽度变小时，可根据内容能显示的宽度纵向排布。

![zh-cn_image_0000001291675805](figures/zh-cn_image_0000001291675805.png)

自适应折行适用于页签、操作块、内容流等具有相同交互层级，且希望保证类型和数量完整性的内容。

自适应布局对应OpenHarmony系统提供的自适应布局能力中的拉伸、均分、缩放、占比、延伸、隐藏、折行。自适应布局能力详见本文“[自适应布局](adaptive-layout-intro.md)”。
