# 一次开发，多端部署

- [前言](about-this-document.md)
- [简介](introduction.md)
- 应用UX设计
    - [设计原则和要点](design-principles.md)
    - 应用架构设计
        - [应用导航结构设计要求](navigation-design.md)
        - [应用页面结构设计](page-design.md)
    - 界面布局
        - [概述](layout-design-intro.md)
        - 布局基础
            - [栅格系统](layout-grid.md)
            - [自适应布局](layout-adaptive.md)
            - [响应式布局](layout-responsive.md)
        - [布局基础运用案例](layout-design-cases.md)
    - 人机交互
        - [交互基础](interaction-basics.md)
        - [常见输入方式](common-input-modes.md)
        - [交互事件归一](design-interaction-events-unification.md)
    - 视觉风格
        - [视觉基础](visual-style-basics.md)
        - [色彩](visual-style-color.md)
        - [字体](visual-style-font.md)
        - [图标](visual-style-icon.md)
    - [多态控件](design-polymorphic-components.md)
    - [设计自检表](design-checklist.md)
    - [资源](resource.md)
- [IDE使用](ide-usage.md)
- 一多能力的页面开发介绍
    - 布局能力
        - [布局能力简介](layout-intro.md)
        - 自适应布局
            - [自适应布局简介](adaptive-layout-intro.md)
            - [拉伸能力](adaptive-layout-stretching.md)
            - [均分能力](adaptive-layout-equalization.md)
            - [占比能力](adaptive-layout-proportion.md)
            - [缩放能力](adaptive-layout-scaling.md)
            - [延伸能力](adaptive-layout-extension.md)
            - [隐藏能力](adaptive-layout-hiding.md)
            - [折行能力](adaptive-layout-wrapping.md)
        - 响应式布局
            - [栅格断点系统](grid-breakpoint.md)
            - [媒体查询](media-query.md)
            - [典型场景](responsive-layout-cases.md)
    - [交互归一](interaction-events-unification.md)
    - [多态组件](polymorphic-components.md)
    - [资源使用](resource-usage.md)
- [一多能力的功能开发介绍](development-intro.md)
- 案例应用
    - 短信应用
        - [概览](sms-intro.md)
        - 会话详情页面
            - [页面结构](sms-session-page-structure.md)
            - [顶部标题栏](sms-session-page-title-bar.md)
            - [底部输入栏](sms-session-page-input-field.md)
            - [信息列表](sms-session-page-message-list.md)
            - [组合成型](sms-session-page-combined.md)
        - [总结](sms-session-summary.md)
    - [桌面应用](cases-home-screen.md)
- [常见问题](faqs.md)
